'' =================================================================================================
''
''   File........ jm_ee_strings_demo.spin
''   Purpose.....
''   Author...... Jon "JonnyMac" McPhalen
''                Copyright (c) 2026 Jon McPhalen
''                -- see below for terms of use
''   E-mail...... jon.mcphalen@gmail.com
''   Started.....
''   Updated..... 187 FEB 2026
''
'' =================================================================================================


con

  VERSION = 0_2_0


con { timing }

  _xinfreq = 5_000_000                                          ' use 5MHz crystal
  _clkmode = xtal1 + pll16x                                     ' x16 = 80MHz

  CLK_FREQ = (_clkmode >> 6) * _xinfreq                         ' system freq as a constant
  MS_001   = CLK_FREQ / 1_000                                   ' ticks in 1ms
  US_001   = CLK_FREQ / 1_000_000                               ' ticks in 1us


con { terminal }

  BR_TERM  = 115_200                                            ' terminal baud rate


con { fixed io pins }

  PGM_RX   = 31  { I }                                          ' serial / programming
  PGM_TX   = 30  { O }

  EE_SDA   = 29  { I/O }                                        ' i2c / eeprom
  EE_SCL   = 28  { I/O }

  LED_27   = 27  { O }                                          ' LEDs on PAB and FLiP
  LED_26   = 26  { O }


con { app io pins }


con

  #true,  ON, OFF
  #false, NO, YES

  EE_HIGH = $8000
  STR_LEN = 12                                                  ' string len plus terminator


obj

' main                                                          ' * master Spin cog
  time : "jm_time_80"                                           '   timing and delays (80MHz)
  list : "jm_random_list"                                       '   random list manager
  io   : "jm_io"                                                '   simple io
  ee   : "jm_24xx512"                                           '   64K EEPROM access
  term : "jm_fullduplexserial"                                  ' * serial IO for terminal

' * uses cog when loaded


dat

' Strings are null-padded to 12 bytes

  MyStrings     byte    "Tagger",      0[6]
                byte    "Sensor",      0[6]
                byte    "Respawn Box", 0
                byte    "Ammo Box",    0[4]
                byte    "Medic Box",   0[3]
                byte    "Flag Box",    0[4]

  NStrings      byte    6


var { globals }

  byte  strbuf[32]


pub main | addr

  setup
  wait_for_terminal(true, 250)

  build_high_eeprom

' display strings from EEPROM in random order

  repeat NStrings
    addr := ee_str_addr(list.next_index)
    ee.rd_str(addr, @strbuf)
    term.fstr1(string("%s \r"), @strbuf)
    time.pause(100)

  repeat
    waitcnt(0)


pub ee_str_addr(idx) : result

'' Returns address in upper EE of idx'th string

  result := EE_HIGH + (idx * STR_LEN)

{
' Alternate method for strings not on even boudaries
' -- add start of string offset to $8000 (start of upper 32K)
' -- remember that strings MUST be terminated with at lease one zero

  case idx
    0 : return EE_HIGH + $0000
    1 : return EE_HIGH + $000C
    2 : return EE_HIGH + $0018
    3 : return EE_HIGH + $0024
    4 : return EE_HIGH + $0030
    5 : return EE_HIGH + $003C
}

pub build_high_eeprom | x

  x := ee.rd_byte(EE_HIGH)                                      ' check for configuration
  if (x > 32) and (x < 127)
    return

  term.fstr0(string("Building upper EEPROM\r"))

  ee.wr_xblock(EE_HIGH, NStrings*STR_LEN, @MyStrings)           ' bulk write strings

  term.fstr0(string("-- done\r\r"))

  time.pause(1000)


pub setup

'' Setup IO and objects for application

  time.start                                                    ' setup timing & delays

  list.start(NStrings)                                          ' setup list

  io.start(0, 0)                                                ' clear all pins (master cog)

  ee.start(%000)                                                ' connect to EEPROM

  term.tstart(BR_TERM)                                          ' start serial for terminal *


pub wait_for_terminal(clear, mshold)

'' Wait for terminal to be open and key pressed

  term.rxflush
  term.rx
  if (clear)
    term.tx(term#CLS)
    time.pause(mshold #> 0)


con { license }

{{

  Terms of Use: MIT License

  Permission is hereby granted, free of charge, to any person obtaining a copy of this
  software and associated documentation files (the "Software"), to deal in the Software
  without restriction, including without limitation the rights to use, copy, modify,
  merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to the following
  conditions:

  The above copyright notice and this permission notice shall be included in all copies
  or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
  PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
  OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}