'' =================================================================================================
''
''   File........ jm_relocated_code.spin
''   Purpose.....
''   Cogs Used...
''   Author...... Jon "JonnyMac" McPhalen
''                Copyright (c) 2026 Jon McPhalen
''                -- see below for terms of use
''   E-mail...... jon.mcphalen@gmail.com
''   Started.....
''   Updated..... 26 JAN 2026
''
'' =================================================================================================


con

  VERSION = 0_0_0


con { timing }

  _xinfreq = 5_000_000                                          ' use 5MHz crystal
  _clkmode = xtal1 + pll16x                                     ' x16 = 80MHz

  CLK_FREQ = (_clkmode >> 6) * _xinfreq                         ' system freq as a constant
  MS_001   = CLK_FREQ / 1_000                                   ' ticks in 1ms
  US_001   = CLK_FREQ / 1_000_000                               ' ticks in 1us


con { terminal }

  BR_TERM  = 115_200                                            ' terminal baud rate


con { fixed io pins }

  PGM_RX   = 31  { I }                                          ' serial / programming
  PGM_TX   = 30  { O }

  EE_SDA   = 29  { I/O }                                        ' i2c / eeprom
  EE_SCL   = 28  { I/O }

  LED_27   = 27  { O }                                          ' LEDs on PAB and FLiP
  LED_26   = 26  { O }


con { app io pins }


con

  #true,  ON, OFF
  #false, NO, YES

  CODE_ADDR = $7000                                             ' for relocated code


obj

' main                                                          ' * master Spin cog
  time : "jm_time_80"                                           '   timing and delays (80MHz)
  io   : "jm_io"                                                '   simple io
  term : "jm_fullduplexserial"                                  ' * serial IO for terminal

' * uses cog when loaded


dat { pre-initialized }


var

  long  flasher
  long  ticks


pub main

  setup
  wait_for_terminal(true, 250)

  show_dat_code
  run_dat_demo

  copy_code
  show_relocated_code
  relocated_demo

  repeat
    waitcnt(0)


pub show_dat_code | p_code, p_end

  p_code := @entry
  p_end  := @end_of_pasm

  repeat while (p_code < p_end)
    term.fstr1(string("$%.4x... "), p_code)
    repeat 4
      term.fstr1(string("%.2x "), byte[p_code++])
    term.tx(13)

  term.tx(13)


pub run_dat_demo | cog

  flasher := 26
  ticks   := CLK_FREQ >> 1

  cog := cognew(@entry, @flasher)

  term.fstr1(string("DAT code running in cog %d\r\r"), cog)


pub copy_code | len

  len := (@end_of_pasm - @entry + 1) >> 2                       ' longs

  longmove(CODE_ADDR, @entry, len)


pub show_relocated_code | len, p_code

  len := (@end_of_pasm - @entry + 1) >> 2

  p_code := CODE_ADDR

  repeat len
    term.fstr1(string("$%.4x... "), p_code)
    repeat 4
      term.fstr1(string("%.2x "), byte[p_code++])
    term.tx(13)

  term.tx(13)


pub relocated_demo | cog

  flasher := 27
  ticks   := CLK_FREQ >> 2

  cog := cognew(CODE_ADDR, @flasher)

  term.fstr1(string("Relocated code running in cog %d\r\r"), cog)


pub setup

'' Setup IO and objects for application

  time.start                                                    ' setup timing & delays

  io.start(0, 0)                                                ' clear all pins (master cog)

  term.tstart(BR_TERM)                                          ' start serial for terminal *


pub wait_for_terminal(clear, ms)

'' Wait for terminal to be open and key pressed
'' -- waits ms milliseconds after clearing

  term.rxflush
  term.rx
  if (clear)
    term.tx(term#CLS)
    time.pause(ms #> 0)


dat { cog driver }

                        org       0

entry                   mov       t1, par                       ' point to parameters
                        rdlong    t2, t1                        ' read pin
                        mov       pinmask, #1                   ' convert to mask
                        shl       pinmask, t2
                        or        dira, pinmask                 ' set to output
                        add       t1, #4
                        rdlong    delayticks, t1                ' get 1/2 cycle ticks

                        mov       t1, cnt                       ' sync blink timer
                        add       t1, delayticks                ' set initial delay

loop                    or        outa, pinmask                 ' led pin high
                        waitcnt   t1, delayticks
                        andn      outa, pinmask                 ' led pin low
                        waitcnt   t1, delayticks
                        jmp       #loop
                                       '
' --------------------------------------------------------------------------------------------------

pinmask                 res       1
delayticks              res       1

t1                      res       1                             ' work vars
t2                      res       1
t3                      res       1


dat

end_of_pasm             long      0                             ' marker for end of previous section


con { license }

{{

  Terms of Use: MIT License

  Permission is hereby granted, free of charge, to any person obtaining a copy of this
  software and associated documentation files (the "Software"), to deal in the Software
  without restriction, including without limitation the rights to use, copy, modify,
  merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to the following
  conditions:

  The above copyright notice and this permission notice shall be included in all copies
  or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
  PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
  OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}