'Test of 7.3" 6-Color eInk display from buyepaper.com  (gdep073e01)
'Copies full screen, 6-color Windows BMP files (264x176 pixels) to screen
'Eventually...  Just plain colors for now
'Copyright (C) 2014-2025 Raymond Allen, Rayslogic.com, LLC
'MIT License
'Driver now mostly assembly

CON 'Crystal settings
  _clkmode = xtal1 + pll16x
  _xinfreq =5_000_000

CON 'pin settings for DESPI-C73 connector board
  ''NOTE:  YOU WILL PROBABLY NEED TO CHANGE THESE PIN SETTINGS TO MATCH YOUR SETUP !!!!!!!!!!
   pin_MOSI     = 16
   pin_CLK      = 17
   pin_CS       = 18
   pin_DC       = 19
   pin_RESET    = 20
   pin_BUSY     = 21
   'Note:  You must also connect VCC and GND to the DESPI-C73 board

obj
  ser: "fullduplexserial"
  spi: "SPI_asm"


PUB Main
{
  'panel.start(pin_CS,pin_BUSY,pin_SCLK,pin_MOSI,pin_MISO,pin_RESET,pin_POWERON,pin_DISCHARGE,pin_BORDER)

  repeat
    Panel.ShowEmbeddedBitmap(@TestBmp1)
    panel.delayms(5000)
    Panel.ShowEmbeddedBitmap(@TestBmp2)
    panel.delayms(5000)
    Panel.ShowEmbeddedBitmap(@TestBmp3)
    panel.delayms(5000)
  repeat
}
  Start

  repeat

CON 'Color bytes for display (2 pixels)
  black = $00
  red   = $33
  Yellow= $22
  blue  = $55
  green = $66
  white = $11

PUB Start |i
  ser.start(31,30,0,115200)
  spi.start(1,0)           '' Initialize SPI


  'wait a sec for terminal to start
  waitms(500)
  repeat i from 4 to 0
    ser.dec(i)
    ser.tx(13)
    waitms(500)

  'Initializing I/O Pins...
  ser.str(string("Initializing I/O Pins..."))
  ser.tx(13)
  InitPins

  'Reset Display
  ser.str(string("Resetting Display..."))
  ser.tx(13)
  Reset

  'Initializing Display...
  ser.str(string("Initializing Display..."))
  ser.tx(13)
  InitDisplay

  'Clearing Screen
  ser.str(string("Clearing Screen"))
  ser.tx(13)
  ClearScreen(red)



PUB waitms(ms)
  waitcnt(cnt+ms*(clkfreq/1000))


PUB Reset
  DIRA[pin_RESET]:=0
  waitms(10)
  DIRA[pin_RESET]:=1
  waitms(10)

PUB InitPins
  'All pins are outputs, except for BUSY
{'These are controlled by ASM SPI driver now...
  DIRA[pin_MOSI]:=1
  OUTA[pin_MOSI]:=1

  DIRA[pin_CLK]:=1
  OUTA[pin_CLK]:=1
}
  DIRA[pin_CS]:=1
  OUTA[pin_CS]:=1

  DIRA[pin_DC]:=1
  OUTA[pin_DC]:=1

  DIRA[pin_RESET]:=1
  OUTA[pin_RESET]:=1

  DIRA[pin_BUSY]:=0

PUB WriteCMD(c)
  OUTA[pin_cs]:=0
  OUTA[pin_DC]:=0
  SPI.SHIFTOUT(pin_mosi, pin_clk, SPI#MSBFIRST , 8, c)
  OUTA[pin_cs]:=1

PUB WriteData(d)
  OUTA[pin_cs]:=0
  OUTA[pin_DC]:=1
  SPI.SHIFTOUT(pin_mosi, pin_clk, SPI#MSBFIRST , 8, d)
  OUTA[pin_cs]:=1

PUB InitDisplay

  WriteCMD($AA)    ' CMDH
  WriteDATA($49)
  WriteDATA($55)
  WriteDATA($20)
  WriteDATA($08)
  WriteDATA($09)
  WriteDATA($18)

  WriteCMD(PWRR)'
  WriteDATA($3F)

  WriteCMD(PSR)
  WriteDATA($5F)
  WriteDATA($69)

  WriteCMD(POFS)
  WriteDATA($00)
  WriteDATA($54)
  WriteDATA($00)
  WriteDATA($44)

  WriteCMD(BTST1)
  WriteDATA($40)
  WriteDATA($1F)
  WriteDATA($1F)
  WriteDATA($2C)

  WriteCMD(BTST2)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($17)
  WriteDATA($49)

  WriteCMD(BTST3)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($1F)
  WriteDATA($22)
  WriteCMD(PLL)
  WriteDATA($08)
  WriteCMD(CDI)
  WriteDATA($3F)

  WriteCMD(TCON)
  WriteDATA($02)
  WriteDATA($00)

  WriteCMD(TRES)
  WriteDATA($03)
  WriteDATA($20)
  WriteDATA($01)
  WriteDATA($E0)

  WriteCMD(T_VDCS)
  WriteDATA($01)

  WriteCMD(PWS)
  WriteDATA($2F)

  WriteCMD($04)     'PWR on
  lcd_chkstatus          'waiting for the electronic paper IC to release the idle signal

PUB lcd_chkstatus
  'should check busy pin, but just do delay instead
  waitms(100)



PUB ClearScreen(c)  |i



  WriteCMD(DTM)

  repeat i from 1 to 192000
    WriteDATA(c)

  ser.str(string("Data transfered.."))
  ser.tx(13)

  WriteCMD(PON)
  lcd_chkstatus

  '//20211212
  '//Second setting
  WriteCMD(BTST2)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($17)
  WriteDATA($49)


  WriteCMD(DRF)
  WriteDATA($00)
  lcd_chkstatus


  WriteCMD(POF)
  WriteDATA($00)
  lcd_chkstatus




CON  'Some defined values
 PSR         =   $00
 PWRR        =   $01
 POF         =   $02
 POFS        =   $03
 PON         =   $04
 BTST1       =   $05
 BTST2       =   $06
 DSLP        =   $07
 BTST3       =   $08
 DTM         =   $10
 DRF         =   $12
 PLL         =   $30
 CDI         =   $50
 TCON        =   $60
 TRES        =   $61
 _REV         =   $70
 VDCS        =   $82
 T_VDCS      =   $84
 PWS         =   $E3
