#ifndef P2SCREEN
#define P2SCREEN
#endif

#include <stdint.h>

/* Preparation functions */
//To generate the bar values (the values of the bins along the x-axis)
void generate_bars(int16_t output_dim, int16_t *bars);
void generate_bars_baseFreq(int16_t output_dim, int16_t *bars, int16_t freq);
void generate_octaves(int16_t output_dim, int16_t *bars);

//To generate the height values (the values of the points along the y-axis)
void generate_height(int16_t max_input, int16_t max_value, int16_t db_reduc, int16_t *bar_heights);

/* Functions to calculate the output (i.e., the height of the bars that have to be draw graphically) */
//Max value
void generate_output_amp_max(int16_t data_dim, int16_t freq, int16_t *data, int16_t output_dim, int16_t *bar_values, int16_t max_bar_value, int16_t *bar_heights, int8_t *output);
//Amplitude-preserving aggregation
void generate_output_amp_mean(int16_t data_dim, int16_t freq, int16_t *data, int16_t output_dim, int16_t *bar_values, int16_t max_bar_value, int16_t *bar_heights, int8_t *output);
//Power-preserving aggregation
void generate_output_rms_mean(int16_t data_dim, int16_t freq, int16_t *data, int16_t output_dim, int16_t *bar_values, int16_t max_bar_value, int16_t *bar_heights, int8_t *output);

/* Old functions left for compatibility */
void old_generate_bars_lowValue(int16_t output_dim, int16_t *bars, int16_t freq);
void old_generate_bars_meanValue(int16_t output_dim, int16_t *bars, int16_t freq);
void old_generate_height_old(int16_t max_input, int16_t max_value, int16_t *bar_heights);

/* Generate output */
void old_generate_output_max(int16_t sample_rate, int16_t  data_window_dim, int16_t *data, int16_t output_dim, int16_t *bar_values, int16_t max_value, int16_t * bar_heights, int8_t *output, int16_t rescaling_value);
void old_generate_output_mean(int16_t sample_rate, int16_t  data_window_dim, int16_t *data, int16_t output_dim, int16_t *bar_values, int16_t max_value, int16_t * bar_heights, int8_t *output, int16_t rescaling_value);