'' =================================================================================================
''
''   File........ jm_pasm_blinker.spin
''   Purpose.....
''   Cogs Used...
''   Author...... Jon "JonnyMac" McPhalen
''                Copyright (c) 2026 Jon McPhalen
''                -- see below for terms of use
''   E-mail...... jon.mcphalen@gmail.com
''   Started.....
''   Updated..... 28 JAN 2026
''
'' =================================================================================================


con

  VERSION = 0_1_0


con { fixed io pins }

  PGM_RX   = 31  { I }                                          ' serial / programming
  PGM_TX   = 30  { O }

  EE_SDA   = 29  { I/O }                                        ' i2c / eeprom
  EE_SCL   = 28  { I/O }

  LED_27   = 27  { O }                                          ' LEDs on PAB and FLiP
  LED_26   = 26  { O }


var { globals }

  long  cog                                                     ' cog running blinker code
  long  pin                                                     ' blinker pin
  long  ticks                                                   ' half-cycle ticks


pub null

'' This is not an application


pub start(blinkpin, hcticks) : result

'' Start blinker on pin
'' -- hcticks is system ticks for one-half cycle

  stop                                                          ' shutdown if already running

  longmove(@pin, @blinkpin, 2)                                  ' get blinker parameters

  cog := cognew(@CogCode, @pin) + 1                             ' start the cog

  return cog


pub stop

  if (cog)                                                      ' if running
    cogstop(cog-1)                                              '  shut down the cog
    longfill(@cog, 0, 3)                                        '  clear object parameters


pub cog_longs : size

'' Returns size of PASM blob in longs

  return (@CogCodeEnd - @CogCode) >> 2


dat

  CogCode               file    "p1-blinker.bin"
  CogCodeEnd


con { license }

{{

  Terms of Use: MIT License

  Permission is hereby granted, free of charge, to any person obtaining a copy of this
  software and associated documentation files (the "Software"), to deal in the Software
  without restriction, including without limitation the rights to use, copy, modify,
  merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to the following
  conditions:

  The above copyright notice and this permission notice shall be included in all copies
  or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
  PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
  OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}