'' =================================================================================================
''
''   File........ jm_hidden_pasm.spin
''   Purpose.....
''   Cogs Used...
''   Author...... Jon "JonnyMac" McPhalen
''                Copyright (c) 2026 Jon McPhalen
''                -- see below for terms of use
''   E-mail...... jon.mcphalen@gmail.com
''   Started.....
''   Updated..... 28 JAN 2026
''
'' =================================================================================================


con

  VERSION = 0_0_0


con { timing }

  _xinfreq = 5_000_000                                          ' use 5MHz crystal
  _clkmode = xtal1 + pll16x                                     ' x16 = 80MHz

  CLK_FREQ = (_clkmode >> 6) * _xinfreq                         ' system freq as a constant
  MS_001   = CLK_FREQ / 1_000                                   ' ticks in 1ms
  US_001   = CLK_FREQ / 1_000_000                               ' ticks in 1us


con { terminal }

  BR_TERM  = 115_200                                            ' terminal baud rate


con { fixed io pins }

  PGM_RX   = 31  { I }                                          ' serial / programming
  PGM_TX   = 30  { O }

  EE_SDA   = 29  { I/O }                                        ' i2c / eeprom
  EE_SCL   = 28  { I/O }

  LED_27   = 27  { O }                                          ' LEDs on PAB and FLiP
  LED_26   = 26  { O }


con { app io pins }


con

  #true,  ON, OFF
  #false, NO, YES


obj

' main                                                          ' * master Spin cog
  time : "jm_time_80"                                           '   timing and delays (80MHz)
  io   : "jm_io"                                                '   simple io
  term : "jm_fullduplexserial"                                  ' * serial IO for terminal
  led  : "jm_pasm_blinker"                                      ' * single-pin blinker w/hidden pasm

' * uses cog when loaded


var

  long  param1
  long  param2


pub main | size

  setup
  wait_for_terminal(true, 100)

  term.fstr0(string("Press key to run blinker\r\r"))

  wait_for_terminal(false, 0)                                   ' just wait for key

  led.start(26, CLK_FREQ >> 1)                                  ' run on P26 @ 1Hz

  time.pause(2000)

  term.fstr0(string("Press key to rerun blinker\r\r"))

  wait_for_terminal(false, 0)                                   ' just wait for key

  led.start(27, CLK_FREQ >> 3)                                  ' run on P27 @ 8Hz

  term.fstr1(string("PASM blob size is %d longs"), led.cog_longs)

  repeat
    waitcnt(0)


pub setup

'' Setup IO and objects for application

  time.start                                                    ' setup timing & delays

  io.start(0, 0)                                                ' clear all pins (master cog)

  term.tstart(BR_TERM)                                          ' start serial for terminal *


pub wait_for_terminal(clear, mshold)

'' Wait for terminal to be open and key pressed

  term.rxflush
  term.rx
  if (clear)
    term.tx(term#CLS)
    time.pause(mshold #> 0)


con { license }

{{

  Terms of Use: MIT License

  Permission is hereby granted, free of charge, to any person obtaining a copy of this
  software and associated documentation files (the "Software"), to deal in the Software
  without restriction, including without limitation the rights to use, copy, modify,
  merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to the following
  conditions:

  The above copyright notice and this permission notice shall be included in all copies
  or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
  PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
  OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}