'' =================================================================================================
''
''   File........ jm_ssd1306_128x32_i2c_test.spin
''   Purpose..... Simple test code for SSD1306 128x32 I2C display
''   Cogs Used...
''   Author...... Jon "JonnyMac" McPhalen
''                Copyright (c) 2025 Jon McPhalen
''                -- see below for terms of use
''   E-mail...... jon.mcphalen@gmail.com
''   Started.....
''   Updated..... 05 APR 2025
''
'' =================================================================================================


con

  VERSION = 0_0_0


con { timing }

  _xinfreq = 5_000_000                                          ' use 5MHz crystal
  _clkmode = xtal1 + pll16x                                     ' x16 = 80MHz

  CLK_FREQ = (_clkmode >> 6) * _xinfreq                         ' system freq as a constant
  MS_001   = CLK_FREQ / 1_000                                   ' ticks in 1ms
  US_001   = CLK_FREQ / 1_000_000                               ' ticks in 1us


con { terminal }

  BR_TERM  = 115_200                                            ' terminal baud rate


con { fixed io pins }

  RX_PGM   = 31  { I }                                          ' serial / programming
  TX_PGM   = 30  { O }

  SDA1     = 29  { I/O }                                        ' i2c / eeprom
  SCL1     = 28  { I/O }

  LED27    = 27  { O }                                          ' LEDs on PAB and FLiP
  LED26    = 26  { O }


con { app io pins }

  OLED_SDA = 20  { I/O }                                        ' JM SSD1306 HMI board
  OLED_SCL = 19  { I/O }


con

  #true,  ON, OFF
  #false, NO, YES


obj

' main                                                          ' * master Spin cog
  time : "jm_time_80"                                           '   timing and delays (80MHz)
  io   : "jm_io"                                                '   simple io
  term : "jm_fullduplexserial"                                  ' * serial IO for terminal
  oled : "jm_ssd1306_128x32-i2c"

' * uses cog when loaded


dat { pre-initialized }

  Menu      byte        "TAGGER ", 0
            byte        "G-BOX_2", 0
            byte        "TARGET ", 0
            byte        "W-HDSET", 0
            byte        0

  Items     byte        4


var { globals }


pub main | i, p_str, t

  setup
' wait_for_terminal(true, 250)

  oled.clear
  time.pause(100)

  repeat
    oled.clear
    time.pause(100)

    oled.box(0, 0, 127, 31, 1)

    repeat i from 0 to Items-1
      p_str := get_item(@Menu, i, Items)
      if (p_str > 0)
        oled.crsr_xy(1, 1)
        oled.str(p_str, oled#F_BIG, 1)
        time.pause(1000)

  repeat
    waitcnt(0)


pub get_item(p_list, idx, idxmax) : p_str

'' Get string from list
'' -- returns pntr to string

  if (idx < 0) or (idx => idxmax)
    return 0

  p_str := p_list

  repeat idx
    p_str += strsize(p_str) + 1


pub setup

'' Setup IO and objects for application

  time.start                                                    ' setup timing & delays

  io.start(0, 0)                                                ' clear all pins (master cog)

  term.tstart(BR_TERM)                                          ' start serial for terminal *

  oled.startx(OLED_SCL, OLED_SDA)


pub wait_for_terminal(clrscr, mshold)

'' Wait for terminal to be open and key pressed

  term.rxflush
  term.rx
  if (clrscr)
    term.tx(term#CLS)
    time.pause(mshold #> 0)


con { license }

{{

  Terms of Use: MIT License

  Permission is hereby granted, free of charge, to any person obtaining a copy of this
  software and associated documentation files (the "Software"), to deal in the Software
  without restriction, including without limitation the rights to use, copy, modify,
  merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to the following
  conditions:

  The above copyright notice and this permission notice shall be included in all copies
  or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
  PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
  OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}