'Test of 7.3" 6-Color eInk display from buyepaper.com  (gdep073e01)
'Copies full screen, 6-color Windows BMP files (264x176 pixels) to screen
'Eventually...  Just plain colors for now
'Copyright (C) 2014-2025 Raymond Allen, Rayslogic.com, LLC
'MIT License
'Driver now mostly assembly
'Test#4 continuous image rotation to check coin cell battery life

CON 'Crystal settings
  _clkmode = xtal1 + pll16x
  _xinfreq =5_000_000

CON 'pin settings for DESPI-C73 connector board
  ''NOTE:  YOU WILL PROBABLY NEED TO CHANGE THESE PIN SETTINGS TO MATCH YOUR SETUP !!!!!!!!!!
   pin_MOSI     = 16
   pin_CLK      = 17
   pin_CS       = 18
   pin_DC       = 19
   pin_RESET    = 20
   pin_BUSY     = 21
   'Note:  You must also connect VCC and GND to the DESPI-C73 board

   USE_BUSY = 1 'Set this to one if can use Busy signal (needs a pullup resistor), or 0 to just use a delay

CON 'uSD card pins
        SD_MISO = 0
        SD_CLK = 1
        SD_MOSI = 2
        SD_CSn = 3
        SD_POWER = 4 'Set to -1 if not used
        SD_BufferSize = 1000
VAR 'generic variables
        byte          SdBuffer[SD_BufferSize]   'buffer for SD card

obj
  ser: "fullduplexserial"
  spi: "SPI_asm"
  sd : "FSRW" 'for SD card access


PUB Main

  Start

  repeat

CON 'Color bytes for display (2 pixels)
  black = $00
  red   = $33
  Yellow= $22
  blue  = $55
  green = $66
  white = $11

CON 'QWIIC pins

QSDA = 26 '28
QSCL = 27 '29

PUB Start |i
  ser.start(31,30,0,115200)
  spi.start(1,0)           '' Initialize SPI


  'wait a sec for terminal to start
  waitms(500)
  repeat i from 4 to 0
    ser.dec(i)
    ser.tx(13)
    waitms(500)


  'Mounting SD card now
  MountSD

  'Initializing I/O Pins...
  ser.str(string("Initializing I/O Pins..."))
  ser.tx(13)
  InitPins

  'Reset Display
  ser.str(string("Resetting Display..."))
  ser.tx(13)
  Reset

  'Initializing Display...
  ser.str(string("Initializing Display..."))
  ser.tx(13)
  InitDisplay

{
  'Clearing Screen
  ser.str(string("Clearing Screen"))
  ser.tx(13)
  ClearScreen(red)
}
  dira[QSDA]~~
  dira[QSCL]~~

  repeat
    'Load bmp #1
    outa[QSDA]~~
    outa[QSCL]~
    ser.str(string("Showing 4bpp BMP from uSD"))
    ser.tx(13)
    BmpLoad(string("6C4bppD.bmp"))

    waitms(5000)
    waitms(5000)
    waitms(5000)
    waitms(5000)
    waitms(5000)
    waitms(5000)

    'Load bmp #2
    outa[QSDA]~
    outa[QSCL]~~
    ser.str(string("Showing 4bpp BMP from uSD"))
    ser.tx(13)
    BmpLoad(string("6C4bppC.bmp"))

    waitms(5000)
    waitms(5000)
    waitms(5000)
    waitms(5000)
    waitms(5000)
    waitms(5000)

PUB BmpLoad(pFilename)|i,b,c,p 'load file whose name is pointed by pFilename into eink

  'open file
  ser.str(string("Opening uSD."))
  ser.tx(13)
  i:=\sd.popen(pFileName,"r")
  if (i<>0)
    ser.str(string("Opening uSD file failed."))
    return
  ser.str(string("uSD Open."))
  ser.tx(13)


  WriteCMD(DTM)

  'skip bmp header
  sd.pread(@SdBuffer,$48+14)

  'transfer data
  c:=0
  ser.str(string("Transferring data..."))
  ser.tx(13)
  repeat
    b:=sd.pread(@SdBuffer,SD_BufferSize)
    p:=@SdBuffer
    repeat b
      WriteDATA(byte[p++])
    ser.dec(b)
    ser.tx(13)
    c+=b
  until b<SD_BufferSize or c==192000

  ser.str(string("Data transfered.."))
  ser.tx(13)

  WriteCMD(PON)
  lcd_chkstatus

  '//20211212
  '//Second setting
  WriteCMD(BTST2)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($17)
  WriteDATA($49)


  WriteCMD(DRF)
  WriteDATA($00)
  lcd_chkstatus


  WriteCMD(POF)
  WriteDATA($00)
  lcd_chkstatus

PUB MountSD|i
    ser.str(string("Attempting to mount SD card",13))
    waitms(100)

    'Turn on uSD power via mosfet if enabled by constant, SD_POWER
    if (SD_POWER>0)
      outa[SD_POWER]:=0
      dira[SD_POWER]:=1

    repeat   'try forever to mount the SD card
       i:=\sd.mount_explicit(SD_MISO, SD_CLK, SD_MOSI, SD_CSn)
       if i==0
          quit  'mounted, so exit
       waitcnt(cnt+clkfreq/4)
       ser.tx(".")

    ser.str(string("SD card mounted.",13))

PUB waitms(ms)
  waitcnt(cnt+ms*(clkfreq/1000))


PUB Reset
  DIRA[pin_RESET]:=0
  waitms(10)
  DIRA[pin_RESET]:=1
  waitms(10)

PUB InitPins
  'All pins are outputs, except for BUSY
{'These are controlled by ASM SPI driver now...
  DIRA[pin_MOSI]:=1
  OUTA[pin_MOSI]:=1

  DIRA[pin_CLK]:=1
  OUTA[pin_CLK]:=1
}
  DIRA[pin_CS]:=1
  OUTA[pin_CS]:=1

  DIRA[pin_DC]:=1
  OUTA[pin_DC]:=1

  DIRA[pin_RESET]:=1
  OUTA[pin_RESET]:=1

  DIRA[pin_BUSY]:=0

PUB WriteCMD(c)
  OUTA[pin_cs]:=0
  OUTA[pin_DC]:=0
  SPI.SHIFTOUT(pin_mosi, pin_clk, SPI#MSBFIRST , 8, c)
  OUTA[pin_cs]:=1

PUB WriteData(d)
  OUTA[pin_cs]:=0
  OUTA[pin_DC]:=1
  SPI.SHIFTOUT(pin_mosi, pin_clk, SPI#MSBFIRST , 8, d)
  OUTA[pin_cs]:=1

PUB InitDisplay

  WriteCMD($AA)    ' CMDH
  WriteDATA($49)
  WriteDATA($55)
  WriteDATA($20)
  WriteDATA($08)
  WriteDATA($09)
  WriteDATA($18)

  WriteCMD(PWRR)'
  WriteDATA($3F)

  WriteCMD(PSR)
  WriteDATA($5F)
  WriteDATA($69)

  WriteCMD(POFS)
  WriteDATA($00)
  WriteDATA($54)
  WriteDATA($00)
  WriteDATA($44)

  WriteCMD(BTST1)
  WriteDATA($40)
  WriteDATA($1F)
  WriteDATA($1F)
  WriteDATA($2C)

  WriteCMD(BTST2)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($17)
  WriteDATA($49)

  WriteCMD(BTST3)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($1F)
  WriteDATA($22)
  WriteCMD(PLL)
  WriteDATA($08)
  WriteCMD(CDI)
  WriteDATA($3F)

  WriteCMD(TCON)
  WriteDATA($02)
  WriteDATA($00)

  WriteCMD(TRES)
  WriteDATA($03)
  WriteDATA($20)
  WriteDATA($01)
  WriteDATA($E0)

  WriteCMD(T_VDCS)
  WriteDATA($01)

  WriteCMD(PWS)
  WriteDATA($2F)

  WriteCMD($04)     'PWR on
  lcd_chkstatus          'waiting for the electronic paper IC to release the idle signal

PUB lcd_chkstatus
  'should check busy pin, but just do delay instead
  waitms(100)



PUB ClearScreen(c)  |i



  WriteCMD(DTM)

  repeat i from 1 to 192000
    WriteDATA(c)

  ser.str(string("Data transfered.."))
  ser.tx(13)

  WriteCMD(PON)
  lcd_chkstatus

  '//20211212
  '//Second setting
  WriteCMD(BTST2)
  WriteDATA($6F)
  WriteDATA($1F)
  WriteDATA($17)
  WriteDATA($49)


  WriteCMD(DRF)
  WriteDATA($00)
  lcd_chkstatus


  WriteCMD(POF)
  WriteDATA($00)
  lcd_chkstatus




CON  'Some defined values
 PSR         =   $00
 PWRR        =   $01
 POF         =   $02
 POFS        =   $03
 PON         =   $04
 BTST1       =   $05
 BTST2       =   $06
 DSLP        =   $07
 BTST3       =   $08
 DTM         =   $10
 DRF         =   $12
 PLL         =   $30
 CDI         =   $50
 TCON        =   $60
 TRES        =   $61
 _REV         =   $70
 VDCS        =   $82
 T_VDCS      =   $84
 PWS         =   $E3