'' =================================================================================================
''
''   File........ jm_random_list.spin
''   Purpose..... Provide random sequence of 0 to N-1
''   Author...... Jon "JonnyMac" McPhalen
''                Copyright (c) 2021-2026 Jon McPhalen
''                -- see below for terms of use
''   E-mail...... jon.mcphalen@gmail.com
''   Started.....
''   Updated..... 10 FEB 2026
''
'' =================================================================================================

{{

   The purpose of this object is to provide a random index of 0 to N-1 from a list size of 1 to N,
   where the maximum N is 32.

   The index provided will not repeat, and all available indexes will be used before any are used
   again.

}}


con

  VERSION = 1_0_0


var

  long  seed                                                    ' random seed

  byte  listsize                                                ' bits in list, 1..32
  byte  usedcnt                                                 ' bits used, 0..32
  long  fullmask                                                ' mask for filled list
  long  listbits                                                ' list bits (1 = used)
  byte  lastindex

  byte  setup


pub null

'' This is not an application

  repeat
    waitcnt(0)


pub start(len) : result

'' Create randomized bit list of 1..32 elements

  if (len < 1) or (len > 32)
    return false

  seed := cnt                                                   ' set initial seed

  listsize := len                                               ' save size of list
  fullmask := -1 >> (32 - len)                                  ' create mask for all items used

  clear                                                         ' ensure list is reset

  result := setup := true


pub clear

'' Clear used items from list
'' -- does not reset last index (prevents repeats)

  listbits := 0
  usedcnt  := 0


pub randomize(lo, hi) : result

'' Return a random number between lo and hi (inclusive)

  result := (?seed & $7FFF_FFFF) // ((hi - lo) + 1) + lo


pub next_index : idx | mask

'' Returns next randomized index
'' -- result is 0..listsize-1
'' -- -1 if start not called first

  ifnot (setup)
    return -1

  repeat
    repeat
      idx := randomize(0, listsize-1)                           ' randomize
    until (idx <> lastindex)                                    '  until not equil to last used

    mask := |<idx                                               ' mask for this bit

    ifnot (mask & listbits)                                     ' if this slot available
      listbits |= mask                                          '  mark used
      if (listbits == fullmask)                                 '  if list is full
        clear                                                   '   clear it
      lastindex := idx
      usedcnt++
      quit


pub last_index : idx

'' Return last used index

  ifnot (setup)
    return -1

  return lastindex


pub used : count | check

'' Returns number of used indexes
'' -- returns -1 if not intialized

  ifnot (setup)
    return -1

  check := listbits

  repeat while (check)
    check &= check-1
    ++count


pub available : count

'' Returns number of unused indexes

  ifnot (setup)
    return -1

  count := listsize-used


pub used_bits : thelist

'' Returns current list

  return listbits


pub mask_bits : themask

'' Returns full mask for current list

  return fullmask


con { license }

{{

  Terms of Use: MIT License

  Permission is hereby granted, free of charge, to any person obtaining a copy of this
  software and associated documentation files (the "Software"), to deal in the Software
  without restriction, including without limitation the rights to use, copy, modify,
  merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to the following
  conditions:

  The above copyright notice and this permission notice shall be included in all copies
  or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
  PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
  OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

}}