﻿Imports System.IO
Imports System.Drawing
Imports System.Drawing.Drawing2D
Imports System.Windows.Forms
Imports Strings = Microsoft.VisualBasic ' so can use things like left( and right( for strings
Public Class frmMain
    'http://dimac.net/default3.asp?M=FreeDownloads/Menu.asp&P=FreeDownloads/FreeDownloadsstart.asp
    ' Get the free download called w3sockets half way down the page
    ' put the sockets.dll file in c:\windows\system32
    ' run the SocketReg program
    'Your application needs to be aware of the socket.dll file, I accomplished this as follows:
    '1. Click on the 'Project' menu and select 'Add reference...'
    '2. Click on the 'Browse' tab
    '3. Navigate to where you have socket.dll installed on the HD
    '4. Select this file and click 'OK'
    Private WithEvents w3sock As Socket.TCP ' needs 
    Private WithEvents w3sock2 As Socket.TCP ' needs 
    Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Integer) ' for sleep statements
    Public Declare Auto Function SendMessage Lib "user32.dll" (ByVal hWnd As IntPtr, ByVal wMsg As Int32, ByVal wParam As IntPtr, ByVal lParam As IntPtr) As IntPtr ' disable redrawing of richtextbox etc
    Public Const WM_SETREDRAW As Int32 = &HB ' for above sendmessage
    Dim WithEvents SerialPort1 As New IO.Ports.SerialPort ' serial port declare first com port com1
    Dim WithEvents SerialPort3 As New IO.Ports.SerialPort("COM3") ' port 3 is the USB port
    Dim InPacket(0 To 2000) As Byte ' Major bug with serial.write strings like chr(255) won't go out
    Dim OutPacket(0 To 2000) As Byte
    Dim XOut(0 To 133) As Byte ' xmodem output packet
    Public CursX As Integer
    Public CursY As Integer
    Public Display(81, 41) As String
    Public Redrawing As Boolean ' flag to disable textboxchanged
    Public OldCursorPos As Integer
    'Public CaptureFlag As Boolean
    Public KeyCounter As Integer
    Public SbasicFile As String
    Public BDSCfile As String
    Public MbasicFile As String
    Public CatalinaFile As String
    Public BDSCchanged As Boolean
    Public MbasicChanged As Boolean
    Public SbasicRedraw As Integer
    Public ComboBoxEnable As Boolean = False
    Public SbasicChanged As Boolean = False
    Public ColorOn As Boolean = True
    Public Richtext3Updated As Boolean = False
    Public Startup As Boolean = True
    Public SerialPortFound As Boolean = True
    Public EchoOn As Boolean = True
    Public RadioAsciiCharacters As Boolean = False
    Public AssemblyFile As String
    Public CancelButton As Boolean

    Sub SaveTextFileExample() ' not used at present, just to remind me how it is done
        FileOpen(1, "test.txt", OpenMode.Output) ' open a file
        PrintLine(1, "line1")
        FileClose(1)
    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' startup
        SerialPort1.ReadTimeout = 100
        w3sock = New Socket.TCP
        w3sock2 = New Socket.TCP
        Timer1.Interval = 150 ' check for new characters every 150ms
        'TextBox3.ForeColor = Color.LawnGreen
        'TextBox3.BackColor = Color.Black
        'CaptureFlag = False
        Call StartScreen()
        Call LoadINI()
        Try
            ' set the portname and baudrate in the loadini subroutine
            'SerialPort1.PortName = "COM1"
            'SerialPort1.BaudRate = "38400" ' 38400
            SerialPort1.Parity = IO.Ports.Parity.None ' no parity
            SerialPort1.DataBits = 8 ' 8 bits
            SerialPort1.StopBits = IO.Ports.StopBits.One ' one stop bit
            'SerialPort1.ReadTimeout = 1000 ' milliseconds so times out in 1 second if no response
            SerialPort1.Open() ' open the port
            SerialPort1.DiscardInBuffer() ' clear the input buffer
        Catch ex As Exception
            MsgBox("Error opening serial port - is another program using the selected COM port? This program will continue running but with no serial port comms. Also another possible error is the w3sockets.dll is not installed (needed to talk to the altair). Get the w3sockets.zip from the Mini N8vem Files folder on the wiki, then unzip and put the sockets.dll in c:\windows\system32. Then run the registration program")
            SerialPortFound = False
        End Try
        RichTextBox2.Visible = False
        Call LoadSbasicLibrary()
        RichTextBox1.AcceptsTab = True ' so tab stays in the rich text box
        RichTextBox4.AcceptsTab = True
        RichTextBox6.AcceptsTab = True ' so tab stays in the box
        RichTextBox8.AcceptsTab = True ' so tab stays in the box
        RichTextBox10.AcceptsTab = True ' so tab stays in the box
        TimerOn() ' collect bytes from serial port
        Timer1.Enabled = True   ' turn on the timer
        Call LoadRomSettings()
        Me.WindowState = FormWindowState.Maximized
        CancelButton = False
    End Sub
    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        If SerialPortFound = True Then
            SerialPort1.Close()
        End If
        If SbasicFile <> "" And SbasicChanged = True Then
            Call SaveSbasicFile()
        End If
        End
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        ' collect bytes from the serial port
        Timer1.Enabled = False
        Static TimerCounter As Integer
        Dim LineOfText As String
        If SerialPortFound = True Then
            Call ReadSerialPort()
            If SbasicRedraw >= 0 Then
                SbasicRedraw = SbasicRedraw + 1 ' if no keypress for 5 secs then redraw
            End If
            If SbasicRedraw > 40 Then
                Call ColorSbasic()
                SbasicRedraw = -1 ' disable counter till at least one keypress
            End If
            TimerCounter = TimerCounter + 1
            If TimerCounter > 12 And Richtext3Updated = False Then
                TimerCounter = 0
                RichTextBox3.SelectionStart = RichTextBox3.TextLength
                RichTextBox3.ScrollToCaret()
                Richtext3Updated = True
                If SerialPortFound = True Then
                    LineOfText = Str(SerialPort1.BaudRate)
                End If
                Label7.Text = "Baud rate: " + LineOfText
            End If
            If Startup = True And TimerCounter > 2 Then
                TabControl1.SelectedIndex = 0
                TextBox3.Focus()
                Call StringToPacket(vbCr) ' send a carriage return to get the A> prompt
                Startup = False
            End If
        End If
        Timer1.Enabled = True
    End Sub
    Sub ReadSerialPort()
        Dim BytesToRead As Integer '  may as well get in batches
        Dim i As Integer
        Dim j As Integer
        Dim Character As String
        Dim LineOfText As String
        Static ControlA As Boolean
        Static CaptureXmodem As String
        Dim XmodemBytes As Long
        If SerialPortFound = True Then
            Do
                'Try
                If SerialPort1.BytesToRead = 0 Then Exit Do ' no more bytes
                BytesToRead = SerialPort1.BytesToRead
                If BytesToRead > 2000 Then BytesToRead = 2000
                SerialPort1.Read(InPacket, 0, BytesToRead) ' read in a packet
                For i = 1 To BytesToRead
                    Character = Strings.Chr(InPacket(i - 1))
                    Timer1.Enabled = False ' displaycharacter can take a while, more than one tick
                    If Character = Strings.Chr(1) Then
                        ControlA = True
                    Else
                        ControlA = False
                    End If
                    If ControlA = True Or Strings.Len(CaptureXmodem) <> 0 Then
                        CaptureXmodem = CaptureXmodem + Character
                    End If
                    If Strings.Len(CaptureXmodem) = 3 Then
                        If Asc(Strings.Mid(CaptureXmodem, 2, 1)) = 255 - Asc(Strings.Mid(CaptureXmodem, 3, 1)) Then
                            XmodemBytes = Asc(Mid(CaptureXmodem, 2, 1)) * 128
                            LineOfText = vbCrLf + "[ Packet number:" + Str(Asc(Mid(CaptureXmodem, 2, 1))) + " =" + Str(XmodemBytes) + " Bytes ]" + vbCrLf
                            For j = 1 To Len(LineOfText)
                                Call DisplayCharacter(Mid(LineOfText, j, 1))
                            Next
                        End If
                    End If
                    If Strings.Len(CaptureXmodem) > 4 Then CaptureXmodem = ""
                    Call DisplayCharacter(Character) ' display the character
                    If RadioAsciiCharacters = True Then
                        LineOfText = Trim(Str(Asc(Character)))
                        Call DisplayCharacter("[")
                        For j = 1 To Len(LineOfText)
                            Call DisplayCharacter(Mid(LineOfText, j, 1))
                        Next
                        Call DisplayCharacter("]")
                        Call DisplayCharacter(Chr(13))
                        Call DisplayCharacter(Chr(10))
                    End If
                    Call ScrollWindow(Character) ' altair simh window
                    Timer1.Enabled = True
                    'If CaptureFlag = True Then
                    ' Call CaptureText(Character)
                    ' End If
                Next

                Call RedrawDisplay()

                'Catch ex As Exception
                'MsgBox("Serial port error in ReadSerialPort - this program requires a serial connection to run and will now shut down.")
                ' unfortunately it is not possible to have a message explaining the error for clicking ok takes >150ms by which time it has run again, and it won't disable the timer, all most odd.
                ' but this should never run because it should have been flagged on startup
                'End Try
            Loop
        End If
    End Sub
    Sub ScrollWindow(ByVal Character As String)
        If Asc(Character) <> 10 Then ' altair simh window
            RichTextBox3.AppendText(Character)
            Richtext3Updated = False
        End If
    End Sub
    Sub StringToPacket(ByVal lineoftext As String)
        ' send a string out, but don't use for data as numbers like 255 don't work
        ' also don't go over 30 (CPM commands never would be)
        Dim i As Byte
        Dim PacketLength As Byte
        Dim TypematicDelay As Integer
        Dim Character As String
        PacketLength = Strings.Len(lineoftext)
        'TypematicDelay = 10 ' anything under 50 misses characters on MPM
        ' seems to be more reliable with timer off (Sept 2010)
        ' 120 for 4800 baud don't go too short otherwise errors, errors at 60 for instance at 4800
        ' errors below 10 at 38400 baud
        ' needs 60 to send and 60 to get character back, so slow but it works
        ' comment - for some reason at wired 38400 we need the slow speed yet can send out as a whole string for radio at 1200?
        Sleep(TypematicDelay) ' typematic delay - depends on clock as much as baud rate
        For i = 1 To PacketLength
            OutPacket(0) = Strings.Asc(Strings.Mid(lineoftext, i, 1))
            If SerialPortFound = True Then
                SerialPort1.Write(OutPacket, 0, 1)
            End If
            'Sleep(TypematicDelay)
            ClearInputBuffer() ' gobble up return bytes
            System.Windows.Forms.Application.DoEvents() ' update the display
        Next
        Sleep(10)
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub
    Private Sub ComPortToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComPortToolStripMenuItem.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Dim Result
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = True
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        Result = OpenFileDialog1.ShowDialog()
        TimerOff()
        If Result = 1 Then ' clicked ok 
            For Each Filenamepath In OpenFileDialog1.FileNames
                Call XModemFSend(Filenamepath, "XMODEMF", "CPM")
            Next Filenamepath
        End If
        TimerOn()
    End Sub
    Sub OutputXout() ' uses xout() array and sends it out in pieces of 30 bytes
        ' in a subroutine so resends are easier - passing subroutine fills up the bytes
        ' 1. an SOH byte                             {1 byte}
        ' 2. the packet number                       {1 byte}
        ' 3:      .the(1) 's complement of the packet number {1 byte}
        ' 4. the packet                            {128 bytes}
        ' 5. the checksum                            {1 byte}

        'The following terms are simply ascii codes:
        'SOH = chr(1)  = CTRL-A =
        'EOT = chr(4)  = CTRL-D = End of Transmission
        'ACK = chr(6)  = CTRL-F = Positive Acknowledgement
        'NAK = chr(21) = CTRL-U = Negative Acknowledgement
        'CAN = Chr(24) = CTRL - X = Cancel
        'The packet number sent is simply the number of the packet.  If the packet
        'number is greater than 255, then subtract 256 repeatly until the number is
        'between 0 and 255.  For example, if you were sending packet 731, then you
        'would send 731 - 256 - 256 = 219.
        'The(1) 's complement of a byte (to make life easy) is simply 255 minus the
        'byte.  For example, if you had to take the 1's complement of 142, the answer
        'would be 255 - 142 = 133.

        'The checksum is the value of all the bytes in the packet added together.  For
        'example, if the first five bytes were 45, 12, 64, 236, 173 and the other 123
        'bytes were zeroes, the checksum would be 45+12+64+236+173+0+0+...+0 = 530.
        'However, to make each block one byte smaller, they repeatly subtract 256
        'from the checksum until it is between 0 and 255.  In this case, the checksum
        'would be 530 - 256 - 256 = 18.
        'The(downloader)

        '1. ensures that the packet number sent matches the actual packet number
        'that it is (If the third block send has a '4' as the second byte,
        'something is wrong --> CANCEL TRANSFER (send CAN byte))
        '2. adds the packet number and the 1's complement of it together to make
        'sure that they add up to 255.  if they don't --> CANCEL TRANSFER
        '3. adds up all the bytes in the packet together --> THE SUM
        '4. compares the last two significant digits of THE SUM with the checksum
        '5. if everything looks ok (sum=checksum), then the downloader appends the
        'bytes in the packet to the file being created (sent).  The down-
        'loader then sends an ACK byte which tells the uploader to send the
        'next block.
        'if the sums do not match then the downloader sends an NAK byte which
        'tells the uploader to send the same block it just sent over again.

        ' send in blocks of 30 bytes to keep the Hope module happy
        ' removed the 30 byte block for the moment, hope modules go via boards not pc to board
        Dim i As Integer
        For i = 0 To 131
            OutPacket(i) = XOut(i)
        Next
        If SerialPortFound = True Then
            SerialPort1.Write(OutPacket, 0, 132)
        End If
        ' very slow code to catch bugs etc

        'Dim lineoftext As String
        'For i = 0 To 131
        ' OutPacket(0) = XOut(i)
        ' SerialPort1.Write(OutPacket, 0, 1)
        ' lineoftext = Chr(XOut(i)) ' + "  " + Str(XOut(i))
        ' Call DisplayCharacter(lineoftext)
        ' Call RedrawDisplay()
        ' System.Windows.Forms.Application.DoEvents()
        ' Sleep(100)
        ' Next

    End Sub
    Sub OutputXoutSlow()
        ' for MPM as overruns the 64 byte simh buffer if too fast
        Dim i As Integer
        Dim c As Integer
        'Dim lineoftext As String
        c = 0
        For i = 0 To 131
            OutPacket(0) = XOut(i)
            SerialPort1.Write(OutPacket, 0, 1)
            'lineoftext = Chr(XOut(i)) ' + "  " + Str(XOut(i))
            'Call DisplayCharacter(lineoftext)
            'Call RedrawDisplay()
            System.Windows.Forms.Application.DoEvents()
            c += 1
            If c > 50 Then
                c = 0
                Sleep(30) ' catchup time for MPM to process the SIMH 64 byte buffer
            End If
        Next
    End Sub

    '   Sub CancelXmodem()
    ' ' sends a series of CAN bytes - ascii 24
    'Dim i As Integer
    '      If SerialPortFound = True Then
    '          For i = 0 To 10
    '              OutPacket(0) = 24
    '              SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
    '              Sleep(200)
    '          Next i
    '      End If
    '  End Sub
    '  Private Sub CancelSessionToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CancelSessionToolStripMenuItem.Click
    '      Call CancelXmodem()
    '  End Sub

    Private Sub ReceiveFileToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ReceiveFileToolStripMenuItem.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Dim Result
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        Result = SaveFileDialog1.ShowDialog()
        TimerOff()
        If Result = 1 Then ' clicked ok 
            Filenamepath = SaveFileDialog1.FileName
            Call XModemReceive(Filenamepath, "XMODEMF")
        End If
        TimerOn()
    End Sub
    Sub XModemReceive(ByRef Filenamepath As String, ByVal XmodemVersion As String)
        ' pass full path eg C:\n8vem\FILE.TXT
        ' true for calls from menu bar, false for calls from pip
        'Dim Filepath As String
        Dim FileName As String
        Dim XModemIn(0 To 131) As Byte
        Dim PacketSave(0 To 127) As Byte
        Dim i As Integer
        Dim LineOfText As String
        Dim Packetnumber As Integer
        Dim OnesComplement As Byte
        Dim BinaryFileLength As Long
        Dim ErrorCounter As Byte ' give up if gets to 10
        Dim Checksum As Long
        Dim ValidPacket As Boolean
        Dim ErrorType As String
        Dim BytesToRead As Integer
        Dim RetryCounter As Integer
        Packetnumber = 1 ' I think it is 1 for the first packet
        Dim Output As New FileStream(Filenamepath, FileMode.Create, FileAccess.Write)
        Dim br As New BinaryWriter(Output)
        BinaryFileLength = br.BaseStream.Length() - 1
        FileName = Strings.Mid(Filenamepath, 10) ' strip off c:\N8VEM\
        FileName = Strings.UCase(FileName) ' upper case
        LineOfText = Strings.Chr(13)
        Call StringToPacket(LineOfText)
        Sleep(300) ' to process the return
        ' run xmodem on the board
        System.Windows.Forms.Application.DoEvents() ' update the label1 message
        LineOfText = XmodemVersion + " S " + FileName ' eg xmodemf or xm1
        Call StringToPacket(LineOfText) ' start xmodem
        LineOfText = vbCrLf
        Call StringToPacket(LineOfText) ' send a return/LF
        System.Windows.Forms.Application.DoEvents() ' update the label1 message
        Sleep(3000) ' wait a few seconds for the text to come back 
        System.Windows.Forms.Application.DoEvents() ' update the label1 message
        Call ClearInputBuffer()  ' clear the buffer into the PC
        OutPacket(0) = 21 ' send a NAK
        If SerialPortFound = True Then
            SerialPort1.Write(OutPacket, 0, 1) ' send it out
        End If
        Sleep(1000) ' wait for xmodem to put the line together
        Packetnumber = 1
        Label2.Text = ""
        Do
            ' get first byte back
            ValidPacket = True ' start with true but errors could make it false
            RetryCounter = 0
            Do
                Try
                    If SerialPortFound = True Then
                        SerialPort1.Read(InPacket, 0, 1)
                        RetryCounter = 255 ' set so it restarts
                    End If
                Catch
                    RetryCounter += 1
                    Sleep(10)
                End Try
            Loop Until RetryCounter > 100
            If RetryCounter <> 255 Then
                ValidPacket = False
                ErrorCounter = ErrorCounter + 1
                ErrorType = "Serial port timeout"
            End If
            If InPacket(0) = 4 Then
                Label1.Text = "Finished transfer"
                Label2.Text = "100%"
                Exit Do
            End If
            If InPacket(0) = 1 Then
                ' valid packet so read the rest in
                XModemIn(0) = InPacket(0) ' already got the 1st byte so put it in xmodemin array
                If SerialPortFound = True Then
                    For i = 1 To 131
                        SerialPort1.Read(InPacket, 0, 1)
                        'Sleep(3) ' average of 50x4=200ms in a packet 
                        XModemIn(i) = InPacket(0)
                    Next
                End If
                Label1.Text = "Packet " + Strings.Str(Packetnumber) ' display packet
                System.Windows.Forms.Application.DoEvents() ' update the label1 message
            End If
            If XModemIn(0) <> 1 And ValidPacket = True Then ' first number should be a 1
                ValidPacket = False
                ErrorType = "First # not ^A SOH"
                ErrorCounter = ErrorCounter + 1
            End If
            Do
                If Packetnumber < 256 Then Exit Do
                Packetnumber = Packetnumber - 256
            Loop
            OnesComplement = 255 - Packetnumber ' ones complement must match
            If Packetnumber <> XModemIn(1) And ValidPacket = True Then ' packet number should be the next one
                ValidPacket = False
                ErrorType = "Packet number mismatch"
                ErrorCounter = ErrorCounter + 1
            End If
            If XModemIn(2) <> OnesComplement And ValidPacket = True Then
                ValidPacket = False
                ErrorType = "Ones complement not valid"
                ErrorCounter = ErrorCounter + 1
            End If
            Checksum = 0
            For i = 3 To 130
                Checksum = Checksum + XModemIn(i)
            Next
            Do
                If Checksum < 256 Then Exit Do ' work out checksum
                Checksum = Checksum - 256
            Loop
            If Checksum <> XModemIn(131) And ValidPacket = True Then
                ValidPacket = False
                ErrorType = "Checksum invalid"
                ErrorCounter = ErrorCounter + 1
            End If
            If ValidPacket = True Then ' got a good packet
                'Sleep(50) ' 50 at 4800 wait a tick then acknowledge that got it
                ' no sleeps needed now with RetryCounter variable - that keeps trying till a byte arrives
                OutPacket(0) = 6 ' got the packet ^F=ACK
                If SerialPortFound = True Then
                    SerialPort1.Write(OutPacket, 0, 1) ' send it out
                End If
                'Sleep(50) ' 400 at 4800 wait for next packet to all come through - at least 200ms in pauses, plus the data, 200 does work but make it 400
                For i = 3 To 130
                    PacketSave(i - 3) = XModemIn(i) ' read for save
                Next
                Output.Write(PacketSave, 0, 128) ' save 128 bytes
                Packetnumber = Packetnumber + 1
            Else ' an error
                ' don't add one to packet number
                ' send a NAK
                ' try again
                Sleep(50) ' wait a tick then ask to send again
                OutPacket(0) = 21 ' NAK
                If SerialPortFound = True Then
                    SerialPort1.Write(OutPacket, 0, 1) ' send it out
                End If
                Sleep(3000) ' wait for next packet to all come through - at least 200ms in pauses, plus the data, 200 does work but make it 400
            End If
            Label3.Text = "Error: " + Strings.Str(ErrorCounter) + " " + ErrorType
            System.Windows.Forms.Application.DoEvents() ' update the label1 message
            If ErrorCounter >= 5 Then Exit Do
        Loop
        If ErrorCounter < 5 Then
            ' tell board got it all ok
            OutPacket(0) = 21
            If SerialPortFound = True Then
                SerialPort1.Write(OutPacket, 0, 1)
            End If
            Sleep(100)
            ' expect back a 4, and then send a 6
            OutPacket(0) = 6
            If SerialPortFound = True Then
                SerialPort1.Write(OutPacket, 0, 1)
            End If
        Else
            Label1.Text = "File transfer failed"
            Label2.Text = "0%"
            System.Windows.Forms.Application.DoEvents() ' update the label1 message
            For i = 1 To 10
                OutPacket(0) = 24 ' ^X cancel send 10 times
                If SerialPortFound = True Then
                    SerialPort1.Write(OutPacket, 0, 1) ' send it out
                End If
                Sleep(200)
            Next i
            OutPacket(0) = 3 ' ^C
            If SerialPortFound = True Then
                SerialPort1.Write(OutPacket, 0, 1) ' send it out
            End If
        End If
        Output.Close() ' close the file
    End Sub
    Sub ClearInputBuffer()
        ' eg for running pip no need to display all the background information
        Dim BytesToRead As Integer
        Dim i As Integer
        Dim Character As String
        If SerialPortFound = True Then
            Do
                If SerialPort1.BytesToRead = 0 Then Exit Do ' no more bytes
                BytesToRead = SerialPort1.BytesToRead
                If BytesToRead > 2000 Then BytesToRead = 2000
                SerialPort1.Read(InPacket, 0, BytesToRead) ' read in a packet
                For i = 1 To BytesToRead
                    Character = Strings.Chr(InPacket(i - 1))
                    Call DisplayCharacter(Character)
                Next i
            Loop
        End If
        Call RedrawDisplay()
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub
    Sub Get_CPM_Filename(ByRef Filenamepath As String, ByRef CPMFilename As String)
        ' send as byref to get the answer back
        ' pass c:\n8vem\mbasic\bascom.com and returns bascom.com
        ' start at the end and look for a \ character
        Dim i As Integer
        i = Strings.Len(Filenamepath)
        Do
            If Strings.Mid(Filenamepath, i, 1) = "\" Then Exit Do
            i = i - 1
        Loop
        CPMFilename = Strings.Mid(Filenamepath, i + 1)
    End Sub
    Sub StartScreen()
        Dim y As Integer
        Dim x As Integer
        For y = 0 To 41 ' line 41 is not displayed but useful for scrolling as a hidden line
            For x = 0 To 79
                Display(x, y) = " " ' clear display array to spaces
            Next
        Next
        Call RedrawDisplay()
        TextBox3.SelectionStart = 0 ' unhighlights the text
        Redrawing = True
    End Sub

    Sub SendCharacter(ByRef CharacterChanged As String)
        ' send to serial port - display it when it comes back
        If SerialPortFound = True Then
            OutPacket(0) = Asc(CharacterChanged) ' send as a byte through an array
            SerialPort1.Write(OutPacket, 0, 1)
        End If
    End Sub
    Sub DisplayCharacter(ByRef CharacterChanged As String)
        ' receives a character from serial port and updates the display
        Dim x As Integer
        Dim y As Integer
        Dim a As Integer
        Dim i As Integer
        Dim DisplayString As String
        Dim asciichar As Integer
        Dim LineOfText As String
        If CursX > 79 Then CursX = 0 ' when listening to lots of ^ characters can error
        Static VT100 As String ' build vt100 string 
        asciichar = Strings.Asc(CharacterChanged)
        Select Case asciichar
            ' special cases for propeller border characters
            Case 138, 139, 140, 141
                CharacterChanged = "+" ' corner to +
                asciichar = Strings.Asc(CharacterChanged)
            Case 142
                CharacterChanged = "-" ' - to -
                asciichar = Strings.Asc(CharacterChanged)
            Case 143
                CharacterChanged = "|" ' | to |
                asciichar = Strings.Asc(CharacterChanged)
        End Select
        Select Case asciichar
            Case 13 ' carriage return - back to the left side but don't scroll
                CursX = 0
            Case 10 ' scroll up one line if on bottom line, otherwise just move down one
                If CursY < 40 Then
                    CursY = CursY + 1
                Else
                    For x = 0 To 79
                        Display(x, 41) = " " ' clear hidden line
                    Next
                    For y = 1 To 41
                        For x = 0 To 79
                            Display(x, y - 1) = Display(x, y)
                        Next
                    Next
                    CursY = 40
                End If
            Case 8 ' backspace
                CursX = CursX - 1
                If CursX < 0 Then CursX = 0
                Display(CursX, CursY) = " "
                If CursX < 0 Then CursX = 0
            Case 0, 28 To 31, 128 To 255 ' display binary values in curly braces
                DisplayString = "{" + Trim(Strings.Str(asciichar)) + "}"
                If CursX > 74 Then ' near end of line so new line
                    Call Scroll()
                End If
                For i = 1 To Len(DisplayString)
                    Display(CursX, CursY) = Strings.Mid(DisplayString, i, 1)
                    CursX = CursX + 1
                Next
            Case 1 To 7, 9, 11, 12, 14 To 26 ' display values 0 to 26 as ^
                If CursX > 74 Then ' near end of line so new line
                    Call Scroll()
                End If
                DisplayString = "^" + Strings.Chr(64 + asciichar) ' 1=^A 2=^B etc
                For i = 1 To Len(DisplayString)
                    Display(CursX, CursY) = Strings.Mid(DisplayString, i, 1)
                    CursX = CursX + 1
                Next
            Case 27 ' escape sequence
                VT100 = "]" ' start building vt100 string
        End Select
        ' no need to print character if >128 or a control character as already printed above
        If asciichar >= 32 And VT100 = "" And asciichar < 128 Then  ' ignore other characters under 32
            Display(CursX, CursY) = CharacterChanged
            CursX = CursX + 1 ' add one to the cursor
            If CursX > 79 Then
                CursX = 0
                CursY = CursY + 1 ' move to next line
            End If
            If CursY > 40 Then
                ' scroll up
                For x = 0 To 79
                    Display(x, 41) = " " ' clear hidden line
                Next
                For y = 1 To 41
                    For x = 0 To 79
                        Display(x, y - 1) = Display(x, y)
                    Next
                Next
                CursY = 40 ' beginning of last line
                CursX = 0
            End If
        End If
        ' vt100 escape codes - all start with ] which stands for escape (easier to match string)
        If VT100 <> "" And asciichar >= 32 Then
            VT100 = VT100 + CharacterChanged ' add new ones on
        End If
        If Strings.Len(VT100) > 40 Then ' some {instructions} can be at least 33 char
            VT100 = "" ' cancel it but this should never happen. Just gets it out of a potential hang
        End If
        If VT100 = "][H" Then
            ' home position
            CursX = 0
            CursY = 0
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][J" Then
            ' erase from current line to the bottom of the screen
            For y = CursY To 40
                For x = 0 To 79
                    Display(x, y) = " "
                Next
            Next
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][0m" Then
            ' reset all attributes - ignore
            VT100 = "" ' reset it must do this for every command
        End If
        If Strings.Len(VT100) >= 6 And Strings.Len(VT100) <= 8 And Strings.Right(VT100, 1) = "H" Then
            ' a cursor move instruction can be ][03;04H or ][3;4H or ][03;4H
            i = Strings.InStr(VT100, ";")
            If i <> 0 Then
                LineOfText = Strings.Left(VT100, i - 1)
                LineOfText = Strings.Mid(LineOfText, 3) ' strip off escape and [
                a = Val(LineOfText) ' row
                CursY = a - 1 ' I use origin of 0,0 and vt100 uses 1,1
                LineOfText = Strings.Mid(VT100, i + 1)
                LineOfText = Strings.Left(LineOfText, Strings.Len(LineOfText) - 1) ' strip off H
                a = Val(LineOfText) ' column
                CursX = a - 1
                Call RedrawDisplay()
            End If
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][0;1m" Then ' highlight text
            ' highlight text but I'm not sure how to do this in a textbox (? a rich text box) 
            ' plus need to store this attribute in the array
            ' so just ignore for the moment
            VT100 = ""
        End If
        If VT100 = "][K" Or VT100 = "][0K" Then ' delete to the end of the line
            For x = CursX To 79
                Display(x, CursY) = " "
            Next
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][D" Then ' backspace ? a non documented vt100 code (escD is left arrow)
            'Only happens when opening a file and changing the name. 
            ' wordstar sends <esc>[D then a space then <esc>[D again
            CursX = CursX - 1
            If CursX < 0 Then CursX = 0
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][M" Then
            ' deletes the line with the cursor on it
            ' scrolls all lines below this up one
            For x = 0 To 79
                Display(x, y) = " "
            Next
            y = 41 ' delete hidden line
            For x = 0 To 79
                Display(x, y) = " "
            Next
            For y = CursY To 40
                For x = 0 To 79
                    Display(x, y) = Display(x, y + 1)
                Next
            Next
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][L" Then
            ' everything moves down one line from the current cursor line
            ' and delete the cursor line
            For y = 23 To CursY Step -1
                For x = 0 To 79
                    Display(x, y + 1) = Display(x, y)
                Next
            Next
            For x = 0 To 79
                Display(x, CursY) = " "
            Next
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        If VT100 = "][2J" Then
            ' clear the whole display and move cursor to home
            For y = 0 To 41
                For x = 0 To 79
                    Display(x, y) = " "
                Next
            Next
            CursX = 0
            CursY = 0
            Call RedrawDisplay()
            VT100 = "" 'reset it must do this for every command
        End If
        ' Televideo and Wyse commands for Pacman and tetris
        If VT100 = "];" Or VT100 = "]*" Then
            ' Televideo/Wyse60 command to clear screen ESC; or ESC*
            For y = 0 To 41
                For x = 0 To 79
                    Display(x, y) = " "
                Next
            Next
            CursX = 0
            CursY = 0
            Call RedrawDisplay()
            VT100 = "" 'reset it must do this for every command
        End If
        ' move cursor
        If Strings.Len(VT100) = 4 And Strings.Left(VT100, 2) = "]=" Then
            ' a cursor move instruction is ESC=RC,4 bytes 32 offset
            CursY = Strings.Asc(Strings.Mid(VT100, 3, 1)) - 32
            CursX = Strings.Asc(Strings.Mid(VT100, 4, 1)) - 32
            Call RedrawDisplay()
            VT100 = "" ' reset it must do this for every command
        End If
        ' cursor off
        If Strings.Len(VT100) > 2 And Strings.Left(VT100, 1) = "]" And Strings.Mid(VT100, 3, 1) <> "[" Then
            ' not a VT100 message as second character is not [
            If VT100 = "].0" Then
                ' cursor off
                VT100 = "" ' reset it must do this for every command
            End If
            If VT100 = "].1" Then
                ' cursor on
                VT100 = "" ' reset it must do this for every command
            End If
        End If
        ' don't forget to set vt100 to "" after every if vt100 statement
        ' now do the code for custom dir etc. Use ESC { which is not a valid vt100 code
        ' careful with recursiveness - eg if send anything out then will come back and start this sub again
        ' because even if turn off the timer, any xmodem send will turn it on again
        ' do not put a redraw display here - slows down code++
    End Sub
    Sub Scroll()
        ' scroll the line and insert a new line
        Dim x As Integer
        Dim y As Integer
        CursX = 0
        If CursY < 40 Then
            CursY = CursY + 1
        Else
            For x = 0 To 79
                Display(x, 41) = " " ' clear hidden line
            Next
            For y = 1 To 41
                For x = 0 To 79
                    Display(x, y - 1) = Display(x, y)
                Next
            Next
            CursY = 40
        End If

    End Sub
    Sub RedrawDisplay()
        Dim y As Integer
        Dim x As Integer
        Dim Textstring As String
        Dim CursorPosition As Integer
        Redrawing = False ' so textboxchanged doesn't keep being called
        For y = 0 To 40
            For x = 0 To 79
                Textstring = Textstring + Display(x, y)
            Next
            Textstring = Textstring + vbCrLf
        Next
        TextBox3.Text = Textstring
        CursorPosition = CursY * 82 + CursX ' 82 because of the CR and LF
        TextBox3.SelectionStart = CursorPosition
        Redrawing = True
        OldCursorPos = CursorPosition
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub
    Private Sub TextBox3_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles TextBox3.KeyPress
        ' must use keypress to get the ascii value, not keydown (which gives the keyboard scan value and doesn't distinguish between smalls and caps)
        Dim c As String
        Dim asciichar As String
        c = e.KeyChar.ToString
        REM If Radio1200 = False Then
        OutPacket(0) = Asc(c) ' send as a byte through an array
        If SerialPortFound = True Then
            SerialPort1.Write(OutPacket, 0, 1)
        End If
    End Sub
    Sub StoreKeyPress(ByRef SingleCharacter As String)
        ' store and forward. Also if a counter Keycounter gets to 1 sec then send anyway
        ' disabled for the moment see above
        Static Buff1200 As String
        Dim i As Integer
        If SingleCharacter = "" Then
            'called from timer - force a send of all the buffer
            If Buff1200 <> "" Then
                For i = 1 To Strings.Len(Buff1200)
                    OutPacket(0) = Asc(Strings.Mid(Buff1200, i, 1)) ' send as a byte through an array
                    If SerialPortFound = True Then
                        SerialPort1.Write(OutPacket, 0, 1)
                    End If
                Next
            End If
            Buff1200 = ""
        Else
            KeyCounter = 0 ' reset it 
            Select Case Asc(SingleCharacter)
                ' maybe need to handle 10??
                Case 13
                    For i = 1 To Strings.Len(Buff1200)
                        OutPacket(0) = Asc(Strings.Mid(Buff1200, i, 1)) ' send as a byte through an array
                        If SerialPortFound = True Then
                            SerialPort1.Write(OutPacket, 0, 1)
                        End If
                    Next
                    Buff1200 = ""
                    OutPacket(0) = 13 ' send as a byte through an array
                    If SerialPortFound = True Then
                        SerialPort1.Write(OutPacket, 0, 1)
                    End If
                Case Else
                    Buff1200 = Buff1200 + SingleCharacter
            End Select
        End If
    End Sub
    Private Declare Function GetDiskFreeSpaceEx Lib "kernel32" Alias "GetDiskFreeSpaceExA" (ByVal lpDirectoryName As String, ByRef lpFreeBytesAvailableToCaller As Long, ByRef lpTotalNumberOfBytes As Long, ByRef lpTotalNumberOfFreeBytes As Long) As Long
    Public Function GetFreeSpace(ByVal Drive As String) As Long
        'returns free space in MB, formatted to two decimal places
        'e.g., msgbox("Free Space on C: "& GetFreeSpace("C:\") & "MB")
        Dim lBytesTotal, lFreeBytes, lFreeBytesAvailable As Long
        Dim iAns As Long
        iAns = GetDiskFreeSpaceEx(Drive, lFreeBytesAvailable, lBytesTotal, lFreeBytes)
        If iAns > 0 Then
            Return BytesToMegabytes(lFreeBytes)
        Else
            Throw New Exception("Invalid or unreadable drive")
        End If
    End Function
    Private Function BytesToMegabytes(ByVal Bytes As Long) As Long
        Dim dblAns As Double
        dblAns = (Bytes / 1024) / 1024
        BytesToMegabytes = Format(dblAns, "###,###,##0.00")
    End Function
    '    Private Sub OnToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OnToolStripMenuItem.Click
    '        CaptureFlag = True
    '        MsgBox("File captured in c:\n8vem\capture.txt (rename as .bin to view hidden characters)")
    '    End Sub
    '    Private Sub OffToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OffToolStripMenuItem.Click
    '        CaptureFlag = False
    '    End Sub
    '    Sub CaptureText(ByRef lineoftext As String)
    ' Dim i As Integer
    ' Dim c As String
    '     FileOpen(2, "c:\n8vem\capture.txt", OpenMode.Append) ' open a file
    '     For i = 1 To Strings.Len(lineoftext)
    '         c = Strings.Mid(lineoftext, i, 1)
    '         Print(2, c)
    '     Next
    '     FileClose(2)
    ' End Sub
    '
    '
    '    Private Sub ToolStripMenuItem5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
    '        Call StringToPacket("1200" + vbCrLf)
    '        If SerialPortFound = True Then
    '            SerialPort1.BaudRate = "1200" ' 1200
    '        End If
    '        Sleep(300) ' delay to do it
    '        Call StringToPacket(vbCrLf)
    '    End Sub

    Private Sub CompileToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call CompileN8VEM()
    End Sub
    Sub CompileN8VEM()
        Dim NoExtension As String
        TabControl1.SelectedIndex = 0 ' to tab 0
        Call SaveSbasicFile()
        NoExtension = Strings.Left(SbasicFile, Len(SbasicFile) - 4)
        Call XModemFSend("C:\N8VEM\" + SbasicFile, "XMODEMF", "CPM")
        Sleep(1000) ' so mpm has time to get back to the > prompt
        Call StringToPacket("SBASIC " + NoExtension + vbCrLf)
        TabControl1.SelectedIndex = 0 ' display cp/m
        TextBox3.Focus() 'display to cp/m
    End Sub
    Private Sub SaveToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call SaveSbasicFile()
    End Sub
    Sub SaveSbasicFile()
        If SbasicFile = "" Then
            SbasicFile = InputBox("Filename eg MYFILE.BAS: ", , SbasicFile)
            Label5.Text = SbasicFile
        End If
        RichTextBox1.SaveFile("C:\N8VEM\" + SbasicFile, RichTextBoxStreamType.PlainText)
        RichTextBox1.Focus()
        SbasicChanged = False
    End Sub
    Private Sub NewToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call NewSbasic()
    End Sub
    Sub NewSbasic()
        SbasicFile = "NEW.BAS"
        SbasicFile = InputBox("Filename eg MYFILE.BAS (no more than 8 characters):", , SbasicFile)
        SbasicFile = Strings.UCase(SbasicFile)
        Label5.Text = SbasicFile
        RichTextBox1.Text = ""
        RichTextBox1.AppendText("comment" + vbLf + vbTab + "call small procedures first then bigger procedures" + vbLf + vbTab + "as can't call/reference a later procedure (one pass compiler)" + vbLf + vbTab + "Dim common variables eg arrays at beginning of program" + vbLf + "end" + vbLf)
        RichTextBox1.AppendText("rem *** functions and procedures ***" + vbLf + vbLf)
        RichTextBox1.AppendText("rem ************ MAIN **************" + vbLf + vbLf)
        RichTextBox1.AppendText("print " + Chr(34) + "Hello World" + Chr(34) + vbLf)
        RichTextBox1.AppendText("end" + vbLf)
        Call ColorSbasic()
        TabControl1.SelectedIndex = 1
        RichTextBox1.Focus()
    End Sub
    Private Sub OpenToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call OpenSbasic()
    End Sub
    Sub OpenSbasic()
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.BAS"
        OpenFileDialog1.ShowDialog()
        SbasicFile = OpenFileDialog1.FileName
        SbasicFile = Strings.Mid(SbasicFile, 10) ' strip off directory
        SbasicFile = Strings.UCase(SbasicFile)
        Label5.Text = SbasicFile
        Try
            RichTextBox1.LoadFile("C:\N8VEM\" + SbasicFile, RichTextBoxStreamType.PlainText)
            TabControl1.SelectedIndex = 1
            RichTextBox1.Focus()
            If RichTextBox1.TextLength < 5000 Then
                Call ColorSbasic() ' no color for big files as takes ages to load
                ColorOn = True
            Else
                ColorOn = False
            End If
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub
    Private Sub RichTextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RichTextBox1.TextChanged
        SbasicRedraw = 0 ' reset it each keypress - if no activity for 5 secs then redraw
        SbasicChanged = True
    End Sub
    Sub ColorSbasic()
        Dim Greenwords As New List(Of String)
        Dim Bluewords As New List(Of String)
        Dim Goldwords As New List(Of String) ' syntax errors
        Greenwords.Add("rem")
        ' purple words
        Goldwords.Add(" as ") ' should use =
        ' blue words
        Bluewords.Add("abs(")
        Bluewords.Add(" and ")
        Bluewords.Add("atn(")
        'Bluewords.Add("base")
        Bluewords.Add("begin")
        Bluewords.Add("call ")
        Bluewords.Add("case ")
        Bluewords.Add("chain ")
        Bluewords.Add("chr$(")
        Bluewords.Add("close ")
        'Bluewords.Add("com")
        Bluewords.Add("comment")
        Bluewords.Add("cos(")
        'Bluewords.Add("create")
        Bluewords.Add("data ")
        Bluewords.Add("delete ")
        Bluewords.Add("dim ")
        Bluewords.Add(" do")
        Bluewords.Add("else")
        Bluewords.Add("end")
        'Bluewords.Add("eqv")
        'Bluewords.Add("execute")
        Bluewords.Add("exp")
        Bluewords.Add("fcb")
        Bluewords.Add("files")
        Bluewords.Add("fint")
        Bluewords.Add("for ")
        Bluewords.Add("fre(")
        Bluewords.Add("function ")
        Bluewords.Add("gosub ")
        Bluewords.Add("goto ")
        Bluewords.Add("hex$(")
        Bluewords.Add("if ")
        'Bluewords.Add("imp")
        Bluewords.Add("input ")
        Bluewords.Add("instr(")
        Bluewords.Add("int(")
        Bluewords.Add("left$(")
        Bluewords.Add("left(")
        Bluewords.Add("len(")
        Bluewords.Add("let ")
        'Bluewords.Add("locate")
        Bluewords.Add("log(")
        Bluewords.Add("mid(")
        Bluewords.Add("mid$(")
        Bluewords.Add("next ")
        Bluewords.Add("not ")
        Bluewords.Add("num$(")
        Bluewords.Add("of ")
        'Bluewords.Add("on ")
        Bluewords.Add("open ")
        Bluewords.Add("or ")
        Bluewords.Add("out ")
        Bluewords.Add("peek(")
        Bluewords.Add("poke ")
        Bluewords.Add("print ")
        Bluewords.Add("procedure ")
        'Bluewords.Add("read")
        'Bluewords.Add("rename")
        Bluewords.Add("repeat")
        Bluewords.Add("restore")
        'Bluewords.Add("ret")
        Bluewords.Add("return" + vbLf)
        Bluewords.Add("right(")
        Bluewords.Add("right$(")
        Bluewords.Add("rnd(")
        Bluewords.Add("sgn(")
        Bluewords.Add("sin(")
        'Bluewords.Add("size")
        Bluewords.Add("space$(")
        'Bluewords.Add("spc")
        Bluewords.Add("sqr(")
        Bluewords.Add("step ")
        'Bluewords.Add("stop")
        Bluewords.Add("str$(")
        Bluewords.Add("string(")
        Bluewords.Add("string$(")
        'Bluewords.Add("sub")
        'Bluewords.Add("tab")
        Bluewords.Add("tan(")
        'Bluewords.Add("text ")
        Bluewords.Add("then ")
        Bluewords.Add("to ")
        Bluewords.Add("until ")
        Bluewords.Add("var ")
        'Bluewords.Add("variable")
        Bluewords.Add("while ")
        Bluewords.Add("write ")
        'Bluewords.Add("xlate")
        Bluewords.Add("xor ")
        Dim i As Integer
        Dim GreenFlag As Boolean
        Dim TempString As String
        Dim L As Integer
        Dim RemFlag As Boolean
        Dim QuoteFlag As Boolean
        Dim QuoteCount As Integer
        If RichTextBox1.Text.Length > 0 And ColorOn = True Then
            SendMessage(RichTextBox1.Handle, WM_SETREDRAW, New IntPtr(CInt(False)), IntPtr.Zero) ' disable refresh
            Dim selectStart As Integer = RichTextBox1.SelectionStart ' preserve cursor
            RichTextBox1.Select(0, RichTextBox1.Text.Length)
            RichTextBox1.SelectionColor = Color.Black
            RichTextBox1.DeselectAll()
            'do blue words
            For Each oneWord As String In Bluewords
                Dim pos As Integer = 0
                Do While RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox1.Select(pos, oneWord.Length)
                    RichTextBox1.SelectionColor = Color.Blue
                    pos = pos + 1
                Loop
            Next
            'do purple words (syntax errors eg using as instead of = because vb.net uses as
            For Each oneWord As String In Goldwords
                Dim pos As Integer = 0
                Do While RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox1.Select(pos, oneWord.Length)
                    RichTextBox1.SelectionColor = Color.Gold
                    pos = pos + 1
                Loop
            Next
            ' put in rem and comments in green. 10 is end of line
            GreenFlag = False
            TempString = LCase(RichTextBox1.Text) ' all lower case for matching
            L = Strings.Len(TempString)
            For i = 1 To L
                If i > 8 Then 'not too near the beginning
                    If Strings.Mid(TempString, i - 8, 8) = "comment" + vbLf Then
                        GreenFlag = True
                    End If
                End If
                If i < L - 3 Then ' not too near the end
                    If Strings.Mid(TempString, i, 4) = vbLf + "end" Then
                        GreenFlag = False
                    End If
                End If
                If Strings.Mid(TempString, i, 3) = "rem" Then ' rem to end of line
                    RemFlag = True
                    GreenFlag = True
                End If
                If RemFlag = True And Strings.Mid(TempString, i, 1) = vbLf Then
                    RemFlag = False
                    GreenFlag = False
                End If
                If Strings.Mid(TempString, i, 1) = Strings.Chr(34) Then
                    QuoteFlag = True
                End If
                If i > 2 And QuoteCount > 1 Then
                    If QuoteFlag = True And Strings.Mid(TempString, i - 1, 1) = Strings.Chr(34) Then
                        QuoteFlag = False
                        QuoteCount = 0
                    End If
                End If
                If GreenFlag = True Then
                    RichTextBox1.Select(i - 1, 1)
                    RichTextBox1.SelectionColor = Color.Green
                End If
                If QuoteFlag = True Then QuoteCount = QuoteCount + 1
                If QuoteFlag = True Then ' add red text last, overwrites green and blue in quotes
                    RichTextBox1.Select(i - 1, 1)
                    RichTextBox1.SelectionColor = Color.Red
                End If
            Next
            RichTextBox1.SelectionStart = selectStart
            RichTextBox1.SelectionLength = 0
            SbasicRedraw = -1 ' disable counter till next keypress
            SendMessage(RichTextBox1.Handle, WM_SETREDRAW, New IntPtr(CInt(True)), IntPtr.Zero)
            RichTextBox1.Refresh()
        End If
    End Sub
    Sub LoadSbasicLibrary()
        Dim storefile As Directory
        Dim directory As String
        Dim files As String()
        Dim File As String
        Dim NameOnly As String
        ComboBoxEnable = False
        Try
            files = storefile.GetFiles("C:\N8VEM", "*.SBA")
            For Each File In files
                NameOnly = Strings.Mid(File, 10)
                'NameOnly = Strings.Left(NameOnly, Strings.Len(NameOnly) - 4) ' strip off .sba
                ComboBox1.Items.Add(NameOnly)
            Next
            ComboBox1.Text = ComboBox1.Items(0)
        Catch ex As Exception
            ' eg if no files present
        End Try
        ComboBoxEnable = True
    End Sub
    Private Sub Button17_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button17.Click
        Dim tempstring As String
        Dim Filename As String
        Dim i As Integer
        tempstring = RichTextBox1.Text
        i = RichTextBox1.SelectionStart
        Filename = "C:\N8VEM\" + ComboBox1.Text
        RichTextBox2.LoadFile(Filename, RichTextBoxStreamType.PlainText) ' one line fileload!!
        tempstring = Strings.Left(tempstring, i) + RichTextBox2.Text + Strings.Mid(tempstring, i + 1)
        RichTextBox1.Text = tempstring
        Call ColorSbasic() ' color it in
    End Sub

    Private Sub SaveToolStripMenuItem1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call SaveAsSbasic()
    End Sub
    Sub SaveAsSbasic()
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = SbasicFile ' ? put CPM files somewhere safe
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        Try
            RichTextBox1.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
            SbasicFile = Strings.Mid(Filenamepath, 10)
            Label5.Text = SbasicFile
            RichTextBox1.Focus()
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If ColorOn = False Then
            ColorOn = True
            Button1.Text = "Color Off"
            Call ColorSbasic()
        Else
            ColorOn = False
            Button1.Text = "Color On"
            Dim selectStart As Integer = RichTextBox1.SelectionStart ' preserve cursor
            RichTextBox1.Select(0, RichTextBox1.Text.Length)
            RichTextBox1.SelectionColor = Color.Black
            RichTextBox1.SelectionStart = selectStart
            RichTextBox1.SelectionLength = 0
        End If
    End Sub

    Private Sub DocumentationToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
    End Sub
    Sub HelpSbasic()
        ColorOn = False ' if color was on then turn it off
        Button1.Text = "Color On"
        If SbasicFile <> "" Then
            Call SaveSbasicFile()
        End If
        RichTextBox1.Clear()
        RichTextBox1.LoadFile("C:\N8VEM\SBEntire.txt", RichTextBoxStreamType.PlainText)
        TabControl1.SelectedIndex = 1
        RichTextBox1.Focus()
    End Sub

    Private Sub CompileUsingSIMHToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call CompileSIMHN8VEM("Send")
    End Sub
    Sub CompileSIMHN8VEM(ByVal Download As String)
        Dim Location As New Process
        Dim Filename1 As String
        Dim PipInstruction As String
        Dim i As Integer
        Try
            Call SaveSbasicFile()
            TimerOff()
            TextBox1.Text = ""
            TextBox1.Refresh()
            TabControl1.SelectedIndex = 2 ' tab 2 shows what is going on
            TextBox1.Focus() ' cursor to textbox1 so highlights the error
            Filename1 = Strings.Left(SbasicFile, Len(SbasicFile) - 4)
            FileCopy("C:\N8VEM\" + Filename1 + ".BAS", "C:\N8VEM\AltairSIMH\" + Filename1 + ".BAS")
            Location.StartInfo.FileName = "AltairAllTelnet.bat"
            Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
            Location.Start() ' shell the batch file
            w3sock.TimeOut = 15000 ' in milliseconds long enough to do a compile for a big program?
            w3sock.DoTelnetEmulation = True
            w3sock.TelnetEmulation = "TTY"
            w3sock.Host = "Localhost:23"
            w3sock.Open()
            w3sock.WaitFor(">")
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("D:" + vbCrLf) ' change to drive D where sbasic is
            Sleep(200)
            w3sock.WaitFor("D>") ' must use D> not > otherwise later on searches for the first D> 
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("R " + Filename1 + ".BAS" + vbCrLf) ' copy to the simh from pc directory
            Sleep(200) ' read in file
            w3sock.WaitFor("D>")
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("SBASIC " + Filename1 + vbCrLf) ' run sbasic
            Sleep(200) ' longer delay is below
            w3sock.WaitFor("D>") ' wait for the D> prompt to come back
            Call RefreshTextBox1() ' display messages etc as they come in
            For i = 1 To 2
                w3sock.SendText(vbCrLf) ' in case hangs send a few CRs
                Sleep(200)
                w3sock.WaitFor("D>")
                RefreshTextBox1()
            Next
            w3sock.SendText("W " + Filename1 + ".COM" + vbCrLf) ' write back to PC directory
            Sleep(200) ' write the file
            w3sock.WaitFor("D>")
            RefreshTextBox1()
            For i = 1 To 2
                w3sock.SendText(vbCrLf) ' in case hangs send a couple of CRs
                Sleep(100)
                w3sock.WaitFor("D>")
            Next
            ' erase the files on the simh otherwise fill up the 1mb disk image
            w3sock.SendText("ERA " + Filename1 + ".BAS" + vbCrLf) ' so don't clutter up simulated drive D
            Sleep(200)
            w3sock.WaitFor("D>")
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("ERA " + Filename1 + ".COM" + vbCrLf)
            Sleep(200)
            w3sock.WaitFor("D>")
            'now halt the simh program
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("HALT" + vbCrLf) ' halt the simh
            Sleep(200)
            Call RefreshTextBox1() ' display messages etc as they come in
            ' now copy file to c:\N8VEM
            FileCopy("C:\N8VEM\AltairSIMH\" + Filename1 + ".COM", "C:\N8VEM\" + Filename1 + ".COM")
            Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".BAS") ' clean up
            Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".COM") ' clean up
            ' and transfer it to the board
            w3sock.Close() ' close the socket
            If Download = "Send" Then
                TabControl1.SelectedIndex = 0 ' to tab 0
                TextBox3.Focus() ' focus to cp/m window
                System.Windows.Forms.Application.DoEvents() ' update the display
                Call XModemFSend("C:\N8VEM\" + Filename1 + ".COM", "XMODEMF", "CPM")
            End If
            If Download = "PropellerUSER0" Then
                TabControl1.SelectedIndex = 0 ' to tab 0
                TextBox3.Focus() ' focus to cp/m window
                System.Windows.Forms.Application.DoEvents() ' update the display
                ' latest version, erase on user 0 and user1 and use xmodemf which saves to user 0
                Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well otherwise if happens to be on user 0 then won't erase on user 1!
                Call WaitForPrompt()
                Call StringToPacket("ERA " + Filename1 + ".COM" + vbCr)
                Call WaitForPrompt()
                Call StringToPacket("USER 1" + vbCr)
                Call WaitForPrompt()
                Call XModemFSend("C:\N8VEM\" + Filename1 + ".COM", "XMODEMF", "MPM")
                Call WaitForPrompt()
                'PipInstruction = "PIP " + Filename1 + ".COM[G0]=" + Filename1 + ".COM[G1]" + vbCr
                'Call StringToPacket(PipInstruction)
                'Call WaitForPrompt()
            End If
            If Download = "PropellerUSER1" Then
                TabControl1.SelectedIndex = 0 ' to tab 0
                TextBox3.Focus() ' focus to cp/m window
                System.Windows.Forms.Application.DoEvents() ' update the display
                Call XModemFSend("C:\N8VEM\" + Filename1 + ".COM", "XM1", "MPM")
                Call WaitForPrompt()
                Call StringToPacket(vbCr) ' finish up 
            End If
            ' and try running it
            ' disable running it for the moment
            'Call StringToPacket(Filename1 + vbCrLf)

        Catch ex As Exception
            ' errors eg if it didn't compile so there is no file to copy
            w3sock.Close() ' close the socket
            TextBox1.Text += vbCrLf + "Syntax error - aborting" + vbCrLf
            TextBox1.Refresh()
            TextBox1.SelectionStart = TextBox1.TextLength
            TextBox1.ScrollToCaret()
            TabControl1.SelectedIndex = 2 ' tab 2 has the error message
            TextBox1.Focus() ' cursor to textbox1 so highlights the error
        End Try
        TimerOn()
    End Sub
    Private Sub RefreshTextBox1()
        Static Oldstring As String
        Dim NewString As String
        ' the winsock buffer doesn't clear sometimes, so if newstring=oldstring then don't add
        NewString = w3sock.Buffer
        If NewString <> Oldstring Then
            TextBox1.Text += NewString
            Oldstring = NewString ' store for next time
            TextBox1.Refresh()
            TextBox1.SelectionStart = TextBox1.TextLength
            TextBox1.ScrollToCaret()
            System.Windows.Forms.Application.DoEvents() ' update the display
        End If
    End Sub
    Private Sub ListenW3Sock()
        Dim Mystring As String
        Dim n As Integer
        n = 0
        Do Until n <> 0
            n = w3sock.BytesInBuffer
        Loop
        Sleep(1000)
        'Mystring = w3sock.Buffer ' this does not return anything ? why because it does above
        ' Mystring = w3sock.GetText(n) ' and this just hangs
    End Sub

    Private Sub HelpSIMHCompilerToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call HelpSimhCompiler()
    End Sub
    Sub HelpSimhCompiler()
        ColorOn = False ' if color was on then turn it off
        Button1.Text = "Color On"
        If SbasicFile <> "" Then
            Call SaveSbasicFile()
        End If
        RichTextBox1.Clear()
        RichTextBox1.LoadFile("C:\N8VEM\SBSIMH.txt", RichTextBoxStreamType.PlainText)
        RichTextBox1.Focus()
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Dim Filename As String
        Call CompileSIMHN8VEM("Send")
        Call StringToPacket(vbCrLf)
        Sleep(100)
        Filename = Strings.Left(SbasicFile, Len(SbasicFile) - 4)
        Call StringToPacket(Filename + vbCrLf)
    End Sub

    Private Sub CompuToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Call CompileSIMH()
    End Sub
    Sub CompileSIMH()
        ' compile using SIMH but leave the SIMH window open
        Dim Location As New Process
        Dim Filename1 As String 'eg MYFILE.BAS
        Call SaveSbasicFile()
        FileOpen(1, "C:\N8VEM\AltairSIMH\SIM.BAT", OpenMode.Output) ' open a file
        PrintLine(1, "altairZ80 sim_cmd")
        FileClose(1)
        ' create the large simulation file
        FileOpen(1, "C:\N8VEM\AltairSIMH\sim_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "d tracks[0-7] 254")
        PrintLine(1, "attach dsk cpm2.dsk")
        PrintLine(1, "attach dsk1 basic.dsk")
        PrintLine(1, "attach dsk2 games.dsk")
        PrintLine(1, "attach dsk3 sbasic.dsk")
        PrintLine(1, "attach dsk4 supercalc.dsk")
        PrintLine(1, "attach dsk5 tools.dsk")
        PrintLine(1, "attach dsk6 wordstar.dsk")
        PrintLine(1, "attach hdsk i.dsk")
        PrintLine(1, "set cpu 64k")
        PrintLine(1, "set cpu noitrap")
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu altairrom")
        PrintLine(1, "set cpu nonbanked")
        PrintLine(1, "Reset cpu ")
        PrintLine(1, "set sio ansi")
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "attach sio cpm_cmd") ' attach the little file below to run a batch
        PrintLine(1, "boot dsk") ' will run till type HALT which runs HALT.COM
        PrintLine(1, "bye")
        FileClose(1)
        ' now create the file to compile
        Filename1 = Strings.Left(SbasicFile, Len(SbasicFile) - 4) 'trim the .bas
        FileCopy("C:\N8VEM\" + Filename1 + ".BAS", "C:\N8VEM\AltairSIMH\" + Filename1 + ".BAS")
        FileOpen(1, "C:\N8VEM\AltairSIMH\cpm_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "D:") ' sbasic is on the D drive
        PrintLine(1, "R " + Filename1 + ".BAS") ' read the file into the SIMH
        PrintLine(1, "SBASIC " + Filename1) 'compile it
        PrintLine(1, "W " + Filename1 + ".COM") ' write back to PC
        FileClose(1)
        ' shell the altair SIMH
        Location.StartInfo.FileName = "SIM.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
        Location.Start() ' shell the batch file
        Sleep(2000)
        Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".BAS") ' clean up
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        Call CompileN8VEM()

    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        Call CompileSIMH()
    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click
        ' take the raw cp/m file and create the new cp/m file with true/false
        Button8.ForeColor = Color.Green
        System.Windows.Forms.Application.DoEvents()
        Dim CheckBoxes(0 To 20) As String
        Dim LineOfText As String
        Dim FileLocation As String
        ' note that checked is false rather than true
        If CheckBox1.Checked = True Then CheckBoxes(1) = "FALSE" Else CheckBoxes(1) = "TRUE"
        If CheckBox2.Checked = True Then CheckBoxes(2) = "FALSE" Else CheckBoxes(2) = "TRUE"
        If CheckBox3.Checked = True Then CheckBoxes(3) = "FALSE" Else CheckBoxes(3) = "TRUE"
        If CheckBox4.Checked = True Then CheckBoxes(4) = "FALSE" Else CheckBoxes(4) = "TRUE"
        If CheckBox5.Checked = True Then CheckBoxes(5) = "FALSE" Else CheckBoxes(5) = "TRUE"
        If CheckBox6.Checked = True Then CheckBoxes(6) = "FALSE" Else CheckBoxes(6) = "TRUE"
        If CheckBox7.Checked = True Then CheckBoxes(7) = "FALSE" Else CheckBoxes(7) = "TRUE"
        If CheckBox8.Checked = True Then CheckBoxes(8) = "FALSE" Else CheckBoxes(8) = "TRUE"
        If CheckBox9.Checked = True Then CheckBoxes(9) = "FALSE" Else CheckBoxes(9) = "TRUE"
        If CheckBox10.Checked = True Then CheckBoxes(10) = "FALSE" Else CheckBoxes(10) = "TRUE"
        If CheckBox11.Checked = True Then CheckBoxes(11) = "FALSE" Else CheckBoxes(11) = "TRUE"
        If CheckBox12.Checked = True Then CheckBoxes(12) = "FALSE" Else CheckBoxes(12) = "TRUE"

        FileLocation = TextBox2.Text + "\" + TextBox6.Text
        FileOpen(2, FileLocation, OpenMode.Output) ' open a file
        FileLocation = TextBox2.Text + "\" + TextBox10.Text
        FileOpen(1, FileLocation, OpenMode.Input)
        PrintLine(2, ";**************************************************************")
        PrintLine(2, ";*")
        PrintLine(2, ";*             C P / M   VERSION   2 . 2")
        PrintLine(2, ";*")
        PrintLine(2, ";*   RECONSTRUCTED FROM MEMORY IMAGE ON FEBRUARY 27, 1981")
        PrintLine(2, ";*")
        PrintLine(2, ";*                BY CLARK A. CALKINS")
        PrintLine(2, ";*")
        PrintLine(2, ";**************************************************************")
        PrintLine(2, ";")
        PrintLine(2, ";   SET MEMORY LIMIT HERE. THIS IS THE AMOUNT OF CONTIGEOUS")
        PrintLine(2, "; RAM STARTING FROM 0000. CP/M WILL RESIDE AT THE END OF THIS SPACE.")
        PrintLine(2, "; all instructions changed to .z80 mnemonics with XIZ.COM")
        PrintLine(2, "; change dbgmonitor so it boots into cp/m directly")
        PrintLine(2, "; changed 3 files on b drive ")
        PrintLine(2, ";")
        PrintLine(2, "; add conditional assembly instructions here either .equ true or .equ false")
        PrintLine(2, "; all conditional assembly groups start with CONDxxxx:")
        PrintLine(2, "; default is true ie the original instructions eg .IF TSR is the original code")
        PrintLine(2, "; so to add a new group set the name to false else set it to true for the old code")
        PrintLine(2, "FALSE:		.EQU 0")
        PrintLine(2, "TRUE:		.EQU ~FALSE")
        PrintLine(2, "")
        PrintLine(2, "; list of conditional assembly instructions")
        PrintLine(2, "")
        PrintLine(2, "CONDSWAPAB:	.EQU	" + CheckBoxes(1) + "   ; true for original, false for new code=A=ram")
        PrintLine(2, "CONDIDESOFT:	.EQU	" + CheckBoxes(2) + "	; if no ide drive, has a significant delay on soft boot (true) or quick (false)")
        PrintLine(2, "CONDWBOOT:	.EQU	" + CheckBoxes(3) + "	; warm boot completely reloads cp/m (true) or doesn't (false)")
        PrintLine(2, "CONDTSR		.EQU	" + CheckBoxes(4) + "	; true for original, false to add TSR routines")
        PrintLine(2, "CONDSHORTMSG	.EQU	" + CheckBoxes(5) + "	; true for original warm boot signon, false for shorter one with less <CR>")
        PrintLine(2, "CONDSUPERSUB	.EQU	" + CheckBoxes(6) + "	; true for no supersub autoexec, false to run supersub autoexec")
        PrintLine(2, "CONDKEYBOARD	.EQU	" + CheckBoxes(7) + "	; true for original, false to scan PS2 keyboard in CONIN as well as serial")
        PrintLine(2, "CONDCONOUT	.EQU	" + CheckBoxes(8) + "	; true for original, false to run echooff.com TSR to maintain radio silence and LCD")
        PrintLine(2, "CONDUSRPATCH	.EQU	" + CheckBoxes(9) + "	; true for original, false to add A1> for user number as well as drive")
        PrintLine(2, "CONDMASKCONIN .EQU    " + CheckBoxes(10) + "   ; true for original, false to add a >127 mask for conin")
        PrintLine(2, "CONDABONLY    .EQU    " + CheckBoxes(11) + "   ; true for original, false to only have drive A and B")
        PrintLine(2, "CONDINVALIDDRV    .EQU    " + CheckBoxes(12) + "   ; true for original, false to go to A if an invalid drive selected")

        Do Until EOF(1)
            LineOfText = LineInput(1)
            PrintLine(2, LineOfText)
        Loop
        FileClose(1)
        FileClose(2)
        Button8.ForeColor = Color.Black
    End Sub
    Private Sub Button9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button9.Click
        ' shell the batch file
        Dim Location As New Process
        Button9.ForeColor = Color.Green
        System.Windows.Forms.Application.DoEvents()
        Location.StartInfo.FileName = TextBox8.Text
        Location.StartInfo.WorkingDirectory = TextBox2.Text
        Location.Start() ' shell the batch file
        Button9.ForeColor = Color.Black
    End Sub


    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        Call SaveRomSettings()
    End Sub
    Sub SaveRomSettings()
        Dim FileLocation As String
        Dim i As Integer
        Dim a As String
        Dim RadioButton As String
        FileLocation = TextBox2.Text + "\" + TextBox9.Text
        FileOpen(1, FileLocation, OpenMode.Output)
        ' store the files on drive B 
        a = Strings.Str(ListBox2.Items.Count)
        PrintLine(1, a) ' store the number of entries
        For i = 0 To a - 1
            PrintLine(1, ListBox2.Items(i))
        Next
        PrintLine(1, TextBox2.Text)
        PrintLine(1, TextBox4.Text)
        PrintLine(1, TextBox5.Text)
        PrintLine(1, TextBox6.Text)
        PrintLine(1, TextBox8.Text)
        PrintLine(1, TextBox10.Text)
        PrintLine(1, TextBox11.Text)
        PrintLine(1, TextBox12.Text)
        ' now store the check boxes
        PrintLine(1, CheckBox1.Checked)
        PrintLine(1, CheckBox2.Checked)
        PrintLine(1, CheckBox3.Checked)
        PrintLine(1, CheckBox4.Checked)
        PrintLine(1, CheckBox5.Checked)
        PrintLine(1, CheckBox6.Checked)
        PrintLine(1, CheckBox7.Checked)
        PrintLine(1, CheckBox8.Checked)
        PrintLine(1, CheckBox9.Checked)
        PrintLine(1, CheckBox10.Checked)
        PrintLine(1, CheckBox11.Checked)
        PrintLine(1, CheckBox12.Checked)
        If RadioButton1.Checked = True Then RadioButton = "1"
        If RadioButton2.Checked = True Then RadioButton = "2"
        If RadioButton3.Checked = True Then RadioButton = "3"
        If RadioButton4.Checked = True Then RadioButton = "4"
        If RadioButton5.Checked = True Then RadioButton = "5"
        If RadioButton6.Checked = True Then RadioButton = "6"
        PrintLine(1, RadioButton)
        FileClose(1)
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        Call LoadRomSettings()
    End Sub
    Sub LoadRomSettings()
        Dim FileLocation As String
        Dim i As Integer
        Dim a As String
        Dim RadioButton As String
        Try
            FileLocation = TextBox2.Text + "\" + TextBox9.Text
            FileOpen(1, FileLocation, OpenMode.Input)
            a = LineInput(1)
            ListBox2.Items.Clear()
            For i = 1 To Val(a)
                ListBox2.Items.Add(LineInput(1))
            Next
            TextBox2.Text = LineInput(1)
            TextBox4.Text = LineInput(1)
            TextBox5.Text = LineInput(1)
            TextBox6.Text = LineInput(1)
            TextBox8.Text = LineInput(1)
            TextBox10.Text = LineInput(1)
            TextBox11.Text = LineInput(1)
            TextBox12.Text = LineInput(1)
            ' now store the check boxes
            CheckBox1.Checked = LineInput(1)
            CheckBox2.Checked = LineInput(1)
            CheckBox3.Checked = LineInput(1)
            CheckBox4.Checked = LineInput(1)
            CheckBox5.Checked = LineInput(1)
            CheckBox6.Checked = LineInput(1)
            CheckBox7.Checked = LineInput(1)
            CheckBox8.Checked = LineInput(1)
            CheckBox9.Checked = LineInput(1)
            CheckBox10.Checked = LineInput(1)
            CheckBox11.Checked = LineInput(1)
            CheckBox12.Checked = LineInput(1)
            RadioButton = LineInput(1)
            FileClose(1)
            Select Case Val(RadioButton)
                Case 1 : RadioButton1.Checked = True
                Case 2 : RadioButton2.Checked = True
                Case 3 : RadioButton3.Checked = True
                Case 4 : RadioButton4.Checked = True
                Case 5 : RadioButton5.Checked = True
                Case 6 : RadioButton6.Checked = True
            End Select
        Catch ex As Exception
            FileClose(1)
            Call SaveRomSettings()  'if file doesn't exist then save it
        End Try
    End Sub

    Private Sub Button10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button10.Click
        ' take the raw monitor program and create new one
        Button10.ForeColor = Color.Green
        System.Windows.Forms.Application.DoEvents()
        Sleep(100)
        FileCopy("C:\n8vem\" + TextBox5.Text, "c:\n8vem\dbgmon.asm")
        Button10.ForeColor = Color.Black
    End Sub

    Private Sub Button11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button11.Click
        Call NewSbasic()
    End Sub
    Private Sub Button12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button12.Click
        Call OpenSbasic()
    End Sub

    Private Sub Button13_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button13.Click
        Call SaveSbasicFile()
    End Sub

    Private Sub Button16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button16.Click
        Call HelpSbasic()
    End Sub

    Private Sub Button15_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button15.Click
        Call HelpSimhCompiler()
    End Sub

    Private Sub Button14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button14.Click
        Call SaveAsSbasic()
    End Sub

    Private Sub Button18_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button18.Click
        ' merge testromimage.bin (1mb) and testminiromimage.bin (up to 32k)
        Dim a As Byte
        Dim b As Byte
        Dim i As Long
        Dim OneMeg As New BinaryReader(File.Open("c:\n8vem\OneMegBlank.bin", FileMode.Open))
        Dim Romimage As New BinaryReader(File.Open("c:\n8vem\Romimage.bin", FileMode.Open))
        Dim BinaryOutput As New BinaryWriter(File.Create("c:\n8vem\OneMeg.bin", FileMode.Open))
        ' peekchar gives an error and MS I think are going to abandon it anyway
        Button18.ForeColor = Color.Green
        System.Windows.Forms.Application.DoEvents()
        For i = 0 To 32767
            a = Romimage.ReadByte
            b = OneMeg.ReadByte ' discard this 
            BinaryOutput.Write(a)
        Next
        For i = 32768 To 1048575
            a = OneMeg.ReadByte
            BinaryOutput.Write(a)
        Next
        OneMeg.Close()
        BinaryOutput.Close()
        Romimage.Close()
        Try
            Kill("c:\n8vem\romimage.bin")
            Rename("c:\n8vem\onemeg.bin", "c:\n8vem\Romimage.bin")
        Catch ex As Exception
            MsgBox("Unable to delete Romimage.bin - is another process using this file?")
        End Try
        Button18.ForeColor = Color.Black
    End Sub

    Sub Fill16k()
        ' creates a 16k binary file called 16kFF.bin filled with FF
        Dim i As Long
        Dim a As Byte
        a = Strings.Val("&HFF")
        Dim BinaryOutput As New BinaryWriter(File.Create("c:\n8vem\16kFF.bin", FileMode.Open))
        For i = 0 To 16383
            BinaryOutput.Write(a)
        Next
        BinaryOutput.Close()
    End Sub

    Private Sub Button19_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button19.Click
        Dim Location As New Process
        Dim Filepath As String
        Dim Filenamepath As String
        Dim LineOfText As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = True
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        OpenFileDialog1.ShowDialog()
        FileOpen(1, "C:\N8VEM\cpm_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "F:") ' go to the F drive
        For Each Filenamepath In OpenFileDialog1.FileNames
            LineOfText = Strings.Mid(Filenamepath, 10) ' remove the file path
            LineOfText = "R " + LineOfText ' add R which runs R.COM on the simh
            PrintLine(1, LineOfText) ' read a file into the SIMH
        Next Filenamepath
        FileClose(1)
        ' create a new romimage and ramimage and run a batch file to copy files to the simh
        ' and then save the new romimage
        ' need to create three files
        ' 1) is a batch file that has a single line to run the simh
        ' 2) is the startup file for the simh (no extension) that sets all the parameters
        ' 3) is a series of commands for the simh eg a series of w filename commands to read and write files
        ' ****
        ' 1) create the batch file
        FileOpen(1, "C:\N8VEM\OneMeg.BAT", OpenMode.Output) ' open a file
        PrintLine(1, "altairZ80 n8vem") ' run n8vem (no extension)
        FileClose(1)
        ' 2) create the startup file
        FileOpen(1, "C:\N8VEM\n8vem", OpenMode.Output) ' open a file
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu noaltairrom")
        PrintLine(1, "set n8vem enabled")
        PrintLine(1, "set sio ansi") ' keyboard input
        PrintLine(1, "set sio port=68/0/0/0/0/f/0/t") ' otherwise the calls to the uart hang the simulation
        PrintLine(1, "set sio port=6d/00/01/0/20/f/0/f")
        '; Save ROM and RAM contents on exit
        PrintLine(1, "d n8vem saverom 1")
        PrintLine(1, "d n8vem saveram 1")
        '; image file for ROM and RAM
        PrintLine(1, "att n8vem0 romimage.bin")
        PrintLine(1, "att n8vem1 ramimage.bin")
        ' either "go" or run the cpm_cmd file below
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "echo *************************************")
        PrintLine(1, "echo Type ^E to save and exit (Ctrl and E)")
        PrintLine(1, "echo *************************************")
        PrintLine(1, "attach sio cpm_cmd") ' attach the little file below to run a batch
        PrintLine(1, "go")
        PrintLine(1, "bye")
        FileClose(1)
        ' shell the altair SIMH
        Location.StartInfo.FileName = "OneMeg.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\"
        Location.Start() ' shell the batch file
    End Sub

    Private Sub Button20_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button20.Click
        Dim Location As New Process
        ' see above for explanation of code. This is very similar except no command file
        FileOpen(1, "C:\N8VEM\OneMeg.BAT", OpenMode.Output) ' open a file
        PrintLine(1, "altairZ80 n8vem") ' run n8vem (no extension)
        FileClose(1)
        ' 2) create the startup file
        FileOpen(1, "C:\N8VEM\n8vem", OpenMode.Output) ' open a file
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu noaltairrom")
        PrintLine(1, "set n8vem enabled")
        PrintLine(1, "set sio ansi") ' keyboard input
        PrintLine(1, "set sio port=68/0/0/0/0/f/0/t") ' otherwise the calls to the uart hang the simulation
        PrintLine(1, "set sio port=6d/00/01/0/20/f/0/f")
        '; Save ROM and RAM contents on exit
        PrintLine(1, "d n8vem saverom 1")
        PrintLine(1, "d n8vem saveram 1")
        '; image file for ROM and RAM
        PrintLine(1, "att n8vem0 romimage.bin")
        PrintLine(1, "att n8vem1 ramimage.bin")
        ' either "go" or run the cpm_cmd file below
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "echo *************************************")
        PrintLine(1, "echo Type ^E to save and exit (Ctrl and E)")
        PrintLine(1, "echo *************************************")
        PrintLine(1, "go")
        PrintLine(1, "bye")
        FileClose(1)
        ' shell the altair SIMH
        Location.StartInfo.FileName = "OneMeg.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\"
        Location.Start() ' shell the batch file
    End Sub

    Private Sub EchoonToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        EchoOn = True
        Call StringToPacket("Echoon" + vbCr)
        TextBox3.Focus()
    End Sub

    Private Sub EchoOffToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        EchoOn = False
        Call StringToPacket("EchoOff" + vbCr)
        TextBox3.Focus()
    End Sub




    Private Sub NewToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NewToolStripMenuItem.Click
        Call SaveINI()
    End Sub
    Sub LoadINI()
        Dim LineOfText As String
        Try
            FileOpen(1, "C:\N8VEM\Settings.INI", OpenMode.Input) ' open a file
            LineOfText = LineInput(1)
            If SerialPortFound = True Then
                SerialPort1.PortName = LineOfText
            End If
            LineOfText = LineInput(1)
            If SerialPortFound = True Then
                SerialPort1.BaudRate = LineOfText
            End If
            FileClose(1)
        Catch ex As Exception
            FileClose(1)
            Call SaveINI() ' start a new file
            MsgBox("C:\N8VEM\Settings.INI saved, please restart the program. Also, if you got a fatal exception error when this program started, it could be because the winsock dll is not installed. You need to get the w3scokets.zip file, put the dll in c:\windows\system32, and run the registration program")
            End
        End Try
    End Sub

    Sub SaveINI()
        Dim LineOfText As String
        FileOpen(1, "C:\N8VEM\Settings.INI", OpenMode.Output) ' open a file
        LineOfText = InputBox("Serial com port eg COM1 or COM4 :", "", "COM1")
        PrintLine(1, LineOfText)
        LineOfText = InputBox("Baud rate eg 1200 9600 or 38400", "", "38400")
        PrintLine(1, LineOfText)
        FileClose(1)
        MsgBox("Shutting down the program, please restart")
        End ' shut down the program as too hard to restart

    End Sub
    Private Sub MenuOnToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        TextBox3.Focus()
    End Sub

    Private Sub DisplayAsciiCharactersToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        RadioAsciiCharacters = True
    End Sub

    Private Sub Button25_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button25.Click
        OutPacket(0) = Val(TextBox15.Text)
        SerialPort1.Write(OutPacket, 0, 1)
    End Sub

    Private Sub Button26_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button26.Click
        'http://www.dimac.net/Products/FreeProducts/w3Sockets/Reference/Refstart.htm
        Dim i As Integer
        Dim returnstring As String
        Dim sendstring As String
        Dim getchar As String
        sendstring = "dir" + vbCrLf
        w3sock.TimeOut = 5000 ' long enough to do a compile for a big program?
        w3sock.DoTelnetEmulation = True
        w3sock.TelnetEmulation = "TTY"
        w3sock.Host = "n8vem.homedns.org:3001"
        w3sock.Open()
        ' w3sock.sendline doesnt seem to work
        ' w3sock.sendtext can't send as one line, need to send with delay between each char
        'w3sock.WaitFor(">")
        For i = 1 To Len(sendstring)
            w3sock.SendText(Strings.Mid(sendstring, i, 1))
            'w3sock.SendText(Strings.Chr(i))
            'Sleep(50) ' 10 doesnt work, 50 does, 25 borderline
            Sleep(50)
        Next
        'Sleep(500)
        'w3sock.SendText(Strings.Chr(255)) ' this works, test with the lantr.com program
        'MsgBox("waiting for return line") ' finishes with a cr
        'returnstring = w3sock.GetLine()
        'w3sock.WaitFor(">") ' this works
        'returnstring = w3sock.GetText(1) ' get n characters this does not seem to work
        returnstring = w3sock.GetLine ' this does work
        i = w3sock.BytesInBuffer ' this works
        w3sock.Wait()
        'returnstring = w3sock.peek(2)
        'MsgBox(i)
        'If i > 0 Then
        'returnstring = w3sock.Buffer
        'End If
        w3sock.Close() ' close the socket
        MsgBox(returnstring)
    End Sub

    Sub XModemFSend(ByRef FName As String, ByVal XMVersion As String, ByVal CPMMPM As String)
        Dim Filenamepath As String
        Dim a, j, i As Integer
        Dim k As Integer
        Dim LineOfText As String
        Dim SerialString As String
        Dim Counter As Integer
        Dim ErrorString As String
        Dim Packetnumber As Integer
        Dim Checksum As Long
        Dim OnesComplement As Byte
        Dim ByteRead As Byte
        Dim BinaryFileLength As Long
        Dim BinaryFileCounter As Long
        Dim Percent As Single
        Dim ErrorCounter As Byte ' 0 to 10
        Dim CPMFilename As String
        ProgressBar1.Maximum = 100
        ProgressBar1.Minimum = 0
        ' timer restart =true for sending via menu. False for auto send
        Filenamepath = FName
        Packetnumber = 1 ' 1 for the first packet (not zero)
        Try
            Dim Input As New FileStream(Filenamepath, FileMode.Open, FileAccess.Read)
            Dim br As New BinaryReader(Input)
            Label3.Text = "Error Count"
            Label2.Text = "0%"
            BinaryFileLength = br.BaseStream.Length() - 1
            'i = Len(Filepath) + 1 + 1  ' eg c:\n8vem and a \ = 9 and 1 more for start of name only
            Call Get_CPM_Filename(Filenamepath, CPMFilename)
            CPMFilename = Strings.UCase(CPMFilename)
            Call StringToPacket(vbCr)
            Sleep(100)
            LineOfText = "ERA " + CPMFilename + vbCr
            Call StringToPacket(LineOfText)
            Call WaitForPrompt()
            ' extended to 4000 with MPM running other programs in the background
            ' mod June 2009 to run new xmodemf which deletes and undone again as doesnt work
            ' MPM increased from 500 to 2000
            LineOfText = XMVersion + " R " + CPMFilename + vbCr ' eg XMODEMF or XMODEMP or XMMPM1
            Call StringToPacket(LineOfText) ' 
            Call ClearInputBuffer()  ' clear the buffer into the PC
            For i = 1 To 35 ' need to wait till "Ready to Receive" appears on the screen
                ' 30 works for some but 35 is safer, 32 sometimes errors
                Sleep(100) ' wait for the xmodem text to come back so the next one is a 21
                Label3.Text = Str$(i)
                Call ClearInputBuffer()  ' clear the buffer into the PC
            Next i
            ' xmodem is taking 2 seconds to acknowledge so have at least this much time
            Do
                SerialString = ""
                If SerialPortFound = True Then
                    If SerialPort1.BytesToRead > 0 Then
                        SerialPort1.Read(InPacket, 0, 1) ' get one byte
                        SerialString = Chr(InPacket(0)) ' get a single character/string/byte
                    End If
                End If
                If InPacket(0) = 21 Then
                    ErrorString = "NAK"
                    Exit Do ' got a ^U
                End If
                If SerialString <> "" Then
                    'LineOfText = SerialString
                    'Call TextLines(LineOfText) ' print it out unless it is a chr21
                End If
                Counter = Counter + 10
                Sleep(10) ' don't change this one - this is waiting for NAK
                Label1.Text = "Waiting for NAK to start" + Strings.Str(Counter) + "ms" ' display in milliseconds
                System.Windows.Forms.Application.DoEvents() ' update the label1 message
                ' add a counter and timeout if nothing
                If Counter > 5000 Then
                    ErrorString = "Bypass wait for NAK - xmodem failed"
                    Exit Do
                End If
                If ErrorString <> "" Then Exit Do
            Loop
            Label1.Text = ErrorString
            System.Windows.Forms.Application.DoEvents() ' update the label1 message
            ' bug with vb.net - strings don't go to 255 so have to send data as bytes
            Do
                ' act on each byte in the buffer array here
                Sleep(1) ' 60 for 4800 but 1 working for 38400
                'If Radio1200 = True Then Sleep(250)
                XOut(0) = 1 'SOH ^A
                XOut(1) = Packetnumber
                OnesComplement = 255 - Packetnumber
                XOut(2) = OnesComplement
                Packetnumber = Packetnumber + 1
                If Packetnumber > 255 Then Packetnumber = Packetnumber - 256
                Checksum = 0
                For i = 0 To 127 ' get 128 bytes from file
                    If BinaryFileCounter <= BinaryFileLength Then
                        ByteRead = br.ReadByte ' get a byte
                    Else
                        ByteRead = 26 ' pad with char 26 = hex 1A because hyperterm does this ? why but it works
                    End If
                    XOut(i + 3) = ByteRead
                    Checksum = Checksum + ByteRead
                    BinaryFileCounter = BinaryFileCounter + 1
                Next
                ' create checksum
                Do
                    If Checksum < 256 Then Exit Do ' work out checksum
                    Checksum = Checksum - 256
                Loop
                XOut(131) = Checksum
                If CPMMPM = "CPM" Then
                    Call OutputXout()
                Else
                    Call OutputXoutSlow() ' for MPM
                End If
                System.Windows.Forms.Application.DoEvents() ' update the label
                Do
                    k = 0
                    Do
                        Sleep(10) '80 for 4800  wait for the acknowledge which is a character 6 delay of 80 only occasionally loops so k>0
                        If SerialPortFound = True Then
                            j = SerialPort1.BytesToRead
                        End If
                        If j >= 1 Then
                            If SerialPortFound = True Then
                                SerialPort1.Read(InPacket, 0, 1) ' get one byte
                            End If
                            Exit Do
                        End If
                        k = k + 1
                        If k > 70 Then
                            InPacket(0) = 0 ' for below error testing
                            Exit Do
                        End If
                    Loop
                    If InPacket(0) = 6 Then Exit Do ' board got the packet
                    If InPacket(0) = 21 Or InPacket(0) = 0 Then
                        ' didn't get it so try sending again
                        ErrorCounter = ErrorCounter + 1
                        If CPMMPM = "CPM" Then
                            Call OutputXout()
                        Else
                            Call OutputXoutSlow() ' for MPM
                        End If
                        If InPacket(0) = 0 Then
                            Label3.Text = "Timeout waiting for Ack"
                            ErrorCounter = 20 'force an exit now
                            System.Windows.Forms.Application.DoEvents() ' update the label
                        Else
                            Label3.Text = "Nak: " + Strings.Str(ErrorCounter)
                            System.Windows.Forms.Application.DoEvents() ' update the label
                        End If
                    End If
                    If ErrorCounter >= 2 Then Exit Do ' standard xmodem is 10 but make this 2
                Loop
                If ErrorCounter >= 2 Then
                    Label1.Text = "2 or more errors - aborting"
                    Label2.Text = "0%"
                    OutPacket(0) = 24 ' send a ^X cancel
                    If SerialPortFound = True Then
                        SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
                        OutPacket(0) = 3 ' send a ^C
                        SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
                    End If
                    Exit Do
                End If
                If BinaryFileCounter > BinaryFileLength Then Exit Do ' finish up
                Label1.Text = "Sent packet: " + Strings.Str(Packetnumber) + " = OK"
                Percent = BinaryFileCounter / BinaryFileLength
                Percent = Percent * 100
                Percent = Int(Percent)
                Label2.Text = Strings.Str(Percent) + "%"
                ProgressBar1.Value = Percent
            Loop
            If ErrorCounter < 3 Then
                Sleep(100)
                OutPacket(0) = 4
                If SerialPortFound = True Then
                    SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
                End If
                Label2.Text = "100%"
                Label1.Text = "Finished"
                ProgressBar1.Value = 0 'done
                LineOfText = vbCrLf ' sometimes mpm errors with rubbish bytes so return to prompt
                Call StringToPacket(LineOfText) ' 
                'LineOfText = vbCrLf
            End If
            Input.Close()
            Sleep(200) ' wait for next file
            System.Windows.Forms.Application.DoEvents() ' update the labels
        Catch ex As Exception
            Close()
            Label1.Text = Filenamepath + " not found"
            System.Windows.Forms.Application.DoEvents() ' update the labels
            Sleep(1000) ' so time to read message
        End Try
    End Sub
    Private Sub Button28_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button28.Click
        'RichTextBox4.AcceptsTab = True at startup so tabs stay in the text box
        AssemblyFile = "NEW.ASM"
        AssemblyFile = InputBox("Filename eg MYFILE.ASM (no more than 8 characters):", , AssemblyFile)
        AssemblyFile = Strings.UCase(AssemblyFile)
        Label41.Text = AssemblyFile
        RichTextBox4.Text = ""
        'RichTextBox4.AppendText(vbTab + ".TITLE	Assembly for the N8VEM using Bill Beech's RASM compiler" + vbCrLf)
        RichTextBox4.AppendText(vbTab + ".Z80" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "org 100H" + vbCrLf)
        RichTextBox4.AppendText("bios  equ   0005H" + vbCrLf)
        RichTextBox4.AppendText("main:" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "ld    e,65" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "call  writeconsole" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "ret" + vbCrLf)
        RichTextBox4.AppendText("writeconsole:          ; print letter in E" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "ld    c,2" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "call  bios" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "ret" + vbCrLf)
        RichTextBox4.AppendText(vbTab + "end" + vbCrLf)
        RichTextBox4.Focus()
    End Sub

    Private Sub Button32_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button32.Click
        ' compile with Bill Beech's RASM assembler, download and run
        Dim Location As New Process
        Dim filename1 As String
        Dim filename2 As String
        Dim filename_noextension As String
        Dim batchcommand As String
        Dim LineOfText As String
        Call SaveAssemblyFile()
        filename1 = AssemblyFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 4)
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long and won't work with CP/M. Suggest renaming file")
        End If
        filename2 = filename_noextension + ".COM"
        batchcommand = "rasm -b -l " + filename_noextension
        FileOpen(1, "C:\N8vem\ASM.BAT", OpenMode.Output)
        PrintLine(1, batchcommand)
        FileClose(1)
        Location.StartInfo.FileName = "ASM.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem"
        Location.Start() ' shell the batch file
        Do
            ' wait till batch file finishes
        Loop Until Location.HasExited = True
        Try
            Kill("C:\N8VEM\" + filename_noextension + ".COM")
        Catch ex As Exception
            ' file didn't exist
        End Try
        ' test .lst file to see if any errors. If ok last line will be "No error(s) found"
        FileOpen(1, "C:\N8vem\" + filename_noextension + ".LST", OpenMode.Input)
        Do Until EOF(1)
            LineOfText = LineInput(1) ' leaves last line with the error message or not
        Loop
        FileClose(1)
        If LineOfText = "No error(s) found" Then
            ' rename the file
            TabControl1.SelectedIndex = 0 ' display cp/m
            TextBox3.Focus() 'display to cp/m
            Rename("C:\N8VEM\" + filename_noextension + ".BIN", "C:\N8VEM\" + filename_noextension + ".COM") ' bills program makes.bin files
            TimerOff()
            Call StringToPacket(vbCr) ' clear any rubbish that might be on the terminal
            Call WaitForPrompt()
            Call XModemFSend("C:\N8VEM\" + filename2, "XMODEMF", "CPM")
            Call WaitForPrompt()
            Call StringToPacket(filename_noextension + vbLf) ' don't use crlf as the extra cr character upsets the first read console call in routines.asm
            TimerOn()
        Else
            ' error found so recompile and leave the batch file window open
            FileOpen(1, "C:\N8vem\ERROR.BAT", OpenMode.Output)
            PrintLine(1, batchcommand)
            PrintLine(1, "Pause") ' leaves the batch file running
            FileClose(1)
            Location.StartInfo.FileName = "ERROR.BAT"
            Location.StartInfo.WorkingDirectory = "C:\n8vem"
            Location.Start() ' shell the batch file
            TimerOn()
        End If
    End Sub

    Private Sub Button31_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button31.Click
        Call SaveAssemblyFile()
    End Sub
    Sub SaveAssemblyFile()
        If AssemblyFile = "" Then
            AssemblyFile = InputBox("Filename eg MYFILE.ASM: ", , AssemblyFile)
            Label41.Text = AssemblyFile
        End If
        RichTextBox4.SaveFile("C:\N8VEM\" + AssemblyFile, RichTextBoxStreamType.PlainText)
        RichTextBox4.Focus()
    End Sub
    Private Sub Button33_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button33.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = AssemblyFile
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        Try
            RichTextBox4.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
            AssemblyFile = Strings.Mid(Filenamepath, 10)
            Label41.Text = AssemblyFile
            RichTextBox4.Focus()
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub

    Private Sub Button30_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button30.Click
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.ASM"
        OpenFileDialog1.ShowDialog()
        AssemblyFile = OpenFileDialog1.FileName
        AssemblyFile = Strings.Mid(AssemblyFile, 10) ' strip off directory
        AssemblyFile = Strings.UCase(AssemblyFile)
        Label41.Text = AssemblyFile
        Try
            RichTextBox4.LoadFile("C:\N8VEM\" + AssemblyFile, RichTextBoxStreamType.PlainText)
            'TabControl1.SelectedIndex = 1
            RichTextBox4.Focus()
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub

    Private Sub Button27_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button27.Click
        Dim Location As New Process
        Location.StartInfo.FileName = Strings.Left(Label41.Text, Len(Label41.Text) - 4) + ".LST"
        Location.StartInfo.WorkingDirectory = "C:\n8vem"
        Location.Start()
    End Sub

    Sub NumberToHex(ByRef N As Integer, ByRef Hexstring As String)
        ' 0 to 255 and returns $00 to $FF
        Hexstring = Strings.Hex(N)
        Hexstring = Trim(Hexstring)
        If N < 16 Then Hexstring = "0" + Hexstring
        Hexstring = "$" + Hexstring
    End Sub


    'Private Sub Button34_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button34.Click
    ' ' create the batch file Makerom.bat
    ' Dim LineOfText As String
    ' Dim FileBin As String
    ' Dim FileLocation As String
    ' Dim Complete As String
    ' Dim Complete2 As String
    ' Dim i As Integer
    '     Button34.ForeColor = Color.Green
    '     System.Windows.Forms.Application.DoEvents()
    '     Sleep(200)
    '     Call Fill16k() ' creates 32k.bin filled with E5
    '     FileLocation = TextBox2.Text + "\" + TextBox8.Text
    '     FileOpen(1, FileLocation, OpenMode.Output)
    '    For i = 0 To ListBox2.Items.Count - 1
    '        Complete = Complete + ListBox2.Items(i) + "+"
    '    Next
    '    Complete = Complete + "16kFF.bin"
    'Complete = Strings.Left(Complete, Len(Complete) - 1) ' remove the last +
    '    FileBin = Strings.Left(TextBox4.Text, Len(TextBox4.Text) - 4) + ".bin"
    '    PrintLine(1, "tasm -t80 -b " + TextBox4.Text + " " + FileBin)
    '    Complete2 = "copy /B " + FileBin
    '    FileBin = Strings.Left(TextBox12.Text, Len(TextBox12.Text) - 4) + ".bin"
    '    PrintLine(1, "tasm -t80 -b " + TextBox12.Text + " " + FileBin)
    '    Complete2 = Complete2 + "+" + FileBin
    '    FileBin = Strings.Left(TextBox6.Text, Len(TextBox6.Text) - 4) + ".bin"
    '    PrintLine(1, "tasm -t80 -b " + TextBox6.Text + " " + FileBin)
    '    Complete2 = Complete2 + "+" + FileBin
    '    FileBin = Strings.Left(TextBox17.Text, Len(TextBox17.Text) - 4) + ".bin"
    '    PrintLine(1, "tasm -t80 -b -fE5 " + TextBox17.Text + " " + FileBin)
    '    Complete2 = Complete2 + "+" + FileBin
    '    Complete = Complete2 + "+" + Complete + " " + TextBox11.Text
    '    PrintLine(1, Complete)
    '   PrintLine(1, "pause")
    '    FileClose(1)
    '    Button34.ForeColor = Color.Black
    'End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        Dim a As Integer
        a = ListBox2.SelectedIndex
        If a = -1 Then
            MsgBox("No item selected")
        Else
            ListBox2.Items.RemoveAt(a)
        End If
    End Sub

    Private Sub Button29_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button29.Click
        Dim LineOfText As String
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = True
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        OpenFileDialog1.ShowDialog()
        For Each Filenamepath In OpenFileDialog1.FileNames
            LineOfText = Strings.Mid(Filenamepath, 10) ' remove the full directory listing
            LineOfText = Strings.UCase(LineOfText)
            Call ListBox2.Items.Add(LineOfText)
        Next Filenamepath
    End Sub

    Private Sub Button35_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button35.Click
        Dim DiskImage(0 To &H7FFF) As Byte
        Dim LineOfText As String
        Dim Filenamepath As String
        Dim BinaryFileLength As Long
        Dim Records As Integer ' 128 bytes
        Dim rc As Long
        Dim i As Integer
        Dim ListboxCounter
        Dim Blocks As Integer ' 1024 bytes
        Dim bc As Long
        Dim DiskPointer As Long
        Dim ByteRead As Byte
        Dim FilePointer As Long
        Dim DiskMapCounter As Long
        Dim FileNameBuild As String
        Dim FCB(0 To 31) As Byte
        Dim DirectoryPointer As Long
        Dim ProgressString As String
        Dim RemainingBytes As Long
        RichTextBox5.Clear()
        Button35.ForeColor = Color.Green
        System.Windows.Forms.Application.DoEvents()
        Sleep(200)
        DiskPointer = &H2C00
        FilePointer = &H2C00
        RemainingBytes = &H8000 - &H2C00
        For i = &H0 To &H7FFF ' Do this in hex
            DiskImage(i) = &HE5 ' clear the disk
        Next
        ' files start at 2C00 and go to 7FFF which is 11264 up
        For ListboxCounter = 0 To ListBox2.Items.Count - 1
            LineOfText = ListBox2.Items(ListboxCounter)
            Filenamepath = "C:\N8VEM\" + LineOfText
            Dim BinaryInput As New FileStream(Filenamepath, FileMode.Open, FileAccess.Read)
            Dim br As New BinaryReader(BinaryInput)
            BinaryFileLength = br.BaseStream.Length() - 1
            rc = 0 ' there is a way to do with with integer division but it is complicated
            Records = 0 ' and involves adding 0.5 to the integer afterwards and MOD
            Do Until rc > BinaryFileLength
                Records = Records + 1
                rc = rc + 128
            Loop
            bc = 0
            Blocks = 0
            Do Until bc > BinaryFileLength
                Blocks = Blocks + 1
                bc = bc + 1024
            Loop
            For i = 0 To BinaryFileLength
                ByteRead = br.ReadByte ' get a byte
                DiskImage(DiskPointer) = ByteRead
                DiskPointer = DiskPointer + 1
            Next
            BinaryInput.Close() ' close the binary file
            FilePointer = FilePointer + Blocks * 1024 ' get location for next file
            DiskPointer = FilePointer ' ready for next file
            ProgressString = LineOfText + " " + Strings.Str(Blocks) + "k" + vbCrLf
            RichTextBox5.AppendText(ProgressString)
            RemainingBytes = RemainingBytes - Blocks * 1024
            ProgressString = "Free: " + Strings.Str(RemainingBytes) + vbCrLf
            RichTextBox5.AppendText(ProgressString)
        Next
        ' now create the directory listing starts at &h2800
        DiskMapCounter = 1 ' start at 1 and add for each file
        DirectoryPointer = &H2800 ' start here
        For ListboxCounter = 0 To ListBox2.Items.Count - 1
            LineOfText = ListBox2.Items(ListboxCounter)
            Filenamepath = "C:\N8VEM\" + LineOfText
            Dim Input As New FileStream(Filenamepath, FileMode.Open, FileAccess.Read)
            Dim br As New BinaryReader(Input)
            BinaryFileLength = br.BaseStream.Length() - 1 ' 2279 for xmodem
            Input.Close() ' close the binary file
            rc = 0 ' there is a way to do with with integer division but it is complicated
            Records = 0 ' and involves adding 0.5 to the integer afterwards and MOD
            Do Until rc > BinaryFileLength
                Records = Records + 1
                rc = rc + 128
            Loop
            bc = 0
            Blocks = 0
            Do Until bc > BinaryFileLength
                Blocks = Blocks + 1
                bc = bc + 1024
            Loop
            For i = 0 To 31
                FCB(i) = 0 ' clear the fcb as most bytes are zero
            Next
            i = Strings.InStr(LineOfText, ".")
            FileNameBuild = Strings.Left(LineOfText, i - 1) + "        " ' add spaces
            FileNameBuild = Strings.Left(FileNameBuild, 8) 'truncate to 8
            FileNameBuild += Strings.Mid(LineOfText, i + 1, 3) ' add the extension
            For i = 1 To Len(FileNameBuild)
                FCB(i) = Strings.Asc(Strings.Mid(FileNameBuild, i, 1))
            Next
            FCB(15) = Records
            ' list of 1k blocks
            For i = 1 To Blocks ' fill up the array
                FCB(i + 15) = DiskMapCounter ' start at 16
                DiskMapCounter = DiskMapCounter + 1
            Next
            For i = 0 To 31
                DiskImage(DirectoryPointer) = FCB(i)
                DirectoryPointer = DirectoryPointer + 1 ' add one
            Next
        Next
        ' now save this to a binary file
        Filenamepath = "C:\N8VEM\BDRIVE.BIN"
        Dim BinaryOutput As New FileStream(Filenamepath, FileMode.Create, FileAccess.Write)
        BinaryOutput.Write(DiskImage, &H2800, &H7FFF - &H2800)
        BinaryOutput.Close()
        Button35.ForeColor = Color.Black
    End Sub

    Private Sub Button36_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button36.Click
        ' create the batch file Makerom.bat
        Dim LineOfText As String
        Dim FileBin As String
        Dim FileLocation As String
        Dim Complete As String
        Dim Complete2 As String
        Dim i As Integer
        Button36.ForeColor = Color.Green
        System.Windows.Forms.Application.DoEvents()
        Sleep(200)
        FileLocation = TextBox2.Text + "\" + TextBox8.Text
        FileOpen(1, FileLocation, OpenMode.Output)
        FileBin = Strings.Left(TextBox4.Text, Len(TextBox4.Text) - 4) + ".bin"
        PrintLine(1, "tasm -t80 -b " + TextBox4.Text + " " + FileBin)
        Complete2 = "copy /B " + FileBin
        FileBin = Strings.Left(TextBox12.Text, Len(TextBox12.Text) - 4) + ".bin"
        PrintLine(1, "tasm -t80 -b " + TextBox12.Text + " " + FileBin)
        Complete2 = Complete2 + "+" + FileBin
        FileBin = Strings.Left(TextBox6.Text, Len(TextBox6.Text) - 4) + ".bin"
        PrintLine(1, "tasm -t80 -b " + TextBox6.Text + " " + FileBin)
        Complete2 = Complete2 + "+" + FileBin
        Complete = Complete2 + "+" + "BDRIVE.BIN" + " " + TextBox11.Text
        PrintLine(1, Complete)
        PrintLine(1, "pause")
        FileClose(1)
        Button36.ForeColor = Color.Black
    End Sub

    Private Sub RadioButton1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton1.CheckedChanged
        TextBox5.Text = "dbgmon96.asm"
    End Sub

    Private Sub RadioButton2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton2.CheckedChanged
        TextBox5.Text = "dbgmon38.asm"
    End Sub

    Private Sub RadioButton3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton3.CheckedChanged
        TextBox5.Text = "dbgmon_autocpm_1200.asm"
    End Sub

    Private Sub RadioButton4_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton4.CheckedChanged
        TextBox5.Text = "dbgmon_autocpm_9600.asm"
    End Sub

    Private Sub RadioButton5_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton5.CheckedChanged
        TextBox5.Text = "dbgmon_autocpm_38400.asm"
    End Sub

    Private Sub RadioButton6_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton6.CheckedChanged
        TextBox5.Text = "dbgmon_autocpm_38400_key_lcd.asm"
    End Sub

    Private Sub Button34_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button34.Click
        BDSCfile = "NEW.C"
        BDSCfile = InputBox("Filename eg MYFILE.C (no more than 8 characters):", , BDSCfile)
        BDSCfile = Strings.UCase(BDSCfile)
        Label12.Text = BDSCfile
        RichTextBox6.Text = ""
        RichTextBox6.AppendText("/*" + vbCrLf)
        RichTextBox6.AppendText("Hello world example in BDS C" + vbCrLf)
        RichTextBox6.AppendText("*/" + vbCrLf)
        RichTextBox6.AppendText("#include <stdio.h>" + vbCrLf)
        RichTextBox6.AppendText("main()" + vbCrLf)
        RichTextBox6.AppendText("{" + vbCrLf)
        RichTextBox6.AppendText("     printf(" + Chr(34) + "Hello World\n" + Chr(34) + ");" + vbCrLf)
        RichTextBox6.AppendText("}" + vbCrLf)
        TabControl1.SelectedIndex = 7
        RichTextBox6.Focus()
    End Sub

    Private Sub Button37_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button37.Click
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.C"
        OpenFileDialog1.ShowDialog()
        BDSCfile = OpenFileDialog1.FileName
        BDSCfile = Strings.Mid(BDSCfile, 10) ' strip off directory
        BDSCfile = Strings.UCase(BDSCfile)
        Label12.Text = BDSCfile
        Try
            RichTextBox6.LoadFile("C:\N8VEM\" + BDSCfile, RichTextBoxStreamType.PlainText)
            TabControl1.SelectedIndex = 7 ' tab number 0-7 (8)
            RichTextBox6.Focus()
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub

    Private Sub Button38_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button38.Click
        Call SaveBDSC()
    End Sub
    Sub SaveBDSC()
        If BDSCfile = "" Then
            BDSCfile = InputBox("Filename eg MYFILE.C: ", , BDSCfile)
            Label12.Text = BDSCfile
        End If
        RichTextBox6.SaveFile("C:\N8VEM\" + BDSCfile, RichTextBoxStreamType.PlainText)
        RichTextBox6.Focus()
        BDSCchanged = False
    End Sub
    Private Sub Button39_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button39.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = BDSCfile ' ? put CPM files somewhere safe
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        Try
            RichTextBox6.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
            BDSCfile = Strings.Mid(Filenamepath, 10)
            Label12.Text = BDSCfile
            RichTextBox6.Focus()
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub
    Private Sub Button40_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button40.Click
        Dim Filename1 As String
        Call CompileBDSC() ' compile with halt so simh stops
        Filename1 = Strings.Left(BDSCfile, Len(BDSCfile) - 2) ' remove extension
        Call StringToPacket(vbCrLf)
        Sleep(100)
        Call StringToPacket(Filename1 + vbCrLf)
    End Sub

    Sub CompileBDSC()
        Dim Location As New Process
        Dim Filename1 As String
        Dim PipInstruction As String
        Dim i As Integer
        Try
            Call SaveBDSC()
            TimerOff()
            TextBox1.Text = ""
            TextBox1.Refresh()
            Filename1 = Strings.Left(BDSCfile, Len(BDSCfile) - 2) ' remove extension
            FileCopy("C:\N8VEM\" + Filename1 + ".C", "C:\N8VEM\AltairSIMH\" + Filename1 + ".C")
            Location.StartInfo.FileName = "AltairAllTelnet.bat" ' order of disks in file telnet
            Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
            TabControl1.SelectedIndex = 2 ' to tab 2 which is the simh console so can see any errors
            System.Windows.Forms.Application.DoEvents() ' update the display
            Location.Start() ' shell the batch file
            w3sock.TimeOut = 15000 ' long enough to do a compile for a big program?
            w3sock.DoTelnetEmulation = True
            ' many experiments trying to trap errors. If you erase the .com before starting
            ' anything then for some reason the first few commands don't show up on the console
            ' so you either have a choice of erasing which doesn't work or you can show the 
            ' error messages but they are really hard to spot. It should not create a file if it errors
            ' but it does!!
            ' ok, start with a new file and put an error in it and it will stop as expected
            ' so it is imperative to delete any .com files of the same name before starting to compile
            ' how do we see this if the console will not display the first few messages??
            ' well if you do an era it does not work, which is very strange. Put the era
            ' after the R command which is reading in the .c file but there is no .com yet
            ' however, it writes a .com. It should error when write a .com that does not exist.
            ' this is so hard to debug if you can't see this. 
            ' maybe a batch file??
            ' ha, I found it. CLINK will happily compile a program even if CC produced errors
            ' tested this on the simh as individual commands.
            ' so need some other way to detect errors
            ' ok, here is an idea, try deleting the CRL file as well
            ' see also the sbasic routines as ended up doing it another way
            TextBox1.Text = ""
            TextBox1.Refresh()
            TabControl1.SelectedIndex = 2 ' tab 2 shows what is going on
            TextBox1.Focus() ' cursor to textbox1 so highlights the error
            w3sock.TelnetEmulation = "TTY"
            w3sock.Host = "Localhost:23"
            w3sock.Open()
            w3sock.WaitFor(">")
            w3sock.SendText("E:" + vbCrLf) ' change to drive E (altairalltelnet.bat different to the directory C, is on E)
            w3sock.WaitFor("E>")
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("R " + Filename1 + ".C" + vbCrLf) ' copy to the simh from pc directory
            Sleep(200)
            w3sock.WaitFor("E>")
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("CC " + Filename1 + vbCrLf) ' compile
            Sleep(100) ' will take longer than this
            w3sock.WaitFor("E>")
            Call RefreshTextBox1() ' display messages etc as they come in
            w3sock.SendText("CLINK " + Filename1 + vbCrLf) ' compile
            Sleep(100)
            w3sock.WaitFor("E>") ' wait for the > prompt to come back
            Call RefreshTextBox1() ' display error messages etc as they come in
            For i = 1 To 2
                w3sock.SendText(vbCrLf) ' in case hangs send a few CRs
                Sleep(200)
                w3sock.WaitFor("E>")
            Next
            w3sock.SendText("W " + Filename1 + ".COM" + vbCrLf) ' write back to PC directory
            Sleep(400)
            w3sock.WaitFor("E>")
            RefreshTextBox1()
            For i = 1 To 2
                w3sock.SendText(vbCrLf) ' in case hangs send a couple of CRs
                Sleep(100)
                w3sock.WaitFor("E>")
            Next
            'erase the files on the simh otherwise fill up the 1mb disk image
            w3sock.SendText("ERA " + Filename1 + ".C" + vbCrLf) ' so don't clutter up simulated drive D
            Sleep(100)
            w3sock.WaitFor("E>")
            Call RefreshTextBox1()
            w3sock.SendText("ERA " + Filename1 + ".COM" + vbCrLf)
            Sleep(100)
            w3sock.WaitFor("E>")
            w3sock.SendText("ERA " + Filename1 + ".CRL" + vbCrLf)
            Sleep(100)
            w3sock.WaitFor("E>")
            'now halt the simh program 
            w3sock.SendText("HALT" + vbCrLf) ' halt the simh
            Call RefreshTextBox1()
            ' now copy file to c:\N8VEM
            FileCopy("C:\N8VEM\AltairSIMH\" + Filename1 + ".COM", "C:\N8VEM\" + Filename1 + ".COM")
            Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".C") ' clean up
            Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".COM") ' clean up
            ' and transfer it to the board
            w3sock.Close() ' close the socket
            ' leave the display box open in case there were errors.
            System.Windows.Forms.Application.DoEvents() ' update the display
            TabControl1.SelectedIndex = 0 ' to tab 0 cp/m window
            TextBox3.Focus() ' focus to cp/m window
            ' debug this in CP/M as MP/M is too unreliable. Boot into kyedos 
            ' and run cpm1.bin or cpm.bin
            ' send to user 0 as crashes user 1
            'Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well
            'Call WaitForPrompt()
            'Call StringToPacket("ERA " + Filename1 + ".COM" + vbCr)
            'Call WaitForPrompt()
            'Call StringToPacket("USER 1" + vbCr)
            'Call WaitForPrompt()
            'Call XModemFSend("C:\N8VEM\" + Filename1 + ".COM", "XM1", "CPM") 'send via xm1
            'Call WaitForPrompt()
            Call XModemFSend("C:\N8VEM\" + Filename1 + ".COM", "XMODEMF", "CPM") 'send via xmodemf
            Call WaitForPrompt()
            'PipInstruction = "PIP " + Filename1 + ".COM[G0]=" + Filename1 + ".COM[G1]" + vbCr
            'Call StringToPacket(PipInstruction)
            'Call WaitForPrompt()
        Catch ex As Exception
            ' errors eg if it didn't compile so there is no file to copy
            w3sock.Close() ' close the socket
            TextBox1.Text += vbCrLf + "Syntax error - aborting. Compile on the SIMH to see errors" + vbCrLf
            TextBox1.Refresh()
            TextBox1.SelectionStart = TextBox1.TextLength
            TextBox1.ScrollToCaret()
            TabControl1.SelectedIndex = 2 ' tab 2 has the error message
            TextBox1.Focus() ' cursor to textbox1 so highlights the error
        End Try
        TimerOn()
    End Sub
    Private Sub Button21_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button21.Click
        Label44.Text = "Waiting"
        w3sock.TimeOut = 5000 ' long enough to do a compile for a big program?
        w3sock.DoTelnetEmulation = True
        w3sock.TelnetEmulation = "TTY"
        w3sock.Host = "Localhost:23"
        w3sock.Open()
        w3sock.WaitFor("A")
        w3sock.Close() ' close the socket
        Label44.Text = "A received"
    End Sub

    Private Sub Button22_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button22.Click
        Dim Location As New Process
        ' Punch program (.mac)
        'FDOS	EQU	0005H	; COMMON ENTRY POINT FOR BIOS AND BDOS
        '		
        'MAIN:	
        '	
        '	LD E,65
        '	CALL WRITE_CONSOLE
        '	LD E,65
        '	CALL WRITE_PUNCH
        '
        '	RET		; back to cp/m
        '
        '; ************************************************		
        '; bdos calls that preserve registers 			
        'WARM_BOOT:
        '	LD C,0
        '	CALL FDOS
        '	RET			; probably doesn't need a RET!
        'READ_CONSOLE:		; returns answer in A
        '	LD C,1
        '	CALL FDOS
        '	RET
        'WRITE_CONSOLE:		; prints letter in E
        '	LD C,2		; FUNCTION NUMBER
        '	CALL FDOS
        '	RET
        '
        'WRITE_PUNCH:		; prints letter in E
        '	LD C,4		; FUNCTION NUMBER
        '	CALL FDOS
        '	RET
        '
        '	END

        FileOpen(1, "C:\N8VEM\AltairSIMH\Punch", OpenMode.Output) ' open a file called punch
        PrintLine(1, "set console telnet=23")
        PrintLine(1, "attach ptp punch.txt")
        PrintLine(1, "attach ptr reader.txt")
        PrintLine(1, "d tracks[0-7] 254")
        PrintLine(1, "attach dsk cpm2.dsk")
        PrintLine(1, "set cpu 64k")
        PrintLine(1, "set cpu noitrap")
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu altairrom")
        PrintLine(1, "set cpu nonbanked")
        PrintLine(1, "Reset cpu ")
        PrintLine(1, "set sio ansi")
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "boot dsk") ' will run till type HALT which runs HALT.COM
        PrintLine(1, "bye")
        FileClose(1)

        FileOpen(1, "C:\N8VEM\AltairSIMH\AltairPunch.bat", OpenMode.Output) ' open a file called punch.bat
        PrintLine(1, "altairz80 punch")
        FileClose(1)

        ' PROBLEM - can't open two winsock connections at the same time!
        ' one thing that does work is outputting to a file
        ' attach ptp punch.txt  and run PUNCH.COM and it writes to punch.txt
        ' but once the simh opens these files they are open for ever and vb.net can't write to them 
        ' (it might be able to open for read only)

        Location.StartInfo.FileName = "AltairPunch.bat"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
        Location.Start() ' shell the batch file
        w3sock.TimeOut = 5000 ' long enough to do a compile for a big program?
        w3sock.DoTelnetEmulation = True
        w3sock.TelnetEmulation = "TTY"
        w3sock.Host = "Localhost:23" ' 23 
        w3sock.Open()
        w3sock.WaitFor(">")

        ' let's be really mean to the simh and open punch.txt so simh can't write to it
        ' no this doesn't work because simh has already opened this file and so vb.net crashes 
        ' and ditto with reader.txt (?? can open for read only but still need to write somehow)
        'FileOpen(1, "C:\N8VEM\AltairSIMH\Punch.txt", OpenMode.Output) ' open a file called punch.txt
        'FileOpen(1, "C:\N8VEM\AltairSIMH\Reader.txt", OpenMode.Output) ' open file called reader.txt

        w3sock.SendText("PUNCH" + vbCrLf) ' run a little .com program called PUNCH.COM
        w3sock.WaitFor(">")
        'w3sock.SendText("HALT" + vbCrLf) ' end the simh
        Call RefreshTextBox1() ' get the buffer and display it
        TextBox1.SelectionStart = TextBox1.TextLength
        TextBox1.ScrollToCaret()
        TabControl1.SelectedIndex = 2 ' tab 2 has the error message
        TextBox1.Focus() ' cursor to textbox1 so highlights the error
        'w3sock2.WaitFor("A") ' has punch sent something?
        w3sock.Close() ' close the socket
    End Sub

    Private Sub Button41_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button41.Click
        ' compile using SIMH but leave the SIMH window open, and don't send to N8VEM
        Dim Location As New Process
        Dim Filename1 As String 'eg MYFILE.BAS
        Call SaveBDSC()
        FileOpen(1, "C:\N8VEM\AltairSIMH\SIM.BAT", OpenMode.Output) ' open a file
        PrintLine(1, "altairZ80 sim_cmd")
        FileClose(1)
        ' create the large simulation file
        FileOpen(1, "C:\N8VEM\AltairSIMH\sim_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "d tracks[0-7] 254")
        PrintLine(1, "attach dsk cpm2.dsk")
        PrintLine(1, "attach dsk1 wordstar.dsk")
        PrintLine(1, "attach dsk2 bdsc160.dsk")
        PrintLine(1, "attach dsk3 bdsc160source.dsk")
        PrintLine(1, "attach dsk4 supercalc.dsk")
        PrintLine(1, "attach dsk5 tools.dsk")
        PrintLine(1, "attach dsk6 basic.dsk")
        PrintLine(1, "attach hdsk i.dsk")
        PrintLine(1, "set cpu 64k")
        PrintLine(1, "set cpu noitrap")
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu altairrom")
        PrintLine(1, "set cpu nonbanked")
        PrintLine(1, "Reset cpu ")
        PrintLine(1, "set sio ansi")
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "attach sio cpm_cmd") ' attach the little file below to run a batch
        PrintLine(1, "boot dsk") ' will run till type HALT which runs HALT.COM
        PrintLine(1, "bye")
        FileClose(1)
        ' now create the file to compile
        Filename1 = Strings.Left(BDSCfile, Len(BDSCfile) - 2) 'trim the .c
        FileCopy("C:\N8VEM\" + Filename1 + ".C", "C:\N8VEM\AltairSIMH\" + Filename1 + ".C") ' copy c program to simh
        FileOpen(1, "C:\N8VEM\C.SUB", OpenMode.Output) ' do as a submit as too fast to do as a cpm_cmd
        PrintLine(1, "CC " + Filename1 + " -p") ' -p switch prints out the lines, (no need for -w error log as has line numbers now)
        PrintLine(1, "CLINK " + Filename1)
        PrintLine(1, Filename1)
        FileClose(1)
        FileCopy("C:\N8VEM\C.SUB", "C:\N8VEM\AltairSIMH\C.SUB")
        FileOpen(1, "C:\N8VEM\AltairSIMH\cpm_cmd", OpenMode.Output) ' open a command file
        PrintLine(1, "C:") ' C is on the C drive (of course!)
        PrintLine(1, "R " + Filename1 + ".C") ' read the file into the SIMH
        PrintLine(1, "R C.SUB") ' read in the batch file
        PrintLine(1, "SUBMIT C") ' run batch file 
        FileClose(1)
        Sleep(100)
        ' shell the altair SIMH
        Location.StartInfo.FileName = "SIM.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
        Location.Start() ' shell the batch file
        Sleep(2000)
        Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".C") ' clean up
    End Sub





    Private Sub RadioButton7_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton7.CheckedChanged
        TextBox3.ForeColor = Color.Black
        TextBox3.BackColor = Color.White
        TextBox3.Focus()
    End Sub

    Private Sub RadioButton8_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton8.CheckedChanged
        TextBox3.ForeColor = Color.White
        TextBox3.BackColor = Color.DarkBlue
        TextBox3.Font = New Font(TextBox3.Font.Name, TextBox3.Font.Size, FontStyle.Bold)
        TextBox3.Focus()
    End Sub

    Private Sub RadioButton9_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton9.CheckedChanged
        TextBox3.ForeColor = Color.LightGreen
        TextBox3.BackColor = Color.Black
        TextBox3.Focus()
        TextBox3.Font = New Font(TextBox3.Font.Name, TextBox3.Font.Size, FontStyle.Bold)
    End Sub

    Private Sub Button46_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button46.Click
        Dim i As Integer
        Dim n As Integer
        n = RichTextBox6.Lines.Length
        RichTextBox7.WordWrap = False
        RichTextBox7.Clear()
        For i = 0 To n - 1
            RichTextBox7.Text += Strings.Str(i + 1) + ":" + Strings.Space(4 - Strings.Len(Strings.Str(i + 1))) + RichTextBox6.Lines(i) + vbCrLf
        Next i
    End Sub

    Private Sub Button42_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button42.Click
        OpenPort3()
    End Sub
    Sub OpenPort3()
        SerialPort3.PortName = TextBox13.Text
        SerialPort3.BaudRate = TextBox14.Text
        SerialPort3.Parity = IO.Ports.Parity.None ' no parity
        SerialPort3.DataBits = 8 ' 8 bits
        SerialPort3.StopBits = IO.Ports.StopBits.One ' one stop bit
        SerialPort3.Open()
        SerialPort3.Write(vbCr)
        Timer2.Enabled = True
        Timer2.Interval = 500 ' check for characters every 500ms
        Sleep(500) ' needs a slight delay
    End Sub
    Private Sub Button43_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button43.Click
        Timer2.Enabled = False ' stop scanning
        SerialPort3.Close()
    End Sub

    Private Sub Timer2_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer2.Tick
        ' timer for second com port
        Dim BytesToRead As Integer
        Dim Port3Inbuffer(1000) As Byte
        Dim i As Integer
        Dim c As Integer
        Dim Character As String
        Static Counter As Integer
        Counter += 1
        Timer2.Enabled = False
        BytesToRead = SerialPort3.BytesToRead
        If BytesToRead <> 0 Then
            SerialPort3.Read(Port3Inbuffer, 0, BytesToRead) ' read in a packet
            For i = 1 To BytesToRead
                c = Port3Inbuffer(i - 1) ' get the byte
                'Character = Strings.Chr(c) ' turn to a character
                'If c <> 13 Then
                'RichTextBox8.Text += Character ' add to the text box but ignore cr
                'End If
                'TextBox17.Text += DecimalToHex(Port3Inbuffer(i - 1)) + " "
                'TextBox24.Text += DecimalToHex(Port3Inbuffer(i - 1))
                TextBox24.Text += DecimalToHex(c) ' print in the text window
            Next i
        End If
        If Counter > 2 Then ' process every 200ms
            ProcessAllBytes() ' decode 
            Counter = 0
        End If
        Timer2.Enabled = True
    End Sub

    Private Sub Button44_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button44.Click
        Dim OutP(2) As Byte
        Dim Outstring As String
        Dim i As Integer
        Dim Status As Boolean
        Status = SerialPort3.IsOpen
        If Status = False Then OpenPort3() ' if port not open then open it
        Outstring = "NETWORK" + vbCr ' only send carriage return, not line feed as well
        For i = 1 To Strings.Len(Outstring)
            OutP(0) = Strings.Asc(Strings.Mid(Outstring, i, 1))
            SerialPort3.Write(OutP, 0, 1)
        Next
        TextBox44.Clear()
    End Sub
    Private Function DecimalToHex(ByVal d As Integer) As String
        Dim Result As String
        Result = Strings.Hex(d)
        If d < 16 Then Result = "0" + Result
        Return Result
    End Function
    Private Sub Button53_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button53.Click
        SendPacket()
    End Sub
    Private Sub SendPacket()
        Dim OutP(0) As Byte
        For i = 1 To Len(TextBox27.Text) - 1 Step 2
            OutP(0) = Strings.Val("&H" + Strings.Mid(TextBox27.Text, i, 2)) ' calc the byte
            SerialPort3.Write(OutP, 0, 1) ' send out one byte
        Next
    End Sub
    Private Sub Button45_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button45.Click
        CreatePacket()
    End Sub
    Sub CreatePacket()
        Dim i As Integer
        Dim Checksum As Integer
        Dim PacketSize As Integer
        TextBox23.Text = DecimalToHex(Rnd() * 255) ' 2 byte random packet number
        TextBox23.Text = TextBox23.Text + DecimalToHex(Rnd() * 255) ' second part of random number
        PacketSize = Strings.Len(TextBox32.Text) / 2 ' length of the data packet
        PacketSize = PacketSize + 15 ' 15 extra bytes
        TextBox19.Text = DecimalToHex(PacketSize) ' convert to hex
        ' now calculate checksum
        Checksum = 0
        Checksum += Val("&H" + TextBox18.Text) ' add value of start byte (02H)
        Checksum += Val("&H" + TextBox19.Text) ' add the number of bytes
        For i = 1 To Len(TextBox20.Text) - 1 Step 2 ' source
            Checksum += Val("&H" + Strings.Mid(TextBox20.Text, i, 2))
        Next
        For i = 1 To Len(TextBox21.Text) - 1 Step 2 ' destination
            Checksum += Val("&H" + Strings.Mid(TextBox21.Text, i, 2))
        Next
        For i = 1 To Len(TextBox23.Text) - 1 Step 2 ' packet number
            Checksum += Val("&H" + Strings.Mid(TextBox23.Text, i, 2))
        Next
        Checksum += Val("&H" + TextBox22.Text) ' packet type
        For i = 1 To Len(TextBox32.Text) - 1 Step 2 ' data
            Checksum += Val("&H" + Strings.Mid(TextBox32.Text, i, 2))
        Next
        Checksum += Val("&H" + TextBox26.Text) ' finish byte (03H)
        Checksum = Checksum And Val("&H000000FF") ' same as subtracting 256 till <256
        TextBox25.Text = DecimalToHex(Checksum)
        TextBox27.Text = TextBox18.Text + TextBox19.Text + TextBox20.Text + TextBox21.Text + TextBox23.Text + TextBox22.Text + TextBox32.Text + TextBox25.Text + TextBox26.Text

    End Sub

    Private Sub MPMPCToPropellerToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MPMPCToPropellerToolStripMenuItem.Click
        ' this assumes XMODEMF.COM is on USER 1. If not then send it over
        ' PIP XMODEMF.COM[G1]=XMODEMF.COM[G0]
        ' note also that any user can change to any other user with the USER command
        ' eg if you are USER 0 you can change to USER 1 and see what files are there
        ' even while USER 1 is running a program
        ' downloads come via user 1 but are stored on USER 0 ie the VGA display
        ' June 26 2010, new system, make sure xmodemf is on user0, this sub changes
        ' from user 1 to user 0 and copies to user 0. You can use the PIP manually to 
        ' copy to other users. For direct download to user 1 or user 2, use the 
        ' programs xm1 and xm2
        ' Sept 2010 - some problems erasing on other users, so only stay in one user
        ' xm1 is a bit faster, though do have to do the PIP afterwards

        Dim Filenamepath As String
        Dim Filepath As String
        Dim Result
        Dim Filename As String
        Dim PipInstruction As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = True
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        Result = OpenFileDialog1.ShowDialog()
        TimerOff()
        If Result = 1 Then ' clicked ok 
            ' changing users seems to cause problems, so use PIP instead
            ' BUT - need to erase on both user 0 and user 1!!!!!
            ' try doing xmodem manually and it says 'file exists' if we are in 
            ' user 1 and the file happens to be on user 0
            ' so make sure delete it on user 1
            ' This really works best with MPM native to the vga screen NOT the serial port
            'Call StringToPacket("USER 0" + vbCr)
            'Call WaitForPrompt() ' wait for > to come back and display it
            ' found one problem - if send to user 1 and a file of the same name happens to be
            ' on user 0 then it won't work. So to be safe, delete on both users
            ' can either XM1 to user 1 and PIP to user 0 or use xmodemf which saves to user 0
            For Each Filenamepath In OpenFileDialog1.FileNames
                Filename = IO.Path.GetFileName(Filenamepath)
                Filename = Strings.UCase(Filename)
                Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well
                Call WaitForPrompt()
                Call StringToPacket("ERA " + Filename + vbCr)
                Call WaitForPrompt()
                Call StringToPacket("USER 1" + vbCr)
                Call WaitForPrompt()
                Call XModemFSend(Filenamepath, "XMODEMF", "MPM")
                Call WaitForPrompt()
                'PipInstruction = "PIP " + Filename + "[G0]=" + Filename + "[G1]" + vbCr
                'Call StringToPacket(PipInstruction)
                'Call WaitForPrompt()
            Next Filenamepath
            Call StringToPacket(vbCr) ' finish up 
        End If
        TimerOn()
    End Sub
    Sub WaitForPrompt()
        ' waits for a > prompt
        Dim a As Integer
        Dim SerialString As String
        a = 0
        Do
            If SerialPort1.BytesToRead > 0 Then
                SerialPort1.Read(InPacket, 0, 1) ' get one byte
                SerialString = Chr(InPacket(0)) ' get a single character/string/byte
                Call DisplayCharacter(SerialString) ' store for later display
            End If
            If SerialString = ">" Then Exit Do ' wait for the > prompt to come back
            Sleep(10)
            a = a + 10
            Label3.Text = "Waiting for prompt " + Str$(a)
            System.Windows.Forms.Application.DoEvents() ' update the label
            If a > 12000 Then Exit Do 'give up after 12 seconds
            If CancelButton = True Then
                CancelButton = False
                a = 30000 ' rem force an exit
            End If
        Loop
        Label3.Text = "Done"
        System.Windows.Forms.Application.DoEvents() ' update display etc
        ClearInputBuffer() ' clear any more bytes and update display
    End Sub

    Private Sub MPMPropellerToPCToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MPMPropellerToPCToolStripMenuItem.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Dim Result
        Dim Filename As String
        Dim PipInstruction As String
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        Result = SaveFileDialog1.ShowDialog()
        TimerOff()
        If Result = 1 Then ' clicked ok 
            Filenamepath = SaveFileDialog1.FileName
            Filename = IO.Path.GetFileName(Filenamepath)
            Filename = Strings.UCase(Filename)
            PipInstruction = "PIP " + Filename + "[G1]=" + Filename + "[G0]" + vbCr
            Call StringToPacket(PipInstruction)
            Call WaitForPrompt()
            Filenamepath = SaveFileDialog1.FileName
            Call XModemReceive(Filenamepath, "XM1")
            Call StringToPacket(vbCr) ' finish up 
        End If
        TimerOn()
    End Sub

    ' Private Sub PCToMPMPropellerUsingFasterXMODEMPToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PCToMPMPropellerUsingFasterXMODEMPToolStripMenuItem.Click
    '     MPMPCToPropeller("XMODEMP")
    'End Sub

    Private Sub Button49_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button49.Click
        Dim Filename As String
        Call CompileSIMHN8VEM("PropellerUSER1") ' send to propeller with the user commands
        Filename = Strings.Left(SbasicFile, Len(SbasicFile) - 4)
        Call StringToPacket(Filename + vbCrLf) ' run the program
    End Sub

    Private Sub Button50_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button50.Click
        Dim Filename As String
        Call CompileSIMHN8VEM("PropellerUSER0") ' send to propeller with the user commands
        'Sleep(200)
        'Call StringToPacket("Run this program from the local keyboard/VGA display" + vbCr)
        Call StringToPacket(vbCr)
        'Filename = Strings.Left(SbasicFile, Len(SbasicFile) - 4)
        'Call StringToPacket(Filename + vbCrLf) ' run the program
    End Sub
    Sub ColorBDSC()
        Dim Greenwords As New List(Of String)
        Dim Bluewords As New List(Of String)
        Dim Goldwords As New List(Of String) ' syntax errors
        'Greenwords.Add("rem")
        ' purple words
        'Goldwords.Add(" as ") ' should use =
        ' blue words
        Bluewords.Add("char ")
        Bluewords.Add("do")
        Bluewords.Add("#define")
        Bluewords.Add("else")
        Bluewords.Add("for ")
        Bluewords.Add("getchar")
        Bluewords.Add("int ")
        Bluewords.Add("if")
        Bluewords.Add("#include")
        Bluewords.Add("kbhit")
        Bluewords.Add("printf")
        Bluewords.Add("return")
        Bluewords.Add("srand")
        Bluewords.Add("while ")
        Dim i As Integer
        Dim GreenFlag As Boolean
        Dim TempString As String
        Dim L As Integer
        Dim QuoteFlag As Boolean
        Dim QuoteCount As Integer
        'Dim IncludeFlag As Boolean
        'Dim IncludeCount As Integer
        If RichTextBox6.Text.Length > 0 And ColorOn = True Then
            SendMessage(RichTextBox6.Handle, WM_SETREDRAW, New IntPtr(CInt(False)), IntPtr.Zero) ' disable refresh
            Dim selectStart As Integer = RichTextBox6.SelectionStart ' preserve cursor
            RichTextBox6.Select(0, RichTextBox6.Text.Length)
            RichTextBox6.SelectionColor = Color.Black
            RichTextBox6.DeselectAll()
            'do blue words
            For Each oneWord As String In Bluewords
                Dim pos As Integer = 0
                Do While RichTextBox6.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox6.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox6.Select(pos, oneWord.Length)
                    RichTextBox6.SelectionColor = Color.Blue
                    pos = pos + 1
                Loop
            Next
            'do purple words (syntax errors eg using as instead of = because vb.net uses as
            For Each oneWord As String In Goldwords
                Dim pos As Integer = 0
                Do While RichTextBox6.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox6.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox6.Select(pos, oneWord.Length)
                    RichTextBox6.SelectionColor = Color.Gold
                    pos = pos + 1
                Loop
            Next
            ' put in rem and comments in green. 10 is end of line
            GreenFlag = False
            TempString = LCase(RichTextBox6.Text) ' all lower case for matching
            L = Strings.Len(TempString)
            For i = 1 To L
                If Strings.Mid(TempString, i, 2) = "/*" Then
                    GreenFlag = True
                End If
                If i < L - 3 And i > 3 Then
                    If Strings.Mid(TempString, i - 2, 2) = "*/" Then
                        GreenFlag = False
                    End If
                End If
                'If Strings.Mid(TempString, i, 3) = "rem" Then ' rem to end of line
                ' RemFlag = True
                ' GreenFlag = True
                ' End If
                'If RemFlag = True And Strings.Mid(TempString, i, 1) = vbLf Then
                ' RemFlag = False
                ' GreenFlag = False
                ' End If
                'If Strings.Mid(TempString, i, 1) = "<" Then
                ' IncludeFlag = True
                ' End If
                'If i > 2 And IncludeCount > 1 Then
                ' If IncludeFlag = True And Strings.Mid(TempString, i - 1, 1) = ">" Then
                ' IncludeFlag = False
                ' IncludeCount = 0
                ' End If
                ' End If

                If Strings.Mid(TempString, i, 1) = Strings.Chr(34) Then
                    QuoteFlag = True
                End If
                If i > 2 And QuoteCount > 1 Then
                    If QuoteFlag = True And Strings.Mid(TempString, i - 1, 1) = Strings.Chr(34) Then
                        QuoteFlag = False
                        QuoteCount = 0
                    End If
                End If
                If QuoteFlag = True Then ' add red text for quotes
                    RichTextBox6.Select(i - 1, 1)
                    RichTextBox6.SelectionColor = Color.Red
                End If
                If GreenFlag = True Then
                    RichTextBox6.Select(i - 1, 1)
                    RichTextBox6.SelectionColor = Color.Green
                End If
                If QuoteFlag = True Then QuoteCount = QuoteCount + 1
                'If IncludeFlag = True Then IncludeCount = IncludeCount + 1
                'If IncludeFlag = True Then ' purple text
                ' RichTextBox6.Select(i - 1, 1)
                ' RichTextBox6.SelectionColor = Color.Purple
                ' End If
            Next
            RichTextBox6.SelectionStart = selectStart
            RichTextBox6.SelectionLength = 0
            SendMessage(RichTextBox6.Handle, WM_SETREDRAW, New IntPtr(CInt(True)), IntPtr.Zero)
            RichTextBox6.Refresh()
        End If
    End Sub
    Private Sub Button48_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button48.Click
        ColorBDSC()
    End Sub

    Private Sub Button51_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button51.Click
        Call StringToPacket("SPIN CPM.BIN" + vbCr)
    End Sub

    Private Sub PCToMPMUser1UsingXMMPM1COMToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PCToMPMUser1UsingXMMPM1COMToolStripMenuItem.Click
        ' uses new program XM1.COM which has the port settings for user 1 (see xmodem source)
        Dim Filenamepath As String
        Dim Filepath As String
        Dim Result
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = True
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        Result = OpenFileDialog1.ShowDialog()
        TimerOff()
        If Result = 1 Then ' clicked ok 
            For Each Filenamepath In OpenFileDialog1.FileNames
                Call XModemFSend(Filenamepath, "XM1", "MPM")
                Call WaitForPrompt()
            Next Filenamepath
            Call StringToPacket(vbCr) ' finish up 
        End If
        TimerOn()
    End Sub

    Private Sub MPMUser1ToPCUsingXM1COMToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MPMUser1ToPCUsingXM1COMToolStripMenuItem.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Dim Result
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = "*.*" ' ? put CPM files somewhere safe
        Result = SaveFileDialog1.ShowDialog()
        TimerOff()
        If Result = 1 Then ' clicked ok 
            Filenamepath = SaveFileDialog1.FileName
            Call XModemReceive(Filenamepath, "XM1")
            Call StringToPacket(vbCr) ' finish up 
        End If
        TimerOn()
    End Sub
    Private Sub Button52_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button52.Click
        ListBox1.Items.Add(TextBox28.Text)
        ListBox3.Items.Add(TextBox29.Text)
        ListBox4.Items.Add(TextBox30.Text)
        ListBox5.Items.Add(TextBox31.Text)
        'Dim gr As Graphics
        'gr.DrawLine(Pens.Black, 3, 4, 5, 6)
        ' pset has gone in vb.net and after 1 hours of searching the net, I cannot
        ' see how you do graphics in vb.net. There are many other frustrated people out there
        ' which is not a good sign. I added some imports at the top of this program - I think they are needed
        ' I don't think you can draw directly on pictureboxes
        ' I'm not sure what you can draw on though. Lots of people mention the form but
        ' I don't want to draw on the form - it needs to be in some sort of container
        ' like a picturebox. 
        ' anyway the aim of this project is to build a map of a mesh based on 
        ' what nodes can see each other. I had an idea one could draw that on the screen
        ' but you can't so the next best method is to do this in text
        ' rules - if two nodes are within range, move them closer. If they can't move them away
        ' until stable
        ' leave node 1 fixed in the centre

    End Sub

    Private Sub Button54_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button54.Click
        TextBox24.Text = TextBox27.Text
    End Sub
    Private Sub ProcessInputByte()
        Dim ByteString As String
        Dim ByteValue As Byte
        Dim BytesInBuffer As Integer
        Dim PacketSize As Integer
        If Strings.Len(TextBox24.Text) > 1 Then
            ByteString = Strings.Left(TextBox24.Text, 2)
            ByteValue = Strings.Val("&H" + ByteString)
            TextBox33.Text = TextBox33.Text + ByteString ' add byte
            TextBox24.Text = Strings.Mid(TextBox24.Text, 3) 'shorten the buffer
            BytesInBuffer = Strings.Len(TextBox33.Text) / 2 ' size of current packet
            PacketSize = Val("&H" + TextBoxPacketSize.Text) ' size expect packet to be
            If TextBoxPacketSize.Text = "00" And ByteValue <> 2 And CheckBoxReadingPacket.Checked = True Then ' second byte
                TextBoxPacketSize.Text = ByteString ' store the packet size
            End If
            If ByteValue = 2 And CheckBoxReadingPacket.Checked = False Then
                CheckBoxReadingPacket.Checked = True
                TextBoxPacketSize.Text = "00" ' reset the packet counter
            End If
            If PacketSize <> 0 And BytesInBuffer = PacketSize And ByteValue = 3 Then
                ' a valid packet so process it - copy to a new location then check valid etc
                TextBox34.Text = TextBox33.Text ' copy to processing buffer
                ChopPacket()    ' chop up the packet
                TextBox33.Text = "" ' clear the buffer
                TextBoxPacketSize.Text = "00" ' reset the expected size
                CheckBoxReadingPacket.Checked = False ' not reading a packet any more
            End If
            If PacketSize <> 0 And (BytesInBuffer > PacketSize Or BytesInBuffer > 150) Then ' error so clear 
                ' max size is 131 data bytes (an xmodem packet) plus 15 packet bytes = 146 so make it 150 to reset if get this many rubbish bytes
                TextBox33.Text = "" ' clear the buffer
                TextBoxPacketSize.Text = "00" ' reset the expected size
                CheckBoxReadingPacket.Checked = False ' not reading a packet any more
            End If
            If CheckBoxReadingPacket.Checked = False And ByteValue <> 2 Then ' garbage byte
                TextBox33.Text = "" ' re-clear the buffer
                TextBoxPacketSize.Text = "00" ' reset the expected size
            End If
        End If
    End Sub

    Private Sub ChopPacket()
        Dim PacketSize As Integer
        Dim Checksum As Integer
        Dim i As Integer
        ' chop up the packet
        TextBox41.Text = Strings.Mid(TextBox34.Text, 1, 2) ' start byte
        TextBox42.Text = Strings.Mid(TextBox34.Text, 3, 2) ' packet size
        PacketSize = Strings.Val("&H" + TextBox42.Text) ' size as an integer value
        TextBox35.Text = Strings.Mid(TextBox34.Text, 5, 8) 'source
        TextBox36.Text = Strings.Mid(TextBox34.Text, 13, 8) 'destination
        TextBox37.Text = Strings.Mid(TextBox34.Text, 21, 4) 'packet number
        TextBox38.Text = Strings.Mid(TextBox34.Text, 25, 2) ' packet type
        TextBox39.Text = Strings.Mid(TextBox34.Text, 27, (PacketSize - 15) * 2) ' data bytes
        TextBox40.Text = Strings.Mid(TextBox34.Text, (PacketSize * 2) - 3, 2) ' checksum
        TextBox43.Text = Strings.Mid(TextBox34.Text, PacketSize * 2 - 1, 2) ' finish byte
        If TextBox41.Text = "02" Then CheckBox13.Checked = True
        If TextBox43.Text = "03" Then CheckBox15.Checked = True
        ' now create checksum
        Checksum = 0
        Checksum += Val("&H" + TextBox41.Text) ' add value of start byte (02H)
        Checksum += Val("&H" + TextBox42.Text) ' add the number of bytes
        For i = 1 To Len(TextBox35.Text) - 1 Step 2 ' source
            Checksum += Val("&H" + Strings.Mid(TextBox35.Text, i, 2))
        Next
        For i = 1 To Len(TextBox36.Text) - 1 Step 2 ' destination
            Checksum += Val("&H" + Strings.Mid(TextBox36.Text, i, 2))
        Next
        For i = 1 To Len(TextBox37.Text) - 1 Step 2 ' packet number
            Checksum += Val("&H" + Strings.Mid(TextBox37.Text, i, 2))
        Next
        Checksum += Val("&H" + TextBox38.Text) ' packet type
        For i = 1 To Len(TextBox39.Text) - 1 Step 2 ' data
            Checksum += Val("&H" + Strings.Mid(TextBox39.Text, i, 2))
        Next
        Checksum += Val("&H" + TextBox43.Text) ' finish byte
        Checksum = Checksum And Val("&H000000FF") ' same as subtracting 256 till <256
        If Checksum = Strings.Val("&H" + TextBox40.Text) Then
            CheckBox14.Checked = True ' checksum is valid
        End If
        ' display ascii characters
        For i = 1 To Len(TextBox39.Text) - 1 Step 2
            TextBox44.Text += Strings.Chr(Strings.Val("&H" + Strings.Mid(TextBox39.Text, i, 2)))
        Next
        System.Windows.Forms.Application.DoEvents()
    End Sub

    Private Sub Button57_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button57.Click
        TextBox22.Text = "05" ' data
        TextBox32.Text = "4142430D" ' ABC then a CR
        TextBox27.Text = "" ' clear the packet (create a new one)
    End Sub

    Private Sub ControlP()
        TextBox22.Text = "05" ' data
        TextBox32.Text = "10" ' ^P in hex (16 in decimal)
        TextBox27.Text = "" ' clear the packet (create a new one)
    End Sub

    Private Sub ReplyToMeOn()
        TextBox22.Text = "01" ' turn on and send packets to sender
        TextBox32.Text = "00" ' data (not used)
        TextBox27.Text = "" ' clear the packet (create a new one)
    End Sub
    Private Sub ReplyToMeOff()
        TextBox22.Text = "02" ' turn off output from this node
        TextBox32.Text = "00" ' data (not used)
        TextBox27.Text = "" ' clear the packet (create a new one)
    End Sub

    Private Sub Button60_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button60.Click
        TextBox22.Text = "02" ' turn off output
        TextBox32.Text = "00" ' data (not used)
        TextBox27.Text = "" ' clear the packet (create a new one)
    End Sub


    Private Sub Button56_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button56.Click
        ProcessInputByte()
    End Sub

    Private Sub Button62_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button62.Click
        ' The text below is from the modified MP/M io.spin program
        ' which replaces ^P and captures all data bytes including mbasic and wordstar


        ' Write to the console #0
        '
        'conout_char()
        '#ifdef USER0_PS2_VGA
        'mov	lmm_pc, #lmm_vt100_out
        'call	#lmm_func

        ' experiments trying to send all vga data to the punch output as well
        ' replicates ^P but works within programs eg mbasic, that bypass CP/M system calls
        '#ifdef USER0_TO_PUNCH
        '       mov     lmm_pc, #lmm_ram_wr
        '       call    #lmm_func
        '#End If


        ControlP()
        CreatePacket()
        SendPacket()
    End Sub

    Private Sub Button61_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button61.Click
        ReplyToMeOn()
        CreatePacket()
        SendPacket()
    End Sub

    Private Sub TextBox45_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox45.TextChanged
        Dim i As Integer
        If Strings.Len(TextBox45.Text) > 0 Then
            If Strings.Right(TextBox45.Text, 1) = Strings.Chr(10) Then
                TextBox32.Text = "" ' clear the data text
                For i = 1 To Strings.Len(TextBox45.Text) - 1 ' last two are 13,10 and leave off the 10
                    TextBox32.Text += DecimalToHex(Strings.Asc(Strings.Mid(TextBox45.Text, i, 1)))
                Next
                TextBox45.Text = ""
                TextBox22.Text = "05" ' data packet
                CreatePacket() ' turn into a packet
                SendPacket() ' and send it
            End If
        End If
    End Sub

    Private Sub Button63_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button63.Click
        ProcessAllBytes()
    End Sub
    Private Sub ProcessAllBytes()
        Do While Strings.Len(TextBox24.Text) > 1
            ProcessInputByte() ' gobble up all the characters
        Loop
        TextBox44.SelectionStart = TextBox44.TextLength
        TextBox44.ScrollToCaret() ' scroll down to the end
    End Sub
    Private Sub Button55_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button55.Click
        ReplyToMeOff()
        CreatePacket()
        SendPacket()
    End Sub

    Private Sub Button58_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button58.Click
        TextBox22.Text = "03" ' ping
        TextBox32.Text = "50494E47" ' PING
        TextBox27.Text = "" ' clear the packet (create a new one)
        CreatePacket()
        SendPacket()
    End Sub

    Private Sub Button64_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button64.Click
        TextBox22.Text = "06" ' who
        TextBox32.Text = "00" ' dummy data
        TextBox27.Text = "" ' clear the packet (create a new one)
        CreatePacket()
        SendPacket()
    End Sub

    Private Sub Button65_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button65.Click
        Dim Location As New Process
        Dim filename1 As String
        Dim filename_noextension As String
        Dim FilenameMac As String
        Call SaveAssemblyFile()
        filename1 = AssemblyFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 4)
        FilenameMac = filename_noextension + ".MAC"
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long and won't work with CP/M. Suggest renaming file")
        End If
        ' compile using SIMH and leave the SIMH window open
        FileOpen(1, "C:\N8VEM\AltairSIMH\SIM.BAT", OpenMode.Output) ' open a file
        PrintLine(1, "altairZ80 sim_cmd")
        FileClose(1)
        ' create the large simulation file
        FileOpen(1, "C:\N8VEM\AltairSIMH\sim_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "d tracks[0-7] 254")
        PrintLine(1, "attach dsk cpm2.dsk")
        PrintLine(1, "attach dsk1 basic.dsk")
        PrintLine(1, "attach dsk2 games.dsk")
        PrintLine(1, "attach dsk3 sbasic.dsk")
        PrintLine(1, "attach dsk4 supercalc.dsk")
        PrintLine(1, "attach dsk5 tools.dsk")
        PrintLine(1, "attach dsk6 wordstar.dsk")
        PrintLine(1, "attach hdsk i.dsk")
        PrintLine(1, "set cpu 64k")
        PrintLine(1, "set cpu noitrap")
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu altairrom")
        PrintLine(1, "set cpu nonbanked")
        PrintLine(1, "Reset cpu ")
        PrintLine(1, "set sio ansi")
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "attach sio cpm_cmd") ' attach the little file below to run a batch
        PrintLine(1, "boot dsk") ' will run till type HALT which runs HALT.COM
        PrintLine(1, "bye")
        FileClose(1)
        ' now create the file to compile
        FileCopy("C:\N8VEM\" + filename1, "C:\N8VEM\AltairSIMH\" + FilenameMac) ' change .asm to .mac for M80
        FileOpen(1, "C:\N8VEM\AltairSIMH\cpm_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "I:") ' do on hard drive i as other drives are floppy drives and rather small
        PrintLine(1, "R A.SUB")
        PrintLine(1, "SUBMIT A")
        FileClose(1)
        FileOpen(1, "C:\N8VEM\AltairSIMH\A.SUB", OpenMode.Output)
        PrintLine(1, "R " + FilenameMac) ' read the file into the SIMH
        PrintLine(1, "M80 =" + filename_noextension + "/M/C") 'compile it
        PrintLine(1, "LINK " + filename_noextension + "=" + filename_noextension)
        PrintLine(1, filename_noextension)
        FileClose(1)
        ' shell the altair SIMH
        Location.StartInfo.FileName = "SIM.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
        Location.Start() ' shell the batch file
    End Sub

    Private Sub Button66_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button66.Click
        RichTextBox1.SaveFile("C:\N8VEM\AltairSIMH\MPM 8 Users\" + SbasicFile, RichTextBoxStreamType.PlainText)
        RichTextBox1.Focus()
    End Sub

    Private Sub Button68_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button68.Click
        TabControl1.SelectedIndex = 0 ' display cp/m
        TextBox3.Focus() 'display to cp/m
        'Call StringToPacket("USER 0" + vbCr)
        'Call WaitForPrompt() ' wait for > to come back and display it
        TimerOff()
        Call XModemReceive("C:\N8VEM\MPMXIOS.MAC", "XMODEMF")
        Call XModemReceive("C:\N8VEM\LDRBIOS.MAC", "XMODEMF")
        Call XModemReceive("C:\N8VEM\GENSYS.COM", "XMODEMF")
        Call XModemReceive("C:\N8VEM\SYSTEM.DAT", "XMODEMF")
        Call XModemReceive("C:\N8VEM\MPMLDR.COM", "XMODEMF")
        Call XModemReceive("C:\N8VEM\SYSMPM.SUB", "XMODEMF")
        Call XModemReceive("C:\N8VEM\MPMD.LIB", "XMODEMF")
        Call XModemReceive("C:\N8VEM\MPM.SYS", "XMODEMF")
        Call StringToPacket(vbCr) ' finish up 
        'Call StringToPacket("USER 1" + vbCr)
        'Call WaitForPrompt() ' wait for > to come back and display it
        'Call StringToPacket(vbCr) ' finish up 
        TabControl1.SelectedIndex = 11 ' back to this tab
        TimerOn()
    End Sub

    Private Sub Button69_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button69.Click
        TabControl1.SelectedIndex = 0 ' display cp/m
        TextBox3.Focus() 'display to cp/m
        TimerOff()
        Call StringToPacket("USER 0" + vbCr)
        Call WaitForPrompt() ' wait for > to come back and display it
        Call XModemReceive("C:\N8VEM\BNKBDOS.SPR", "XMODEMF")
        Call XModemReceive("C:\N8VEM\BNKXIOS.SPR", "XMODEMF")
        Call XModemReceive("C:\N8VEM\BNKXDOS.SPR", "XMODEMF")
        Call XModemReceive("C:\N8VEM\RESXIOS.SPR", "XMODEMF")
        Call XModemReceive("C:\N8VEM\XDOS.SPR", "XMODEMF")
        Call XModemReceive("C:\N8VEM\TMP.SPR", "XMODEMF")
        Call XModemReceive("C:\N8VEM\RESBDOS.SPR", "XMODEMF")
        Call StringToPacket(vbCr) ' finish up 
        Call StringToPacket("USER 1" + vbCr)
        Call WaitForPrompt() ' wait for > to come back and display it
        Call StringToPacket(vbCr) ' finish up 
        TabControl1.SelectedIndex = 11 ' back to this tab
        TimerOn()
    End Sub

    '  Private Sub Button70_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button70.Click
    '      TabControl1.SelectedIndex = 0 ' display cp/m
    '      TextBox3.Focus() 'display to cp/m
    '      Call StringToPacket("USER 0" + vbCr)
    '      Call WaitForPrompt() ' wait for > to come back and display it
    '      Call XModemReceive("C:\N8VEM\M80.COM", True, "XMODEMF")
    '      Call XModemReceive("C:\N8VEM\L80.COM", True, "XMODEMF")
    '      Call XModemReceive("C:\N8VEM\DDTZ.COM", True, "XMODEMF")
    '      Call XModemReceive("C:\N8VEM\LINK.COM", True, "XMODEMF")
    '      Call XModemReceive("C:\N8VEM\XSUB.COM", True, "XMODEMF")
    '      Call StringToPacket(vbCr) ' finish up 
    '      Call StringToPacket("USER 1" + vbCr)
    '      Call WaitForPrompt() ' wait for > to come back and display it
    '      Call StringToPacket(vbCr) ' finish up 
    '      TabControl1.SelectedIndex = 11 ' back to this tab
    '  End Sub

    Private Sub Button71_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button71.Click
        ' compile using SIMH and leave SIMH window open
        Dim Location As New Process
        FileOpen(1, "C:\N8VEM\AltairSIMH\SIM.BAT", OpenMode.Output) ' open a file
        PrintLine(1, "altairZ80 sim_cmd")
        FileClose(1)
        ' create the large simulation file
        FileOpen(1, "C:\N8VEM\AltairSIMH\sim_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "d tracks[0-7] 254")
        PrintLine(1, "attach dsk cpm2.dsk")
        PrintLine(1, "attach hdsk i.dsk")
        PrintLine(1, "d common b000")
        PrintLine(1, "set cpu 64k")
        PrintLine(1, "set cpu itrap")
        PrintLine(1, "set cpu z80")
        PrintLine(1, "set cpu altairrom")
        PrintLine(1, "set simh timeroff")
        PrintLine(1, "set cpu banked")
        PrintLine(1, "set sio ansi")
        PrintLine(1, "set sio nosleep")
        PrintLine(1, "attach sio cpm_cmd") ' attach the little file below to run a batch
        PrintLine(1, "boot dsk") ' will run till type HALT which runs HALT.COM
        'PrintLine(1, "bye")
        FileClose(1)
        ' now create the file to compile
        ' don't send system.dat each time as overwrites manually changed version on the simh
        FileCopy("C:\N8VEM\MPMXIOS.MAC", "C:\N8VEM\AltairSIMH\MPMXIOS.MAC")
        FileCopy("C:\N8VEM\LDRBIOS.MAC", "C:\N8VEM\AltairSIMH\LDRBIOS.MAC")
        FileCopy("C:\N8VEM\GENSYS.COM", "C:\N8VEM\AltairSIMH\GENSYS.COM")
        If CheckBox16.Checked = True Then
            FileCopy("C:\N8VEM\SYSTEM.DAT", "C:\N8VEM\AltairSIMH\SYSTEM.DAT")
        End If
        FileCopy("C:\N8VEM\MPMLDR.COM", "C:\N8VEM\AltairSIMH\MPMLDR.COM")
        FileCopy("C:\N8VEM\SYSMPM.SUB", "C:\N8VEM\AltairSIMH\SYSMPM.SUB")
        FileCopy("C:\N8VEM\MPMD.LIB", "C:\N8VEM\AltairSIMH\MPMD.LIB")
        FileCopy("C:\N8VEM\BNKBDOS.SPR", "C:\N8VEM\AltairSIMH\BNKBDOS.SPR")
        FileCopy("C:\N8VEM\BNKXIOS.SPR", "C:\N8VEM\AltairSIMH\BNKXIOS.SPR")
        FileCopy("C:\N8VEM\BNKXDOS.SPR", "C:\N8VEM\AltairSIMH\BNKXDOS.SPR")
        FileCopy("C:\N8VEM\RESXIOS.SPR", "C:\N8VEM\AltairSIMH\RESXIOS.SPR")
        FileCopy("C:\N8VEM\XDOS.SPR", "C:\N8VEM\AltairSIMH\XDOS.SPR")
        FileCopy("C:\N8VEM\TMP.SPR", "C:\N8VEM\AltairSIMH\TMP.SPR")
        FileCopy("C:\N8VEM\RESBDOS.SPR", "C:\N8VEM\AltairSIMH\RESBDOS.SPR")
        FileCopy("C:\N8VEM\M80.COM", "C:\N8VEM\AltairSIMH\M80.COM")
        FileCopy("C:\N8VEM\L80.COM", "C:\N8VEM\AltairSIMH\L80.COM")
        FileCopy("C:\N8VEM\DDTZ.COM", "C:\N8VEM\AltairSIMH\DDTZ.COM")
        FileCopy("C:\N8VEM\LINK.COM", "C:\N8VEM\AltairSIMH\LINK.COM")
        FileCopy("C:\N8VEM\XSUB.COM", "C:\N8VEM\AltairSIMH\XSUB.COM")
        FileCopy("C:\N8VEM\MPM.SYS", "C:\N8VEM\AltairSIMH\MPM.SYS")

        FileOpen(1, "C:\N8VEM\AltairSIMH\MPMBUILD.SUB", OpenMode.Output) ' open a file
        PrintLine(1, "R MPMXIOS.MAC") ' read the file into the SIMH
        PrintLine(1, "R LDRBIOS.MAC")
        PrintLine(1, "R GENSYS.COM")
        If CheckBox16.Checked = True Then
            PrintLine(1, "R SYSTEM.DAT")
        End If
        PrintLine(1, "R MPMLDR.COM")
        PrintLine(1, "R MAKEMPM.SUB")
        PrintLine(1, "R MPMD.LIB")
        PrintLine(1, "R BNKBDOS.SPR")
        PrintLine(1, "R BNKXIOS.SPR")
        PrintLine(1, "R BNKXDOS.SPR")
        PrintLine(1, "R RESXIOS.SPR")
        PrintLine(1, "R XDOS.SPR")
        PrintLine(1, "R TMP.SPR")
        PrintLine(1, "R RESBDOS.SPR")
        PrintLine(1, "R M80.COM")
        PrintLine(1, "R L80.COM")
        PrintLine(1, "R DDTZ.COM")
        PrintLine(1, "R LINK.COM")
        PrintLine(1, "R XSUB.COM")
        PrintLine(1, "R MPM.SYS")
        PrintLine(1, "SUBMIT MAKEMPM")
        FileClose(1)

        FileOpen(1, "C:\N8VEM\AltairSIMH\MAKEMPM.SUB", OpenMode.Output) ' open a file
        PrintLine(1, "; build MP/M system")
        PrintLine(1, "; needs to be executed under CP/M 2")
        PrintLine(1, "; required sources: LDRBIOS.MAC, MPMXIOS.MAC, MPMD.LIB")
        PrintLine(1, "; required programs: M80.COM, L80.COM, DDTZ.COM, LINK.COM, XSUB.COM")
        PrintLine(1, "XSUB")
        PrintLine(1, "M80 =LDRBIOS/M")
        PrintLine(1, "L80 LDRBIOS,LDRBIOS/N/E")
        PrintLine(1, "DDTZ MPMLDR.COM")
        PrintLine(1, "FLDRBIOS.COM")
        PrintLine(1, "R1600")
        PrintLine(1, "G0")
        PrintLine(1, "SAVE 26 MPM.COM")
        PrintLine(1, "ERA LDRBIOS.REL")
        PrintLine(1, "ERA LDRBIOS.COM")
        PrintLine(1, "M80 =MPMXIOS/M/Z/C/L") ' http://www.retroarchive.org/cpm/lang/MACRO-80.PDF for switches
        PrintLine(1, "LINK BNKXIOS[OS]=MPMXIOS")
        PrintLine(1, "GENSYS $$A")
        PrintLine(1, "ERA BNKXIOS.SYM")
        PrintLine(1, "ERA MPMXIOS.REL")
        PrintLine(1, "; start MP/M with MPM")
        PrintLine(1, "W SYSTEM.DAT B") ' must copy these back as binary files
        PrintLine(1, "W MPM.COM B")
        PrintLine(1, "W MPM.SYS B")
        'PrintLine(1, "W MPMLDR.COM B")
        FileClose(1)

        FileOpen(1, "C:\N8VEM\AltairSIMH\cpm_cmd", OpenMode.Output) ' open a file
        PrintLine(1, "A:") ' drive A
        PrintLine(1, "R MPMBUILD.SUB")
        PrintLine(1, "SUBMIT MPMBUILD")
        FileClose(1)
        ' shell the altair SIMH
        Location.StartInfo.FileName = "SIM.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem\AltairSIMH"
        Location.Start() ' shell the batch file
    End Sub

    Private Sub Button72_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button72.Click
        TabControl1.SelectedIndex = 0 ' display cp/m
        TextBox3.Focus() 'display to cp/m
        'GENSYS $A
        'Generates the file MPM.SYS to hold the MP/M II
        'system. GENSYS generates new versions fo the
        'system. Can be executed from CP/M or MP/M. If
        'the $A option is specified GENSYS goes through
        'an automatic system generation using the
        'defaults found in the SYSTEM.DAT file on the
        'default drive.
        'OA>GENSYS
        'OA>GENSYS $A
        TimerOff()
        FileCopy("C:\N8VEM\AltairSIMH\SYSTEM.DAT", "C:\N8VEM\SYSTEM.DAT")
        FileCopy("C:\N8VEM\AltairSIMH\MPM.COM", "C:\N8VEM\MPM.COM")
        FileCopy("C:\N8VEM\AltairSIMH\MPM.SYS", "C:\N8VEM\MPM.SYS")
        'FileCopy("C:\N8VEM\AltairSIMH\MPMLDR.COM", "C:\N8VEM\MPMLDR.COM")
        Call XModemFSend("C:\N8VEM\SYSTEM.DAT", "XMODEMF", "CPM")
        Call XModemFSend("C:\N8VEM\MPM.COM", "XMODEMF", "CPM")
        Call XModemFSend("C:\N8VEM\MPM.SYS", "XMODEMF", "CPM")
        'Call XModemFSend("C:\N8VEM\MPMLDR.COM", True, "XMODEMF","CPM")
        'TabControl1.SelectedIndex = 11 ' back to this tab
        Call StringToPacket("MPM" + vbCr)
        TimerOn()
    End Sub

    Private Sub Button67_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button67.Click
        RichTextBox8.LoadFile("C:\N8VEM\MPMXIOS.MAC", RichTextBoxStreamType.PlainText)
        'TabControl1.SelectedIndex = 1
        RichTextBox8.Focus()
    End Sub
    Sub SaveMPMXIOS()
        RichTextBox8.SaveFile("C:\N8VEM\MPMXIOS.MAC", RichTextBoxStreamType.PlainText)
        RichTextBox8.Focus()
    End Sub
    Private Sub Button73_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button73.Click
        SaveMPMXIOS()
    End Sub

    Private Sub Button74_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button74.Click
        TimerOff()
        SaveMPMXIOS()
        TabControl1.SelectedIndex = 0 ' display cp/m
        TextBox3.Focus() 'display to cp/m
        Call XModemFSend("C:\N8VEM\MPMXIOS.MAC", "XMODEMF", "CPM")
        Call StringToPacket("DO SYSMPM" + vbCr)
        TimerOn()
    End Sub

    Sub TimerOn()
        Timer1.Enabled = True
        PictureBox2.BackColor = Color.Green
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub
    Sub TimerOff()
        Timer1.Enabled = False
        PictureBox2.BackColor = Color.Red
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub

    Private Sub Button47_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button47.Click
        CancelButton = True
    End Sub

    Private Sub Button75_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button75.Click
        ' compile with Bill Beech's RASM assembler, download and run
        Dim Location As New Process
        Dim filename1 As String
        Dim filename2 As String
        Dim filename_noextension As String
        Dim batchcommand As String
        Dim LineOfText As String
        Call SaveAssemblyFile()
        filename1 = AssemblyFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 4)
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long and won't work with CP/M. Suggest renaming file")
        End If
        filename2 = filename_noextension + ".COM"
        batchcommand = "rasm -b -l " + filename_noextension
        FileOpen(1, "C:\N8vem\ASM.BAT", OpenMode.Output)
        PrintLine(1, batchcommand)
        FileClose(1)
        Location.StartInfo.FileName = "ASM.BAT"
        Location.StartInfo.WorkingDirectory = "C:\n8vem"
        Location.Start() ' shell the batch file
        Do
            ' wait till batch file finishes
        Loop Until Location.HasExited = True
        Try
            Kill("C:\N8VEM\" + filename_noextension + ".COM")
        Catch ex As Exception
            ' file didn't exist
        End Try
        ' test .lst file to see if any errors. If ok last line will be "No error(s) found"
        FileOpen(1, "C:\N8vem\" + filename_noextension + ".LST", OpenMode.Input)
        Do Until EOF(1)
            LineOfText = LineInput(1) ' leaves last line with the error message or not
        Loop
        FileClose(1)
        If LineOfText = "No error(s) found" Then
            ' rename the file
            TabControl1.SelectedIndex = 0 ' display cp/m
            TextBox3.Focus() 'display to cp/m
            Rename("C:\N8VEM\" + filename_noextension + ".BIN", "C:\N8VEM\" + filename_noextension + ".COM") ' bills program makes.bin files
            TimerOff()
            Call StringToPacket(vbCr) ' clear any rubbish that might be on the terminal
            Call WaitForPrompt()
            Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well otherwise if happens to be on user 0 then won't erase on user 1!
            Call WaitForPrompt()
            Call StringToPacket("ERA " + filename2 + vbCr)
            Call WaitForPrompt()
            Call StringToPacket("USER 1" + vbCr)
            Call WaitForPrompt()
            Call XModemFSend("C:\N8VEM\" + filename2, "XMODEMF", "MPM")
            Call WaitForPrompt()
            TimerOn()
        Else
            ' error found so recompile and leave the batch file window open
            FileOpen(1, "C:\N8vem\ERROR.BAT", OpenMode.Output)
            PrintLine(1, batchcommand)
            PrintLine(1, "Pause") ' leaves the batch file running
            FileClose(1)
            Location.StartInfo.FileName = "ERROR.BAT"
            Location.StartInfo.WorkingDirectory = "C:\n8vem"
            Location.Start() ' shell the batch file
            TimerOn()
        End If
    End Sub

    Private Sub Button76_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button76.Click
        MbasicFile = "NEW.BAS"
        MbasicFile = InputBox("Filename eg MYFILE.BAS (no more than 8 characters):", , MbasicFile)
        MbasicFile = Strings.UCase(MbasicFile)
        Label98.Text = MbasicFile
        RichTextBox9.Text = ""
        RichTextBox9.AppendText("10 PRINT " + Chr(34) + "Hello World" + Chr(34) + vbCrLf)
        RichTextBox9.AppendText("10000 END" + vbCrLf)
        TabControl1.SelectedIndex = 12
        RichTextBox9.Focus()
    End Sub

    Private Sub Button77_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button77.Click
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.BAS"
        OpenFileDialog1.ShowDialog()
        MbasicFile = OpenFileDialog1.FileName
        MbasicFile = Strings.Mid(MbasicFile, 10) ' strip off directory
        MbasicFile = Strings.UCase(MbasicFile)
        Label98.Text = MbasicFile
        Try
            RichTextBox9.LoadFile("C:\N8VEM\" + MbasicFile, RichTextBoxStreamType.PlainText)
            TabControl1.SelectedIndex = 12 ' tab number 0-7 (8)
            RichTextBox9.Focus()
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub

    Private Sub Button78_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button78.Click
        Call SaveMbasic()
    End Sub
    Sub SaveMBasic()
        If MbasicFile = "" Then
            MbasicFile = InputBox("Filename eg MYFILE.BAS: ", , MbasicFile)
            Label12.Text = MbasicFile
        End If
        RichTextBox9.SaveFile("C:\N8VEM\" + MbasicFile, RichTextBoxStreamType.PlainText)
        RichTextBox9.Focus()
        MBASICchanged = False
    End Sub

    Private Sub Button79_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button79.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "c:\N8VEM"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = MbasicFile ' ? put CPM files somewhere safe
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        Try
            RichTextBox9.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
            MbasicFile = Strings.Mid(Filenamepath, 10)
            Label98.Text = MbasicFile
            RichTextBox9.Focus()
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub

    Private Sub Button80_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button80.Click
        Dim Filename As String
        SaveMBasic() ' save the file
        TabControl1.SelectedIndex = 0 ' to tab 0
        TextBox3.Focus() ' focus to cp/m window
        System.Windows.Forms.Application.DoEvents() ' update the display
        Filename = Strings.Left(MbasicFile, Len(MbasicFile) - 4)
        TimerOff()
        Call StringToPacket("SYSTEM" + vbCr) ' in case still in basic
        Sleep(500)
        System.Windows.Forms.Application.DoEvents() ' update the display
        Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well
        Call WaitForPrompt()
        Call StringToPacket("ERA " + Filename + vbCr)
        Call WaitForPrompt()
        Call StringToPacket("USER 1" + vbCr)
        Call WaitForPrompt()
        Call XModemFSend("C:\N8VEM\" + MbasicFile, "XM1", "MPM")
        Call WaitForPrompt()
        Call StringToPacket("MBASIC " + Strings.Left(MbasicFile, Len(MbasicFile) - 4) + vbCr) ' finish up 
        TimerOn()
    End Sub

    Private Sub Button81_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button81.Click
        Dim Filename As String
        TabControl1.SelectedIndex = 0 ' to tab 0
        TextBox3.Focus() ' focus to cp/m window
        System.Windows.Forms.Application.DoEvents() ' update the display
        Filename = Strings.Left(MbasicFile, Len(MbasicFile) - 4)
        TimerOff()
        Call StringToPacket("BASCOM =" + Filename + vbCr) ' run the compiler
        Call WaitForPrompt()
        Call StringToPacket("L80 " + Filename + "," + Filename + "/N/E" + vbCr) ' run the linker 
        Call WaitForPrompt()
        TimerOn()
    End Sub

    Private Sub Button82_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button82.Click
        ' assumes mbasic is running
        Dim ProgramString As String
        Dim i As Integer
        TabControl1.SelectedIndex = 0 ' to tab 0
        TextBox3.Focus() ' focus to cp/m window
        System.Windows.Forms.Application.DoEvents() ' update the display
        ProgramString = vbCr + "NEW" + vbCr
        For i = 1 To Strings.Len(ProgramString)
            OutPacket(0) = Strings.Asc(Strings.Mid(ProgramString, i, 1))
            SerialPort1.Write(OutPacket, 0, 1)
        Next
        Sleep(200)
        ClearInputBuffer() ' gobble up return bytes
        System.Windows.Forms.Application.DoEvents() ' update the display
        ProgramString = RichTextBox9.Text
        For i = 1 To Strings.Len(ProgramString)
            OutPacket(0) = Strings.Asc(Strings.Mid(ProgramString, i, 1))
            If OutPacket(0) = 10 Then
                OutPacket(0) = 13 ' rich textbox uses LF as line end, need to convert to CR
                Sleep(30)
                ClearInputBuffer() ' gobble up return bytes
                System.Windows.Forms.Application.DoEvents() ' update the display
            End If
            SerialPort1.Write(OutPacket, 0, 1)
        Next
        ClearInputBuffer() ' gobble up return bytes
        System.Windows.Forms.Application.DoEvents() ' update the display
        ProgramString = "RUN" + vbCr
        For i = 1 To Strings.Len(ProgramString)
            OutPacket(0) = Strings.Asc(Strings.Mid(ProgramString, i, 1))
            SerialPort1.Write(OutPacket, 0, 1)
        Next
        Sleep(200)
        ClearInputBuffer() ' gobble up return bytes
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub

    Private Sub Button83_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button83.Click
        Dim Filename As String
        TimerOff()
        TabControl1.SelectedIndex = 0 ' to tab 0
        TextBox3.Focus() ' focus to cp/m window
        System.Windows.Forms.Application.DoEvents() ' update the display
        Filename = Strings.Left(MbasicFile, Len(MbasicFile) - 4)
        ' latest version, erase on user 0 and user1 and use xmodemf which saves to user 0
        ' need to run manually on user 0
        Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well otherwise if happens to be on user 0 then won't erase on user 1!
        Call WaitForPrompt()
        Call StringToPacket("ERA " + Filename + ".BAS" + vbCr)
        Call WaitForPrompt()
        Call StringToPacket("USER 1" + vbCr)
        Call WaitForPrompt()
        Call XModemFSend("C:\N8VEM\" + Filename + ".BAS", "XMODEMF", "MPM")
        Call WaitForPrompt()
        TimerOn()
    End Sub

    Private Sub Button84_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button84.Click
        'split into two parts for big programs that produce socket read errors
        Dim Filename1 As String
        TimerOff()
        Filename1 = Strings.Left(SbasicFile, Len(SbasicFile) - 4) 'trim the .bas
        FileCopy("C:\N8VEM\AltairSIMH\" + Filename1 + ".COM", "C:\N8VEM\" + Filename1 + ".COM")
        'Kill("C:\N8VEM\AltairSIMH\" + Filename1 + ".COM") ' clean up
        ' and transfer it to the board
        TabControl1.SelectedIndex = 0 ' to tab 0
        TextBox3.Focus() ' focus to cp/m window
        System.Windows.Forms.Application.DoEvents() ' update the display
        ' latest version, erase on user 0 and user1 and use xmodemf which saves to user 0
        Call StringToPacket("USER 0" + vbCr) ' erase on user 0 as well otherwise if happens to be on user 0 then won't erase on user 1!
        Call WaitForPrompt()
        Call StringToPacket("ERA " + Filename1 + ".COM" + vbCr)
        Call WaitForPrompt()
        Call StringToPacket("USER 1" + vbCr)
        Call WaitForPrompt()
        Call XModemFSend("C:\N8VEM\" + Filename1 + ".COM", "XMODEMF", "MPM")
        Call WaitForPrompt()
        TimerOn()
    End Sub

    Private Sub Button85_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button85.Click
        CatalinaFile = "NEW.C"
        CatalinaFile = InputBox("Filename eg MYFILE.C (no more than 8 characters):", , CatalinaFile)
        CatalinaFile = Strings.UCase(CatalinaFile)
        Label99.Text = CatalinaFile
        RichTextBox10.Text = ""
        RichTextBox10.AppendText("/* Traditional first C program */" + vbCrLf)
        RichTextBox10.AppendText(vbCrLf)
        RichTextBox10.AppendText("#include <stdio.h>" + vbCrLf)
        RichTextBox10.AppendText(vbCrLf)
        RichTextBox10.AppendText("void main () {" + vbCrLf)
        RichTextBox10.AppendText("printf(" + Chr(34) + "Hello, World!\n" + Chr(34) + ");" + vbCrLf)
        RichTextBox10.AppendText("while (1) ; /* Prop reboots on exit from main()! */" + vbCrLf)
        RichTextBox10.AppendText("}" + vbCrLf)
        RichTextBox10.AppendText(vbCrLf)
        TabControl1.SelectedIndex = 13
        RichTextBox10.Focus()
    End Sub

    Sub ColorCatalina()
        Dim Greenwords As New List(Of String)
        Dim Bluewords As New List(Of String)
        Dim Goldwords As New List(Of String) ' syntax errors
        ' purple words
        'Goldwords.Add(" as ") ' should use =
        ' blue words
        Bluewords.Add("char ")
        Bluewords.Add("do")
        Bluewords.Add("#define")
        Bluewords.Add("else")
        Bluewords.Add("for ")
        Bluewords.Add("getchar")
        Bluewords.Add("int ")
        Bluewords.Add("if")
        Bluewords.Add("#include")
        Bluewords.Add("kbhit")
        Bluewords.Add("printf")
        Bluewords.Add("return")
        Bluewords.Add("srand")
        Bluewords.Add("void")
        Bluewords.Add("while")
        Dim i As Integer
        Dim GreenFlag As Boolean
        Dim TempString As String
        Dim L As Integer
        Dim QuoteFlag As Boolean
        Dim QuoteCount As Integer
        'Dim IncludeFlag As Boolean
        'Dim IncludeCount As Integer
        If RichTextBox10.Text.Length > 0 And ColorOn = True Then
            SendMessage(RichTextBox10.Handle, WM_SETREDRAW, New IntPtr(CInt(False)), IntPtr.Zero) ' disable refresh
            Dim selectStart As Integer = RichTextBox10.SelectionStart ' preserve cursor
            RichTextBox10.Select(0, RichTextBox10.Text.Length)
            RichTextBox10.SelectionColor = Color.Black
            RichTextBox10.DeselectAll()
            'do blue words
            For Each oneWord As String In Bluewords
                Dim pos As Integer = 0
                Do While RichTextBox10.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox10.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox10.Select(pos, oneWord.Length)
                    RichTextBox10.SelectionColor = Color.Blue
                    pos = pos + 1
                Loop
            Next
            'do purple words (syntax errors eg using as instead of = because vb.net uses as
            For Each oneWord As String In Goldwords
                Dim pos As Integer = 0
                Do While RichTextBox10.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox10.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox10.Select(pos, oneWord.Length)
                    RichTextBox10.SelectionColor = Color.Gold
                    pos = pos + 1
                Loop
            Next
            ' put in rem and comments in green. 10 is end of line
            GreenFlag = False
            TempString = LCase(RichTextBox10.Text) ' all lower case for matching
            L = Strings.Len(TempString)
            For i = 1 To L
                If Strings.Mid(TempString, i, 2) = "/*" Then
                    GreenFlag = True
                End If
                If i < L - 2 And i > 2 Then
                    If Strings.Mid(TempString, i - 2, 2) = "*/" Then
                        GreenFlag = False
                    End If
                End If
                'If Strings.Mid(TempString, i, 3) = "rem" Then ' rem to end of line
                ' RemFlag = True
                ' GreenFlag = True
                ' End If
                'If RemFlag = True And Strings.Mid(TempString, i, 1) = vbLf Then
                ' RemFlag = False
                ' GreenFlag = False
                ' End If
                'If Strings.Mid(TempString, i, 1) = "<" Then
                ' IncludeFlag = True
                ' End If
                'If i > 2 And IncludeCount > 1 Then
                ' If IncludeFlag = True And Strings.Mid(TempString, i - 1, 1) = ">" Then
                ' IncludeFlag = False
                ' IncludeCount = 0
                ' End If
                ' End If

                If Strings.Mid(TempString, i, 1) = Strings.Chr(34) Then
                    QuoteFlag = True
                End If
                If i > 2 And QuoteCount > 1 Then
                    If QuoteFlag = True And Strings.Mid(TempString, i - 1, 1) = Strings.Chr(34) Then
                        QuoteFlag = False
                        QuoteCount = 0
                    End If
                End If
                If QuoteFlag = True Then ' add red text for quotes
                    RichTextBox10.Select(i - 1, 1)
                    RichTextBox10.SelectionColor = Color.Red
                End If
                If GreenFlag = True Then
                    RichTextBox10.Select(i - 1, 1)
                    RichTextBox10.SelectionColor = Color.Green
                End If
                If QuoteFlag = True Then QuoteCount = QuoteCount + 1
                'If IncludeFlag = True Then IncludeCount = IncludeCount + 1
                'If IncludeFlag = True Then ' purple text
                ' RichTextBox10.Select(i - 1, 1)
                ' RichTextBox10.SelectionColor = Color.Purple
                ' End If
            Next
            RichTextBox10.SelectionStart = selectStart
            RichTextBox10.SelectionLength = 0
            SendMessage(RichTextBox10.Handle, WM_SETREDRAW, New IntPtr(CInt(True)), IntPtr.Zero)
            RichTextBox10.Refresh()
        End If
    End Sub

    Private Sub Button87_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button87.Click
        ColorCatalina()
    End Sub
    Sub SaveCatalina()
        RichTextBox10.SaveFile("C:\Program Files\Catalina\Demos\" + CatalinaFile, RichTextBoxStreamType.PlainText)
        RichTextBox10.Focus()
    End Sub


    Private Sub Compile_C()
        ' compile the program - 
        Dim Location As New Process
        Dim filename1 As String
        Dim filename2 As String
        Dim filename_noextension As String
        Dim batchcommand As String
        Dim LineOfText As String
        Dim Memsize As String
        Dim VGAMode As String
        Dim CommandLine As String
        SaveCatalina()
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long. Suggest renaming file")
        End If
        SaveCatalina() ' save the file
        ' create a batch file in the demo folder
        Memsize = TextBox17.Text
        If RadioButton10.Checked = True Then
            VGAMode = "HIRES_VGA"
        Else
            VGAMode = "LORES_VGA"
        End If
        'PrintLine(1, "catalina -lcx -x5 -M 128k -D DRACBLADE -D HIRES_VGA " + CatalinaFile)
        If CheckBox17.Checked = False Then
            CommandLine = "catalina -lcx -x5 -M " + Memsize + "k -D DRACBLADE -D " + VGAMode + " " + CatalinaFile
        Else
            CommandLine = "catalina -lc -D DEMO -D " + VGAMode + " " + CatalinaFile
        End If
        FileOpen(1, "C:\Program Files\Catalina\Demos\drac.bat", OpenMode.Output)
        PrintLine(1, "@echo off")
        PrintLine(1, "echo.")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo    SETTING UP CATALINA")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo.")
        PrintLine(1, "PATH=C:\Program Files\Catalina\bin;%PATH%")
        PrintLine(1, "Call catalina_env.bat()")
        PrintLine(1, CommandLine) ' see above
        PrintLine(1, "pause")
        'PrintLine(1, "pause") ' leaves batch file window open so can see errors
        FileClose(1)
        ' compile the program
        Location.StartInfo.FileName = "drac.bat"
        Location.StartInfo.WorkingDirectory = "C:\Program Files\Catalina\Demos"
        Location.Start() ' shell the startup file
        Do
            ' wait till batch file finishes
        Loop Until Location.HasExited = True
    End Sub
    Private Sub Download_C()
        Dim filename1 As String
        Dim filename_noextension As String
        Dim LineOfText As String
        Dim i As Integer
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        'MsgBox("Compiled")
        ' send the file
        TabControl1.SelectedIndex = 0 ' display kyedos
        TextBox3.Focus() 'display to kyedos
        ' rename .binary to .bin
        Try
            Kill("C:\Program Files\Catalina\Demos\" + filename_noextension + ".bin")
        Catch ex As Exception ' file didn't exist
        End Try
        Try
            Rename("C:\Program Files\Catalina\Demos\" + filename_noextension + ".binary", "C:\Program Files\Catalina\Demos\" + filename_noextension + ".bin")
            TimerOff()
            Call XmodemSendKyeDOS("C:\Program Files\Catalina\Demos\" + filename_noextension + ".bin")
            TimerOn()
            LineOfText = "Spin Catlyst2.bin" + vbCr ' run the serial version of catalyst
            Call StringToPacket(LineOfText)
            'The baud rate you are fiddling with is (as the comment implies) the loader baud rate. The baud rate you need to change to affect the PC HMI option are the ones in:
            'Catalina_PC_Text.spin()
            'Catalina_PC_Keyboard.spin()
            'Catalina_PC_Mouse.spin()
            ' and recompile with    build_all DRACBLADE              <-- to use local VGA and keyboard
            'or
            'build_all DRACBLADE PC VT100     <-- to use PC terminal emulator
            ' local version is catlyst1.bin and serial version is catlyst2.bin
            For i = 1 To 6
                System.Windows.Forms.Application.DoEvents() ' update the label1 message
                Sleep(1000) ' wait for reboot approx 8 seconds
            Next i
            LineOfText = UCase(filename_noextension) + vbCr ' and run the program
            Call StringToPacket(LineOfText)
        Catch ex As Exception
            MsgBox("Compile error, check batch file for error message(s)")
        End Try
    End Sub

    Private Sub Button89_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button89.Click
        SaveCatalina()
    End Sub

    Sub XmodemSendKyeDOS(ByVal Fname As String)
        Dim Filenamepath As String
        Dim a, j, i As Integer
        Dim k As Integer
        Dim LineOfText As String
        Dim SerialString As String
        Dim Counter As Integer
        Dim ErrorString As String
        Dim Packetnumber As Integer
        Dim Checksum As Long
        Dim OnesComplement As Byte
        Dim ByteRead As Byte
        Dim BinaryFileLength As Long
        Dim BinaryFileCounter As Long
        Dim Percent As Single
        Dim ErrorCounter As Byte ' 0 to 10
        Dim CPMFilename As String
        ProgressBar1.Maximum = 100
        ProgressBar1.Minimum = 0
        ' timer restart =true for sending via menu. False for auto send
        Filenamepath = Fname
        Packetnumber = 1 ' 1 for the first packet (not zero)
        Try
            Dim Input As New FileStream(Filenamepath, FileMode.Open, FileAccess.Read)
            Dim br As New BinaryReader(Input)
            Label3.Text = "Error Count"
            Label2.Text = "0%"
            BinaryFileLength = br.BaseStream.Length() - 1
            'i = Len(Filepath) + 1 + 1  ' eg c:\n8vem and a \ = 9 and 1 more for start of name only
            Call Get_CPM_Filename(Filenamepath, CPMFilename)
            CPMFilename = Strings.UCase(CPMFilename)
            LineOfText = "XMR " + CPMFilename + vbCr ' send command to kyedos
            Call StringToPacket(LineOfText)
            Call ClearInputBuffer()  ' clear the buffer into the PC
            For i = 1 To 20 ' need to wait till "Ready to Receive" appears on the screen
                Sleep(100) ' wait for the xmodem text to come back so the next one is a 21
                Label3.Text = Str$(i) ' if make this too short then starts erroring on the first, but only the first, download
                Call ClearInputBuffer()  ' clear the buffer into the PC
            Next i
            ' wiat for text to come back, "Receiving filename: " etc
            Do
                SerialString = ""
                If SerialPortFound = True Then
                    If SerialPort1.BytesToRead > 0 Then
                        SerialPort1.Read(InPacket, 0, 1) ' get one byte
                        SerialString = Chr(InPacket(0)) ' get a single character/string/byte
                    End If
                End If
                If InPacket(0) = 21 Then
                    ErrorString = "NAK"
                    Exit Do ' got a ^U
                End If
                If SerialString <> "" Then
                    'LineOfText = SerialString
                    'Call TextLines(LineOfText) ' print it out unless it is a chr21
                End If
                Counter = Counter + 10
                Sleep(10) ' don't change this one - this is waiting for NAK
                Label1.Text = "Waiting for NAK to start" + Strings.Str(Counter) + "ms" ' display in milliseconds
                System.Windows.Forms.Application.DoEvents() ' update the label1 message
                ' add a counter and timeout if nothing
                If Counter > 5000 Then
                    ErrorString = "Bypass wait for NAK - xmodem failed"
                    Exit Do
                End If
                If ErrorString <> "" Then Exit Do
            Loop
            Label1.Text = ErrorString
            System.Windows.Forms.Application.DoEvents() ' update the label1 message
            ' bug with vb.net - strings don't go to 255 so have to send data as bytes
            Do
                ' act on each byte in the buffer array here
                Sleep(1) ' 60 for 4800 but 1 working for 38400
                XOut(0) = 1 'SOH ^A
                XOut(1) = Packetnumber
                OnesComplement = 255 - Packetnumber
                XOut(2) = OnesComplement
                Packetnumber = Packetnumber + 1
                If Packetnumber > 255 Then Packetnumber = Packetnumber - 256
                Checksum = 0
                For i = 0 To 127 ' get 128 bytes from file
                    If BinaryFileCounter <= BinaryFileLength Then
                        ByteRead = br.ReadByte ' get a byte
                    Else
                        ByteRead = 26 ' pad with char 26 = hex 1A because hyperterm does this ? why but it works
                    End If
                    XOut(i + 3) = ByteRead
                    Checksum = Checksum + ByteRead
                    BinaryFileCounter = BinaryFileCounter + 1
                Next
                ' create checksum
                Do
                    If Checksum < 256 Then Exit Do ' work out checksum
                    Checksum = Checksum - 256
                Loop
                XOut(131) = Checksum
                Call OutputXout()
                System.Windows.Forms.Application.DoEvents() ' update the label
                Do
                    k = 0
                    Do
                        Sleep(1) '80 for 4800  wait for the acknowledge which is a character 6 delay of 80 only occasionally loops so k>0
                        If SerialPortFound = True Then
                            j = SerialPort1.BytesToRead
                        End If
                        If j >= 1 Then
                            If SerialPortFound = True Then
                                SerialPort1.Read(InPacket, 0, 1) ' get one byte
                            End If
                            Exit Do
                        End If
                        k = k + 1
                        If k > 700 Then
                            InPacket(0) = 0 ' for below error testing
                            Exit Do
                        End If
                    Loop
                    If InPacket(0) = 6 Then Exit Do ' board got the packet
                    If InPacket(0) = 21 Or InPacket(0) = 0 Then
                        ' didn't get it so try sending again
                        ErrorCounter = ErrorCounter + 1
                        Call OutputXoutSlow() ' send the next one slowly
                        If InPacket(0) = 0 Then
                            Label3.Text = "Timeout waiting for Ack"
                            ErrorCounter = 20 'force an exit now
                            System.Windows.Forms.Application.DoEvents() ' update the label
                        Else
                            Label3.Text = "Nak: " + Strings.Str(ErrorCounter)
                            System.Windows.Forms.Application.DoEvents() ' update the label
                        End If
                    End If
                    If ErrorCounter >= 2 Then Exit Do ' standard xmodem is 10 but make this 2
                Loop
                If ErrorCounter >= 5 Then
                    Label1.Text = "5 or more errors - aborting"
                    Label2.Text = "0%"
                    OutPacket(0) = 24 ' send a ^X cancel
                    If SerialPortFound = True Then
                        SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
                        OutPacket(0) = 3 ' send a ^C
                        SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
                    End If
                    Exit Do
                End If
                If BinaryFileCounter > BinaryFileLength Then Exit Do ' finish up
                Label1.Text = "Sent packet: " + Strings.Str(Packetnumber) + " = OK"
                Percent = BinaryFileCounter / BinaryFileLength
                Percent = Percent * 100
                Percent = Int(Percent)
                Label2.Text = Strings.Str(Percent) + "%"
                ProgressBar1.Value = Percent
            Loop
            If ErrorCounter < 10 Then
                Sleep(1) ' tiny delay
                OutPacket(0) = 4 ' finish character
                If SerialPortFound = True Then
                    SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
                End If
                Label2.Text = "100%"
                Label1.Text = "Finished"
                ProgressBar1.Value = 0 'done
            End If
            Input.Close()
            System.Windows.Forms.Application.DoEvents() ' update the labels
        Catch ex As Exception
            Close()
            Label1.Text = Filenamepath + " not found"
            System.Windows.Forms.Application.DoEvents() ' update the labels
            Sleep(1000) ' so time to read message
        End Try
    End Sub


    Private Sub Button90_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button90.Click
        Dim Filepath As String
        Filepath = "C:\Program Files\Catalina\Demos"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.C"
        OpenFileDialog1.ShowDialog()
        CatalinaFile = OpenFileDialog1.FileName
        CatalinaFile = Strings.Mid(CatalinaFile, 33) ' strip off directory
        CatalinaFile = Strings.UCase(CatalinaFile)
        Label99.Text = CatalinaFile
        Try
            RichTextBox10.LoadFile("C:\Program Files\Catalina\Demos\" + CatalinaFile, RichTextBoxStreamType.PlainText)
            TabControl1.SelectedIndex = 13 ' tab number 0-7 (8)
            RichTextBox10.Focus()
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub
    Private Sub Button86_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button86.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "C:\Program Files\Catalina\Demos\"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = CatalinaFile
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        Try
            RichTextBox10.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
            CatalinaFile = Strings.Mid(Filenamepath, 33)
            Label99.Text = CatalinaFile
            RichTextBox10.Focus()
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub
    Sub ResetPropeller()
        SerialPort1.DtrEnable = True ' toggle the dtr line
        SerialPort1.DtrEnable = False
    End Sub

    Private Sub Button88_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button88.Click
        ResetPropeller() ' boot back into kyedos
        Sleep(2000) ' compile is faster than kyedos rebooting
        Compile_C()
        Download_C()
    End Sub

    Private Sub Button91_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button91.Click
        Compile_C()
    End Sub
End Class
