CON
  'Clock settings
  _clkmode = xtal1 + pll16x              'Crystal and PLL settings
  _xinfreq = 5_000_000                   '5 Mgz crystal x 16 = 80 Mgz

  ' define pins 
  SR_DATA = 6                  'to pin 14 on 74HC595
  SR_LATCH = 8                 'to pin 12 on 74HC595
  SR_CLOCK = 10                'to pin 11 on 74HC595
  
OBJ

VAR
  long pauseMS
  
PUB Main | i, highBits, lowBits
  ' set pins to output
  dira[SR_CLOCK]~~
  dira[SR_LATCH]~~
  dira[SR_DATA]~~
  
  pauseMS := 1000
  ' test 
  repeat
    dataOut16Bit($0001)
    pause(pauseMS)  
    dataOut16Bit($0002)
    pause(pauseMS)  
    dataOut16Bit($0100)
    pause(pauseMS)  
    dataOut16Bit($0200)
    pause(pauseMS)  
  
{{
  ' counter using 16 bits
  pauseMS := 50 
  repeat
    repeat i from 0 to 32766
      dataOut16Bit(i)        
      pause(pauseMS)
}}
      

PRI dataOut16Bit(data)| high8Bits, low8Bits 
  high8Bits := data / 256
  low8Bits := data // 256  'modulus
  outa[SR_LATCH] := 0
  writeHC595(high8Bits)  
  writeHC595(low8Bits)
  outa[SR_LATCH] := 1  
  'waitcnt(clkfreq/10 + cnt)  '## stabilize output 

PRI writeHC595(bits)

  bits <-= 24                      ' Move Bits To MSB
  repeat 8                         ' 8 Bits
    outa[SR_DATA] := bits <-= 1    ' Rotate Bits And Output
    outa[SR_CLOCK] := 1            ' Clock The HC595
    outa[SR_CLOCK] := 0

PRI Pause(ms)
  waitcnt(clkfreq / 1000 * ms + cnt) ' Convert To mS
