// Project 16 – Creating an LED Binary Number Display

#define DATA 6 // digital 6 to pin 14 on the 74HC595
#define LATCH 8 // digital 8 to pin 12 on the 74HC595
#define CLOCK 10 // digital 10 to pin 11 on the 74HC595

void setup()
{
  pinMode(LATCH, OUTPUT);
  pinMode(CLOCK, OUTPUT);
  pinMode(DATA, OUTPUT);

  digitalWrite(LATCH, LOW);    
  shiftOut(DATA, CLOCK, MSBFIRST, 0);
  shiftOut(DATA, CLOCK, MSBFIRST, 0);    
  digitalWrite(LATCH, HIGH);
}

void loop()
{
  int high8Bits = 0; 
  int low8Bits = 0; 
  int i;
  
  for ( i = 0; i < 32767; i++ )
  {
    high8Bits = i / 256; 
    low8Bits = i % 256; 
    digitalWrite(LATCH, LOW);    
    shiftOut(DATA, CLOCK, MSBFIRST, high8Bits);
    shiftOut(DATA, CLOCK, MSBFIRST, low8Bits);    
    digitalWrite(LATCH, HIGH);
    delay(50);
  }
  
}

