﻿Imports System.IO
Imports System.Windows.Forms
Imports System.IO.Ports
Imports Strings = Microsoft.VisualBasic ' so can use things like left( and right( for strings
Public Class Form1
    Dim WithEvents SerialPortName As New IO.Ports.SerialPort ' generic serial port
    Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Integer) ' for sleep statements
    Public Declare Auto Function SendMessage Lib "user32.dll" (ByVal hWnd As IntPtr, ByVal wMsg As Int32, ByVal wParam As IntPtr, ByVal lParam As IntPtr) As IntPtr ' disable redrawing of richtextbox etc
    Public Const WM_SETREDRAW As Int32 = &HB ' for above sendmessage
    Dim InPacket(0 To 2000) As Byte ' Major bug with serial.write strings like chr(255) won't go out
    Dim OutPacket(0 To 2000) As Byte
    Dim XOut(0 To 133) As Byte ' xmodem output packet
    Public CatalinaFile As String
    Public VGAMode As String
    Public MemSize As String
    Public XMM As String
    Public SerialPortFound As Boolean = True
    Public Baud As String
    Public ComPort As String
    Public MouseGUI As String
    Public FindString As String
    Public PlaceHolder As Integer
    Public IndentPointer As Integer
    Public CompilePause As Boolean

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Timer1.Interval = 150 ' check for new characters every 150ms

        RichTextBox1.AcceptsTab = True ' so tab stays in the box
        RichTextBox3.AcceptsTab = True ' so tab stays in the box
        VGAMode = "HIRES_VGA"
        MemSize = "512"
        XMM = "FALSE"
        ComPort = "COM1" ' can change later if needed
        Baud = "38400"
        SettingsTabLoad() ' update the display
        LoadINI() ' load settings - overwrites above
        MouseGUI = "Default"
        FindString = ""
        CompilePause = True
    End Sub
    Sub OpenSerialPort()
        Try
            ' set the portname and baudrate in the loadini subroutine
            SerialPortName.PortName = ComPort
            SerialPortName.BaudRate = Baud '38400
            SerialPortName.Parity = IO.Ports.Parity.None ' no parity
            SerialPortName.DataBits = 8 ' 8 bits
            SerialPortName.StopBits = IO.Ports.StopBits.One ' one stop bit
            'serialportname.ReadTimeout = 1000 ' milliseconds so times out in 1 second if no response
            SerialPortName.Open() ' open the port
            SerialPortName.DiscardInBuffer() ' clear the input buffer
        Catch ex As Exception
            MsgBox("Error opening serial port - is another program using the selected COM port? This program will continue running but with no serial port comms.")
            SerialPortFound = False
        End Try
    End Sub
    Sub CloseSerialPort()

    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        End
    End Sub

    Private Sub NewToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NewToolStripMenuItem.Click
        CatalinaFile = "NEW.C"
        CatalinaFile = InputBox("Filename eg MYFILE.C (no more than 8 characters):", , CatalinaFile)
        CatalinaFile = Strings.UCase(CatalinaFile)
        RichTextBox1.Text = ""
        RichTextBox1.AppendText("/* Traditional first C program */" + vbCrLf)
        RichTextBox1.AppendText(vbCrLf)
        RichTextBox1.AppendText("#include <stdio.h>" + vbCrLf)
        RichTextBox1.AppendText(vbCrLf)
        RichTextBox1.AppendText("void clearscreen() // white text on dark blue background" + vbCrLf)
        RichTextBox1.AppendText("{" + vbCrLf)
        RichTextBox1.AppendText("int i;" + vbCrLf)
        RichTextBox1.AppendText("for (i=0;i<40;i++)" + vbCrLf)
        RichTextBox1.AppendText("{" + vbCrLf)
        RichTextBox1.AppendText("t_setpos(0,0,i); // move cursor to next line" + vbCrLf)
        RichTextBox1.AppendText("t_color(0,0x08FC); // RRGGBBxx eg dark blue background 00001000 white text 11111100" + vbCrLf)
        RichTextBox1.AppendText("}" + vbCrLf)
        RichTextBox1.AppendText("}" + vbCrLf)
        RichTextBox1.AppendText(vbCrLf)
        RichTextBox1.AppendText("void main ()" + vbCrLf)
        RichTextBox1.AppendText("{" + vbCrLf)
        RichTextBox1.AppendText("clearscreen();" + vbCrLf)
        RichTextBox1.AppendText("printf(" + Chr(34) + "Hello, World!\n" + Chr(34) + ");" + vbCrLf)
        RichTextBox1.AppendText("while (1); // Prop reboots on exit from main()!" + vbCrLf)
        RichTextBox1.AppendText("}" + vbCrLf)
        RichTextBox1.AppendText(vbCrLf)
        RichTextBox1.Focus()
        Indents() ' add the proper indentation
        ColorCatalina() ' display in color
        PrintFileName()
    End Sub
    Private Sub PrintFileName()
        Label1.Text = CatalinaFile
        If XMM = True Then
            Label1.Text += " in XMM External Memory"
        Else
            Label1.Text += " in LMM Propeller Memory"
        End If
    End Sub
    Private Sub OpenToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenToolStripMenuItem.Click
        Dim Filepath As String
        Filepath = "C:\Program Files\Catalina\Demos"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.C"
        OpenFileDialog1.ShowDialog()
        CatalinaFile = OpenFileDialog1.FileName
        CatalinaFile = Strings.Mid(CatalinaFile, 33) ' strip off directory
        CatalinaFile = Strings.UCase(CatalinaFile)
        PrintFileName()
        Try
            RichTextBox1.LoadFile("C:\Program Files\Catalina\Demos\" + CatalinaFile, RichTextBoxStreamType.PlainText)
            RichTextBox1.Focus()
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub

    Private Sub SaveToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveToolStripMenuItem.Click
        SaveCatalina()
    End Sub
    Sub SaveCatalina()
        RichTextBox1.SaveFile("C:\Program Files\Catalina\Demos\" + CatalinaFile, RichTextBoxStreamType.PlainText)
    End Sub

    Private Sub SaveAsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveAsToolStripMenuItem.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Filepath = "C:\Program Files\Catalina\Demos\"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = CatalinaFile
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        PrintFileName()
        Try
            RichTextBox1.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
            CatalinaFile = Strings.Mid(Filenamepath, 33)
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub

    Private Sub ColorToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ColorToolStripMenuItem.Click
        ColorCatalina()
    End Sub
    Sub ColorCatalina()
        Dim Greenwords As New List(Of String)
        Dim Bluewords As New List(Of String)
        Dim Goldwords As New List(Of String) ' syntax errors
        Dim Purplewords As New List(Of String)
        ' http://condor.depaul.edu/sjost/it236/documents/colorNames.htm
        ' purple words
        Purplewords.Add("FILE")
        'Goldwords.Add(" as ") ' should use =
        ' blue words
        Bluewords.Add("char ")
        Bluewords.Add("do")
        Bluewords.Add("#define")
        Bluewords.Add("else")
        Bluewords.Add("for ")
        Bluewords.Add("fopen")
        Bluewords.Add("fclose")
        Bluewords.Add("fread")
        Bluewords.Add("fwrite")
        Bluewords.Add("fputc")
        Bluewords.Add("fgetc")
        Bluewords.Add("fprintf")
        Bluewords.Add("getchar")
        Bluewords.Add("int ")
        Bluewords.Add("if")
        Bluewords.Add("#include")
        Bluewords.Add("kbhit")
        Bluewords.Add("printf")
        Bluewords.Add("return")
        Bluewords.Add("srand")
        Bluewords.Add("void")
        Bluewords.Add("unsigned")
        Bluewords.Add("while")
        Bluewords.Add("_coginit")
        Bluewords.Add("long")
        Bluewords.Add("const")
        Dim i As Long
        Dim GreenFlag As Boolean
        Dim TempString As String
        Dim L As Integer
        Dim QuoteFlag As Boolean
        Dim QuoteCount As Integer
        Dim RemFlag As Boolean
        Dim CONflag As Boolean
        Dim PUBFlag As Boolean
        Dim DATflag As Boolean
        Dim PASMflag As Boolean
        'Dim IncludeFlag As Boolean
        'Dim IncludeCount As Integer
        Label3.Text = "Start blue"
        System.Windows.Forms.Application.DoEvents() ' update the label
        If RichTextBox1.Text.Length > 0 Then
            SendMessage(RichTextBox1.Handle, WM_SETREDRAW, New IntPtr(CInt(False)), IntPtr.Zero) ' disable refresh
            Dim selectStart As Integer = RichTextBox1.SelectionStart ' preserve cursor
            RichTextBox1.Select(0, RichTextBox1.Text.Length)
            RichTextBox1.SelectionColor = Color.Black
            RichTextBox1.DeselectAll()
            'do blue words
            For Each oneWord As String In Bluewords
                Dim pos As Integer = 0
                Do While RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox1.Select(pos, oneWord.Length)
                    RichTextBox1.SelectionColor = Color.Blue ' change the foreground color
                    'RichTextBox1.SelectionBackColor = Color.Black ' change the background color
                    pos = pos + 1
                Loop
            Next
            Label3.Text = "Start purple"
            System.Windows.Forms.Application.DoEvents() ' update the label
            'do purple words (syntax errors eg using as instead of = because vb.net uses as
            For Each oneWord As String In Purplewords
                Dim pos As Integer = 0
                Do While RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos) >= 0
                    pos = RichTextBox1.Text.ToUpper.IndexOf(oneWord.ToUpper, pos)
                    RichTextBox1.Select(pos, oneWord.Length)
                    RichTextBox1.SelectionColor = Color.Purple
                    pos = pos + 1
                Loop
            Next
            System.Windows.Forms.Application.DoEvents() ' update the richtextbox
            Label3.Text = "Start green"
            System.Windows.Forms.Application.DoEvents() ' update the label
            ' put in rem and comments in green. 10 is end of line
            ' also put PASM code in dark green
            GreenFlag = False
            TempString = LCase(RichTextBox1.Text) ' all lower case for matching
            L = Strings.Len(TempString)
            For i = 1 To L
                If i < L - 10 Then
                    If Strings.Mid(TempString, i, 10) = "pasm start" Then ' lower case see above
                        PASMflag = True
                    End If
                    If Strings.Mid(TempString, i, 8) = "pasm end" Then
                        PASMflag = False
                        GreenFlag = True ' still green
                    End If
                    If PASMflag = True And Strings.Mid(TempString, i, 3) = "con" Then
                        CONflag = True
                    End If
                    If PASMflag = True And Strings.Mid(TempString, i, 3) = "pub" Then
                        PUBFlag = True
                    End If
                    If PASMflag = True And Strings.Mid(TempString, i, 3) = "dat" Then
                        DATflag = True
                    End If
                    If Strings.Mid(TempString, i, 1) = "'" And PASMflag = True Then
                        RemFlag = True ' comments green in the pasm block
                    End If
                    If Strings.Mid(TempString, i, i) = vbLf And PASMflag = True Then
                        RemFlag = False ' turn off green comments on next line
                    End If
                End If
                If Strings.Mid(TempString, i, 2) = "/*" Then
                    GreenFlag = True
                End If
                If i < L - 2 And i > 2 Then
                    If Strings.Mid(TempString, i - 2, 2) = "*/" Then
                        GreenFlag = False
                    End If
                End If
                If Strings.Mid(TempString, i, 2) = "//" Then ' // to end of line
                    RemFlag = True
                    GreenFlag = True
                End If
                If RemFlag = True And Strings.Mid(TempString, i, 1) = vbLf Then
                    RemFlag = False
                    GreenFlag = False
                End If
                If Strings.Mid(TempString, i, 1) = Strings.Chr(34) Then
                    QuoteFlag = True
                End If
                If i > 2 And QuoteCount > 1 Then
                    If QuoteFlag = True And Strings.Mid(TempString, i - 1, 1) = Strings.Chr(34) Then
                        QuoteFlag = False
                        QuoteCount = 0
                    End If
                End If
                If QuoteFlag = True Then ' add red text for quotes
                    RichTextBox1.Select(i - 1, 1)
                    RichTextBox1.SelectionColor = Color.Red
                End If
                If GreenFlag = True Then
                    RichTextBox1.Select(i - 1, 1)
                    RichTextBox1.SelectionColor = Color.Green
                End If
                If PASMflag = True Then
                    RichTextBox1.Select(i - 1, 1)
                    If CONflag = True Then
                        RichTextBox1.SelectionColor = Color.Goldenrod ' CON
                    End If
                    If PUBFlag = True Then
                        RichTextBox1.SelectionColor = Color.Firebrick ' PUB
                    End If
                    If DATflag = True Then
                        RichTextBox1.SelectionColor = Color.DarkSlateBlue 'DAT
                    End If
                    If RemFlag = True Then
                        RichTextBox1.SelectionColor = Color.Green ' Comments
                    End If
                End If
                If QuoteFlag = True Then QuoteCount = QuoteCount + 1
            Next
            'RichTextBox1.SelectionStart = selectStart
            RichTextBox1.SelectionStart = 0 ' move to the beginning
            RichTextBox1.SelectionLength = 0
            SendMessage(RichTextBox1.Handle, WM_SETREDRAW, New IntPtr(CInt(True)), IntPtr.Zero)
            RichTextBox1.Refresh()
        End If
        Label3.Text = "Finish color"

    End Sub

    Private Sub CompileToolStripMenuItem1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompileToolStripMenuItem1.Click
        CompilePause = True
        Compile_C()
    End Sub
    Private Sub Compile_C()
        ' compile the program - 
        Dim Location As New Process
        Dim filename1 As String
        Dim filename2 As String
        Dim filename_noextension As String
        Dim batchcommand As String
        Dim LineOfText As String
        Dim CommandLine As String
        SaveCatalina()
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long. Suggest renaming file")
        End If
        ' create a batch file in the demo folder
        'PrintLine(1, "catalina -lcx -x5 -M 128k -D DRACBLADE -D HIRES_VGA " + CatalinaFile)
        If XMM = "TRUE" Then
            CommandLine = "catalina -lcx -x5 -M " + MemSize + "k -D DRACBLADE -D " + VGAMode + " " + CatalinaFile
        Else
            CommandLine = "catalina -lc -D DEMO -D " + VGAMode + " " + CatalinaFile
        End If
        FileOpen(1, "C:\Program Files\Catalina\Demos\drac.bat", OpenMode.Output)
        PrintLine(1, "@echo off")
        PrintLine(1, "echo.")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo    SETTING UP CATALINA")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo.")
        PrintLine(1, "PATH=C:\Program Files\Catalina\bin;%PATH%")
        PrintLine(1, "Call catalina_env.bat()")
        PrintLine(1, CommandLine) ' see above
        If CompilePause = True Then
            PrintLine(1, "pause") ' leaves batch file window open so can see errors
        End If
        FileClose(1)
        ' compile the program
        Location.StartInfo.FileName = "drac.bat"
        Location.StartInfo.WorkingDirectory = "C:\Program Files\Catalina\Demos"
        Location.Start() ' shell the startup file
        Do
            ' wait till batch file finishes
        Loop Until Location.HasExited = True
    End Sub
    Sub ResetPropeller()
        SerialPortName.Open()
        SerialPortName.DtrEnable = False
        SerialPortName.DtrEnable = True ' toggle the dtr line
        SerialPortName.DtrEnable = False
        SerialPortName.Close()
    End Sub

    Private Sub MemorySizeToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        MemSize = InputBox("Memory Size 64 to 512", "Memory Size", MemSize)
        SaveINI()
    End Sub

    Private Sub VGAResolutionToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        VGAMode = InputBox("VGA resolution", "HIRES_VGA or LORES_VGA", VGAMode)
        SaveINI()
    End Sub

    Private Sub ExtendedMemoryToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        XMM = InputBox("Use Extended Memory and SD card", "TRUE or FALSE", XMM)
        SaveINI()
    End Sub

    Private Sub COMPortToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        ComPort = InputBox("Serial Port", "COM1 or COM2 etc", ComPort)
        SaveINI()
    End Sub

    Private Sub BaudRateToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Baud = InputBox("Baud rate", "38400, 115200 etc", Baud)
        SaveINI()
    End Sub

    Private Sub CompileDownloadRunToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompileDownloadRunToolStripMenuItem.Click
        ' can do both xmm and normal programs. Slower than payload
        CompilePause = False ' assumes program has been debugged
        ResetPropeller() ' boot back into kyedos
        Sleep(3000) ' compile is faster than kyedos rebooting
        Compile_C() ' compile the program
        Download_C() ' download the file
    End Sub
    Sub XmodemSendKyeDOS(ByVal Fname As String)
        Dim Filenamepath As String
        Dim a, j, i As Integer
        Dim k As Integer
        Dim LineOfText As String
        Dim SerialString As String
        Dim Counter As Integer
        Dim ErrorString As String
        Dim Packetnumber As Integer
        Dim Checksum As Long
        Dim OnesComplement As Byte
        Dim ByteRead As Byte
        Dim BinaryFileLength As Long
        Dim BinaryFileCounter As Long
        Dim Percent As Single
        Dim ErrorCounter As Byte ' 0 to 10
        Dim CPMFilename As String
        ProgressBar1.Maximum = 100
        ProgressBar1.Minimum = 0
        ' timer restart =true for sending via menu. False for auto send
        Filenamepath = Fname
        Packetnumber = 1 ' 1 for the first packet (not zero)
        Try
            Dim Input As New FileStream(Filenamepath, FileMode.Open, FileAccess.Read)
            Dim br As New BinaryReader(Input)
            Label3.Text = "Error Count"
            Label2.Text = "0%"
            BinaryFileLength = br.BaseStream.Length() - 1
            'i = Len(Filepath) + 1 + 1  ' eg c:\n8vem and a \ = 9 and 1 more for start of name only
            Call Get_CPM_Filename(Filenamepath, CPMFilename)
            CPMFilename = Strings.UCase(CPMFilename)
            LineOfText = "XMR " + CPMFilename + vbCr ' send command to kyedos
            Call StringToPacket(LineOfText)
            Call ClearInputBuffer()  ' clear the buffer into the PC
            For i = 1 To 20 ' need to wait till "Ready to Receive" appears on the screen
                Sleep(100) ' wait for the xmodem text to come back so the next one is a 21
                Label3.Text = Str$(i) ' if make this too short then starts erroring on the first, but only the first, download
                Call ClearInputBuffer()  ' clear the buffer into the PC
            Next i
            ' wiat for text to come back, "Receiving filename: " etc
            Do
                SerialString = ""
                If SerialPortFound = True Then
                    If SerialPortName.BytesToRead > 0 Then
                        SerialPortName.Read(InPacket, 0, 1) ' get one byte
                        SerialString = Chr(InPacket(0)) ' get a single character/string/byte
                    End If
                End If
                If InPacket(0) = 21 Then
                    ErrorString = "NAK"
                    Exit Do ' got a ^U
                End If
                If SerialString <> "" Then
                    'LineOfText = SerialString
                    'Call TextLines(LineOfText) ' print it out unless it is a chr21
                End If
                Counter = Counter + 10
                Sleep(10) ' don't change this one - this is waiting for NAK
                Label1.Text = "Waiting for NAK to start" + Strings.Str(Counter) + "ms" ' display in milliseconds
                System.Windows.Forms.Application.DoEvents() ' update the label1 message
                ' add a counter and timeout if nothing
                If Counter > 5000 Then
                    ErrorString = "Bypass wait for NAK - xmodem failed"
                    Exit Do
                End If
                If ErrorString <> "" Then Exit Do
            Loop
            Label1.Text = ErrorString
            System.Windows.Forms.Application.DoEvents() ' update the label1 message
            ' bug with vb.net - strings don't go to 255 so have to send data as bytes
            Do
                ' act on each byte in the buffer array here
                Sleep(1) ' 60 for 4800 but 1 working for 38400
                XOut(0) = 1 'SOH ^A
                XOut(1) = Packetnumber
                OnesComplement = 255 - Packetnumber
                XOut(2) = OnesComplement
                Packetnumber = Packetnumber + 1
                If Packetnumber > 255 Then Packetnumber = Packetnumber - 256
                Checksum = 0
                For i = 0 To 127 ' get 128 bytes from file
                    If BinaryFileCounter <= BinaryFileLength Then
                        ByteRead = br.ReadByte ' get a byte
                    Else
                        ByteRead = 26 ' pad with char 26 = hex 1A because hyperterm does this ? why but it works
                    End If
                    XOut(i + 3) = ByteRead
                    Checksum = Checksum + ByteRead
                    BinaryFileCounter = BinaryFileCounter + 1
                Next
                ' create checksum
                Do
                    If Checksum < 256 Then Exit Do ' work out checksum
                    Checksum = Checksum - 256
                Loop
                XOut(131) = Checksum
                Call OutputXout()
                System.Windows.Forms.Application.DoEvents() ' update the label
                Do
                    k = 0
                    Do
                        Sleep(1) '80 for 4800  wait for the acknowledge which is a character 6 delay of 80 only occasionally loops so k>0
                        If SerialPortFound = True Then
                            j = SerialPortName.BytesToRead
                        End If
                        If j >= 1 Then
                            If SerialPortFound = True Then
                                SerialPortName.Read(InPacket, 0, 1) ' get one byte
                            End If
                            Exit Do
                        End If
                        k = k + 1
                        If k > 700 Then
                            InPacket(0) = 0 ' for below error testing
                            Exit Do
                        End If
                    Loop
                    If InPacket(0) = 6 Then Exit Do ' board got the packet
                    If InPacket(0) = 21 Or InPacket(0) = 0 Then
                        ' didn't get it so try sending again
                        ErrorCounter = ErrorCounter + 1
                        Call OutputXoutSlow() ' send the next one slowly
                        If InPacket(0) = 0 Then
                            Label3.Text = "Timeout waiting for Ack"
                            ErrorCounter = 20 'force an exit now
                            System.Windows.Forms.Application.DoEvents() ' update the label
                        Else
                            Label3.Text = "Nak: " + Strings.Str(ErrorCounter)
                            System.Windows.Forms.Application.DoEvents() ' update the label
                        End If
                    End If
                    If ErrorCounter >= 5 Then Exit Do ' standard xmodem is 10 but make this 5 as kyedos is 5 as well
                Loop
                If ErrorCounter >= 5 Then
                    Label1.Text = "5 or more errors - aborting"
                    Label2.Text = "0%"
                    OutPacket(0) = 24 ' send a ^X cancel
                    If SerialPortFound = True Then
                        SerialPortName.Write(OutPacket, 0, 1) ' send 1 byte
                        OutPacket(0) = 3 ' send a ^C
                        SerialPortName.Write(OutPacket, 0, 1) ' send 1 byte
                    End If
                    Exit Do
                End If
                If BinaryFileCounter > BinaryFileLength Then Exit Do ' finish up
                Label1.Text = "Sent packet: " + Strings.Str(Packetnumber) + " = OK"
                Percent = BinaryFileCounter / BinaryFileLength
                Percent = Percent * 100
                Percent = Int(Percent)
                Label2.Text = Strings.Str(Percent) + "%"
                ProgressBar1.Value = Percent
            Loop
            If ErrorCounter < 10 Then
                Sleep(1) ' tiny delay
                OutPacket(0) = 4 ' finish character
                If SerialPortFound = True Then
                    SerialPortName.Write(OutPacket, 0, 1) ' send 1 byte
                End If
                Label2.Text = "100%"
                Label1.Text = "Finished"
                ProgressBar1.Value = 0 'done
            End If
            Input.Close()
            System.Windows.Forms.Application.DoEvents() ' update the labels
        Catch ex As Exception
            Close()
            Label1.Text = Filenamepath + " not found"
            System.Windows.Forms.Application.DoEvents() ' update the labels
            Sleep(1000) ' so time to read message
        End Try
        Label3.Text = ""
    End Sub
    Private Sub Download_C()
        Dim filename1 As String
        Dim filename_noextension As String
        Dim LineOfText As String
        Dim i As Integer
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        'MsgBox("Compiled")
        ' send the file
        'TabControl1.SelectedIndex = 0 ' display kyedos
        'TextBox3.Focus() 'display to kyedos
        ' rename .binary to .bin
        Try
            Kill("C:\Program Files\Catalina\Demos\" + filename_noextension + ".bin")
        Catch ex As Exception ' file didn't exist
        End Try
        Try
            Rename("C:\Program Files\Catalina\Demos\" + filename_noextension + ".binary", "C:\Program Files\Catalina\Demos\" + filename_noextension + ".bin")
            'TimerOff()
            SerialPortName.Open()
            SerialPortName.BaudRate = Baud ' current baud rate
            Call XmodemSendKyeDOS("C:\Program Files\Catalina\Demos\" + filename_noextension + ".bin")
            SerialPortName.Close()
            SerialPortName.BaudRate = Baud ' reopen at 115200 or whatever the default rate is
            SerialPortName.Open() ' open at 38400
            'TimerOn()
            LineOfText = "Spin Catlyst2.bin" + vbCr ' run the serial version of catalyst
            Call StringToPacket(LineOfText)
            Label1.Text = LineOfText
            System.Windows.Forms.Application.DoEvents() ' display on screen
            'The baud rate you are fiddling with is (as the comment implies) the loader baud rate. The baud rate you need to change to affect the PC HMI option are the ones in:
            'Catalina_PC_Text.spin()
            'Catalina_PC_Keyboard.spin()
            'Catalina_PC_Mouse.spin()
            ' and recompile with    build_all DRACBLADE              <-- to use local VGA and keyboard
            'or
            'build_all DRACBLADE PC VT100     <-- to use PC terminal emulator
            ' local version is catlyst1.bin and serial version is catlyst2.bin
            Sleep(2000) ' delay while catalyst starts up
            Label1.Text = "Talking to Catalyst at 38400 baud"
            System.Windows.Forms.Application.DoEvents() ' display on screen
            SerialPortName.Close() ' close
            SerialPortName.BaudRate = 38400 ' catlyst2 talks at 38400 baud
            SerialPortName.Open()
            For i = 1 To 3
                System.Windows.Forms.Application.DoEvents() ' update the label1 message
                Sleep(1000) ' wait for reboot approx 5 seconds
            Next i
            LineOfText = UCase(filename_noextension) + vbCr ' and run the program
            Call StringToPacket(LineOfText) ' talk to catalyst and run this program
            Label1.Text = "Run program " + LineOfText ' display the command on the screen
            System.Windows.Forms.Application.DoEvents() ' display on screen
            SerialPortName.Close()
            Sleep(2000)
            Label1.Text = "Finished"
        Catch ex As Exception
            MsgBox("Compile error, check batch file for error message(s)")
            SerialPortName.Close()
        End Try
    End Sub
    Sub StringToPacket(ByVal lineoftext As String)
        ' send a string out, but don't use for data as numbers like 255 don't work
        ' also don't go over 30 (CPM commands never would be)
        Dim i As Byte
        Dim PacketLength As Byte
        Dim TypematicDelay As Integer
        Dim Character As String
        PacketLength = Strings.Len(lineoftext)
        'TypematicDelay = 10 ' anything under 50 misses characters on MPM
        ' seems to be more reliable with timer off (Sept 2010)
        ' 120 for 4800 baud don't go too short otherwise errors, errors at 60 for instance at 4800
        ' errors below 10 at 38400 baud
        ' needs 60 to send and 60 to get character back, so slow but it works
        ' comment - for some reason at wired 38400 we need the slow speed yet can send out as a whole string for radio at 1200?
        Sleep(TypematicDelay) ' typematic delay - depends on clock as much as baud rate
        For i = 1 To PacketLength
            OutPacket(0) = Strings.Asc(Strings.Mid(lineoftext, i, 1))
            If SerialPortFound = True Then
                SerialPortName.Write(OutPacket, 0, 1)
            End If
            'Sleep(TypematicDelay)
            ClearInputBuffer() ' gobble up return bytes
            System.Windows.Forms.Application.DoEvents() ' update the display
        Next
        Sleep(10)
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub
    Sub ClearInputBuffer()
        ' eg for running pip no need to display all the background information
        Dim BytesToRead As Integer
        Dim i As Integer
        Dim Character As String
        If SerialPortFound = True Then
            Do
                If SerialPortName.BytesToRead = 0 Then Exit Do ' no more bytes
                BytesToRead = SerialPortName.BytesToRead
                If BytesToRead > 2000 Then BytesToRead = 2000
                SerialPortName.Read(InPacket, 0, BytesToRead) ' read in a packet
                For i = 1 To BytesToRead
                    Character = Strings.Chr(InPacket(i - 1))
                    'Call DisplayCharacter(Character)
                Next i
            Loop
        End If
        'Call RedrawDisplay()
        System.Windows.Forms.Application.DoEvents() ' update the display
    End Sub
    Sub Get_CPM_Filename(ByRef Filenamepath As String, ByRef CPMFilename As String)
        ' send as byref to get the answer back
        ' pass c:\n8vem\mbasic\bascom.com and returns bascom.com
        ' start at the end and look for a \ character
        Dim i As Integer
        i = Strings.Len(Filenamepath)
        Do
            If Strings.Mid(Filenamepath, i, 1) = "\" Then Exit Do
            i = i - 1
        Loop
        CPMFilename = Strings.Mid(Filenamepath, i + 1)
    End Sub
    Sub OutputXout() ' uses xout() array and sends it out in pieces of 30 bytes
        ' in a subroutine so resends are easier - passing subroutine fills up the bytes
        ' 1. an SOH byte                             {1 byte}
        ' 2. the packet number                       {1 byte}
        ' 3:      .the(1) 's complement of the packet number {1 byte}
        ' 4. the packet                            {128 bytes}
        ' 5. the checksum                            {1 byte}

        'The following terms are simply ascii codes:
        'SOH = chr(1)  = CTRL-A =
        'EOT = chr(4)  = CTRL-D = End of Transmission
        'ACK = chr(6)  = CTRL-F = Positive Acknowledgement
        'NAK = chr(21) = CTRL-U = Negative Acknowledgement
        'CAN = Chr(24) = CTRL - X = Cancel
        'The packet number sent is simply the number of the packet.  If the packet
        'number is greater than 255, then subtract 256 repeatly until the number is
        'between 0 and 255.  For example, if you were sending packet 731, then you
        'would send 731 - 256 - 256 = 219.
        'The(1) 's complement of a byte (to make life easy) is simply 255 minus the
        'byte.  For example, if you had to take the 1's complement of 142, the answer
        'would be 255 - 142 = 133.

        'The checksum is the value of all the bytes in the packet added together.  For
        'example, if the first five bytes were 45, 12, 64, 236, 173 and the other 123
        'bytes were zeroes, the checksum would be 45+12+64+236+173+0+0+...+0 = 530.
        'However, to make each block one byte smaller, they repeatly subtract 256
        'from the checksum until it is between 0 and 255.  In this case, the checksum
        'would be 530 - 256 - 256 = 18.
        'The(downloader)

        '1. ensures that the packet number sent matches the actual packet number
        'that it is (If the third block send has a '4' as the second byte,
        'something is wrong --> CANCEL TRANSFER (send CAN byte))
        '2. adds the packet number and the 1's complement of it together to make
        'sure that they add up to 255.  if they don't --> CANCEL TRANSFER
        '3. adds up all the bytes in the packet together --> THE SUM
        '4. compares the last two significant digits of THE SUM with the checksum
        '5. if everything looks ok (sum=checksum), then the downloader appends the
        'bytes in the packet to the file being created (sent).  The down-
        'loader then sends an ACK byte which tells the uploader to send the
        'next block.
        'if the sums do not match then the downloader sends an NAK byte which
        'tells the uploader to send the same block it just sent over again.

        ' send in blocks of 30 bytes to keep the Hope module happy
        ' removed the 30 byte block for the moment, hope modules go via boards not pc to board
        Dim i As Integer
        For i = 0 To 131
            OutPacket(i) = XOut(i)
        Next
        If SerialPortFound = True Then
            SerialPortName.Write(OutPacket, 0, 132)
        End If
        ' very slow code to catch bugs etc

        'Dim lineoftext As String
        'For i = 0 To 131
        ' OutPacket(0) = XOut(i)
        ' SerialPortname.Write(OutPacket, 0, 1)
        ' lineoftext = Chr(XOut(i)) ' + "  " + Str(XOut(i))
        ' Call DisplayCharacter(lineoftext)
        ' Call RedrawDisplay()
        ' System.Windows.Forms.Application.DoEvents()
        ' Sleep(100)
        ' Next

    End Sub
    Sub OutputXoutSlow()
        ' for MPM as overruns the 64 byte simh buffer if too fast
        Dim i As Integer
        Dim c As Integer
        'Dim lineoftext As String
        c = 0
        For i = 0 To 131
            OutPacket(0) = XOut(i)
            SerialPortName.Write(OutPacket, 0, 1)
            'lineoftext = Chr(XOut(i)) ' + "  " + Str(XOut(i))
            'Call DisplayCharacter(lineoftext)
            'Call RedrawDisplay()
            System.Windows.Forms.Application.DoEvents()
            c += 1
            If c > 50 Then
                c = 0
                Sleep(30) ' catchup time for MPM to process the SIMH 64 byte buffer
            End If
        Next
    End Sub
    Sub TestComPort()
        MsgBox("Com port " + ComPort + " Baud " + Baud + " trying to open...")
        Try
            SerialPortName.PortName = ComPort
            SerialPortName.BaudRate = Baud '38400
            SerialPortName.Parity = IO.Ports.Parity.None ' no parity
            SerialPortName.DataBits = 8 ' 8 bits
            SerialPortName.StopBits = IO.Ports.StopBits.One ' one stop bit
            SerialPortName.Open()
            SerialPortName.Close()
            MsgBox("Success")
        Catch ex As Exception
            MsgBox("Fail")
        End Try
    End Sub
    Sub PortsAvailable()
        Dim ports As String() = SerialPort.GetPortNames()
        Dim PortsAvailable As String
        ' Display each port name to the console.
        Dim port As String
        For Each port In ports
            PortsAvailable += port + " "
        Next port
        MsgBox(PortsAvailable)
    End Sub
    Private Sub AvailablePortsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        PortsAvailable()
    End Sub

    Private Sub CompileDownloadRunPayloadToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompileDownloadRunPayloadToolStripMenuItem.Click
        Dim Location As New Process
        Dim filename1 As String
        Dim filename_noextension As String
        Dim LineOfText As String
        Dim PortNumber As String
        Dim CommandLine As String
        CompilePause = False ' assumes program has been debugged
        PortNumber = Strings.Right(ComPort, 1)
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        SaveCatalina()
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long. Suggest renaming file")
        End If
        If XMM = "TRUE" Then MsgBox("Change View/Settings and disable XMM to run small LMM programs")
        ' create a batch file in the demo folder
        'PrintLine(1, "catalina -lcx -x5 -M 128k -D DRACBLADE -D HIRES_VGA " + CatalinaFile)
        If XMM = "TRUE" Then
            CommandLine = "catalina -lcx -x5 -M " + MemSize + "k -D DRACBLADE -D " + VGAMode + " " + CatalinaFile
        Else
            CommandLine = "catalina -lc -D DEMO -D " + VGAMode + " " + CatalinaFile
        End If
        FileOpen(1, "C:\Program Files\Catalina\Demos\drac.bat", OpenMode.Output)
        PrintLine(1, "@echo off")
        PrintLine(1, "echo.")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo    SETTING UP CATALINA")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo.")
        PrintLine(1, "PATH=C:\Program Files\Catalina\bin;%PATH%")
        PrintLine(1, "Call catalina_env.bat()")
        PrintLine(1, CommandLine) ' see above
        PrintLine(1, "payload -b 115200 -p " + PortNumber + " " + filename_noextension)
        'PrintLine(1, "pause")
        FileClose(1)
        Location.StartInfo.FileName = "drac.bat"
        Location.StartInfo.WorkingDirectory = "C:\Program Files\Catalina\Demos"
        Location.Start() ' shell the startup file
    End Sub

    Sub SaveINI()
        SettingsTabSave() ' update the screen
        ' go through all the check boxes and update the variables

        FileOpen(1, "C:\Program Files\Catalina\Settings.INI", OpenMode.Output) ' open a file
        PrintLine(1, VGAMode)
        PrintLine(1, MemSize)
        PrintLine(1, XMM)
        PrintLine(1, ComPort)
        PrintLine(1, Baud)
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        PrintLine(1, "Spare")
        FileClose(1)
    End Sub
    Sub LoadINI()
        Dim LineofText As String
        Try
            FileOpen(1, "C:\Program Files\Catalina\Settings.INI", OpenMode.Input) ' open a file
            VGAMode = LineInput(1)
            MemSize = LineInput(1)
            XMM = LineInput(1)
            ComPort = LineInput(1)
            Baud = LineInput(1)
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            LineofText = LineInput(1) ' spare
            FileClose(1)
        Catch ex As Exception
            FileClose(1)
            Call SaveINI() ' start a new file
        End Try
        SettingsTabLoad() ' update the settings tab
    End Sub
    Sub SettingsTabLoad()
        ' take settings variables and update the check boxes etc
        Dim ports As String() = SerialPort.GetPortNames()
        ' Display each port name to the console.
        Dim port As String
        ComboBox1.Items.Clear()
        For Each port In ports
            ComboBox1.Items.Add(port)
        Next port
        ComboBox1.Text = ComPort ' com port
        If VGAMode = "HIRES_VGA" Then
            RadioButton3.Checked = True
        End If
        If VGAMode = "LORES_VGA" Then
            RadioButton2.Checked = True
        End If
        TextBox15.Text = MemSize ' memory size
        If XMM = "FALSE" Then CheckBox2.Checked = False Else CheckBox2.Checked = True
        If Baud = "19200" Then RadioButton6.Checked = True
        If Baud = "38400" Then RadioButton4.Checked = True
        If Baud = "115200" Then RadioButton5.Checked = True
    End Sub
    Sub SettingsTabSave()
        ' take check boxes etc and change to public variables
        If RadioButton3.Checked = True Then VGAMode = "HIRES_VGA"
        If RadioButton2.Checked = True Then VGAMode = "LORES_VGA"
        MemSize = TextBox15.Text
        If CheckBox2.Checked = False Then XMM = "FALSE" Else XMM = "TRUE"
        ComPort = ComboBox1.Text
        If RadioButton6.Checked = True Then Baud = 19200
        If RadioButton4.Checked = True Then Baud = 38400
        If RadioButton5.Checked = True Then Baud = 115200
    End Sub
    Private Sub SaveSettingsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        SaveINI()
    End Sub

    Private Sub LoadDemoToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim Location As New Process
        ' start the spin part in the proptool
        Location.StartInfo.FileName = "Catalina_Plugin.spin"
        Location.StartInfo.WorkingDirectory = "C:\Program Files\Catalina\plugins\custom"
        Location.Start() ' shell the startup file
        ' load the demo
        CatalinaFile = "generic_plugin.c"
        RichTextBox1.LoadFile("C:\Program Files\Catalina\Plugins\custom_demo\" + CatalinaFile, RichTextBoxStreamType.PlainText)
    End Sub
    ' ************* Mouse Events on TabPage2********************
    'We can handle mouse events such as mouse pointer movements in Forms. The mouse events supported by VB .NET are as follows:
    'MouseDown: This event happens when the mouse pointer is over the form/control and is pressed
    'MouseEnter: This event happens when the mouse pointer enters the form/control
    'MouseUp: This event happens when the mouse pointer is over the form/control and the mouse button is released
    'MouseLeave: This event happens when the mouse pointer leaves the form/control
    'MouseMove: This event happens when the mouse pointer is moved over the form/control
    'MouseWheel: This event happens when the mouse wheel moves while the form/control has focus
    'MouseHover: This event happens when the mouse pointer hovers over the form/control
    'The properties of the MouseEventArgs objects that can be passed to the mouse event handler are as follows:
    'Button: Specifies that the mouse button was pressed
    'Clicks: Specifies number of times the mouse button is pressed and released
    'X: The X-coordinate of the mouse click
    'Y: The Y-coordinate of the mouse click
    'Delta: Specifies a count of the number of detents (rotation of mouse wheel) the mouse wheel has rotated 
    'Private Sub TabPage2_Click(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TabPage2.Click
    Private Sub GroupBox1_MouseDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles GroupBox1.MouseDown
        If e.Button = MouseButtons.Left Then
            Select Case MouseGUI
                Case "Button"
                    Button1.Location = New Point(e.X, e.Y)
                    CancelDrawing()
            End Select
        End If
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        ' drawing mode = button
        MouseGUI = "Button"
        Me.Cursor = Cursors.Cross ' change mouse cursor
        Button1.Visible = True
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        CancelDrawing()
    End Sub
    Sub CancelDrawing()
        ' cancel drawing mode
        MouseGUI = "Default"
        Me.Cursor = Cursors.Default
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        ' shrink width
        Button1.Size = New Size(Button1.Width - 5, Button1.Height)
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        ' increase width
        Button1.Size = New Size(Button1.Width + 5, Button1.Height)
    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click
        ' shrink height
        Button1.Size = New Size(Button1.Width, Button1.Height - 5)
    End Sub

    Private Sub Button9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button9.Click
        ' increase height
        Button1.Size = New Size(Button1.Width, Button1.Height + 5)
    End Sub

    Private Sub TextBox2_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox2.TextChanged
        Button1.Text = TextBox2.Text
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Button1.Visible = False
        CancelDrawing()
    End Sub
    Sub PictureBoxTest()
        ' Dim PixelValue As Color
        'Dim RedByte As Byte
        'Dim GreenByte As Byte
        'Dim BlueByte As Byte
        '    PictureBox2.Image = New System.Drawing.Bitmap("c:\tweety.bmp")
        'Dim MyBitmap As New System.Drawing.Bitmap(PictureBox2.Image) 'image from picture box
        '    PixelValue = MyBitmap.GetPixel(25, 20) ' get the value of pixel at 25,20
        '    RedByte = PixelValue.R
        '    GreenByte = PixelValue.G
        '    BlueByte = PixelValue.B
        'MsgBox(Strings.Str(RedByte) + Strings.Str(GreenByte) + Strings.Str(BlueByte)) ' display
        '' change some pixels - mygraphics has all the useful drawing things, lines boxes circles etc
        'Dim red As Integer = 0
        'Dim white As Integer = 11
        'Dim MyGraphics As Graphics = Graphics.FromImage(MyBitmap)
        'While white <= 100
        ' MyGraphics.FillRectangle(Brushes.Red, 0, red, 20, 10)
        ' MyGraphics.FillRectangle(Brushes.White, 0, white, 30, 10)
        ' red += 2
        ' white += 2
        ' End While
        '    MyBitmap.SetPixel(10, 10, System.Drawing.Color.Black) ' change a pixel in array
        ' save back to the picturebox
        '    PictureBox2.Image = MyBitmap
        ' save the picturebox as a new file
        '    PictureBox2.Image.Save("C:\Newfile.bmp", System.Drawing.Imaging.ImageFormat.Bmp)
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        Dim sizex As Integer
        Dim sizey As Integer
        Dim PixelValue As Color
        sizex = 256 - 1 ' baggers screen is 256x240
        sizey = 240 - 1
        Dim PixelArray(sizex, sizey, 3) As Byte ' R,G,B and calculated prop byte so 4 values
        Dim x, y, i As Integer
        Dim Propbyte As Byte
        Dim TileArray(1920 - 1) As String ' Up to 1920 tiles though this is more than hub ram
        Dim TileMap(1920 - 1) As Integer ' each entry is 2 bytes
        Dim OutputArray(30000) As Byte ' use for both tilearray and tilemap, can never be more than hub ram
        Dim TileX, TileY As Integer
        Dim TileString As String
        Dim HexString As String
        Dim t, TileCounter As Integer
        Dim TileMapCounter As Integer
        Dim TileExists As Integer
        Dim lsb, msb As Byte
        Dim Sourcefile As String
        Dim DestinationFile As String
        Sourcefile = TextBox4.Text + TextBox3.Text
        ' this little bit of code replaces new sytem.drawing.bitmap as the latter leaves the file locked eg so paintshop can't save a new file
        Dim img As Image
        Dim fs As New FileStream(Sourcefile, IO.FileMode.Open)
        img = Image.FromStream(fs)
        fs.Close()
        PictureBox3.Image = img
        'PictureBox3.Image = New System.Drawing.Bitmap(Sourcefile) ' load picture
        Dim MyBitmap As New System.Drawing.Bitmap(PictureBox3.Image) 'image from picture box
        For y = 0 To sizey
            For x = 0 To sizex
                PixelValue = MyBitmap.GetPixel(x, y) ' get the color
                PixelArray(x, y, 0) = PixelValue.R ' red byte
                PixelArray(x, y, 1) = PixelValue.G ' green byte
                PixelArray(x, y, 2) = PixelValue.B ' blue byte
                PixelArray(x, y, 3) = 3 ' pre fill the prop byte with %00000011 for Baggers tiles
            Next
        Next
        ' create the propeller color byte
        For y = 0 To sizey
            For x = 0 To sizex
                For i = 0 To 2
                    ConvertColor(PixelArray(x, y, i), Propbyte) ' get the value 0-3
                    Select Case i
                        Case 0 : Propbyte = Propbyte * 64 ' shift to red position
                        Case 1 : Propbyte = Propbyte * 16 ' shift to green position
                        Case 2 : Propbyte = Propbyte * 4 ' shift to blue position
                    End Select
                    PixelArray(x, y, 3) = PixelArray(x, y, 3) + Propbyte ' add to existing color
                Next i
            Next x
        Next y
        'PictureBox3.Image = MyBitmap ' bitmap array to picturebox - need to convert pixelarray back to mybitmap to show the decreased color depth 
        ' now create the tiles and the map using the pixelarray data in dimension 3
        TileCounter = 0
        TileMapCounter = 0
        For TileY = 0 To 29 ' 30 rows of tiles
            For TileX = 0 To 63 ' 64 columns of tiles
                TileString = ""
                For y = TileY * 8 To TileY * 8 + 7
                    For x = TileX * 4 To TileX * 4 + 3
                        NumberToHex(PixelArray(x, y, 3), HexString) ' get the hex value
                        TileString = TileString + HexString ' add to the tilestring
                    Next x
                Next y
                ' does this tile exist already?
                TileExists = -1
                For t = 0 To TileCounter
                    If TileString = TileArray(t) Then TileExists = t ' found a match
                Next t
                If TileExists = -1 Then
                    ' no match so add as a new tile
                    TileArray(TileCounter) = TileString ' add to tile array
                    TileMap(TileMapCounter) = TileCounter ' add this to the map
                    TileCounter = TileCounter + 1 ' and add one to tile array counter
                    TileMapCounter = TileMapCounter + 1 ' and increment map counter
                Else
                    ' found a match at Tileexists so no need to add this tile
                    ' add this to the map, and increment the map
                    TileMap(TileMapCounter) = TileExists
                    TileMapCounter = TileMapCounter + 1
                End If
            Next TileX
        Next TileY
        ' now turn these arrays into binary files
        ' the map file is two bytes, lsb first

        t = 0
        For i = 0 To 1920 - 1
            IntegerToBytes(TileMap(i), msb, lsb)
            OutputArray(t) = lsb
            t += 1
            OutputArray(t) = msb
            t += 1
        Next
        DestinationFile = TextBox4.Text + TextBox6.Text
        Dim OutputMap As New FileStream(DestinationFile, FileMode.Create, FileAccess.Write)
        OutputMap.Write(OutputArray, 0, 3840)
        OutputMap.Close()
        ' and now the tiles
        t = 0
        For i = 0 To TileCounter - 1
            For x = 0 To 31 ' number of bytes in each tile
                OutputArray(t) = Val("&H" + Strings.Mid(TileArray(i), x * 2 + 1, 2))
                t += 1
            Next
        Next
        DestinationFile = TextBox4.Text + TextBox5.Text
        Dim OutputTile As New FileStream(DestinationFile, FileMode.Create, FileAccess.Write)
        OutputTile.Write(OutputArray, 0, TileCounter * 32) ' if tilecounter=1 then 32 bytes
        OutputTile.Close()
        ' display the file size
        Label13.Text = "Tile size (bytes) = " + Strings.Str(TileCounter * 32)
    End Sub
    Private Sub ConvertColor(ByVal Bytevalue As Byte, ByRef Returnvalue As Byte)
        ' takes a number 0 to 255 and changes to the nearest propeller color
        ' prop colors are 00,01,10,11
        ' so 0-63 is 00, 64-127 is 01, 128 to 191 is 10 and 192 to 255 is 11
        ' this is the same as dividing by 64 but do it this way in case later
        ' need to tweak the values
        ' experiments with bias at either end of the scale - so centres on 85, 170
        Select Case Bytevalue
            Case 0 To 42
                Returnvalue = 0 ' 0
            Case 43 To 127
                Returnvalue = 1 ' 85
            Case 128 To 212
                Returnvalue = 2 ' 170
            Case 213 To 255
                Returnvalue = 3 ' 255
        End Select
    End Sub
    Sub NumberToHex(ByRef N As Integer, ByRef Hexstring As String)
        ' 0 to 255 and returns 00 to FF
        Hexstring = Strings.Hex(N)
        Hexstring = Trim(Hexstring)
        If N < 16 Then Hexstring = "0" + Hexstring
    End Sub
    Sub IntegerToBytes(ByRef N As Integer, ByRef msb As Byte, ByRef lsb As Byte)
        Dim hexstring As String ' there is a way with mod and integer division as well
        hexstring = Strings.Hex(N)
        hexstring = Trim(hexstring)
        hexstring = "0000" + hexstring
        hexstring = Strings.Right(hexstring, 4)
        msb = Val("&H" + Strings.Left(hexstring, 2))
        lsb = Val("&H" + Strings.Right(hexstring, 2))
    End Sub

    Private Sub TextBox3_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox3.TextChanged
        If Strings.Len(TextBox3.Text) > 4 Then
            TextBox5.Text = Strings.Left(TextBox3.Text, Strings.Len(TextBox3.Text) - 4) + ".chr"
            TextBox6.Text = Strings.Left(TextBox3.Text, Strings.Len(TextBox3.Text) - 4) + ".map"
        End If
    End Sub

    Private Sub TextBox8_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox8.TextChanged
        If Strings.Len(TextBox8.Text) > 4 Then
            TextBox9.Text = Strings.Left(TextBox8.Text, Strings.Len(TextBox8.Text) - 4) + ".vga"
        End If
        If Strings.Len(TextBox9.Text) > 12 Then MsgBox("File name cannot be more than 8 characters (8.3 format)")
    End Sub

    Private Sub Button10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button10.Click
        Dim sizex As Integer
        Dim sizey As Integer
        Dim PixelValue As Color
        sizex = 160 - 1 ' kye screen is 160x120
        sizey = 120 - 1
        Dim PixelArray(sizex, sizey, 3) As Byte ' R,G,B and calculated prop byte so 4 values
        Dim x, y, i As Integer
        Dim Propbyte As Byte
        Dim OutputArray(20000) As Byte
        Dim t As Integer
        Dim Sourcefile As String
        Dim DestinationFile As String
        Sourcefile = TextBox7.Text + TextBox8.Text
        ' this little bit of code replaces new sytem.drawing.bitmap as the latter leaves the file locked eg so paintshop can't save a new file
        Dim img As Image
        Dim fs As New FileStream(Sourcefile, IO.FileMode.Open)
        img = Image.FromStream(fs)
        fs.Close()
        PictureBox2.Image = img
        Dim MyBitmap As New System.Drawing.Bitmap(PictureBox2.Image) 'image from picture box
        For y = 0 To sizey
            For x = 0 To sizex
                PixelValue = MyBitmap.GetPixel(x, y) ' get the color
                PixelArray(x, y, 0) = PixelValue.R ' red byte
                PixelArray(x, y, 1) = PixelValue.G ' green byte
                PixelArray(x, y, 2) = PixelValue.B ' blue byte
                PixelArray(x, y, 3) = 0 ' pre fill the prop byte with %00000000 for Kye's code
            Next
        Next
        ' create the propeller color byte
        For y = 0 To sizey
            For x = 0 To sizex
                For i = 0 To 2
                    ConvertColor(PixelArray(x, y, i), Propbyte) ' get the value 0-3
                    Select Case i
                        Case 0 : Propbyte = Propbyte * 64 ' shift to red position
                        Case 1 : Propbyte = Propbyte * 16 ' shift to green position
                        Case 2 : Propbyte = Propbyte * 4 ' shift to blue position
                    End Select
                    PixelArray(x, y, 3) = PixelArray(x, y, 3) + Propbyte ' add to existing color
                Next i
            Next x
        Next y
        'PictureBox3.Image = MyBitmap ' bitmap array to picturebox - need to convert pixelarray back to mybitmap to show the decreased color depth 
        ' now turn the pixelarray x,y,3 into a binary file
        t = 0
        For y = 0 To sizey
            For x = 0 To sizex
                OutputArray(t) = PixelArray(x, y, 3) ' move to output array
                t += 1
            Next
        Next
        DestinationFile = TextBox7.Text + TextBox9.Text
        Dim OutputVGA As New FileStream(DestinationFile, FileMode.Create, FileAccess.Write)
        OutputVGA.Write(OutputArray, 0, 19200) ' save 19200 bytes
        OutputVGA.Close()
    End Sub

    Private Sub Button11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button11.Click
        Dim sizex As Integer
        Dim sizey As Integer
        Dim PixelValue As Color
        sizex = 160 - 1 ' kye screen is 160x120
        sizey = 120 - 1
        Dim PixelArray(sizex, sizey, 3) As Byte ' R,G,B and calculated prop byte so 4 values
        Dim x, y, i As Integer
        Dim Propbyte As Byte
        Dim OutputArray(20000) As Byte
        Dim t As Integer
        Dim Sourcefile As String
        Dim DestinationFile As String
        Dim StartNumber As Integer
        Dim FinishNumber As Integer
        Dim Filecounter As Integer
        Dim LineofText As String
        DestinationFile = TextBox10.Text + TextBox14.Text
        StartNumber = Strings.Val(TextBox12.Text)
        FinishNumber = Strings.Val(TextBox13.Text)
        Dim OutputVGA As New FileStream(DestinationFile, FileMode.Create, FileAccess.Write)
        For Filecounter = StartNumber To FinishNumber
            Sourcefile = TextBox10.Text + TextBox11.Text ' directory plus rootname
            ' add the right number of leading zeros, (AVS4YOU adds a different number based on how big the total file is)
            LineofText = Strings.Right("000000" + Trim(Strings.Str(Filecounter)), Strings.Len(TextBox12.Text)) ' convert to a string
            Label25.Text = LineofText
            Sourcefile += LineofText + ".bmp"
            ' this little bit of code replaces new sytem.drawing.bitmap as the latter leaves the file locked eg so paintshop can't save a new file
            Dim img As Image
            Dim fs As New FileStream(Sourcefile, IO.FileMode.Open)
            img = Image.FromStream(fs)
            fs.Close()
            ' display the image in the picture box
            PictureBox4.Image = img
            ' Get the source bitmap.
            Dim bm_source As New Bitmap(PictureBox4.Image)
            ' Make a bitmap for the result shrunk to 160x120
            Dim bm_dest As New Bitmap(CInt(160), CInt(120))
            ' Make a Graphics object for the result Bitmap.
            Dim gr_dest As Graphics = Graphics.FromImage(bm_dest)
            ' Copy the source image into the destination bitmap.
            gr_dest.DrawImage(bm_source, 0, 0, bm_dest.Width + 1, bm_dest.Height + 1)
            ' Display the result.
            PictureBox5.Image = bm_dest
            gr_dest.Dispose()
            Dim MyBitmap As New System.Drawing.Bitmap(PictureBox5.Image) 'image from picture box
            For y = 0 To sizey
                For x = 0 To sizex
                    PixelValue = MyBitmap.GetPixel(x, y) ' get the color
                    PixelArray(x, y, 0) = PixelValue.R ' red byte
                    PixelArray(x, y, 1) = PixelValue.G ' green byte
                    PixelArray(x, y, 2) = PixelValue.B ' blue byte
                    PixelArray(x, y, 3) = 0 ' pre fill the prop byte with %00000000 for Kye's code
                Next
            Next
            ' create the propeller color byte
            For y = 0 To sizey
                For x = 0 To sizex
                    For i = 0 To 2
                        ConvertColor(PixelArray(x, y, i), Propbyte) ' get the value 0-3
                        Select Case i
                            Case 0 : Propbyte = Propbyte * 64 ' shift to red position
                            Case 1 : Propbyte = Propbyte * 16 ' shift to green position
                            Case 2 : Propbyte = Propbyte * 4 ' shift to blue position
                        End Select
                        PixelArray(x, y, 3) = PixelArray(x, y, 3) + Propbyte ' add to existing color
                    Next i
                Next x
            Next y
            'PictureBox3.Image = MyBitmap ' bitmap array to picturebox - need to convert pixelarray back to mybitmap to show the decreased color depth 
            ' now turn the pixelarray x,y,3 into a binary file
            t = 0
            For y = 0 To sizey
                For x = 0 To sizex
                    OutputArray(t) = PixelArray(x, y, 3) ' move to output array
                    t += 1
                Next
            Next
            System.Windows.Forms.Application.DoEvents() ' update the display
            OutputVGA.Write(OutputArray, 0, 19200) ' save 19200 bytes
        Next Filecounter
        OutputVGA.Close()
    End Sub

    Private Sub SettingsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        TabControl1.SelectedIndex = 3 'settings
    End Sub
    Private Sub Button12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button12.Click
        SaveINI()
        PrintFileName()
    End Sub

    Private Sub Button13_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button13.Click
        TestComPort()
    End Sub

    Private Sub CutToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CutToolStripMenuItem.Click
        RichTextBox1.Cut()
    End Sub

    Private Sub CopyToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CopyToolStripMenuItem.Click
        RichTextBox1.Copy()
    End Sub

    Private Sub PasteToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteToolStripMenuItem.Click
        RichTextBox1.Paste()
    End Sub

    Private Sub SelectAllToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectAllToolStripMenuItem.Click
        RichTextBox1.SelectAll()
    End Sub

    Private Sub FindToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FindToolStripMenuItem.Click
        FindString = InputBox("String to find", "Find", FindString)
        RichTextBox1.Find(FindString)
        PlaceHolder = RichTextBox1.SelectionStart + 1
    End Sub

    Private Sub UndoToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UndoToolStripMenuItem.Click
        RichTextBox1.Undo()
    End Sub

    Private Sub RedoToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RedoToolStripMenuItem.Click
        RichTextBox1.Redo()
    End Sub

    Private Sub FindAgainToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FindAgainToolStripMenuItem.Click
        Dim x As Integer
        Dim opt As RichTextBoxFinds = 0
        x = RichTextBox1.Find(FindString, PlaceHolder, opt)
        PlaceHolder = RichTextBox1.SelectionStart + 1
        If x < 0 Then
            PlaceHolder = 0
            RichTextBox1.Find(FindString)
            PlaceHolder = RichTextBox1.SelectionStart + 1
        End If
    End Sub

    Private Sub BlackToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BlackToolStripMenuItem.Click
        RichTextBox1.Select(0, RichTextBox1.Text.Length)
        RichTextBox1.SelectionColor = Color.Black
        RichTextBox1.DeselectAll()
    End Sub

    Private Sub SettingsToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SettingsToolStripMenuItem.Click
        TabControl1.SelectedIndex = 0 ' display code
    End Sub

    Private Sub SettingsToolStripMenuItem1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SettingsToolStripMenuItem1.Click
        TabControl1.SelectedIndex = 3 ' display settings
    End Sub
    Private Sub IndentsToolStripMenuItem1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IndentsToolStripMenuItem1.Click
        Indents()
    End Sub

    Private Sub Indents()
        Dim TempString As String
        Dim i As Long
        Dim L As Long
        Dim Character As String
        Dim NextCharacter As String
        Dim Indent As Integer
        Dim LeadingSpace As Boolean
        Dim CommentCounter As Integer
        Dim StarSlash As Boolean
        Indent = 0
        TempString = ""
        Label3.Text = "Start Indents"
        System.Windows.Forms.Application.DoEvents() ' update the label
        L = Strings.Len(RichTextBox1.Text)
        ' add a carriage return at the end if the last line is }
        If Strings.Mid(RichTextBox1.Text, L, 1) = "}" Then
            RichTextBox1.Text += vbCr
            RichTextBox1.Text += vbLf
        End If
        L = Strings.Len(RichTextBox1.Text) ' update length
        ' remove tabs
        For i = 1 To L
            Character = Strings.Mid(RichTextBox1.Text, i, 1)
            If Character <> Strings.Chr(9) Then ' remove tabs
                TempString += Character
            End If
        Next
        RichTextBox1.Text = TempString
        ' purge all the previous indents (spaces)
        ' but only if not in a /* ... */ comment section
        LeadingSpace = False
        TempString = ""
        L = Strings.Len(RichTextBox1.Text)
        StarSlash = False
        For i = 1 To L
            ' is the text within a /* comment section?
            If i < L Then
                If Strings.Mid(RichTextBox1.Text, i, 2) = "/*" Then StarSlash = True ' start comment section
            End If
            If i > 1 Then
                If Strings.Mid(RichTextBox1.Text, i - 1, 2) = "*/" Then StarSlash = False ' end comment section
            End If
            ' now do the rest of the code
            Character = Strings.Mid(RichTextBox1.Text, i, 1)
            If Character = Strings.Chr(10) And StarSlash = False Then
                LeadingSpace = True
                TempString += Character ' add the linefeed
            End If
            If StarSlash = True Then LeadingSpace = False ' override leading space if within a comment
            If LeadingSpace = False Then
                TempString += Character ' add the character
            End If
            If LeadingSpace = True And Character <> Strings.Chr(10) Then
                If Character = " " Then
                    ' add nothing
                Else
                    LeadingSpace = False ' reset the leading space flag
                    TempString += Character ' and add this character
                End If
            End If
        Next
        RichTextBox1.Text = TempString
        ' now add new indents
        LeadingSpace = False
        TempString = ""
        L = Strings.Len(RichTextBox1.Text)
        For i = 1 To L
            Character = Strings.Mid(RichTextBox1.Text, i, 1)
            If i < L Then NextCharacter = Strings.Mid(RichTextBox1.Text, i + 1, 1)
            If Character = "{" Then Indent = Indent + 7
            If NextCharacter = "}" Then Indent = Indent - 7
            If Indent < 0 Then Indent = 0
            TempString += Character
            If Indent > 0 And Character = Strings.Chr(10) Then
                TempString += Strings.Space(Indent)
            End If
        Next
        RichTextBox1.Text = TempString
        ' put comments in the same column
        CommentCounter = 0
        TempString = ""
        L = Strings.Len(RichTextBox1.Text)
        For i = 1 To L - 1
            Character = Strings.Mid(RichTextBox1.Text, i, 1)
            If Character = Strings.Chr(10) Then CommentCounter = 0 ' reset counter when get a line feed
            If Character = "/" And Strings.Mid(RichTextBox1.Text, i + 1, 1) = "/" Then
                ' double //
                If CommentCounter < 70 Then
                    TempString += Strings.Space(70 - CommentCounter) ' add some spaces
                End If
            End If
            TempString += Character ' add the character
            CommentCounter += 1 ' add one to the comment counter
        Next
        TempString += Strings.Mid(RichTextBox1.Text, L, 1) ' add the last character
        RichTextBox1.Text = TempString
        RichTextBox1.Select(0, RichTextBox1.Text.Length)
        RichTextBox1.SelectionColor = Color.Black
        RichTextBox1.DeselectAll()
        Label3.Text = "Finish Indents"
        System.Windows.Forms.Application.DoEvents() ' update the label
    End Sub

    Private Sub PayloadXMMCompileDownloadRunToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PayloadXMMCompileDownloadRunToolStripMenuItem.Click
        PayloadCompile()
    End Sub
    Private Sub PayloadCompile()
        ' compile the program using Payload and XMM
        Dim Location As New Process
        Dim filename1 As String
        Dim filename2 As String
        Dim filename_noextension As String
        Dim batchcommand As String
        Dim LineOfText As String
        Dim CommandLine As String
        Dim PayloadLine As String
        SaveCatalina()
        filename1 = CatalinaFile
        filename_noextension = Strings.Left(filename1, Len(filename1) - 2)
        If Len(filename_noextension) > 8 Then
            MsgBox("Warning - filename is >8 characters long. Suggest renaming file")
        End If
        ' create a batch file in the demo folder
        If XMM = "TRUE" Then
            CommandLine = "catalina -lcx -x5 -M " + MemSize + "k -D DRACBLADE -D " + VGAMode + " " + CatalinaFile
        Else
            MsgBox("Only works for XMM programs - see the Settings tab")
        End If
        PayloadLine = "Payload XMM " + filename_noextension ' loads xmm.binary then new.binary
        ' note - need to copy XMM.BINARY from utilities to demos folder
        FileOpen(1, "C:\Program Files\Catalina\Demos\drac.bat", OpenMode.Output)
        PrintLine(1, "@echo off")
        PrintLine(1, "echo.")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo    SETTING UP CATALINA")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo.")
        PrintLine(1, "PATH=C:\Program Files\Catalina\bin;%PATH%")
        PrintLine(1, "Call catalina_env.bat()")
        PrintLine(1, "echo " + CommandLine)
        PrintLine(1, CommandLine) ' see above
        PrintLine(1, "echo ***Make sure XMM.BINARY is copied from Utilities to Demos folder***")
        PrintLine(1, "echo " + PayloadLine)
        PrintLine(1, PayloadLine)
        'If CompilePause = True Then
        'PrintLine(1, "pause") ' leaves batch file window open so can see errors
        'End If
        FileClose(1)
        ' compile the program
        Location.StartInfo.FileName = "drac.bat"
        Location.StartInfo.WorkingDirectory = "C:\Program Files\Catalina\Demos"
        Location.Start() ' shell the startup file
        Do
            ' wait till batch file finishes
        Loop Until Location.HasExited = True
    End Sub

    Private Sub Button14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button14.Click
        RichTextBox3.Text = ""
        RichTextBox3.AppendText("CON" + vbCrLf)
        RichTextBox3.AppendText("  _clkfreq = 80_000_000" + vbCrLf)
        RichTextBox3.AppendText("  _clkmode = xtal1 + pll16x" + vbCrLf)
        RichTextBox3.AppendText(vbCrLf)
        RichTextBox3.AppendText("PUB Main" + vbCrLf)
        RichTextBox3.AppendText("    coginit(1,@cogstart,0)  ' cog 1, cogstart, dummy value" + vbCrLf)
        RichTextBox3.AppendText(vbCrLf)
        RichTextBox3.AppendText("DAT" + vbCrLf)
        RichTextBox3.AppendText("                  org 0" + vbCrLf)
        RichTextBox3.AppendText("cogstart          wrbyte  testvalue, testvariable ' test value A" + vbCrLf)
        RichTextBox3.AppendText("                  jmp #cogstart" + vbCrLf)
        RichTextBox3.AppendText(vbCrLf)
        RichTextBox3.AppendText("testvariable      long    5000           ' test memory location 5000" + vbCrLf)
        RichTextBox3.AppendText("testvalue         long    65             ' ascii A" + vbCrLf)
        RichTextBox3.AppendText("                  fit 496" + vbCrLf)
        TextBox16.Text = "cogject.spin"
    End Sub

    Private Sub Button15_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button15.Click
        Dim Filepath As String
        Dim FileName As String
        Filepath = "C:\Program Files\Catalina\Demos"
        OpenFileDialog1.Multiselect = False
        OpenFileDialog1.InitialDirectory = Filepath
        OpenFileDialog1.FileName = "*.SPIN"
        OpenFileDialog1.ShowDialog()
        FileName = OpenFileDialog1.FileName
        FileName = Strings.Mid(FileName, 33) ' strip off directory
        FileName = Strings.UCase(FileName)
        TextBox16.Text = FileName
        Try
            RichTextBox3.LoadFile("C:\Program Files\Catalina\Demos\" + FileName, RichTextBoxStreamType.PlainText)
            'RichTextBox3.Focus()
        Catch ex As Exception
            ' user probably hit cancel
        End Try
    End Sub

    Private Sub Button16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button16.Click
        RichTextBox3.SaveFile("C:\Program Files\Catalina\Demos\" + TextBox16.Text, RichTextBoxStreamType.PlainText)
    End Sub

    Private Sub Button17_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button17.Click
        Dim Filenamepath As String
        Dim Filepath As String
        Dim Filename As String
        Filename = TextBox16.Text
        Filepath = "C:\Program Files\Catalina\Demos\"
        SaveFileDialog1.InitialDirectory = Filepath
        SaveFileDialog1.FileName = Filename
        SaveFileDialog1.ShowDialog()
        Filenamepath = SaveFileDialog1.FileName
        Try
            RichTextBox3.SaveFile(Filenamepath, RichTextBoxStreamType.PlainText)
        Catch ex As Exception
            're user probably hit cancel
        End Try
    End Sub

    Private Sub Button18_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button18.Click
        CompilePause = True ' for just compile
        CompilePasm()
    End Sub
    Private Sub CompilePasm()
        Dim Location As New Process
        Dim filename_noextension As String
        TextBox16.Text = Strings.LCase(TextBox16.Text)
        RichTextBox3.SaveFile("C:\Program Files\Catalina\Demos\" + TextBox16.Text, RichTextBoxStreamType.PlainText)
        filename_noextension = Strings.Left(TextBox16.Text, Len(TextBox16.Text) - 5)
        FileOpen(1, "C:\Program Files\Catalina\Demos\dracspin.bat", OpenMode.Output)
        PrintLine(1, "@echo off")
        PrintLine(1, "echo.")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo    SETTING UP CATALINA")
        PrintLine(1, "echo    ===================")
        PrintLine(1, "echo.")
        PrintLine(1, "PATH=C:\Program Files\Catalina\bin;%PATH%")
        PrintLine(1, "echo Call catalina_env.bat()")
        PrintLine(1, "Call catalina_env.bat()")
        PrintLine(1, "echo Erase previous files")
        PrintLine(1, "del " + filename_noextension + ".binary")
        PrintLine(1, "del " + filename_noextension + ".h")
        PrintLine(1, "del " + Strings.Chr(34) + "c:\program files\catalina\include\" + filename_noextension + ".h" + Strings.Chr(34))
        PrintLine(1, "echo homespun -b -d " + TextBox16.Text)
        PrintLine(1, "homespun -b -d " + TextBox16.Text)
        PrintLine(1, "echo spinc " + filename_noextension + ".binary to " + filename_noextension + ".h")
        PrintLine(1, "spinc " + filename_noextension + ".binary" + " > " + " " + filename_noextension + ".h")
        PrintLine(1, "echo xcopy to the include folder")
        PrintLine(1, "xcopy " + filename_noextension + ".h " + Strings.Chr(34) + "c:\program files\catalina\include" + Strings.Chr(34) + " /Y")
        ' in xcopy either get an uppercase file name, OR or specify it exactly, it asks do you want to save as a file or as a directory, even with the Y option. So leave it as upper case
        If CompilePause = True Then
            PrintLine(1, "pause") ' leaves batch file window open so can see errors
        End If
        FileClose(1)
        ' compile the program
        Location.StartInfo.FileName = "dracspin.bat"
        Location.StartInfo.WorkingDirectory = "C:\Program Files\Catalina\Demos"
        Location.Start() ' shell the startup file
        Do
            ' wait till batch file finishes
        Loop Until Location.HasExited = True
    End Sub

    Private Sub Button19_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button19.Click
        Dim filename_noextension As String
        Dim short_filename As String
        CompilePause = False ' don't pause
        CompilePasm() ' compile the program
        filename_noextension = Strings.Left(TextBox16.Text, Strings.Len(TextBox16.Text) - 5) ' remove .spin
        If Strings.Len(filename_noextension) > 8 Then
            short_filename = Strings.Left(filename_noextension, 8) ' xmodem uses 8.3 format
        Else
            short_filename = filename_noextension ' leave as it is
        End If
        Try
            FileCopy("C:\Program Files\Catalina\Demos\" + filename_noextension + ".binary", "C:\Program Files\Catalina\Demos\" + short_filename + ".cog")
            SerialPortName.Open()
            SerialPortName.BaudRate = Baud ' current baud rate
            Call XmodemSendKyeDOS("C:\Program Files\Catalina\Demos\" + short_filename + ".cog")
            SerialPortName.Close()
        Catch ex As Exception
            MsgBox("Download error")
            SerialPortName.Close()
        End Try
    End Sub

    Private Sub Button20_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button20.Click
        Dim PasteString As String
        Dim cogname As String
        CompilePause = False ' assumes no errors 
        CompilePasm()
        cogname = LCase(Strings.Left(TextBox16.Text, Len(TextBox16.Text) - 5))
        PasteString = "#include <" + cogname + ".h>" + vbCrLf
        PasteString += vbCrLf
        PasteString += "unsigned long par_" + cogname + "[] = { 1, 2, 3 };   // data to pass to cog - ignore if not used" + vbCrLf
        PasteString += vbCrLf
        PasteString += "void load_" + cogname + "()" + vbCrLf
        PasteString += "{" + vbCrLf
        PasteString += "       _coginit((int)par_" + cogname + ">>2, (int)" + cogname + "_array>>2, 7);      // load into cog 7" + vbCrLf
        PasteString += vbCrLf
        PasteString += "}" + vbCrLf
        PasteString += vbCrLf
        Clipboard.SetText(PasteString) ' put in clipboard
        TabControl1.SelectedIndex = 0 ' display the c program
        RichTextBox1.Paste() ' paste in the rich text box
        ColorCatalina() ' change to color text
    End Sub
    Private Sub NewPASMToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NewPASMToolStripMenuItem.Click
        CatalinaFile = "NEWPASM.C"
        CatalinaFile = InputBox("Filename eg MYFILE.C (no more than 8 characters):", , CatalinaFile)
        CatalinaFile = Strings.UCase(CatalinaFile)
        RichTextBox1.Text = ""
        With RichTextBox1
            Text = ""
            .AppendText("/* PASM demo for use with Catalina IDE Precompiler and Compiler */" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("#include <stdio.h>" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("/* Global constants for both C and PASM */" + vbCrLf)
            .AppendText("const unsigned long int graphicstart  = 0;                           // start of space for video graphics buffer" + vbCrLf)
            .AppendText("const unsigned long int graphicsize   = 19200;                       // size of graphics buffer = 19200 bytes" + vbCrLf)
            .AppendText("const unsigned long int keyboardstart = 19200;                       // start of space for keyboard" + vbCrLf)
            .AppendText("const unsigned long int keyboardsize  = 100;                         // size of space for keyboard" + vbCrLf)
            .AppendText("/* End global constants */" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("/* PASM Code for compilation using SpinC and inclusion as a data file" + vbCrLf)
            .AppendText("PASM Start mycogject.spin" + vbCrLf)
            .AppendText("CON" + vbCrLf)
            .AppendText("                                                                     ' add your values here" + vbCrLf)
            .AppendText("  _clkfreq = 80_000_000                                              ' 5Mhz Crystal" + vbCrLf)
            .AppendText("  _clkmode = xtal1 + pll16x                                          ' x 16" + vbCrLf)
            .AppendText("  graphicstart = 2048                                                ' precompiler will overwrite this" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("PUB Main" + vbCrLf)
            .AppendText("    coginit(1,@cogstart,0)                                           ' cog 1, cogstart, dummy value" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("DAT" + vbCrLf)
            .AppendText("                  org 0" + vbCrLf)
            .AppendText("cogstart          wrbyte  testvalue, testvariable                    ' test value A" + vbCrLf)
            .AppendText("                  jmp #cogstart" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("testvariable      long    graphicstart                               ' test memory location at graphicstart" + vbCrLf)
            .AppendText("testvalue         long    65                                         ' ascii A" + vbCrLf)
            .AppendText("                  fit     496" + vbCrLf)
            .AppendText("PASM End" + vbCrLf)
            .AppendText("*/ " + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("void mycogject()                                                     // unique name for each loader" + vbCrLf)
            .AppendText("{" + vbCrLf)
            .AppendText("       unsigned long cogject_array[] =                               // dummy data or compiled above code or #include file.h" + vbCrLf)
            .AppendText("       {" + vbCrLf)
            .AppendText("              0x003c0602, 0x5c7c0000, 0x00001388, 0x00000041" + vbCrLf)
            .AppendText("       };" + vbCrLf)
            .AppendText("       unsigned long hub_array[512];" + vbCrLf)
            .AppendText("       unsigned long par_cogject[] = { 1, 2, 3 };                    // data to pass to cog - ignore if not used" + vbCrLf)
            .AppendText("       int i;" + vbCrLf)
            .AppendText("       for (i = 0; i < 512; i++)" + vbCrLf)
            .AppendText("       {" + vbCrLf)
            .AppendText("              hub_array[i] = cogject_array[i];" + vbCrLf)
            .AppendText("       }" + vbCrLf)
            .AppendText("       _coginit((int)par_cogject>>2, (int)hub_array>>2, 7);          // load into cog 7" + vbCrLf)
            .AppendText("}" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("void clearscreen()                                                   // white text on dark blue background" + vbCrLf)
            .AppendText("{" + vbCrLf)
            .AppendText("       int i;" + vbCrLf)
            .AppendText("       for (i=0;i<40;i++)" + vbCrLf)
            .AppendText("       {" + vbCrLf)
            .AppendText("               t_setpos(0,0,i);                                      // move cursor to next line" + vbCrLf)
            .AppendText("               t_color(0,0x08FC);                                    // RRGGBBxx eg dark blue background 00001000 white text 11111100" + vbCrLf)
            .AppendText("       }" + vbCrLf)
            .AppendText("}" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("void sleep(int milliseconds)                                         // sleep function" + vbCrLf)
            .AppendText("{" + vbCrLf)
            .AppendText("       _waitcnt(_cnt()+(milliseconds*(_clockfreq()/1000))-4296);" + vbCrLf)
            .AppendText("}" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("char peek(int address)                                               // function implementation of peek" + vbCrLf)
            .AppendText("{" + vbCrLf)
            .AppendText("       return *((char *)address);" + vbCrLf)
            .AppendText("}" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("void poke(int address, char value)                                   // function implementation of poke" + vbCrLf)
            .AppendText("{" + vbCrLf)
            .AppendText("       *((char *)address) = value;" + vbCrLf)
            .AppendText("}" + vbCrLf)
            .AppendText(vbCrLf)
            .AppendText("void main ()" + vbCrLf)
            .AppendText("{" + vbCrLf)
            .AppendText("       char c;" + vbCrLf)
            .AppendText("       int i;" + vbCrLf)
            .AppendText("       clearscreen();" + vbCrLf)
            .AppendText("       printf(" + Chr(34) + "Clock speed %u \n" + Chr(34) + ",_clockfreq());                     // see page 28 of the propeller manual for other useful commands" + vbCrLf)
            .AppendText("       printf(" + Chr(34) + "Catalina running in cog number %i \n" + Chr(34) + ",_cogid());      // integer" + vbCrLf)
            .AppendText("       i=graphicstart;                                               // location to peek and poke" + vbCrLf)
            .AppendText("       poke(i,66);                                                   // poke a B, the cog should change this to an A" + vbCrLf)
            .AppendText("       printf(" + Chr(34) + "load cogject into cog 7\n" + Chr(34) + ");" + vbCrLf)
            .AppendText("       mycogject();" + vbCrLf)
            .AppendText("       c=peek(i);                                                    // peek byte at this location" + vbCrLf)
            .AppendText("       printf(" + Chr(34) + "Peek value at %i = character %c Ascii value %d \n" + Chr(34) + ",i,c,c);" + vbCrLf)
            .AppendText("       while (1); // Prop reboots on exit from main()" + vbCrLf)
            .AppendText("}" + vbCrLf)
            .AppendText(vbCrLf)
            .Focus()
        End With
        'Indents() ' add the proper indentation (already done)
        ColorCatalina() ' display in color
        PrintFileName()
    End Sub

    Private Sub CompileWithPASMCodeToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompileWithPASMCodeToolStripMenuItem.Click
        Precompile()
    End Sub
    Private Sub Precompile()
        ' convert all pasm code into data listings underneath the pasm code as a C function
        ' and copy all constants from the c constants to each pasm object
        Dim i, j As Integer
        Dim NumberLines As Integer
        Dim PasmCode As Boolean
        Dim LineOfText As String
        Dim PasmString As String
        Dim PASMFilename As String
        Dim RemoveFlag As Boolean
        Dim TempString As String
        Dim ConstantString As String
        Dim ConstantFlag As Boolean
        Dim TempConst As String
        Dim OldText As String
        ConstantString = ""
        ConstantFlag = False
        PasmCode = False ' not reading some pasm code
        NumberLines = RichTextBox1.Lines.Length
        OldText = RichTextBox1.Text ' save in case crashes with the Try
        ' get the list of C constants at the beginning of the program
        For i = 0 To NumberLines - 1
            LineOfText = RichTextBox1.Lines(i)
            If Strings.Left(LineOfText, 13) = "/* Global con" Then ConstantFlag = True ' start of constant list
            If ConstantFlag = True And Strings.Left(LineOfText, 17) = "/* End global con" Then ConstantFlag = False ' end of constant list
            If ConstantFlag = True Then
                If Strings.Left(LineOfText, 5) = "const" Then ' only do constant lines
                    TempConst = Strings.Mid(LineOfText, 25) ' strip off the const unsigned long int
                    j = Strings.InStr(TempConst, ";")
                    TempConst = Strings.Left(TempConst, j - 1)
                    ConstantString += "  " + TempConst + vbCrLf ' two spaces plus changed to spin syntax
                End If
            End If
        Next
        ' rebuild constantstring 
        ConstantString = "                                                                     ' Start of C hub constants" + vbCrLf + ConstantString
        ConstantString += "                                                                     ' End of C constants" + vbCrLf + vbCrLf
        ' remove existing CON sections in all pasm objects ready for new one
        ConstantFlag = False
        TempString = ""
        For i = 0 To NumberLines - 1
            LineOfText = RichTextBox1.Lines(i)
            If Strings.Left(LineOfText, 3) = "PUB" Then ConstantFlag = False
            If ConstantFlag = False Then TempString += LineOfText + vbCrLf
            If Strings.Left(LineOfText, 10) = "  _clkmode" Then ConstantFlag = True ' add after the _clkmode
        Next
        RichTextBox1.Text = TempString ' put back modified file
        ' now add to each CON section
        NumberLines = RichTextBox1.Lines.Length
        TempString = "" ' create a new file
        For i = 0 To NumberLines - 1
            LineOfText = RichTextBox1.Lines(i)
            If Strings.Left(LineOfText, 10) = "  _clkmode" Then
                TempString += LineOfText + vbCrLf ' ad the _clkmode line
                TempString += ConstantString
            Else
                TempString += LineOfText + vbCrLf
            End If
        Next i
        RichTextBox1.Text = TempString ' put back modified file
        NumberLines = RichTextBox1.Lines.Length ' update the file length
        PasmCode = False ' not reading some pasm code
        'create all the cogs as .h files
        For i = 0 To NumberLines - 1
            LineOfText = RichTextBox1.Lines(i)
            ' order here is important - end first, then check, then start
            If Strings.Left(LineOfText, 8) = "PASM End" Then
                TextBox16.Text = PASMFilename ' move over to the pasm tab
                RichTextBox3.Text = PasmString ' move to the pasm richtextbox
                CompilePause = False ' stop at end of shell - not writing file properly with no pause?!
                System.Windows.Forms.Application.DoEvents() ' update the richtextbox
                CompilePasm() ' compile it and save it
                PasmCode = False ' finish logging
                System.Windows.Forms.Application.DoEvents() ' update the richtextbox
            End If
            If PasmCode = True Then PasmString += LineOfText + vbCrLf
            If Strings.Left(LineOfText, 10) = "PASM Start" Then
                TabControl1.SelectedIndex = 4 ' display the pasm code
                System.Windows.Forms.Application.DoEvents() ' update the richtextbox
                PasmCode = True ' start logging the data
                PasmString = "" ' clear the string
                PASMFilename = Strings.Mid(LineOfText, 12) ' filename stored after PASM Start
            End If
        Next i
        ' remove all the associated cog code underneath the pasm ie the next function
        ' use tempstring as a temp store
        RemoveFlag = False
        TempString = ""
        For i = 0 To NumberLines - 1
            LineOfText = RichTextBox1.Lines(i)
            If RemoveFlag = False Then TempString += LineOfText + vbCrLf
            If RemoveFlag = True And LineOfText = "}" Then RemoveFlag = False
            If Strings.Left(LineOfText, 8) = "PASM End" Then RemoveFlag = True
        Next
        RichTextBox1.Text = TempString ' put back the modified file
        NumberLines = RichTextBox1.Lines.Length ' shorter now so get new length
        TempString = ""
        For i = 0 To NumberLines - 1
            LineOfText = RichTextBox1.Lines(i)
            If Strings.Left(LineOfText, 10) = "PASM Start" Then
                PASMFilename = Strings.Mid(LineOfText, 12) ' filename stored after PASM Start
                PASMFilename = Strings.Left(PASMFilename, Strings.Len(PASMFilename) - 5) ' strip off the spin bit
            End If
            If Strings.Left(LineOfText, 8) = "PASM End" Then
                ' add in the new code
                TempString += "PASM End" + vbCrLf
                TempString += "*/" + vbCrLf
                TempString += vbCrLf
                TempString += "void " + PASMFilename + "()                                                     // unique name for each loader" + vbCrLf
                TempString += "{" + vbCrLf
                ' add the .h file
                Try
                    FileOpen(1, "C:\Program Files\Catalina\Demos\" + PASMFilename + ".h", OpenMode.Input) ' open a file
                    Do
                        LineOfText = LineInput(1) ' add line from .h file with leading spaces
                        TempString += "       " + LineOfText + vbCrLf
                    Loop Until LineOfText = "};"
                Catch ex As Exception
                    MsgBox(".h file not created, check syntax of PASM code with Compile in the PASM tab")
                End Try
                FileClose(1) ' close the .h file
                TempString += "       unsigned long hub_array[512];" + vbCrLf
                TempString += "       unsigned long par_cogject[] = { 1, 2, 3 };                    // data to pass to cog - ignore if not used" + vbCrLf
                TempString += "       int i;" + vbCrLf
                TempString += "       for (i = 0; i < 512; i++)" + vbCrLf
                TempString += "       {" + vbCrLf
                TempString += "              hub_array[i] = " + PASMFilename + "_array[i];" + vbCrLf
                TempString += "       }" + vbCrLf
                TempString += "       _coginit((int)par_cogject>>2, (int)hub_array>>2, 7);          // load into cog 7" + vbCrLf
                TempString += "}" + vbCrLf
            Else
                TempString += LineOfText + vbCrLf ' add line to tempstring
            End If
        Next i
        RichTextBox1.Text = TempString ' put back modified file
        'Indents() ' add the proper indentation
        'ColorCatalina() ' display in color disabled as slows things down, though does leave text black
        RichTextBox1.Select(0, RichTextBox1.Text.Length) ' convert to black
        RichTextBox1.SelectionColor = Color.Black
        RichTextBox1.DeselectAll()
        TabControl1.SelectedIndex = 0 ' display the c code
    End Sub

    Private Sub PrecompilePayloadXMMCompileDownloadRunToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PrecompilePayloadXMMCompileDownloadRunToolStripMenuItem.Click
        Precompile()
        PayloadCompile()
    End Sub
    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        ' ticks once a second, display the current line number
        ' as using the textchanged method slows a lot of things down
        Static OldValue As Integer
        Dim NewValue As Integer
        NewValue = RichTextBox1.GetLineFromCharIndex(RichTextBox1.SelectionStart) + 1 ' first line is 1
        If OldValue <> NewValue Then
            Label3.Text = "Line" + Strings.Str(NewValue)
            OldValue = NewValue
        End If
    End Sub
End Class

