/**
 * @file ComPort.h - a C99 compatible com port driver
 * Copyright (c) 2009 John Steven Denson (jazzed)
 * All Rights Reserved.
 */
#ifndef COMPORT_H
#define COMPORT_H

#ifdef CYGWIN
#include <windows.h>
#elif  WINDOWS
#include <windows.h>
#elif  VC2008
#include <windows.h>
#else
typedef int HANDLE;
#endif

extern HANDLE gser;

HANDLE openport(char* file);

void closeport(HANDLE id);

int rx(HANDLE hSerial, uint8_t* buff, int n);

int tx(HANDLE hSerial, uint8_t* buff, int n);

void hwreset(HANDLE hSerial);

#endif
//COMPORT_H
