''***************************************
''*  VGA Tile + Sprite Driver Demo v1.0 *
''*  (C) Jim Bagley                     *
''***************************************

  _clkmode = xtal1 + pll16x         ' enable external clock and pll times 16
  _xinfreq = 5_000_000              ' set frequency to 5 MHZ

CON

NUM_COGS        =  3 'if not using sprites, you can set this to 1 :)
NUM_SPRITES     = 48 'buffer is 3 words ( X,Y,TILENUM), so use even numbers.
SCAN_YCOUNT     = 200 'set to 240 for VGA or 200 for TV

OBJ
  'display : "VGA_JB_001"
  display : "TvFc09"
  rend : "TV_VGA_REND_JB_001"
  prop : "TvProperties"

PUB start | i,c,x,y
  display.start(@disp_params)
  repeat 100
  rend.start(@rend_params)

  repeat y from 0 to 29
    repeat x from 0 to 63
      PutChar(x,y,word[@map][y*64+x])

  showbutton(55,21,string("OK"))

  c:=$deadface
  if NUM_SPRITES>0
    repeat i from 0 to rend_num_sprites-1 step 2
      x:= i*4
      y:= i/8
      'x:=c?
      'y:=c?
      SetSprite(i  ,x  ,y,0)
      SetSprite(i+1,x+4,y,1)
'      SetSprite(i,4+i*3,8+i*2,0)

  repeat 
    repeat while disp_params<>1
    repeat while disp_params==1
    if NUM_SPRITES>0
      wordmove(@sprite_list,@sprite_list2,3*rend_num_sprites)
      repeat i from 0 to rend_num_sprites-1
        sprite_list2[i*3+0]++
        sprite_list2[i*3+1]++

PUB drawbox(x,y,w,h) | s,b,yy
  b:=@boxchars-@chars
  s:=@screen[y<<6+x]
  word[s][0]:=b
  wordfill(s+2,b+72,w<<1)
  word[s+2+(w<<2)]:=b+36
  s+=128
  repeat yy from 1 to h 
    word[s][0]:=b+4
    wordfill(s+2,b+76,w<<1)
    word[s+2+(w<<2)]:=b+40
    s+=128
  word[s][0]:=b+8
  wordfill(s+2,b+80,w<<1)
  word[s+2+(w<<2)]:=b+44

PUB showbutton(x,y,str) | s,w
  s:=str
  w:=0
  repeat while byte[s++]
    w++ 
  drawbox(x,y,w,1)
  print(x+1,y+1,str)
  
PUB print(x,y,str) | c,a
  repeat
    c:=byte[str++]
    if(c==0)
      return
    a:=-1
    if(c>"A"-1) and (c<"Z"+1)
      a:=(c-"A")+10
    if(c>"a"-1) and (c<"z"+1)
      a:=(c-"a")+10
    if(c>"0"-1) and (c<"9"+1)
      a:=c-"0"
    if(a==-1)
      x+=2
    else
      a:=(a<<6)+(@font-@chars) '*64 ( 2 4x8 chars per letter ) + offset from chars to font
      screen[y<<6+x++]:=a
      screen[y<<6+x++]:=a+32
        
PUB PutChar(x,y,charnum)
  screen[y<<6+x]:=charnum<<5
  
PUB SetSprite(sprnum,x,y,tilenum)
  sprite_list2[sprnum*3+0]:=x
  sprite_list2[sprnum*3+1]:=y
  sprite_list2[sprnum*3+2]:=tilenum<<5
        
DAT

rend_params
rend_cognum             long    0
rend_image              long    0
rend_pixels             long    @pixelsdata+$10 'pointer to line buffers ( (256+8)*rendercogs )
rend_screen             long    @screen+$10 'pointer to screen charmap buffer ( 64x30 )
rend_chars              long    @chars+$10 'pointer to screen character image tiles ( 4x8 )
rend_sprite_ptr         long    @sprite_list+$10 'pointer to sprite list ( X,Y,CHR )
rend_sprchr_ptr         long    @sprchrs+$10 'pointer to sprite image tiles ( 4x8 )
rend_num_sprites        long    NUM_SPRITES
'vga_params falls after rend_params
disp_params              long    0               'sync written at start of frame
disp_pixels              long    @pixelsdata+$10 'pointer to line buffers
disp_nextlineptr         long    @next_line+$10  'pointer to nextline to be draw
disp_enable              long    1               'enable display
disp_cogs                long    NUM_COGS        'number of display lines before looping to top of buffer
disp_scancount           long    SCAN_YCOUNT     'to let renderer know how many lines to do.   
'-------------------------------------------------------------
' Board Specific Parameters
'-------------------------------------------------------------
ivcfg                    LONG    prop#ivcfg
ictra                    LONG    prop#ictra
ifrqa                    LONG    prop#ifrqa
idira                    LONG    prop#idira
lnram                    LONG    @screen + $10    ' Address of HUB Pixel Ram

sprite_list   word      0[3*NUM_SPRITES] '4 words as it reads data in longs
sprite_list2  word      0[3*NUM_SPRITES] '4 words as it reads data in longs

next_line     long      0

pixelsdata    byte      $05[(256+8)*NUM_COGS]



screen        word      0*32[64*30] 'Character map layout, TILENUM*32, as you can use pixel offsets into chars if you want, or set the charset to 0, and use as pointer to area

map     file  "TV_mario.map"
chars   file  "TV_mario.chr"

sprchrs

        byte  $00,$00,$00,$00
        byte  $00,$03,$03,$00
        byte  $0f,$00,$00,$0f
        byte  $0f,$00,$00,$0f
        byte  $0f,$00,$00,$0f
        byte  $0f,$00,$00,$0f
        byte  $00,$03,$03,$00
        byte  $00,$00,$00,$00

        byte  $00,$00,$00,$00
        byte  $00,$03,$03,$00
        byte  $0f,$00,$00,$0f
        byte  $0f,$00,$00,$0f
        byte  $0f,$00,$00,$0f
        byte  $0f,$00,$00,$0f
        byte  $00,$03,$03,$00
        byte  $00,$00,$00,$00


boxchars byte $07,$07,$07,$07    'TopLeft +0
        byte  $07,$02,$02,$02    'Left +4
        byte  $07,$02,$02,$02    'BotLeft +8
        byte  $07,$02,$02,$02    '+12
        byte  $07,$02,$02,$02    '+16
        byte  $07,$02,$02,$02    '+20
        byte  $07,$02,$02,$02    '+24
        byte  $07,$02,$02,$02    '+28
        byte  $07,$02,$02,$02    '+32
        byte  $07,$07,$07,$07    'TopRight +36 
        byte  $02,$02,$02,$07    'Right +40
        byte  $02,$02,$02,$07    'BotRight +44
        byte  $02,$02,$02,$07    '+48
        byte  $02,$02,$02,$07    '+52
        byte  $02,$02,$02,$07    '+56
        byte  $02,$02,$02,$07    '+60
        byte  $02,$02,$02,$07    '+64
        byte  $02,$02,$02,$07    '+68
        byte  $07,$07,$07,$07    'Top+72
        byte  $02,$02,$02,$02    'Center+76
        byte  $02,$02,$02,$02    'Bot+80
        byte  $02,$02,$02,$02    '+84
        byte  $02,$02,$02,$02    '+88
        byte  $02,$02,$02,$02    '+92
        byte  $02,$02,$02,$02    '+96
        byte  $02,$02,$02,$02    '+100
        byte  $02,$02,$02,$02    '+104
        byte  $07,$07,$07,$07    '+108
'112 bytes for the box chars.

font    file  "f.chr" '"TV_font.chr"




