{{
TvProperties.spin
Copyright (c) 2010, various contributors
See MIT license for terms of use.
}}

{{
----------------------------------------------------------------------------
Users select TV properties for their hardware platform
in a single, well defined, and easily replacable file.

This file should be modified by the user and put in a library folder
separate from the downloaded folder. Once the file is copied and
modified, the file should be removed from the download folder.

The file can then be referenced by the driver as:

1) Propeller Tool users: copy the file to the Propeller Tool library folder.
2) BST/BSTC users: keep modified file in the user specified library folder.
----------------------------------------------------------------------------
}}

CON
{{
'' USER DEFINED CLOCK PROPERTIES:
----------------------------------------------------------------------------
clkmode is used to define the clock parameters used by the program.
xinfreq is used to define the frequency of the crystal being used.
sysclock is used to derive an IFRQA or calculated clkfreq value.
}}

  clockmode = xtal1 + pll16x          ' enable external clock and pll times 16
  xtalfreq  = 5_000_000               ' set frequency to 5 MHZ
  sysclock  = xtalfreq*16             ' sysclock frequency is xtalfreq * pllx

{{
'' USER DEFINED VCFG PIN PROPERTIES:
----------------------------------------------------------------------------
basepin is the first pin used by the TV DAC
ifrqa   is value to use with the TV COG frqa register - prefer calculation
}}

''NTSC Demoboard & Hydra @ 80MHz
' basepin= 12
' ifrqa = $16E8_BA2F            ' accurate ifrqa value for NTSC @ 80MHz

''NTSC GadgetGangster SDRAM Module TV  @ 80MHz
  basepin= 20
  ifrqa = $16E8_BA2F            ' accurate ifrqa value for NTSC @ 80MHz

''NTSC Hybrid @ 96MHz
' basepin= 24                   ' Hybrid
' ifrqa = $1317_45D1            ' accurate ifrqa value for NTSC @ 96MHz

''NTSC IFRQA value for 100MHz
' ifrqa = $1253C824

{{
'' DERIVED IFRQA VALUES
'' If you have an odd frequency use this. The method is not accurate, but
'' seems to produce reasonable values for a range of sysclock frequencies.
'' You can always comment out this and use the ifrqa values above.
'' If the value is not suitable, open your calculator to 64 bit mode and
'' enter the following (AOS or infix - RPN postfixers figure it out):
'' 7159090.1/sysclock*268435456 then convert to hex if you like.
----------------------------------------------------------------------------
  ntsc  = 7_159_090_9
  ntscm = 268_435_456/(sysclock/1000)
  ifrqa = (ntsc/10000*ntscm)<<4
}}

{{
'' Derived values for driver
----------------------------------------------------------------------------
}}
  group  = (basepin/8)          ' group selects P0-7, P8-15, P16-23, P24-31
  nibble = (basepin/4) & 1      ' nibble selects the 4 bits of a group to use
  vmode  = 2 | nibble           ' vmode selects the video mode in VCFG

  ipins = (group<<9) | (7 << (nibble*4))
  idira = %0111 << basepin
  ictra = %0_00001_110_00000000000000000000000  ' CTRA PLL Mode VCO/2
  ivcfg = (%0_00_1_0_1_000_00000000000 << 12) | (vmode << 29) | ipins


{{
All spin files must have at least one PUB method.
This method satisfies that requirement and is not to be called.
}}
PUB none

{{
----------------------------------------------------------------------------
  MIT License:
----------------------------------------------------------------------------
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         
----------------------------------------------------------------------------
}}


