#include "propeller.h"

int errno;

inline void longfill(int* dst, int fill, int count)
{
  // while --count is generally faster than a for loop
  while(--count > -1)
    *dst++ = fill;
}

inline void longmove(int* dst, int* src, int count)
{
  // while --count is generally faster than a for loop
  while(--count > -1)
    *dst++ = *src++;

#ifdef KEEPFORDEBUG
  int i;
  for (i = 0; i < count; i++)
  {
    if(i % 8 == 0)
      iprintf("\n");
    iprintf("%08x ",*src);
    *dst++ = *src++;
  }
#endif
}

int cognew(int* code, int* par)
{
  int cog;
  cog = _syscall(&errno, SYS_cognew, 0, code, par);
  return (cog);
}

int coginit(int cog, int* code, int* par)
{
  cog = _syscall(&errno, SYS_coginit, cog, code, par);
  return (cog);
}

void cogstop(int cog)
{
  int result;
  result = _syscall(&errno, SYS_cogstop, cog, 0, 0);
}
