'*******************************************************************************
'*                                                                             *
'* uploadsd.spin                                                               *
'*                                                                             *
'*******************************************************************************
'
#define USE_SDCARD

OBJ
'Set your platform configuration in userdef.spin
'Ideally, your userdefs.spin can live in the library path,
'and you can simply remove a new package's userdefs.spin
'to enable your own definitions.

    def : "userdefs.spin"

CON
    _clkmode        = def#_clkmode
    _xinfreq        = def#_xinfreq
    ' user baud rate
    baud            = def#conBaud
    ' user microSD pins
    spiDO           = def#spiDO
    spiClk          = def#spiCLK
    spiDI           = def#spiDI
'   spiCLR          = def#spiCLR    ' not sure what this is
    spiINC          = def#spiCS     ' apparently INC is CS

OBJ
  ser  : "FullDuplexSerialPlus"
  sd   : "fsrw"

VAR
  long file_offset

  'Misc vars
  long cog
  long ioControl[2]               'SD parameters
  long framep
  word err                        'Error code return
  long step_count
  byte diskbuff[$2000+1]
  byte filename[80]
  byte command[80]
  byte cmdstate

DAT
  BEGIN_HELP
  APPE_STR byte "A - Append to file",0
  DUMP_STR byte "D - Dump file to serial port",0
  PRNT_STR byte "P - Print file to serial port",0
  ERASESTR byte "E - Erase file",0
  RESETSTR byte "R - Reboot",0
  LIST_STR byte "L - List files",0
  END_HELP

PUB start : okay | n

  ser.start(def#conRxPin, def#conTxPin, def#conMode, 115200) 'Start the loader terminal
  waitcnt(clkfreq/5+cnt)
  crlf
  ser.str(string("uploadsd v0.x"))

  mount
  ser.str(@OKSTR)

  repeat
    menu

dat
    OKSTR   byte "OK>",$d,$a,0
'   OKSTR   byte ">",$d,$a,0

PUB menu | m,n, len

  ser.getstr(@command)
'  ser.str(@command)
'  crlf

  case command

    "?":
      ser.str(@OKSTR)
      return

{{
Erase file. Command "E <filename>"
}}
    "E","e":
      ser.str(@OKSTR)
      ser.getstr(@filename)
      ser.str(@OKSTR)
{
      ser.str(string("Erase "))
      ser.str(@filename)
}
      if filename[0]
        err := \sd.popen(@filename, "d")
        if err < 0
            ser.str(string("ERROR erasing file"))
        sd.pclose
      ser.str(@OKSTR)
  
{{
Append bytes to file. Command "A <filename> <decimal N> byte1, byte2, ... byte N"
}}
    "A","a":
      ser.str(@OKSTR)
      ser.getstr(@filename)         ' get filename
      ser.str(@OKSTR)
      len := ser.getDec             ' get length
      ser.str(@OKSTR)

      if filename[0]
        err := \sd.popen(@filename, "a")
        ser.rxflush
{
        ' one way to do it, but broken
        repeat n from 0 to len-1    ' get len bytes
          err := \sd.pputc(ser.rx)
          if err < 0
            ser.str(string("ERROR writing file"))
            quit
          ser.tx("#")
'}
'{
        ' another way to do it, but still broken
        repeat n from 0 to len-1    ' get len bytes
          diskbuff[n] := ser.rx
          'ser.tx("#")
        diskbuff[len] := 0
        err := \sd.pwrite(@diskbuff, len)
        if err < 0
          ser.str(string("ERROR writing file"))
'}
        ser.str(@OKSTR)
        sd.pclose

{{
Dump bytes from file. Command "D <filename>"
}}
    "D","d":
      ser.str(@OKSTR)
      file_offset := 0
      ser.getstr(@filename)
      ser.str(@OKSTR)
      if filename[0]
        err := \sd.popen(@filename, "r")
        if err
          ser.str(string("No such file."))
          crlf
          return
        ser.str(string("Dump "))
        ser.str(@filename)
        crlf
        repeat
          len := sd.pread(@diskbuff, 32)
          if len < 1
            quit
          repeat n from 0 to len-1
            ser.hex(diskbuff[n],2)
            ser.tx(" ")
          crlf
        sd.pclose
      ser.str(@OKSTR)
  
{{
Print text from file. Command "D <filename>"
}}
    "P","p":
      ser.str(@OKSTR)
      file_offset := 0
      ser.getstr(@filename)
      ser.str(@OKSTR)
      if filename[0]
        err := \sd.popen(@filename, "r")
        if err
          ser.str(string("No such file."))
          crlf
          return
        ser.str(string("Print "))
        ser.str(@filename)
        crlf
        repeat
          len := sd.pread(@diskbuff, $100)
          if len < 1
            quit
          repeat n from 0 to len-1
            ser.tx(diskbuff[n])
        sd.pclose
        crlf
      ser.str(@OKSTR)
  
    "L","l":
      cmdstate := "L"
      ser.str(@OKSTR)
      sd.opendir
      repeat
        ifnot sd.nextfile(@diskbuff)
          ser.str(@diskbuff)
          crlf
        else
          quit
      ser.str(@OKSTR)

    "R","r":
      cmdstate := "R"
      ser.str(@OKSTR)
      waitcnt(clkfreq+cnt)
      reboot

{
    "C","c":
      if cmdstate == "S"
        len := ser.getDec
        ser.dec(len)
        crlf
        repeat n from 0 to len-1
          queue[n++] := ser.getHex
        sd.initSDCard(spiDO,spiClk,spiDI,spiINC)
        if sd.writeSDCard(file_offset, @queue, len) <> 0
          ser.str(string("ERROR writing file"))
          crlf
          return
        file_offset += len

      elseif cmdstate == "L"
        ser.str(@OKSTR)

    "S","s":
      cmdstate := "S"
      file_offset := 0
      ser.getstr(@filename)
      crlf
      ser.str(string("Save as "))
      ser.str(@filename)
      if filename[0]
        err := \sd.popen(@filename, "w")
        ser.dec(err)
        crlf
        ser.str(@OKSTR)
      else
        ser.str(string("ERROR opening save file"))
        crlf
        cmdstate := 0
}

PUB mount
  ser.str (string("Starting SD driver..."))
  repeat
    ser.str (string("Mounting SD..."))
    err := \sd.mount_explicit(spiDO,spiClk,spiDI,spiINC)    'Mount the SD
    ser.dec(err)
    crlf
  until err == 0
  ser.str (string("SD Mounted ...."))


PRI crlf
  ser.tx(13)
  ser.tx(10)

'---------------------------------------------------------------------------------------------------------

'---------------------------------------------------------------------------------------------------------
'The End.

