#!/bin/sh

#######################################################################
# load.sh is used to upload a file to SDCARD
# $1 is filename
# $2 is optional flag such as -r
#######################################################################

FILE=$1
PORT=$2

if [ "${ZOG}" = "" ]; then
    ZOG=${PWD}
fi

if [ "${FILE}" = "" ]; then
    echo "${0} Syntax: ${0} <c program filename>.bin <portname> [-r]"
    exit 1
fi

if [ "${PORT}" = "" ]; then
    PORT=/dev/ttyUSB0
fi

SPIN=${ZOG}/spin
UPLOAD=${ZOG}/spin/uploadsd.binary
LOAD=${ZOG}/loader
LOADER=${LOAD}/pload

echo "Load ${FILE}"
ln -sf ${PWD}/${FILE} ${LOAD}/main.bin
${LOADER} ${PORT} ${UPLOAD} ${3} -s ${LOAD}/main.bin
