#include "stdio.h"

unsigned short header[0x36];
unsigned char palette[256*4];
unsigned char proppal[256];

unsigned char charcell[8*8];
unsigned char convchar[8*8];
unsigned short currentattr;

unsigned short currentblock;
unsigned short blockcell[4];
unsigned short blockmap[10240*10240];
unsigned short blocks[40960*64];
unsigned short charmap[5120*5120];
unsigned char chars[20480*64];
unsigned int charnum;
unsigned int blocknum;
unsigned int blockmapsize=1;
unsigned int blocksize=1;
int yfirst=0;
int justcharmap=0;
int invx=0;
int nopalette=0;
int pal16=0;
int getting_2600=0;

#define	bitmap2		0
#define	bitmap4		1
#define	bitmap16	2
#define	bitmap256	3
#define C64bitmap2  4
#define C64bitmap4  5
#define AMSbitmap4  6
#define AMSbitmap16 7
#define charmap2	8
#define charmap4	9
#define	charmap16	10
#define	charmap256	11
#define C64sprites  12
#define VGAchars4x8	13

int charand=0x03;
int paland=0xfc;
int palshift=2;
int mode=charmap4;
int fat=0;

int repeatable=0;
int flipable=0;

char extjcs[]="JCS"; //c64 mode sprites
char extcb2[]="CB2"; //c64 mode bitmap2col
char extcb4[]="CB4"; //c64 mode bitmap4col
char extjcc[]="JCC"; //c64 mode characters

char extab4[]="AB4"; //Ams mode 4colour bitmap
char exta16[]="A16"; //Ams mode 16colour fat bitmap
char extas4[]="AS4"; //Ams mode 4colour sprite
char extas6[]="AS6"; //Ams mode 16colour fat sprite

char extjb2[]="JB2";
char extjb4[]="JB4";
char extj16[]="J16";
char extj8b[]="J8B";
char extbm2[]="BM2";
char extbm4[]="BM4";
char extb16[]="B16";
char extb8b[]="B8B";
char extvga[]="VGA";
char *ext=extjb4;

char fname[1024];
unsigned char screen[4096*4096];

unsigned int scrwidth;
unsigned int scrheight;

int doingvga;

unsigned char PropRGBs[256*4]={
	0x04,0x05,0x05,0x00,	0x02,0x04,0x04,0x00,	0x04,0x06,0x06,0x00,	0x31,0x34,0x33,0x00,	0x64,0x66,0x66,0x00,	0x97,0x9b,0x9b,0x00,	0xcf,0xd0,0xd0,0x00,	0xf0,0xf9,0xfa,0x00,	0x29,0x8c,0xa1,0x00,	0x44,0x0a,0x0e,0x00,	0x75,0x00,0x00,0x00,	0x9f,0x2c,0x26,0x00,	0xd4,0x63,0x5c,0x00,	0xfb,0x97,0x90,0x00,	0xf4,0xc5,0xbe,0x00,	0x23,0x5e,0x72,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x99,0x99,0x00,	0xcd,0xce,0xcd,0x00,	0xef,0xf7,0xfb,0x00,	0x21,0x7b,0xd7,0x00,	0x3c,0x07,0x19,0x00,	0x6f,0x06,0x00,0x00,	0x97,0x33,0x11,0x00,	0xcc,0x69,0x43,0x00,	0xfe,0x9e,0x75,0x00,	0xf6,0xc9,0xa8,0x00,	0x1e,0x4c,0xa9,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x66,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xcd,0xcf,0xcd,0x00,	0xf1,0xf6,0xfd,0x00,	0x25,0x66,0xf4,0x00,	0x21,0x04,0x21,0x00,	0x4b,0x0e,0x00,0x00,	0x77,0x3d,0x02,0x00,	0xac,0x73,0x2d,0x00,	0xe3,0xa9,0x5e,0x00,	0xf3,0xd1,0x95,0x00,	0x1f,0x36,0xdc,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x04,0x00,	0x30,0x33,0x33,0x00,	0x62,0x66,0x65,0x00,	0x95,0x99,0x99,0x00,	0xcc,0xcf,0xcd,0x00,	0xf4,0xf5,0xfd,0x00,	0x47,0x54,0xf7,0x00,	0x08,0x03,0x22,0x00,	0x1d,0x16,0x00,0x00,	0x4c,0x45,0x01,0x00,	0x80,0x7b,0x23,0x00,	0xb8,0xb1,0x51,0x00,	0xe0,0xd8,0x8a,0x00,	0x23,0x24,0xef,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x04,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x99,0x99,0x00,	0xca,0xcf,0xcc,0x00,	0xf9,0xf4,0xfd,0x00,	0xad,0x47,0xf7,0x00,	0x14,0x05,0x23,0x00,	0x02,0x1c,0x00,0x00,	0x1e,0x4a,0x01,0x00,	0x52,0x80,0x22,0x00,	0x85,0xb7,0x50,0x00,	0xb8,0xdd,0x88,0x00,	0x7c,0x1d,0xf0,0x00,
	0x01,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x63,0x66,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xc9,0xd0,0xcc,0x00,	0xfc,0xf3,0xfc,0x00,	0xf4,0x41,0xf7,0x00,	0x24,0x05,0x23,0x00,	0x00,0x1e,0x00,0x00,	0x02,0x4c,0x01,0x00,	0x28,0x82,0x2a,0x00,	0x55,0xb9,0x5a,0x00,	0x90,0xdd,0x90,0x00,	0xe6,0x1c,0xdf,0x00,
	0x01,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x63,0x66,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xca,0xd0,0xcd,0x00,	0xfc,0xf3,0xfa,0x00,	0xfd,0x49,0xe3,0x00,	0x28,0x06,0x20,0x00,	0x00,0x1b,0x00,0x00,	0x00,0x4a,0x0c,0x00,	0x09,0x7f,0x3d,0x00,	0x31,0xb6,0x6f,0x00,	0x70,0xdb,0xa1,0x00,	0xf6,0x1c,0xb2,0x00,
	0x01,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x99,0x99,0x00,	0xca,0xcf,0xce,0x00,	0xfc,0xf3,0xf6,0x00,	0xfb,0x5b,0xa8,0x00,	0x29,0x06,0x15,0x00,	0x00,0x15,0x00,0x00,	0x00,0x44,0x21,0x00,	0x00,0x79,0x57,0x00,	0x1d,0xb0,0x8a,0x00,	0x5e,0xd5,0xb6,0x00,	0xf2,0x28,0x72,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x99,0x99,0x00,	0xc9,0xcf,0xcf,0x00,	0xfc,0xf4,0xf4,0x00,	0xfb,0x6f,0x63,0x00,	0x29,0x09,0x07,0x00,	0x00,0x0d,0x0e,0x00,	0x00,0x3c,0x3d,0x00,	0x00,0x72,0x73,0x00,	0x1b,0xa7,0xaa,0x00,	0x5d,0xce,0xd0,0x00,	0xf2,0x3c,0x2f,0x00,
	0x01,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x04,0x00,	0x30,0x33,0x33,0x00,	0x63,0x65,0x65,0x00,	0x96,0x99,0x99,0x00,	0xca,0xcf,0xd0,0x00,	0xfc,0xf6,0xf1,0x00,	0xfc,0x83,0x29,0x00,	0x28,0x0d,0x0a,0x00,	0x00,0x03,0x2a,0x00,	0x00,0x32,0x58,0x00,	0x06,0x68,0x8e,0x00,	0x2b,0x9d,0xc4,0x00,	0x6c,0xc6,0xe8,0x00,	0xf4,0x50,0x1c,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x02,0x05,0x04,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xca,0xce,0xd0,0x00,	0xfc,0xf7,0xf0,0x00,	0xfa,0x98,0x20,0x00,	0x26,0x10,0x19,0x00,	0x00,0x00,0x41,0x00,	0x00,0x29,0x6d,0x00,	0x20,0x5e,0xa2,0x00,	0x4d,0x93,0xd9,0x00,	0x89,0xbe,0xef,0x00,	0xf0,0x65,0x1c,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xca,0xce,0xd0,0x00,	0xfa,0xf8,0xf0,0x00,	0xc3,0xa9,0x21,0x00,	0x18,0x12,0x23,0x00,	0x00,0x00,0x4e,0x00,	0x17,0x22,0x79,0x00,	0x48,0x57,0xae,0x00,	0x7b,0x8b,0xe5,0x00,	0xb0,0xb8,0xf1,0x00,	0x96,0x78,0x1c,0x00,
	0x01,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xcc,0xce,0xd0,0x00,	0xf5,0xf9,0xf0,0x00,	0x57,0xb5,0x21,0x00,	0x07,0x14,0x22,0x00,	0x15,0x00,0x4f,0x00,	0x41,0x1d,0x7a,0x00,	0x78,0x52,0xaf,0x00,	0xad,0x85,0xe6,0x00,	0xd9,0xb4,0xf2,0x00,	0x2e,0x85,0x1d,0x00,
	0x01,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xcd,0xce,0xd0,0x00,	0xf1,0xfa,0xf1,0x00,	0x27,0xba,0x22,0x00,	0x1b,0x14,0x1a,0x00,	0x41,0x00,0x45,0x00,	0x6d,0x1c,0x6f,0x00,	0xa3,0x50,0xa5,0x00,	0xdb,0x83,0xdb,0x00,	0xf1,0xb3,0xf1,0x00,	0x1e,0x8a,0x1f,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x96,0x9a,0x99,0x00,	0xcd,0xce,0xd0,0x00,	0xef,0xfa,0xf3,0x00,	0x22,0xb3,0x28,0x00,	0x36,0x12,0x0b,0x00,	0x67,0x00,0x30,0x00,	0x91,0x1e,0x5c,0x00,	0xc5,0x53,0x92,0x00,	0xfa,0x86,0xc8,0x00,	0xf6,0xb5,0xed,0x00,	0x1f,0x83,0x21,0x00,
	0x02,0x00,0x00,0x00,	0x00,0x00,0x00,0x00,	0x03,0x05,0x05,0x00,	0x30,0x33,0x33,0x00,	0x62,0x65,0x65,0x00,	0x95,0x9a,0x99,0x00,	0xcd,0xce,0xcf,0x00,	0xef,0xf9,0xf6,0x00,	0x22,0xa1,0x56,0x00,	0x46,0x0e,0x02,0x00,	0x7b,0x00,0x15,0x00,	0xa3,0x23,0x43,0x00,	0xd7,0x58,0x78,0x00,	0xff,0x8b,0xaf,0x00,	0xf5,0xba,0xd8,0x00,	0x1f,0x74,0x2c,0x00,
};

unsigned char colours_bmp[86*3]={
	0x78,0x02,0x2a,0x83,0x0b,0x09,0x6e,0x39,0x1a,0x3b,0x2b,0x13,0x2c,0x29,0x1d,0x27,0x30,0x20,0x15,0x3f,0x11,0x14,0x35,0x1c,0x11,0x36,0x2f,0x13,0x3a,0x48,0x0e,0x37,0x58,0x07,0x22,0x73,0x1f,0x14,0x67,0x48,0x1e,0x74,0x45,0x11,0x4f,0x65,0x0f,0x42,
	0xb7,0x09,0x45,0xa8,0x13,0x12,0xa1,0x54,0x25,0x79,0x57,0x22,0x6b,0x62,0x41,0x57,0x6b,0x44,0x27,0x7b,0x1c,0x24,0x69,0x37,0x1f,0x68,0x5a,0x20,0x5e,0x72,0x14,0x4f,0x7b,0x0e,0x33,0xa1,0x32,0x25,0x9c,0x60,0x2b,0x98,0x6c,0x1a,0x79,0x96,0x1a,0x66,
	0xcf,0x4a,0x79,0xc0,0x4f,0x4d,0xc0,0x72,0x40,0xac,0x7c,0x2e,0xa0,0x8f,0x4f,0x85,0x9c,0x6d,0x3a,0xa2,0x32,0x42,0xa6,0x69,0x4c,0xa5,0x94,0x42,0x84,0x9f,0x37,0x76,0xa3,0x4c,0x6e,0xb8,0x7f,0x73,0xbc,0x91,0x68,0xb8,0x9d,0x43,0xac,0xc9,0x5a,0x9f,
	0xcb,0x8b,0xa3,0xbe,0x81,0x7e,0xc0,0x8d,0x6d,0xbe,0x9f,0x6c,0xbb,0xae,0x7f,0xa2,0xb4,0x8e,0x7b,0xb8,0x78,0x75,0xbd,0x92,0x86,0xb6,0xad,0x72,0xa0,0xb6,0x7b,0xa0,0xbc,0x91,0xa0,0xc0,0x9e,0x97,0xbb,0xa7,0x8d,0xbe,0xb5,0x85,0xbc,0xcb,0x85,0xb0,
	0xd7,0xb3,0xc0,0xca,0xa8,0xa8,0xcc,0xb4,0xa5,0xcc,0xbb,0xa2,0xc9,0xc3,0xaf,0xbf,0xca,0xb2,0xb5,0xcb,0xb3,0xb3,0xcc,0xbe,0xb0,0xcb,0xc8,0xa8,0xc0,0xcb,0xa5,0xba,0xca,0xb2,0xba,0xcc,0xb9,0xb4,0xcb,0xbd,0xaf,0xca,0xc5,0xb2,0xc8,0xd6,0xb7,0xcb,
	0x00,0x00,0x00,0x33,0x33,0x33,0x77,0x77,0x77,0xaa,0xaa,0xaa,0xee,0xee,0xee,0xff,0xff,0xff,
};

unsigned char colours_idx[86]={
	0x0a,0x1a,0x2a,0x3a,0x4a,0x5a,0x6a,0x7a,0x8a,0x9a,0xaa,0xba,0xca,0xda,0xea,0xfa,
	0x0b,0x1b,0x2b,0x3b,0x4b,0x5b,0x6b,0x7b,0x8b,0x9b,0xab,0xbb,0xcb,0xdb,0xeb,0xfb,
	0x0c,0x1c,0x2c,0x3c,0x4c,0x5c,0x6c,0x7c,0x8c,0x9c,0xac,0xbc,0xcc,0xdc,0xec,0xfc,
	0x0d,0x1d,0x2d,0x3d,0x4d,0x5d,0x6d,0x7d,0x8d,0x9d,0xad,0xbd,0xcd,0xdd,0xed,0xfd,
	0x0e,0x1e,0x2e,0x3e,0x4e,0x5e,0x6e,0x7e,0x8e,0x9e,0xae,0xbe,0xce,0xde,0xee,0xfe,
	0x02,0x03,0x04,0x05,0x06,0x07
};
unsigned char propcolours[256];

unsigned char getpixelcolour(int r,int g,int b)
{
int tr,tg,tb;
int i,d,t;
unsigned char c;
    if(r==255 && g==0 && b==255) return 0;
    if(doingvga)
    {
        return ((r>>6)<<2)+((g>>6)<<4)+((b>>6)<<6)+3;
    }
    
	c=80;
	d=10000;
	
	for(i=0;i<256;i++)
	{
		tr=PropRGBs[i*4+0]-r;
		tg=PropRGBs[i*4+1]-g;
		tb=PropRGBs[i*4+2]-b;
		tr=abs(tr);
		tg=abs(tg);
		tb=abs(tb);
		t=tr;
		if(tg>t) t=tg;
		if(tb>t) t=tb;

		if (t<d)
		{
			d=t;
			c=i;
		}
	}
	if(c&15<7) c=c&15;
	if(c<2) c=2;
	return c;
	
	
	for(i=0;i<86;i++)
	{
		tr=colours_bmp[i*3+0]-r;
		tg=colours_bmp[i*3+1]-g;
		tb=colours_bmp[i*3+2]-b;
		tr=abs(tr);
		tg=abs(tg);
		tb=abs(tb);
		t=tr;
		if(tg>t) t=tg;
		if(tb>t) t=tb;

		if (t<d)
		{
			d=t;
			c=i;
		}
	}
	return colours_idx[c];
}

void setuppropcolours(void)
{
FILE *f;
int x,y;
	f=fopen("propcolours.bmp","rb");
	if(f)
	{
		fseek(f,0x36,SEEK_SET);
		fread(colours_bmp,86,3,f);
		fclose(f);
	}
    for(x=2;x<=7;x++) propcolours[x]=x;
	for(x=11;x<=14;x++)
	{
		for(y=0;y<16;y++)
		{
			propcolours[x*16+y]=y*16+x;
		}
	}
}

void convcharto1bit(int chr)
{
unsigned char *src=&chars[chr*64];
unsigned char *dst=&convchar[0];
int i;
	for(i=0;i<64;i++)
	{
		if((i&7)==0)	dst[i>>3] =((src[i]&1)<<0);
		if((i&7)==1)	dst[i>>3]|=((src[i]&1)<<1);
		if((i&7)==2)	dst[i>>3]|=((src[i]&1)<<2);
		if((i&7)==3)	dst[i>>3]|=((src[i]&1)<<3);
		if((i&7)==4)	dst[i>>3]|=((src[i]&1)<<4);
		if((i&7)==5)	dst[i>>3]|=((src[i]&1)<<5);
		if((i&7)==6)	dst[i>>3]|=((src[i]&1)<<6);
		if((i&7)==7)	dst[i>>3]|=((src[i]&1)<<7);
	}
}

void convcharto2bit(int chr)
{
unsigned char *src=&chars[chr*64];
unsigned char *dst=&convchar[0];
int i;
	if(fat)
	{
    	for(i=0;i<64;i++)
    	{
    		if((i&7)==0)	dst[i>>3] =((src[i]&3)<<0);
    		if((i&7)==2)	dst[i>>3]|=((src[i]&3)<<2);
    		if((i&7)==4)	dst[i>>3]|=((src[i]&3)<<4);
    		if((i&7)==6)	dst[i>>3]|=((src[i]&3)<<6);
    	}
    }
    else
	{
    	for(i=0;i<64;i++)
    	{
    		if((i&3)==0)	dst[i>>2] =((src[i]&3)<<0);
    		if((i&3)==1)	dst[i>>2]|=((src[i]&3)<<2);
    		if((i&3)==2)	dst[i>>2]|=((src[i]&3)<<4);
    		if((i&3)==3)	dst[i>>2]|=((src[i]&3)<<6);
    	}
    }
}

void convcharto4bit(int chr)
{
unsigned char *src=&chars[chr*64];
unsigned char *dst=&convchar[0];
int i;
	if(fat)
	{
     	for(i=0;i<64;i++)
      	{
    		if((i&3)==0)	dst[i>>2] =((src[i]&15)<<0);
    		if((i&3)==2)	dst[i>>2]|=((src[i]&15)<<4);
    	}
    }
    else
	{
     	for(i=0;i<64;i++)
      	{
    		if((i&1)==0)	dst[i>>1] =((src[i]&15)<<0);
    		if((i&1)==1)	dst[i>>1]|=((src[i]&15)<<4);
    	}
     }
}

void convcharto8bit(int chr)
{
unsigned char *src=&chars[chr*64];
unsigned char *dst=&convchar[0];
int i;
	for(i=0;i<64;i++)
	{
		dst[i]=src[i];
	}
}

void getcharacter(int x,int y)
{
int xx,yy,i,j;
    currentattr=0;
	for(yy=0;yy<8;yy++)
	{
		for(xx=0;xx<8;xx++)
		{
			charcell[yy*8+xx]=screen[(((y*8)+yy)*scrwidth)+((x*8)+xx)];
			if(charcell[yy*8+xx]&paland)
			{
				currentattr=( ( charcell[yy*8+xx] & paland ) >> palshift );
			}
			charcell[yy*8+xx]&=charand;
		}
	}

    if(repeatable)
    {
    	j=0;
    	for(i=0;i<charnum;i++)
    	{
    		j=1;
    		currentattr=(currentattr&0x3c00)+i;
    		for(xx=0;xx<64;xx++)
    		{
    			if(chars[(i*64)+xx]!=charcell[xx])	{xx=64;j=0;}
    		}
    		if(flipable)
    		{
        		if(j==0)
        		{
        			j=1;
        			currentattr=(currentattr&0x3fff)|0x8000;
        			for(yy=0;yy<8;yy++)
        			{
        				for(xx=0;xx<8;xx++)
        				{
        					if(chars[(i*64)+(yy*8)+xx]!=charcell[(yy*8)+(7-xx)])	{xx=8;yy=8;j=0;}
        				}
        			}
        		}
        		if(j==0)
        		{
        			j=1;
        			currentattr=(currentattr&0x3fff)|0x4000;
        			for(yy=0;yy<8;yy++)
        			{
        				for(xx=0;xx<8;xx++)
        				{
        					if(chars[(i*64)+(yy*8)+xx]!=charcell[((7-yy)*8)+xx])	{xx=8;yy=8;j=0;}
        				}
        			}
        		}
        		if(j==0)
        		{
        			j=1;
        			currentattr=(currentattr&0x3fff)|0xc000;
        			for(yy=0;yy<8;yy++)
        			{
        				for(xx=0;xx<8;xx++)
        				{
        					if(chars[(i*64)+(yy*8)+xx]!=charcell[((7-yy)*8)+(7-xx)])	{xx=8;yy=8;j=0;}
        				}
        			}
        		}
            }
    		if(j==1)
    		{
    			i=charnum;
    		}
    	}
    	if(j==0)
    	{
    		currentattr=(currentattr&0x3c00)+charnum;
    		for(i=0;i<64;i++)	chars[(charnum*64)+i]=charcell[i];
    		charnum++;
    	}
//    	charmap[(y*(scrwidth>>3))+x]=currentattr;
    }
    else
    {
    	for(i=0;i<64;i++)	chars[(charnum*64)+i]=charcell[i];
    	currentattr=(currentattr&0x3c00)+charnum;
     	charnum++;
    }
}

void get4x8character(int x,int y)
{
int xx,yy,i,j;
    currentattr=0;
	for(yy=0;yy<8;yy++)
	{
		for(xx=0;xx<4;xx++)
		{
			charcell[yy*8+xx]=proppal[screen[(((y*8)+yy)*scrwidth)+((x*4)+xx)]];
			if(charcell[yy*8+xx]&paland)
			{
				currentattr=( ( charcell[yy*8+xx] & paland ) >> palshift );
			}
			charcell[yy*8+xx]&=charand;
			charcell[yy*8+xx+4]=0;
		}
	}

    if(repeatable)
    {
    	j=0;
    	for(i=0;i<charnum;i++)
    	{
    		j=1;
    		currentattr=(currentattr&0x3c00)+i;
    		for(xx=0;xx<64;xx++)
    		{
    			if(chars[(i*64)+xx]!=charcell[xx])	{xx=64;j=0;}
    		}
			if(j==1)
    		{
    			i=charnum;
    		}
    	}
    	if(j==0)
    	{
    		currentattr=(currentattr&0x3c00)+charnum;
    		for(i=0;i<64;i++)	chars[(charnum*64)+i]=charcell[i];
    		charnum++;
    	}
    }
    else
    {
    	for(i=0;i<64;i++)	chars[(charnum*64)+i]=charcell[i];
    	currentattr=(currentattr&0x3c00)+charnum;
     	charnum++;
    }
}

void getblock(int x,int y)
{
int i,j,xx,yy;
    for(yy=0;yy<blockmapsize;yy++)
    {
        for(xx=0;xx<blockmapsize;xx++)
        {
        	getcharacter(x*blockmapsize+xx,y*blockmapsize+yy);
            blockcell[yy*blockmapsize+xx]=currentattr;
        }
    }
	currentblock=blocknum;
	for(i=0;i<blocknum;i++)
	{
        j=1;
        for(xx=0;xx<blocksize;xx++)
        {
            if(blocks[i*blocksize+xx]!=blockcell[xx])
            j=0;
        }
		if(j==1)
		{
			currentblock=i;
			i=blocknum;
		}
	}
	if(currentblock==blocknum)
	{
        for(xx=0;xx<blocksize;xx++)
        {
            blocks[blocknum*blocksize+xx]=blockcell[xx];
        }
		blocknum++;
	}
	blockmap[y*(scrwidth/(blockmapsize*8))+x]=currentblock;
}

int jcmp(char *s1,char *s2)
{
	while(*s1 && *s2)
	{
		if(*s1 != *s2)	return 0;
		s1++;
		s2++;
	}
	if(*s1==0 && *s2==0) return 1;
	return 0;
}

void getcharfile(char *file)
{
unsigned char buf[64];
unsigned char pix;
int i,x,y;
FILE *f;
unsigned int div;
unsigned int len;
unsigned int xwidth;
    printf("Opening File '%s'\n",file);
    f=fopen(file,"rb");
    if(f==NULL) {printf("Can't open '%s'\n",file);return;}
    fseek(f,0,SEEK_END);
    len=ftell(f);
    fseek(f,0,SEEK_SET);
    div=0;
    if(mode==charmap2) {div=8;}
    if(mode==charmap4) {div=16;}
    if(mode==charmap16) {div=32;}
    if(mode==charmap256) {div=64;}
    if(mode==VGAchars4x8) {div=64;}
    if(fat) div=div/2;
    xwidth=8;
    if(fat) xwidth=4;
    if(div==0) {fclose(f);return;}
    printf("Reading %d Chars\n",len/div);
    charnum=len/div;
    for(i=0;i<charnum;i++)
    {
        fread(buf,1,div,f);
        for(y=0;y<8;y++)
        {
            for(x=0;x<xwidth;x++)
            {
                if(mode==charmap2)
                {
                    pix=(buf[y]>>(7-x))&1;
                }
                if(mode==charmap4)
                {
                    if(fat)
                        pix=(buf[y]>>(6-((x&3)*2)))&3;
                    else
                        pix=(buf[y*2+1-(x>>2)]>>(6-((x&3)*2)))&3;
                }
                if(mode==charmap16)
                {
                    if(fat)
                        pix=(buf[y*2+1-(x>>1)]>>(4-((x&1)*4)))&15;
                    else
                        pix=(buf[y*4+3-(x>>1)]>>(4-((x&1)*4)))&15;
                }
                if(mode==charmap256)
                {
                    pix=buf[y*8+x];
                }
                if(mode==VGAchars4x8)
                {
			        pix=buf[y*4+x];
			 	}
                chars[i*64+y*8+7-x]=pix;
            }
            if(fat)
            {
                chars[i*64+y*8+0]=chars[i*64+y*8+4];
                chars[i*64+y*8+1]=chars[i*64+y*8+4];
                chars[i*64+y*8+2]=chars[i*64+y*8+5];
                chars[i*64+y*8+3]=chars[i*64+y*8+5];
                chars[i*64+y*8+4]=chars[i*64+y*8+6];
                chars[i*64+y*8+5]=chars[i*64+y*8+6];
                chars[i*64+y*8+6]=chars[i*64+y*8+7];
                chars[i*64+y*8+7]=chars[i*64+y*8+7];
            }
        }
    }
    fclose(f);
}
int main(int c,char **s)
{
unsigned char palbuf[256*4];
int i,j,x,y,w,h,xx,yy;
int bytesize,byteand,byteshift,byteout;
FILE *f;
int getcharfileindex=0;

    doingvga=0;
    justcharmap=0;
    blocknum=0;
    charnum=0;
    blocksize=1;
    blockmapsize=1;
	charnum=0;
	blocknum=0;
    yfirst=0;
    fat=0;

    if(c<2)
    {
        printf("bmp8toLite.exe (C) 2009 Jim Bagley\n");
        printf("usage :-\n");
        printf("bmp8toLite.exe Filename <-options>\n");
        printf("Filename is without the '.bmp' extension\n");
        printf("-vga            use VGA colours for the palette\n");
        printf("-novga          don't use VGA colours for the palette\n");
        printf("-c64s           Grab C64 sprites, C64 sprites are 24x21, it will grab the size of the bmp\n");
        printf("                C64 sprites can be either fat pixel(4colour) or fine pixel(2colour)\n");
        printf("-c64bitmap2     Grab a C64 2 colour mode bitmap image\n");
        printf("-c64bitmap4     Grab a C64 4 colour mode bitmap image ( fat pixels )\n");
        printf("-amsbitmap4     Grab Amstrad 4 colour bitmap mode ( fine pixels )\n");
        printf("-amsbitmap16    Grab Amstrad 16 colour bitmap mode ( fat pixels )\n");
        printf("-bitmap2        Grab screen as 1bit ( 2 colour with attributes ) bitmap\n");
        printf("-bitmap4        Grab screen as 2bit ( 4 colour with attributes ) bitmap\n");
        printf("-bitmap16       Grab screen as 4bit ( 16 colour with attributes ) bitmap\n");
        printf("-bitmap256      Grab screen as 8bit ( 256 colour ) bitmap\n");
        printf("-charmap2       Grab screen as 1bit ( 2 colour with attributes ) character map\n");
        printf("-charmap4       Grab screen as 2bit ( 4 colour with attributes ) character map\n");
        printf("-charmap16      Grab screen as 4bit ( 16 colour with attributes ) character map\n");
        printf("-charmap256     Grab screen as 8bit ( 256 colour ) character map\n");
        printf("-vga4x8         ???\n");
        printf("-c64charmap4    Grab screen as 2bit fat pixel ( 4 colour with attributes ) character map\n");
        printf("-amscharmap16   Grab screen as 4bit fat pixel ( 16 colour with attributes ) character map\n");
        printf("-invx           Invert X pixel order per byte\n");
//        printf("-flip           Turns on Character repeat check and flip  checking for X and Y flippable characters\n");
        printf("-rpt            Turns on Character repeat check, for maps, ie doesn't store same character twice.\n");
        printf("-repeat         same as -rpt.\n");
        printf("-repeatable     same as -rpt.\n");
        printf("-1x1            Sets blocks to 1x1 (8x8 pixels) for charmap grabbing.\n");
        printf("-2x2            Sets blocks to 2x2 (16x16 pixels) for charmap grabbing.\n");
        printf("-4x4            Sets blocks to 4x4 (32x32 pixels) for charmap grabbing.\n");
        printf("-8x8            Sets blocks to 8x8 (64x64 pixels) for charmap grabbing.\n");
        printf("-yfirst         Sets Y grab first for map layout\n");
        printf("-xfirst         Sets X grab first for map layout (default)\n");
        printf("-invx           inverts the pixel order in a byte for spectrum and fast spectrum\n");
        printf("-nopal          Don't save palette in 8bit mode, use real colour values\n");
        printf("-2600           Grab a 2600 style background\n");
        printf("-using          grab chars from screen, but using a file as a base font\n");
    }

    while(c>2)
    {
		     if(jcmp(s[c-1],"-vga"))         {doingvga=1;c--;}
		else if(jcmp(s[c-1],"-novga"))       {doingvga=0;c--;}
		else if(jcmp(s[c-1],"-c64s"))        {mode=C64sprites;ext=extjcs;charand=1;paland=0xfe;palshift=1;c--;}
		else if(jcmp(s[c-1],"-c64bitmap2"))  {mode=C64bitmap2;ext=extcb2;charand=1;paland=0xfe;palshift=1;c--;}
		else if(jcmp(s[c-1],"-c64bitmap4"))  {mode=C64bitmap4;ext=extcb4;charand=3;paland=0xfc;palshift=2;c--;}
		else if(jcmp(s[c-1],"-amsbitmap4"))  {mode=AMSbitmap4;ext=extab4;charand=3;paland=0xfc;palshift=2;c--;}
		else if(jcmp(s[c-1],"-amsbitmap16")) {mode=AMSbitmap16;ext=exta16;charand=15;paland=0xf0;palshift=4;c--;}
		else if(jcmp(s[c-1],"-bitmap2"))	 {mode=bitmap2;ext=extbm2;charand=1;paland=0xfe;palshift=1;c--;}
		else if(jcmp(s[c-1],"-bitmap4"))	 {mode=bitmap4;ext=extbm4;charand=3;paland=0xfc;palshift=2;c--;}
		else if(jcmp(s[c-1],"-bitmap16"))	 {mode=bitmap16;ext=extb16;charand=15;paland=0xfe;palshift=4;c--;}
		else if(jcmp(s[c-1],"-bitmap256"))	 {mode=bitmap256;ext=extb8b;charand=255;paland=0;palshift=0;c--;}
		else if(jcmp(s[c-1],"-charmap2"))	 {mode=charmap2;ext=extjb2;charand=1;paland=0xfe;palshift=1;c--;}
		else if(jcmp(s[c-1],"-charmap4"))	 {mode=charmap4;ext=extjb4;charand=3;paland=0xfc;palshift=2;c--;}
		else if(jcmp(s[c-1],"-charmap16"))	 {mode=charmap16;ext=extj16;charand=15;paland=0xf0;palshift=4;c--;}
		else if(jcmp(s[c-1],"-charmap256"))	 {mode=charmap256;ext=extj8b;charand=255;paland=0;palshift=0;c--;}
		else if(jcmp(s[c-1],"-vga4x8"))		 {mode=VGAchars4x8;ext=extj8b;charand=255;paland=0;palshift=0;c--;fat=1;doingvga=1;repeatable=1;nopalette=1;justcharmap=1;blockmapsize=1;blocksize=1;}
		else if(jcmp(s[c-1],"-c64charmap4")) {mode=charmap4;ext=extjb4;charand=3;paland=0xfc;palshift=2;c--;fat=1;}
		else if(jcmp(s[c-1],"-amscharmap16")){mode=charmap16;ext=extj16;charand=15;paland=0xf0;palshift=4;c--;fat=1;}
		else if(jcmp(s[c-1],"-flip"))        {repeatable=1;flipable=1;c--;}
		else if(jcmp(s[c-1],"-flipable"))    {repeatable=1;flipable=1;c--;}
		else if(jcmp(s[c-1],"-norpt"))       {repeatable=0;c--;}
		else if(jcmp(s[c-1],"-norepeat"))    {repeatable=0;c--;}
		else if(jcmp(s[c-1],"-notrepeatable")) {repeatable=0;c--;}
		else if(jcmp(s[c-1],"-rpt"))         {repeatable=1;c--;}
		else if(jcmp(s[c-1],"-repeat"))      {repeatable=1;c--;}
		else if(jcmp(s[c-1],"-repeatable"))  {repeatable=1;c--;}
		else if(jcmp(s[c-1],"-1x1"))         {justcharmap=1;blockmapsize=1;blocksize=1;c--;}
		else if(jcmp(s[c-1],"-2x2"))         {justcharmap=0;blockmapsize=2;blocksize=4;c--;}
		else if(jcmp(s[c-1],"-4x4"))         {justcharmap=0;blockmapsize=4;blocksize=16;c--;}
		else if(jcmp(s[c-1],"-8x8"))         {justcharmap=0;blockmapsize=8;blocksize=64;c--;}
		else if(jcmp(s[c-1],"-yfirst"))      {yfirst=1;c--;}
		else if(jcmp(s[c-1],"-xfirst"))      {yfirst=0;c--;}
		else if(jcmp(s[c-1],"-invx"))        {invx=(1-invx)&1;c--;}
		else if(jcmp(s[c-1],"-nopal"))       {nopalette=1;c--;}
		else if(jcmp(s[c-1],"-pal16"))       {pal16=1;c--;}
		else if(jcmp(s[c-1],"-2600"))        {getting_2600=1;c--;}
		else if(jcmp(s[c-2],"-using"))       {getcharfileindex=c-1;c-=2;}
		else if(jcmp(s[c-2],"-fat"))       	 {fat=1;}
		else {printf("Unknown option '%s'\n",s[c-1]);exit(1);}
    }
	if(c!=2)
	{
		printf("exename filename\n");
		exit(0);
	}
	if(getcharfileindex)
    {
        getcharfile(s[getcharfileindex]);
    }
	setuppropcolours();

	sprintf(fname,"%s.bmp",s[1]);
	f=fopen(fname,"rb");
	if(f!=NULL)
	{
		fread(header,0x36,1,f);
		scrwidth=header[9];
		scrheight=header[11];
		printf("w=%d\nh=%d\n",scrwidth,scrheight);
		fread(palbuf,256,4,f);
		for(i=0;i<256;i++)
		{
			proppal[i]=getpixelcolour(palbuf[i*4+0],palbuf[i*4+1],palbuf[i*4+2]);
		}

		fseek(f,header[5],SEEK_SET);
		for(i=0;i<scrheight;i++)
		{
			fread(&screen[((scrheight-1)-i)*scrwidth],scrwidth,1,f);
		}
		fclose(f);

        if(getting_2600)
        {
    		sprintf(fname,"%s.VCS",s[1]);
    		f=fopen(fname,"wb");
    		if(f!=NULL)
    		{
                int xstp=scrwidth/40;
                int border=0;
                for(y=0;y<scrheight;y++)
                {
                    int background=screen[y*scrwidth];
                    int foreground=0;
                    byteout=0;
                    for(xx=x=0;x<scrwidth;x+=xstp,xx++)
                    {
                        byteout<<=1;
                        if(screen[y*scrwidth+x]!=background) {byteout+=1;foreground=screen[y*scrwidth+x];}
                        if((xx&7)==7)
                            fwrite(&byteout,1,1,f);
                    }
                    if(palbuf[background*4+0]==255 && palbuf[background*4+1]==0 && palbuf[background*4+2]==255)
                    {
                        background=0;
                        fwrite(&background,1,1,f);
                        fwrite(&background,1,1,f);
                        fwrite(&proppal[border],1,1,f);
                    }
                    else
                    {
                        fwrite(&proppal[background],1,1,f);
                        fwrite(&proppal[foreground],1,1,f);
                        fwrite(&proppal[border],1,1,f);
                    }
                }
                fclose(f);
            }
            exit(0);
        }

        if(justcharmap==0)
        {
			for(y=0;y<(scrheight/(blockmapsize*8));y++)
			{
				for(x=0;x<(scrwidth/(blockmapsize*8));x++)
				{
					getblock(x,y);
				}
			}
			printf("block map size = ( %d,%d )\nBlocks Used = %d\nChars Used = %d\n",scrwidth/(blockmapsize*8),scrheight/(blockmapsize*8),blocknum,charnum);
        }
        else
        {
		 	if(mode==VGAchars4x8)
		 	{
	   	    	for(y=0;y<(scrheight/8);y++)
	     		{
			    	for(x=0;x<(scrwidth/4);x++)
	       			{
	                    get4x8character(x,y);
	    				charmap[(y*(scrwidth/4))+x]=currentattr;
//		    			printf("%02x,",currentattr);
	    			}
//		    		printf("\n");
	            }
	        }
	        else
		 	{
	   	    	for(y=0;y<(scrheight/8);y++)
	     		{
			    	for(x=0;x<(scrwidth/8);x++)
	       			{
	                    getcharacter(x,y);
	    				charmap[(y*(scrwidth/8))+x]=currentattr;
//		    			printf("%02x,",currentattr);
	    			}
//		    		printf("\n");
	            }
	        }
		}
		if( mode>=charmap2 && mode<=charmap256 )
    		printf("Char map size = ( %d,%d )\nChars Used = %d\n",scrwidth/8,scrheight/8,charnum);
		if( mode==VGAchars4x8 )
    		printf("Char map size = ( %d,%d )\nChars Used = %d\n",scrwidth/4,scrheight/8,charnum);

        if(nopalette==0)
        {
    		sprintf(fname,"%s.pal",s[1]);
    		f=fopen(fname,"wb");
    		if(f!=NULL)
    		{
                if(pal16)
                    fwrite(proppal,16,1,f);
                else
                    fwrite(proppal,256,1,f);
                fclose(f);
            }
        }

        if(mode!=C64sprites && repeatable!=0)
        {
            if(justcharmap)
            {
        		sprintf(fname,"%s.map",s[1]);
        		f=fopen(fname,"wb");
        		if(f!=NULL)
        		{
		 		    if(mode==VGAchars4x8)
		 		    {
	                    if(yfirst==0)
	                    {
	                        fwrite(charmap,scrheight/8,(scrwidth/4)*2,f);
	                    }
	                    else
	                    {
	          				for(x=0;x<(scrwidth/(blockmapsize*4));x++)
	            			{
	                			for(y=0;y<(scrheight/(blockmapsize*8));y++)
	            				{
	                                fwrite(&charmap[y*(scrwidth/(blockmapsize*4))+x],1,2,f);
	                            }
	                        }
	                    }
                    }
                    else
                    {
	                    if(yfirst==0)
	                    {
	                        fwrite(charmap,scrheight/8,(scrwidth/8)*2,f);
	                    }
	                    else
	                    {
	          				for(x=0;x<(scrwidth/(blockmapsize*8));x++)
	            			{
	                			for(y=0;y<(scrheight/(blockmapsize*8));y++)
	            				{
	                                fwrite(&charmap[y*(scrwidth/(blockmapsize*8))+x],1,2,f);
	                            }
	                        }
	                    }
                    }
                    fclose(f);
                }
            }
            else
            {
        		sprintf(fname,"%s.mpb",s[1]);
        		f=fopen(fname,"wb");
        		if(f!=NULL)
        		{
                    if(yfirst==0)
                    {
                        fwrite(blockmap,scrheight/(blockmapsize*8),(scrwidth/(blockmapsize*8))*2,f);
                    }
                    else
                    {
           				for(x=0;x<(scrwidth/(blockmapsize*8));x++)
            			{
                			for(y=0;y<(scrheight/(blockmapsize*8));y++)
            				{
                                fwrite(&blockmap[y*(scrwidth/(blockmapsize*8))+x],1,2,f);
                            }
                        }
                    }
                    fclose(f);
                }
        
        		sprintf(fname,"%s.blx",s[1]);
        		f=fopen(fname,"wb");
        		if(f!=NULL)
        		{
                    fwrite(blocks,blocknum,blocksize*2,f);
                    fclose(f);
                }
            }
        }
        
//		sprintf(fname,"%s.%s",s[1],ext);
		if( (mode>=charmap2 && mode<=charmap256 ) || mode==VGAchars4x8)
		{
    		sprintf(fname,"%s.chr",s[1]);
        }
        else if(mode==C64sprites)
        {
    		sprintf(fname,"%s.JCS",s[1]);
        }
        else if( (mode>=bitmap2 && mode<=AMSbitmap16 ) )
        {
    		sprintf(fname,"%s.bit",s[1]);
        }
        else
        {
            printf("Don't know Graphics mode :(\n");
            return 0;
        }
		f=fopen(fname,"wb");
		if(f!=NULL)
		{
			if( (mode>=charmap2 && mode<=charmap256) || mode==VGAchars4x8 )
			{
				for(i=0;i<charnum;i++)
				{
					if(mode==charmap2)		{convcharto1bit(i);fwrite(convchar,1,fat?4:8,f);}
					if(mode==charmap4)		{convcharto2bit(i);fwrite(convchar,2,fat?4:8,f);}
					if(mode==charmap16)		{convcharto4bit(i);fwrite(convchar,4,fat?4:8,f);}
					if(mode==charmap256)	{convcharto8bit(i);fwrite(convchar,8,fat?4:8,f);}
					if(mode==VGAchars4x8)
					{
				 	    convcharto8bit(i);
				 	    for(y=0;y<8;y++)
				 	        for(x=0;x<4;x++)
			                    fwrite(&convchar[y*8+x],1,1,f);
				    }
				}
			}
			if( (mode>=bitmap2 && mode<=AMSbitmap16 ) )
			{
				if(mode==C64bitmap2) {bytesize=8;byteand=  1;byteshift=1;fat=0;}
				if(mode==C64bitmap4) {bytesize=4;byteand=  3;byteshift=2;fat=1;}
				if(mode==AMSbitmap4) {bytesize=4;byteand=  3;byteshift=2;fat=0;}
				if(mode==AMSbitmap16){bytesize=2;byteand= 15;byteshift=4;fat=1;}
				if(mode==bitmap2)	 {bytesize=8;byteand=  1;byteshift=1;fat=0;}
				if(mode==bitmap4)	 {bytesize=4;byteand=  3;byteshift=2;fat=0;}
				if(mode==bitmap16)	 {bytesize=2;byteand= 15;byteshift=4;fat=0;}
				if(mode==bitmap256)	 {bytesize=1;byteand=255;byteshift=0;fat=0;}
				for(y=0;y<scrheight;y++)
				{
					for(x=0;x<scrwidth/(bytesize*(1+fat));x++)
					{
						byteout=0;
						for(xx=0;xx<bytesize;xx++)
						{
                            if(invx)
                            {
							    byteout+=(screen[(y*scrwidth)+(((x*bytesize)+xx)*(1+fat))]&byteand)<<(xx*byteshift);
                            }
                            else
                            {
							    byteout+=(screen[(y*scrwidth)+(((x*bytesize)+xx)*(1+fat))]&byteand)<<(((bytesize-1)-xx)*byteshift);
                            }
						}
						if(nopalette) byteout=proppal[byteout];
						fwrite(&byteout,1,1,f);
					}
				}
			}

			if(mode==C64sprites)
			{
				for(y=0;y<scrheight;y+=21)
				{
					for(x=0;x<scrwidth;x+=24)
					{
                        byteand=1;byteshift=1;
                        j=0;
						for(yy=0;yy<21;yy++)
						{
       					    for(xx=0;xx<24;xx++)
			     			{
                                if((screen[((y+yy)*scrwidth)+(x+xx)]&3)>1)
                                {
                                    byteand=3;byteshift=2;
                                    j=1;
                                    xx=24;yy=21;
                                }
                            }
                        }
						for(yy=0;yy<21;yy++)
						{
       					    for(xx=0;xx<24;xx+=byteshift)
			     			{
                                if((xx&7)==0) byteout=0;
				    			byteout+=((screen[((y+yy)*scrwidth)+(x+xx)]&byteand)<<((8-byteshift)-(xx&7)));
				    			if((xx&7)==(8-(byteshift)))
                                {
                                    fwrite(&byteout,1,1,f);
                                }
					      	}
                        }
                        byteout=0;
                        fwrite(&byteout,1,1,f); // to keep nice round 64bytes per sprite :)
					}
				}
			}

			fclose(f);
		}
		else
		{
			printf("Error Creating '%s'\n",fname);
		}
	}
    else
	{
		printf("Error Opening '%s'\n",fname);
	}
	return 0;
}

