{{
TV   256 x 200
}}

PUB start(params) | i, j, k

'Fire off the video COG, with a pointer to it's HUB lineRAM buffer, and start up values.

  cognew(@cogstart,params)


DAT

                        ORG     0
cogstart

'--------------------------------------------------------------------
' Fetch startup pointers from HUB
' Init COG PLL and Video Generator Hardware
'--------------------------------------------------------------------
                        mov       t1,par               'PAR -->@VGA_PARAMS   Written to communicate display status
                        add       t1,#24
                        rdlong    VCFG, t1              ' baseband composite mode w/ 2bpp color on appropriate pins
                        add       t1,#4
                        rdlong    CTRA, t1              ' internal PLL mode, PLLA = 16*colorburst frequency
                        add       t1,#4
                        rdlong    FRQA, t1              ' 2*colorburst frequency
                        add       t1,#4
                        rdlong    DIRA, t1              ' enable output on appropriate pins
                        add       t1,#4
                        rdlong    lnram,t1              ' pixel ram

'-------------------------------------------------------------
' Start of video signal!  Vertical Blanking first, Frame 0
'-------------------------------------------------------------
mainloop                MOV     numline, #9             ' 9 lines of vsync
vsync0                  CMP     numline, #6     WZ      ' lines 4,5,6 serration pulses
              IF_NZ     CMP     numline, #5     WZ      ' lines 1,2,3 / 7,8,9 equalizing pulses
              IF_NZ     CMP     numline, #4     WZ
                        MOV     count, #2               ' 2 pulses per line
half         IF_NZ      MOV     VSCL, vscleqal          ' equalizing pulse (short)
              IF_Z      MOV     VSCL, vsclselo          ' serration pulse (long)
                        WAITVID sync, #0                ' -40 IRE

'--------------------------------------------------------------------
' Fetch pointers and data from HUB
' Do this first
'--------------------------------------------------------------------
tasks
              mov       t1,par               'PAR -->@VGA_PARAMS
              add       t1,#4
              rdlong    pixelbase,t1         'contents of par+4 --> pixelbase
              add       t1,#4
              rdlong    nextlineptr,t1
              add       t1,#4
              rdlong    _enable,t1
              add       t1,#4
              rdlong    cogcount,t1
              sub       cogcount,#1



              IF_NZ     MOV     VSCL, vscleqhi          ' equalizing pulse (long)
              IF_Z      MOV     VSCL, vsclsync          ' serration pulse (short)
                        WAITVID sync, blank             ' 0 IRE
                        DJNZ    count, #half
                        DJNZ    numline, #vsync0

'----------------------------------------------------------------
' Communicate display state to render COG
' Begin of frame (field)
'----------------------------------------------------------------

field                   wrlong  visible,par             'set status to visible

                        mov     t1,par
                        add     t1,#4               'get pointer to line buffer
                        mov     linenum,#0          'clear cog line counter
                        mov     cogline,#0          'clear cog line counter
                        mov     pixelptr,pixelbase

                        MOV     numline, #20            ' 20 blank lines
blank0                  MOV     VSCL, vsclsync
                        WAITVID sync, #0                ' -40 IRE
                        MOV     VSCL, vsclblnk
                        WAITVID sync, blank             ' 0 IRE
                        DJNZ    numline, #blank0



'-------------------------------------------------------------
' Begin active video, frame 0
' HBLANK, CBURST, Back Porch, set tv actv flag
'-------------------------------------------------------------
                        MOV     numline, #241 -41         ' 241 lines of active video
active0                 MOV     VSCL, vsclsync          ' horizontal sync (0H)

'---------------------------------------------------------


                        WAITVID sync, #0                ' -40 IRE
                        MOV     VSCL, vscls2cb          ' 5.3us 0H to burst
                        WAITVID sync, blank

                        MOV     VSCL, vsclbrst          ' 9 cycles of colorburst

                        cmp     no_burst, #0    wz      ' Monochrome signal?
             if_NZ      WAITVID sync, blank             ' No?  Output color burst
             if_Z       WAITVID sync, burst             ' Yes?  No color burst

                        MOV     VSCL, vsclbp            ' backporch 9.2us OH to active video
                        WAITVID sync, blank



'-------------------------------------------------------------
' Screen graphics happen here frame 0
' This is the only frame code running for non-interlaced display
' For interlaced display, this code draws even numbered scanlines
'-------------------------------------------------------------
                        MOV     count, numwtvd          ' number of WAITVIDs
                        MOV     VSCL, vsclactv          ' PLLA per pixel, 4 pixels per frame

                        mov   pixelpush,pixelptr
                        add   pixelptr,#4

:loop                  rdlong pixels,pixelptr                                   'get pixels from line buffer
                       'waitvid test_freaking_pixels ,#%%3210        'draw them to VGA screen
                       'or    pixels,coloror
                       waitvid pixels, #%%3210
                       add   pixelptr,#4                                        'next set of pixels

                        DJNZ    count, #:loop

                        mov   pixelptr,pixelpush




'-------------------------------------------------------------
' Enter Front Porch
'-------------------------------------------------------------
fp0                     MOV     VSCL, vsclfp            ' front porch 1.5us
                        WAITVID sync, blank

                        wrlong  invisible,par

                        wrlong  linenum,nextlineptr      'update scan line complete  (writes number DONE)
                        add     linenum,#1               'prep for next scan line write

                        add     pixelptr,#256+8          'point to next scan line buffer
                        add     cogline,#1               'point to next render cog??
                        cmp     cogcount,cogline wc      'time to recycle cogs and buffers yet?
        if_c            mov     cogline,#0               'yes!  Set cogline to 0
        if_c            mov     pixelptr,pixelbase       'yes!  Set scan line buffer to first buffer.



                        DJNZ    numline, #active0

'--------------------------------------------------------------
' Do Bottom Border
'--------------------------------------------------------------
                        MOV     numline, #21            ' 12 blank lines
blank0b                  MOV     VSCL, vsclsync
                        WAITVID sync, #0                ' -40 IRE
                        MOV     VSCL, vsclblnk
                        WAITVID sync, blank             ' 0 IRE
                        DJNZ    numline, #blank0b



 '-------------------------------------------------------------
' End of frame 0, enable jump here for non-interlaced video
                        TJZ     no_interlace, #half_scan
                        JMP     #mainloop
'-------------------------------------------------------------



'-------------------------------------------------------------
' Output half a scan line required for interlaced display
'-------------------------------------------------------------
half_scan               MOV     VSCL, vsclsync          ' half line
                        WAITVID sync, #0                ' -40 IRE
                        MOV     VSCL, vsclselo
                        WAITVID sync, blank

'-------------------------------------------------------------
' Vertical Blanking, Frame 1
'-------------------------------------------------------------
                        MOV     numline, #9             ' 9 lines of vsync (again)
vsync1                  CMP     numline, #6     WZ      ' lines 4,5,6 serration pulses
              IF_NZ     CMP     numline, #5     WZ      ' lines 1,2,3 / 7,8,9 equalizing pulses
              IF_NZ     CMP     numline, #4     WZ
                        MOV     count, #2               ' 2 pulses per line
:half         IF_NZ     MOV     VSCL, vscleqal          ' equalizing pulse (short)
              IF_Z      MOV     VSCL, vsclselo          ' serration pulse (long)
                        WAITVID sync, #0                ' -40 IRE
'                        wrlong  two, tv_vblank          ' Vblank flag for graphics COG Frame 1
              IF_NZ     MOV     VSCL, vscleqhi          ' equalizing pulse (long)
              IF_Z      MOV     VSCL, vsclsync          ' serration pulse (short)
                        WAITVID sync, blank             ' 0 IRE
                        DJNZ    count, #:half
                        DJNZ    numline, #vsync1
'-------------------------------------------------------------
                        MOV     VSCL, vsclhalf          ' half line
                        WAITVID sync, blank             ' 0 IRE
                        MOV     numline, #13            ' 13 blank lines for this frame
blank1                  MOV     VSCL, vsclsync
                        WAITVID sync, #0                ' -40 IRE
                        MOV     VSCL, vsclblnk
                        WAITVID sync, blank             ' 0 IRE
                        DJNZ    numline, #blank1

'-------------------------------------------------------------
' Begin active video, frame 1
' HBLANK, CBURST, Back Porch
'-------------------------------------------------------------
                        MOV     numline, #240           ' 240 lines of active video (again)
active1                 MOV     VSCL, vsclsync          ' horizontal sync (0H)
                        'wrlong  one, tv_actv             'tell other image cogs pixels are being drawn
                        WAITVID sync, #0                ' -40 IRE
                        MOV     VSCL, vscls2cb          ' 5.3us 0H to burst
                        WAITVID sync, blank
                        MOV     VSCL, vsclbrst          ' 9 cycles of colorburst

                        cmp     no_burst, #0    wz      ' Monochrome signal?
             if_NZ      WAITVID sync, blank             ' No?  Output color burst
             if_Z       WAITVID sync, burst             ' Yes?  No color burst


                        MOV     VSCL, vsclbp            ' backporch 9.2us OH to active video
                        WAITVID sync, blank
                        'rdlong  two_colors, _two_colors              ' Set two color mode for no color cells

'-------------------------------------------------------------
' Set tv_actv flag
' Screen graphics happen here, frame 1
'-------------------------------------------------------------
                        MOV     count, numwtvd                                  ' number of WAITVIDs
                        MOV     index, lnram                                    ' point to HUB pixel RAM
                        'rdlong  indexa, clram                                   ' fetch color ram address from hub
                        sub     indexa, #2
                        MOV     VSCL, vsclactv                                  ' PLLA per pixel, 16 pixels per frame


:loop1                  RDlong  colors, index                                   ' get pixel data
                        ADD     index, #4                                       ' point to future pixels

                        'ADD     indexa, #2                                      ' point to future colors
                        'RDword  colors, indexa                                  ' get colors
                        WAITVID colors, #%%0123                                  ' Draw pixels on screen!
                        DJNZ    count, #:loop1
                        jmp     #fp1



'-------------------------------------------------------------
' Set 2bpp mode here for sync & Reset tv_actv flag
'-------------------------------------------------------------

fp1                     MOV     VSCL, vsclfp            ' front porch 1.5us
'                        wrlong  one, tv_actv             'tell other image cogs pixels are being drawn
                        WAITVID sync, blank
                        DJNZ    numline, #active1

'-------------------------------------------------------------
' End of frame 1, loop back and do it all again
'-------------------------------------------------------------
                        JMP     #mainloop

DAT
'-----------------------------------------------------
' Initalized Data
'-----------------------------------------------------

' Note: for NTSC the colors displayed depend on the phase wrt colorburst.
' Using a different color # for colorburst will cause the colors displayed
' to shift.  i.e. using color #0 for colorburst will cause color #0 to be
' yellow rather than blue.  Dynamic changes to the colorburst color # may
' require several frames for the TV to resynchronize.

sync                    LONG    $CA0200                                         ' %%0 = -40 IRE, %%1 = 0 IRE, %%2 = burst
blank                   LONG    %%1111_1111_1111_1111                           ' 16 pixels color 1
burst                   LONG    %%2222_2222_2222_2222                           ' 16 pixels color 1


vsclhalf                LONG    1<<12+1820                                      ' NTSC H/2
vsclsync                LONG    1<<12+269                                       ' NTSC sync = 4.7us
vsclblnk                LONG    1<<12+3371                                      ' NTSC H-sync
vsclselo                LONG    1<<12+1551                                      ' NTSC H/2-sync
vscleqal                LONG    1<<12+135                                       ' NTSC sync/2
vscleqhi                LONG    1<<12+1685                                      ' NTSC H/2-sync/2
vscls2cb                LONG    1<<12+304-269                                   ' NTSC sync to colorburst
vsclbrst                LONG    16<<12+16*9                                     ' NTSC 16 PLLA per cycle, 9 cycles of colorburst

'-------------------------------------------------------------
' Board Specific Parameters
'-------------------------------------------------------------
{
ivcfg                   LONG    prop#ivcfg
ictra                   LONG    prop#ictra
ifrqa                   LONG    prop#ifrqa
idira                   LONG    prop#idira                                      ' demoboard
}
lnram                   LONG    $c030                                           ' Address of HUB Pixel Ram


'---------------------------------
'  256 Pixel Setup
'---------------------------------                                           ' loaded just prior to drawing a scanline
vsclbp                  LONG    1<<12+312                                     ' NTSC back porch + overscan (213)
vsclactv                LONG    10<<12+40                                      ' 256 pixels
                                                                              '(2560 / (pixels))<<12 + (2560 / (pixels) * 4)
vsclfp                  LONG    1<<12+320                                     ' NTSC overscan (214) + front porch

'----------------------------------------------
' Display Signal Options
'----------------------------------------------
numwtvd                 LONG    64                                            ' Number of waitvids
no_burst                LONG    0                                               'Suppress color burst, if not zero
no_interlace            LONG    1                                               'Suppress interlace, if not zero

zero                    LONG    0
one                     LONG    1
two                     LONG    2
d1                      LONG    1<<9                    'destination = 1


invisible               long    1
visible                 long    2


test_freaking_pixels    long    $07040305
coloror                 long    $03030303

'-------------------------------------------------------------
' Uninitialized Working Longs and constants
'-------------------------------------------------------------

A                       res    1
numline                 res    1
count                   res    1
index                   res    1
indexa                  res    1

colors                  res    1                      'waitvid data
pixels                  res    1                      'waitvid data


'--------------------------------------------------------------
'  JB Specific stuff
'--------------------------------------------------------------

linenum                 res     1
pixelbase               res     1
pixelptr                res     1
pixelpush               res     1
cogline                 res     1
nextlineptr             res     1

_enable                 res     1               'enable
cogcount                res     1

t1                      res     1
t2                      res     1
t3                      res     1
