#ifndef PROPELLER
#define PROPELLER

#ifdef __cplusplus
extern "C" 
{
#endif

#include <stdint.h>

/* ZPU's libgloss uses syscall IDs 1 to 18, we stay well away from that range */
#define SYS_huballoc  30
#define SYS_hubfree   31
#define SYS_stopuart  32
#define SYS_cognew  8000
#define SYS_coginit 8001
#define SYS_cogstop 8002

#define CLKFREQ (*(uint32_t*) 0x10000000)

extern int clkfreq;

extern int _syscall(int *foo, int ID, ...);

extern int errno;

void* zalloc(int len);

void  zfree(void* ptr);

void longfill(int* dst, int fill, int count);

void longmove(int* dst, int* src, int count);

int cognew(int* code, int* par);

int cognewx(int* code, int* par, int parlen);

void cogstop(int cog);

#ifdef __cplusplus
}
#endif

#endif
