CON
  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

CON
  DelayTime = 10

CON
  Rows    = 13
  Columms = 40
  DisplayBufferSize = Rows * Columms

CON
  Key0 = 48  
  Key1 = 49  
  Key2 = 50  
  Key3 = 51  
  Key4 = 52  
  Key5 = 53  
  Key6 = 54  
  Key7 = 55  
  Key8 = 56  
  Key9 = 57  

CON
  X_Dir   = 16
  X_Pulse = 18

  Y_Dir   = 20
  Y_Pulse = 22

  OutPut = 1
  InPut  = 0

  high = 1
  low  = 0
  
  RewriteMenu = -1

CON
  X_Ref_Ini = 8
  Y_Ref_Ini = 9

  X_Ref_INI_On  = 1
  X_Ref_INI_Off = not X_Ref_INI_On 
  
  Y_Ref_INI_On  = 1
  Y_Ref_INI_Off = not Y_Ref_INI_On 
  
  Dir_towards_X_Ref_INI   = 0
  Dir_away_from_X_Ref_INI = not Dir_towards_X_Ref_INI 
  Dir_X_positive        = 1
  Dir_X_negative        = not Dir_X_positive 
  
  Dir_towards_Y_Ref_INI   = 0
  Dir_away_from_Y_Ref_INI = not Dir_towards_Y_Ref_INI 
  Dir_Y_positive        = 1
  Dir_Y_negative        = not Dir_Y_positive 

  XMin = 0
  XMax = 4
  
  YMin = 0
  YMax = 2

  StartStopSpeed_Time  = 50
  MaxSteps_Ref_Ini_Off = 5

CON
  ErrCode_X_Ref_not_switch_on  = 100
  ErrCode_X_Ref_not_switch_off = 101      

  ErrCode_Y_Ref_not_switch_on  = 200
  ErrCode_Y_Ref_not_switch_off = 201

OBJ
  PC_Text    : "PC_Text_advanced"
  PC_Keyb    : "PC_Keyboard"
  

VAR
  long KeyboardCode
     
PUB MainLoop | i, KeyCode

  'start ASM-Driver terminal in a cog
  PC_Text.start(31) 'rxpin, txpin rx/tx from the sight of the propellerchip. Propeller-rx <-----receive from PC, Propeller-tx -----> send to PC
  PC_Keyb.start(31,30)

  PC_Keyb.clearkeys
  i := 0
  repeat until (KeyCode == 115)
    if PC_Keyb.gotkey
      KeyCode := PC_Keyb.GetKey
    PC_Text.Writeln(string("wait for key S to start"))
    wait_MS(500)
    i := i + 1
    if i == 12
      i := 0
      PC_Text.ClearScreen

  PC_Text.ClearScreen
  
  KeyCode := 0
  PC_Keyb.clearkeys
  PC_Text.Writeln(string("waiting for commands"))
  DirA[X_Dir]   := OutPut
  DirA[X_Pulse] := OutPut

  DirA[Y_Dir]   := OutPut
  DirA[Y_Pulse] := OutPut
  
  KeyCode := RewriteMenu
  
  repeat
    'Menu for PUB MainLoop | i, KeyCode 
    if KeyCode == RewriteMenu
      PC_Text.ClearScreen    '1234567890123456789012345678901234567890
      PC_Text.Writeln(string("1.Toggle Steppermotorbits"))
      PC_Text.Writeln(string("2.Test Reference"))
      PC_Text.Writeln(string("9.Next Menu  0.End"))
      KeyCode := 0

    if PC_Keyb.gotkey
      KeyCode := PC_Keyb.GetKey

    case KeyCode
      Key0:
        PC_Text.Writeln(string("Key0"))
        KeyCode := RewriteMenu    
        
      Key1:
        PC_Text.Writeln(string("Key1"))
        ToggleStepperMotorBits
        KeyCode := RewriteMenu    
        
      Key2:
        PC_Text.Writeln(string("Key2"))
        TestReference
        KeyCode := RewriteMenu    
        
      Key3:
        PC_Text.Writeln(string("Key3"))
        KeyCode := RewriteMenu    
        
      Key4:
        PC_Text.Writeln(string("Key4"))
        KeyCode := RewriteMenu    
        
      Key5:
        PC_Text.Writeln(string("Key5"))
        KeyCode := RewriteMenu    
        
      Key6:
        PC_Text.Writeln(string("Key6"))
        KeyCode := RewriteMenu    
        
      Key7:
        PC_Text.Writeln(string("Key7"))
        KeyCode := RewriteMenu    
        
      Key8:
        PC_Text.Writeln(string("Key9"))
        KeyCode := RewriteMenu    
        
      Key9:
        PC_Text.Writeln(string("Key9"))
        KeyCode := RewriteMenu    
       
    
PUB ToggleStepperMotorBits | KeyCode

  KeyCode := RewriteMenu
  repeat until KeyCode == Key0
    'Menu for PUB ToggleStepperMotorBits | KeyCode
    if KeyCode == RewriteMenu
      PC_Text.ClearScreen    '1234567890123456789012345678901234567890
      PC_Text.Writeln(string("1.X_Dir  2.X_Pulse   3.Y_Dir  4.Y_Pulse"))
      PC_Text.Writeln(string("9.Next Menu  0.back"))
      KeyCode := 0    

    if PC_Keyb.gotkey
      KeyCode := PC_Keyb.GetKey

    case KeyCode
      Key0:
        PC_Text.Writeln(string("Key0"))
        
      Key1:
        PC_Text.Writeln(string("Key1"))
        !OutA[X_Dir]
        KeyCode := RewriteMenu    
        
      Key2:
        PC_Text.Writeln(string("Key2"))
        !OutA[X_Pulse]
        KeyCode := RewriteMenu    
        
      Key3:
        PC_Text.Writeln(string("Key3"))
        !OutA[Y_Dir]
        KeyCode := RewriteMenu    
        
      Key4:
        PC_Text.Writeln(string("Key4"))
        !OutA[Y_Pulse]
        KeyCode := RewriteMenu    
        
      Key5:
        PC_Text.Writeln(string("Key5"))
        KeyCode := RewriteMenu    
        
      Key6:
        PC_Text.Writeln(string("Key6"))
        KeyCode := RewriteMenu    
        
      Key7:
        PC_Text.Writeln(string("Key7"))
        KeyCode := RewriteMenu    
        
      Key8:
        PC_Text.Writeln(string("Key9"))
        KeyCode := RewriteMenu    
        
      Key9:
        PC_Text.Writeln(string("Key9"))
        KeyCode := RewriteMenu    

  KeyCode := RewriteMenu                 'if loop is left Prg returns to upper menu  


PUB TestReference | KeyCode, ErrCode, i
  ErrCode := 0
  KeyCode := RewriteMenu 

  repeat until KeyCode == Key0
    if KeyCode == RewriteMenu
      PC_Text.ClearScreen    '1234567890123456789012345678901234567890
      PC_Text.Writeln(string("1.X_Ref towards  2.X_Ref back until off"))
      PC_Text.Writeln(string("3.Y_Ref towards  4.Y_Ref back until off"))
      PC_Text.Writeln(string("5.Show DirBitValues"))
         
      PC_Text.Writeln(string("9.Next Menu  0.back"))
      KeyCode := 0    

    'ShowIO
       
    if PC_Keyb.gotkey
      KeyCode := PC_Keyb.GetKey

    case KeyCode
      Key0:
        PC_Text.Writeln(string("Key0"))
        
      Key1:
        PC_Text.Writeln(string("Key1"))
        ErrCode := Find_X_Ref_INI
        KeyCode := RewriteMenu    
        
      Key2:
        PC_Text.Writeln(string("Key2"))
        ErrCode := Back_from_X_Ref_INI_until_off
        KeyCode := RewriteMenu    
        
      Key3:
        PC_Text.Writeln(string("Key3"))
        ErrCode := Find_Y_Ref_INI
        KeyCode := RewriteMenu    
        
      Key4:
        PC_Text.Writeln(string("Key4"))
        ErrCode := Back_from_Y_Ref_INI_until_off
        KeyCode := RewriteMenu    
        
      Key5:
        PC_Text.Writeln(string("Key5"))
        ShowDirBitValues
        KeyCode := RewriteMenu    
        
      Key6:
        PC_Text.Writeln(string("Key6"))
        KeyCode := RewriteMenu    
        
      Key7:
        PC_Text.Writeln(string("Key7"))
        KeyCode := RewriteMenu    
        
      Key8:
        PC_Text.Writeln(string("Key9"))
        KeyCode := RewriteMenu    
        
      Key9:
        PC_Text.Writeln(string("Key9"))
        KeyCode := RewriteMenu    

    if ErrCode <> 0
      ErrCode := ShowErrMessage(ErrCode)
       
  KeyCode := RewriteMenu 


PUB ShowDirBitValues

  PC_Text.Write(string("X_Ref_INI_On="))
  PC_Text.Dec(X_Ref_INI_On)
  PC_Text.Writeln(string(" "))

  PC_Text.Write(string("X_Ref_INI_Off="))
  PC_Text.Dec(X_Ref_INI_Off)
  PC_Text.Writeln(string(" "))

  ShowMessageWaitForKeypressed(string(" "))    


PUB ShowIO | i

  PC_Text.SetCursorToXY(0,5)

  PC_Text.Writeln(string("00 01 02 03 04 05 06 07"))
  
  repeat i from 0 to 7
    if DirA[i] == 1
      PC_Text.Write(string("O"))
      PC_Text.Dec(OutA[i])
    else   
      PC_Text.Write(string("I"))
      PC_Text.Dec(InA[i])

    PC_Text.Write(string(" "))

  PC_Text.out(13)

  PC_Text.Writeln(string("08 09 10 11 12 13 14 15"))
  repeat i from 8 to 15
    if DirA[i] == 1
      PC_Text.Write(string("O"))
      PC_Text.Dec(OutA[i])
    else   
      PC_Text.Write(string("I"))
      PC_Text.Dec(InA[i])

    PC_Text.Write(string(" "))

  PC_Text.out(13)

  PC_Text.Writeln(string("16 17 18 19 20 21 22 23"))
  repeat i from 16 to 23
    if DirA[i] == 1
      PC_Text.Write(string("O"))
      PC_Text.Dec(OutA[i])
    else   
      PC_Text.Write(string("I"))
      PC_Text.Dec(InA[i])

    PC_Text.Write(string(" "))

  PC_Text.out(13)

  PC_Text.Writeln(string("24 25 26 27 28 29 30 31"))
  repeat i from 24 to 31
    if DirA[i] == 1
      PC_Text.Write(string("O"))
      PC_Text.Dec(OutA[i])
    else   
      PC_Text.Write(string("I"))
      PC_Text.Dec(InA[i])

    PC_Text.Write(string(" "))


PUB Find_X_Ref_INI | steps

  steps := 0
  OutA[X_Dir] := Dir_towards_X_Ref_INI

  repeat until (InA[X_Ref_Ini] == X_Ref_INI_On) or (steps > XMax)
    steps := steps + 1
    OutA[X_Pulse] := high
    wait_MicroSec(StartStopSpeed_Time)
    OutA[X_Pulse] := low
    wait_MicroSec(StartStopSpeed_Time)
    {
    PC_Text.dec(steps)
    wait_MS(40)
    PC_Text.out(13)
    wait_MS(40)
    }
    PC_Text.Dec(steps)  
    ShowMessageWaitForKeypressed(string(" steps Find_X_Ref_INI"))    

    {
    if InA[X_Ref_Ini] == X_Ref_INI_On
      PC_Text.Writeln(string("InA[X_Ref_Ini] == X_Ref_INI_On"))
      wait_MS(40)
    else   
      PC_Text.Writeln(string("InA[X_Ref_Ini] <> X_Ref_INI_On"))
      wait_MS(40)
     }
  if (steps > XMax) 
    result := ErrCode_X_Ref_not_switch_on  

  PC_Text.Dec(steps)  
  ShowMessageWaitForKeypressed(string(" steps Find_X_Ref_INI"))    
                      
PUB Find_Y_Ref_INI | steps

  steps := 0
  OutA[Y_Dir] := Dir_towards_Y_Ref_INI

  repeat until (InA[Y_Ref_Ini] == Y_Ref_INI_On) or (steps > YMax)
    steps := steps + 1
    OutA[Y_Pulse] := high
    wait_MicroSec(StartStopSpeed_Time)

    OutA[Y_Pulse] := low
    wait_MicroSec(StartStopSpeed_Time)

    PC_Text.Dec(steps)  
    ShowMessageWaitForKeypressed(string(" steps Find_Y_Ref_INI"))

  if (steps > YMax) 
    result := ErrCode_Y_Ref_not_switch_on  

  PC_Text.Dec(steps)  
  ShowMessageWaitForKeypressed(string(" steps Find_Y_Ref_INI"))    
    

PUB Back_from_X_Ref_INI_until_off | steps

  steps := 0
  OutA[X_Dir] := Dir_away_from_X_Ref_INI

  repeat until (InA[X_Ref_Ini] == X_Ref_INI_Off) or (steps > MaxSteps_Ref_Ini_Off)
    steps := steps + 1
    OutA[X_Pulse] := high
    wait_MicroSec(StartStopSpeed_Time)
    OutA[X_Pulse] := low
    wait_MicroSec(StartStopSpeed_Time)
    PC_Text.Dec(steps)  
    ShowMessageWaitForKeypressed(string(" steps Back_from_X_Ref_INI_until_off"))    
    
  if (steps > MaxSteps_Ref_Ini_Off) 
    result := ErrCode_X_Ref_not_switch_off  

  PC_Text.Dec(steps)  
  ShowMessageWaitForKeypressed(string(" steps Back_from_X_Ref_INI_until_off"))    
                      
PUB Back_from_Y_Ref_INI_until_off | steps

  steps := 0
  OutA[Y_Dir] := Dir_away_from_Y_Ref_INI

  repeat until (InA[Y_Ref_Ini] == Y_Ref_INI_Off) or (steps > MaxSteps_Ref_Ini_Off)
    steps := steps + 1
    OutA[Y_Pulse] := high
    wait_MicroSec(StartStopSpeed_Time)
    OutA[Y_Pulse] := low
    wait_MicroSec(StartStopSpeed_Time)
    PC_Text.Dec(steps)  
    ShowMessageWaitForKeypressed(string(" steps Back_from_Y_Ref_INI_until_off"))    

  if (InA[Y_Ref_Ini] == Y_Ref_INI_Off)
    ShowMessageWaitForKeypressed(string(" (InA[Y_Ref_Ini] == Y_Ref_INI_Off)"))
     
  if (steps > MaxSteps_Ref_Ini_Off) 
    result := ErrCode_Y_Ref_not_switch_off  

  PC_Text.Dec(steps)  
  ShowMessageWaitForKeypressed(string(" steps Back_from_Y_Ref_INI_until_off"))    
                      
PUB wait_MicroSec(p_WaitTime_MicroSec) 

  if p_WaitTime_MicroSec < 385 
    p_WaitTime_MicroSec := 385
     
  waitcnt( ((clkfreq / 1_000_000) * p_WaitTime_MicroSec) + cnt)

      
PUB wait_MS(p_WaitTime_ms) 

  waitcnt( ((clkfreq / 1000) * p_WaitTime_ms) + cnt)


PUB ShowErrMessage(ErrCode)
  PC_Text.ClearScreen    '1234567890123456789012345678901234567890
  PC_Text.Write(string("an Error occured ErrCode="))
  PC_Text.Dec(ErrCode)
  PC_Text.out(13)
  
  PC_Text.Write(string("press any Key to ackknowledge"))
  PC_Keyb.GetKey


PUB ShowMessageWaitForKeypressed(stringptnr)

  'PC_Text.ClearScreen   
  PC_Text.Writeln(stringptnr)
  wait_MS(40)
  PC_Text.Writeln(string("press any Key to ackknowledge"))
  wait_MS(40)
  PC_Keyb.GetKey


DAT
  entry

  