
#Compiler    PbCC
#Console     On
#Debug Error On
#Dim         All
#Tools       Off

$Product   = "AiChip Industries Executable File Loader for the Propeller"
$Version   = "1.10 #0016"
$Command   = "PropLoad"
$FileExt   = ".Eeprom .Binary"

#Resource    "PropLoad.Pbr"

#Include "Utility.Baz"
#Include "Say.Baz"
#Include "FileWild.Baz"
#Include "CmdLine.Baz"
#Include "Version.Baz"

Function PbMain&
Dim f$
Dim saveSwitches$
  Call ProgramStart($FileExt)

  if FNSwitch("/SHELL") Then
    hldScreenCrLf&=-1
  end if

  errors& = 0
  f$ = GetFirstFilename$

  Call ProgramEnd
End Function

Sub Help
  Say $Product+" ( "+$Version+" )"
  if Not FNswitch("/SHELL") Then
    Say
    Say "Usage : PROPLOAD filename{.Binary|.Eeprom} {/options}"
    Say
    Say "        /COM:n          Serial port to download through ( optional )"
    Say "        /IDENTIFY       Identify connected Propeller Chip"
    Say "        /SAVE           Save download to Propeller Eeprom"
    Say "        /BREAK          Send 'break' signal to initiate reset"
    Say
    Say "        /LOG            Log download process as '"+AppName$+extnPrefix$+".Log'"
    Say "        /VERBOSE        Detail download progression"
    Say "        /SHELL          Use when called from another program"
    Say "        /BATCH          Use when called from a .Bat file"
  end if
End Sub

Sub HelpAdvanced
  Call Help
End Sub

REM  **************************************************************************
REM  *                                                                        *
REM  *
REM  *                                                                        *
REM  **************************************************************************

