
#Compiler    PbCC
#Console     On
#Debug Error On
#Dim         All
#Tools       Off

$Product   = "AiChip Industries LCC Bytecode Generator for the Propeller"
$Version   = "1.10 #0387"
$Command   = "Compile"
$FileExt   = ".$gn"

#Resource    "MakeSpin.Pbr"

#Include "Utility.Baz"
#Include "Say.Baz"
#Include "Calendar.Baz"
#Include "FileWild.Baz"
#Include "CmdLine.Baz"
#Include "Version.Baz"
#Include "Library.Baz"
#Include "Opcode.Baz"
#Include "Bytecode.Baz"
#Include "MakeList.Baz"

%AREA_HIDE = 0
%AREA_SPIN = 1
%AREA_PASM = 2

Function PbMain&
Dim f$
Dim saveSwitches$

  Call ProgramStart($FileExt)

  if FNSwitch("/SHELL") Then
    hldScreenCrLf&=-1
  end if

  errors& = 0
  f$ = GetFirstFilename$
  while Len(f$)<>0 and errors& = 0
    saveSwitches$=cmdSwitches$
    if cmdAnyWildFiles Then
      if Not FNswitch("/SHELL") Then
        Say "Generating from '"+f$+"'"
      end if
    end if
    Call Generate
    cmdSwitches$=saveSwitches$
    f$=GetNextFilenameAsSrcFilename$
  wend

  if errors& = 0 Then
    If Not cmdAnyWildFiles Then
      Call ProgramEnd("Created '"+srcFileBase$+".Spin'")
    end if
  end if

  Call ProgramEnd
End Function

Sub Help
  Say $Product+" ( "+$Version+" )"
  if Not FNswitch("/SHELL") Then
    Say
    Say Pad$(43+7-len(appname$),"Usage : "+Ucase$(AppName$)+" filename{.$gn} {/options}")+"( or "+Ucase$(AppName$)+" @filename{.cmd} )"
    Say
'-- Say "        /BINARY         Create an executable file ( eg, /BINARY, /EEPROM )"
    Say "        /SPIN           Create a '*"+extnPrefix$+".Spin' file as a self-contained program"
    Say "        /OBJECT         Create a '*"+extnPrefix$+".Spin' file as a callable object"
    Say "        /XTALn          Set Crystal Type ( eg, /XTAL1, /RCFAST, /XINPUT )"
    Say "        /nMHZ           Set Clock or System Speed ( eg, /5MHz, /10MHz, /80MHz )"
    Say "        /PLLnX          Set PLL ( eg, /PLL8x, /PLL16x )"
'-- Say "        /pin:number     Set Pin Numbers ( eg, /TV:12, /RX:31, /TX:30 )"
    Say
    Say "        /ADVANCED       Display advanced generator options"
    Say
    Say "Note : Use "+Chr$(&h22)+"COMPILE filename /NOTIDY"+chr$(&h22)+" to create a .$gn file for MAKESPIN use"
  End If
End Sub

Sub HelpAdvanced
  if FNswitch("/ADVANCED:*") then
    Say String$(80,"*")
    Say Pad$(79,"*")+"*"
    Say Pad$(79,"*  Manual for the "+$Product)+"*"
    Say Pad$(79,"*")+"*"
    Say String$(80,"*")
    Say
  end if
  Say $Product+" ( "+$Version+" )"
  Say
  Say Pad$(43+7-len(appname$),"Usage : "+Ucase$(AppName$)+" filename{.$gn} {/options}")+"( or "+Ucase$(AppName$)+" @filename{.cmd} )"
  Say
  if FNswitch("/ADVANCED:*") Then
    Say "Command line help options ..."
    Say
    Say "        "+Ucase$(AppName$)+" /?             Show most common options"
    Say "        "+Ucase$(AppName$)+" /ADVANCED      Show list of advanced options"
    Say "        "+Ucase$(AppName$)+" /ADVANCED:n    Show specific advanced options"
    Say "        "+Ucase$(AppName$)+" /ADVANCED:*    Show all advanced options"
    Say
  end if
  Say
  if FNswitch("/ADVANCED:5") Or FNswitch("/ADVANCED:*") Then
    Say "Command line control options ..."
    Say
    Say "        "+Ucase$(AppName$)+"                Repeat last code generation"
    Say "        "+Ucase$(AppName$)+" @              Use command line in '"+AppName$+".Cmd'"
    Say "        "+Ucase$(AppName$)+" @file{.cmd}    Use command line in '*.Cmd'"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:1") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced output options ..."
    Say
    Say "        /BINARY         Create a '*"+extnPrefix$+".Binary' file"
    Say "        /EEPROM         Create a '*"+extnPrefix$+".Eeprom' file"
    Say "        /SPIN           Create a '*"+extnPrefix$+".Spin' file'"
    Say
    Say "        /OBJECT         Create a callable object"
    Say "        /TEST           Create a self-contained testable program"
    Say "        /DEBUG          Create a self-contained kernel debugger"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:2") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced configuration options ..."
    Say
    Say "        /DEMO           Build for Parallax Demo Board"
    Say "        /PROTO          Build for Parallax Proto Board"
    Say "        /HYDRA          Build for Hydra Games System"
    Say "        /AICHIP         Build for AiChip Development Board"
    Say
    Say "        /XTALn          Set Crystal Type ( eg, /XTAL1, /RCFAST, /XINPUT )"
    Say "        /nMHZ           Set Clock or System Speed ( eg, /5MHz, /10MHz, /80MHz )"
    Say "        /PLLnnx         Set PLL ( eg, /PLL8x, /PLL16x )"
    Say
    Say "        /TV:pin         Set pin for TV display ( eg /TV:12, /TV12 )"
    Say "        /TX:pin         Set pin for Serial Out ( eg /TX:30, /TX30 )"
    Say "        /RX:pin         Set pin for Serial In  ( eg /RX:31, /RX31 )"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:3") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced code generation options ..."
    Say
    Say "        /BYTECODE       Generate bytecode executable   ( smallest, slowest )"
    Say "        /LMM:16         Generate LMM 16-bit executable ( larger  , faster  )"
    Say "        /LMM:32         Generate LMM 32-bit executable ( largest , fastest )"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:4") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced control options ..."
    Say
    Say "        /NOERROR        Do not give an error report"
    Say "        /LOG            Log code generation process as '"+AppName$+extnPrefix$+".Log'"
    Say "        /SHELL          Use when called from another program"
    Say "        /BATCH          Use when called from within a .Bat file"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if Not FNswitch("/ADVANCED:*") Then
    Say "        /ADVANCED:1     Show advanced output options"
    Say "        /ADVANCED:2     Show advanced configuration options"
    Say "        /ADVANCED:3     Show advanced code generation options"
    Say "        /ADVANCED:4     Show advanced control options"
    Say "        /ADVANCED:5     Show command line control options"
    Say
    Say "Note : Use '"+AppName$+" /ADVANCED:* > filename.ext' to create a text file
    Say "       list of all options"
  else
    Say "AiChip is a trademark of AiChip Industries."
  end if
End Sub

Sub Generate
Global libName$()
Global libReal$()
Global libArgs&()
Global libTop&
Global useTop&
Global varTop&
Global subTop&
Global genFileNum&
dim l$
dim i&
dim j&
dim count&
dim kernel$
  Call Report("Generating for "+srcFileBase$)
  genFileNum&=FreeFile
  open srcFilename$ for input as #genFileNum&
  while not eof(genFileNum&)
    line input#genFileNum&,l$
    l$=rtrim$(l$)
    if len(l$)<>0 then
      select case l$

        case "FLAG"
          line input#genFileNum&,l$
          if Not FNswitch("/SHELL") Then
            Call SwitchRemove("/NORAM")
            Call SwitchRemove("/ROM")
            cmdSwitches$=cmdSwitches$+l$
            Call Report("Options changed to ...")
            Call Report("   "+cmdSwitches$)
          end if
          line input#genFileNum&,cpp$
          line input#genFileNum&,rcc$

        case "KERN"
          line input#genFileNum&,kernel$
          if dir$(kernel$+".Spin") = "" Then
            Call Crash("Cannot find kernel file '"+kernel$+"'")
          end if

        case "ERRS"
          line input#genFileNum&,l$
          errors& = errors&+Val(l$)

        case "LIBS"
          input#genFileNum&,libTop&
          if libTop&>0 then
            Dim libName(libTop&) As Global String
            Dim libReal(libTop&) As Global String
            Dim libArgs(libTop&) As Global Long
            for i&=1 to libTop&
              line input#genFileNum&,l$
              j&=instr(l$," ")
              libName$(i&)=Left$(L$,j&-1)
              l$=Ltrim$(right$(l$,len(l$)-j&))
              j&=instr(l$," ")
              libReal$(i&)=Left$(L$,j&-1)
              l$=Ltrim$(right$(l$,len(l$)-j&))
              libArgs&(i&)=Val(l$)
            next
          end if

        case "OPCS"
          input#genFileNum&,useTop&
          if useTop&>0 then
            Dim useFlg(&hFF) As Global Boolean
            Dim useVal(useTop&) As Global Long
            Dim useOpc(useTop&) As Global String
            for i&=1 to useTop&
              line input#genFileNum&,l$
              useVal&(i&)=Val("&h"+Left$(l$,2))
              useFlg(useVal(i&))=%TRUE
              l$=Right$(l$,Len(l$)-3)
              if Len(l$)>3 then
                Mid$(l$,4)="_"
              end if
              useOpc$(i&)=l$
            next
          end if

        case "VARS"
          input#genFileNum&,varTop&
          if varTop&>0 then
            Dim varNam(varTop&) As Global String
            Dim varAdr(varTop&) As Global Long
            Dim varSiz(varTop&) As Global Long
            for i&=1 to varTop&
              line input#genFileNum&,l$
              select case left$(l$,4)
                case "BYTE" : varSiz&(i&)=1
                case "WORD" : varSiz&(i&)=2
                case "CHAR" : varSiz&(i&)=3
                case "LONG" : varSiz&(i&)=4
                case "REAL" : varSiz&(i&)=5
              end select
              VarAdr&(i&)=Val("&h"+Mid$(l$,6,4))
              l$=Ltrim$(Right$(l$,Len(l$)-10))
              VarNam$(i&)=l$
            next
          end if

        case "SUBS"
          input#genFileNum&,subTop&
          if subTop&>0 then
            Dim subAdr(subTop&) As Global String
            Dim subNam(subTop&) As Global String
            Dim subTyp(subTop&) As Global String
            for i&=1 to subTop&
              line input#genFileNum&,l$
              j&=Instr(l$," ")
              subAdr$(i&)=left$(l$,j&-1)
              l$ = Ltrim$(right$(l$,Len(l$)-j&))
              j&=Instr(l$," ")
              subNam$(i&)=Left$(l$,j&-1)
              subTyp$(i&)=Ltrim$(Right$(l$,Len(l$)-j&))
            next
          end if

          case "CODE"
            call ParseKernel(kernel$)

        case else : Call Crash("Unknown section in "+srcFilename$+" '"+l$+"'")
      end select
    end if
  wend
  close#genFileNum&
End Sub

Sub ParseKernel(ByVal kernel$)
global hadCrLf As Boolean
global skip as boolean
Global srcFileNum&
global lstFileNum&
global asmFileNum&
global ifTop&
dim l$
  hadCrLf = %FALSE
  Dim ifCond(100) As Global Long
  ifTop& = 0
  ifCond(ifTop&)=%AREA_SPIN
  lstFileNum& = FreeFile
  Open srcFileBase$+".$sp" for output as #lstFileNum&
        ' @@@@@@
        close#lstFileNum&
        lstFileNum& = FreeFile
        Open srcFileBase$+".Spin" for output as #lstFileNum&
  asmFileNum& = FreeFile
  Open srcFileBase$+".$pi" for output as #asmFileNum&
  srcFileNum& = FreeFile
  Open kernel$+".Spin" for input as #srcFileNum&
  do
    if eof(srcFileNum&) then
      Call Crash("Not a kernel")
    end if
    line input#srcFileNum&,l$
  Loop Until instr(l$,"<<KERNEL FOR LCC>>")<>0

  while not eof(srcFileNum&)
    line input#srcFileNum&,l$
    l$=Rtrim$(l$)
    if len(l$)=0 then
      if ifCond(ifTop&) <> %AREA_HIDE then
        if not hadCrlf Then
          print#lstFileNum&,""
          hadCrLf = %TRUE
        end if
      end if
    else
      Call ParseLine(l$)
    end if
  wend
  close#srcFileNum&
  if not hadCrLf then
    print#lstFileNum&,""
  end if
  close#lstFileNum&
  if asmFileNum&<>0 Then
    close#asmFileNum&
  end if
End Sub

Sub ParseLine( ByVal l$)
Dim o$
dim i&
  o$=ltrim$(l$)
  if left$(o$,1)="{" then
     Do
       if ifCond(ifTop&)<>%AREA_HIDE then
         Print#lstFileNum&,l$
       end if
       Line input#srcFileNum&,l$
     Loop Until Left$(Ltrim$(l$),1) = "}"
     if ifCond(ifTop&)<>%AREA_HIDE then
       Print#lstFileNum&,l$
       hadCrLf = %FALSE
     end if
     Exit Sub
  end if
  if left$(o$,1)="'" then
    o$=ltrim$(Right$(o$,Len(o$)-1))
    if left$(o$,2)="<<" then
      o$=Ltrim$(Right$(o$,len(o$)-2))
      i&=Instr(o$,">")
      if i& = 0 or mid$(o$,i&,2)<>">>" then
        Call KernelMistake("Missing >> in <<"+o$)
      end if
      o$=Left$(o$,i&-1)
      i& = Instr(o$," ")
      if i&=0 Then
        Call Conditional(o$,"")
      else
        Call Conditional(Left$(o$,i&-1),Right$(o$,Len(o$)-i&))
      end if
    else
      if ifCond(ifTop&)<>%AREA_HIDE then
        Print#lstFileNum&,l$
        hadCrLf = %FALSE
      end if
    end if
    Exit Sub
  end if
  select case ifCond(ifTop&)
    Case %AREA_SPIN
      Print#lstFileNum&,l$
      hadCrLf = %FALSE
      If left$(l$+" ",4) = "DAT " Then
        ifCond(ifTop&)=%AREA_PASM
      end if
    Case %AREA_PASM
      select case left$(l$+" ",4)
        case "CON ","VAR ","OBJ ","PUB ","PRI "
          ifCond(ifTop&)=%AREA_SPIN
          Print#lstFileNum&,l$
          hadCrLf = %FALSE
        case "DAT "
          Print#lstFileNum&,l$
          hadCrLf = %FALSE
        case else
          Call PasmEmit(l$)
      end select
  end select
end sub

Declare Function IfConditional( ByVal o$) As boolean

Sub Conditional( Byval Opc$, Byval opr$)
dim l$
  select case opc$
    Case "CASE"
      Call UnHide
      If IfConditional(opr$) Then
        Call Show
      Else
        Call Hide
      End If
    Case "DEFINE"
    Case "ELSE"
      If ifCond(ifTop&)=%AREA_HIDE then
        Call UnHide
        Call Show
      else
        Call UnHide
        Call Hide
      end if
    Case "END"
      Call Unhide
    Case "FINISH"
    Case "IF"
      If IfConditional(opr$) Then
        Call Show
      Else
        Call Hide
      End If
    Case "IFNOT"
      If Not IfConditional(opr$) Then
        Call Show
      Else
        Call Hide
      End If
    Case "INSERT"
      do
        line input#srcFileNum&,l$
      loop until instr(l$,"<<FINISH ")<>0
      if ifCond(ifTop&)<>%AREA_HIDE then
        select case opr$
          Case "CLKMODE"         : Call InsertClkMode
          Case "COGDEBUG"        : Call InsertCogDebug
          Case "HEADER"          : Call InsertHeader
          Case "KERNELVERSION"   : Call InsertKernelVersion
          Case "LCCCODE"         : Call InsertLccCode
          Case "LIBNAMES"        : Call InsertLibNames
          Case "LIBPTRTABLE"     : Call InsertLibPtrTable
          Case "METHODS"         : Call InsertMethods
          Case "OPCJMPTABLE"     : Call InsertOpcJmpTable
          Case "OPCNAMES"        : Call InsertOpcNames
          Case "OPCPTRTABLE"     : Call InsertOpcPtrTable
          Case "SOURCEFILE"      : Call InsertSourceFile
          Case "SXPIN"           : Call InsertSxPin
          Case "TVPIN"           : Call InsertTvPin
          Case "VARNAMES"        : Call InsertVarNames
          CAse Else              : Call KernelMistake("Unknown INSERT "+opr$,"")
        end select
      end if
    Case "LIB"

    Case "LIST"

    Case "OR"
      If ifCond(ifTop&)=%AREA_HIDE Then
        If IfConditional(opr$) Then
          Call UnHide
          Call Show
        end if
      end if
    Case "SELECT
      Call Show
    Case "SET"
      If ifCond(ifTop&)<>%AREA_HIDE then
        Call SwitchAdd("/"+opr$)
      end if
    Case else : Call KernelMistake("Unknown "+opc$+" "+opr$,"")
  end select
End Sub

Sub Show
  ifTop&=ifTop&+1
  ifCond(ifTop&)=ifCond(ifTop&-1)
end sub

Sub Hide
  ifTop& =ifTop&+1
  ifCond(ifTop&)=%AREA_HIDE
end sub

Sub UnHide
  if ifTop& = 0 Then
    Call KernelMistake("Nesting error")
  else
    ifTop&=ifTop&-1
  end if
End Sub

Function IfOpcodeRangeUsed( ByVal o$) As boolean
dim result as boolean
dim OpcFrom&
dim opcOnto&
dim i&
 ' KERNEL.$NN..$NN
 ' KERNEL.$Nx
 ' KERNEL.$NN
 if mid$(o$,4,2)=".." then
   opcFrom& = Val("&h"+Mid$(o$,2,2))
   opcOnto& = Val("&h"+Right$(o$,2))
 else
   if Ucase$(Mid$(o$,3,1))="X" then
     opcFrom& = Val("&h"+Mid$(o$,2,1)+"0")
     opcOnto& = opcFrom& Or &h0F
   else
     opcFrom& = Val("&h"+Mid$(o$,2,2))
     opcOnto& = opcFrom&
   end if
 end if
 result = %FALSE
 i& = opcFrom&
 while ( i& <= opcOnto& ) and ( not result )
   result = useFlg(i&)
   i& = i&+1
 wend
 IfOpcodeRangeUsed = result
End Function

Function IfConditional( ByVal o$) As boolean
Global libTop&
Dim i&
Dim result as Boolean
  i&=Instr(o$," ")
  o$ = Ucase$(Ltrim$(Right$(o$,Len(o$)-i&)))
  If left$(o$,6)="KERNEL" then
    o$ = right$(o$,Len(o$)-7)
    select case o$
      case "SPIN" : result = %FALSE
      case "LIBS" : result = libTop& > 0
      case "VARS" : result = varTop& > 0
      case "KPX"  : result = IfOpcodeRangeUsed("$00..$7F") or %TRUE ' @@@@@@
      case "KXX"  : result = IfOpcodeRangeUsed("$8x")
      case "MZX"  : result = IfOpcodeRangeUsed("$9x")
      case "AZX"  : result = IfOpcodeRangeUsed("$Ax")
      case "LZX"  : result = IfOpcodeRangeUsed("$Bx")
      case else   : if left$(o$,1)="$" then
                      result = IfOpcodeRangeUsed(o$)
                    else
                      result = %TRUE
                      Call KernelMistake("Unknown conditional KERNEL."+o$,"")
                    end if
    end select
  else
    result = FNswitch("/"+o$)
  end if
  IfConditional = result
end Function

Sub PasmEmit( Byval l$ )
dim i&
dim lab$
dim cnd$
dim opc$
dim opr$
dim flg$
dim com$
dim o$
global lastLab$
global org&
dim rawL$

  print#lstFileNum&,l$
  hadCrlf = %FALSE
  if asmFileNum&<>0 Then
    rawL$ = l$
    i&=instr(l$,"'")
    if i& > 0 then
      com$=Right$(l$,Len(l$)-i&+1)
      l$=Rtrim$(Left$(l$,i&-1))
    end if
    if left$(L$,1) <> " "then
      i&=Instr(l$," ")
      if i&=0 then
        lab$=l$
        l$=""
      else
        lab$=Left$(l$,i&-1)
        l$=Right$(l$,Len(l$)-i&)
      end if
      o$=FNNum$(0,5)
      o$=Pad$(8,o$)+lab$
      print#asmFileNum&,o$
      if left$(lab$,1)<>":" Then
        lastLab$ = lab$
      end if
    end if
    l$=Ltrim$(l$)
    if ucase$(left$(l$,3))="IF_" then
      i&=Instr(l$," ")
      cnd$=UCASE$(Left$(l$,i&-1))
      l$=Ltrim$(Right$(l$,Len(l$)-i&))
    else
      cnd$=""
    end if
    i& = instr(l$," ")
    if i&=0 then
      opc$=l$
      opr$=""
    else
      opc$=Left$(l$,i&-1)
      l$=Ltrim$(Right$(l$,Len(l$)-i&))
      i& = instr(l$," ")
      if i& = 0 then
        opr$=l$
        flg$=""
      else
        opr$=Left$(l$,i&-1)
        flg$=Ltrim$(Right$(l$,Len(l$)-i&))
      end if
    end if

    if cnd$ = "IF_ALWAYS" Then
      cnd$ = ""
    else
      select case ucase$(opc$)
        case "JMP","CALL"
          if left$(opr$,1) = "@" Then
            Call KernelMistake(Ucase$(opc$)+" with @ after "+lastLab$,rawL$)
          else
            if left$(opr$,1) <> "#" Then
              if left$(opr$,1) <> "*" Then
                Call KernelMistake(ucase$(opc$)+" via register without # after "+lastLab$,rawL$)
              else
                opr$ = Right$(opr$,len(opr$)-1)
              end if
            end if
            if ucase$(left$(opr$,4)) = "#LMM" then
              if ucase$(opc$)<>"JMP" Then
                Call KernelMistake("JMP required not CALL after "+lastLab$,rawL$)
              end if
            end if
          end if
        case "TJZ","TJNZ","DJNZ","JMPRET"
          if Instr(opr$,",@") <> 0 Then
            Call KernelMistake(Ucase$(opc$)+" with @ after "+lastLab$,rawL$)
          else
            if Instr(opr$,",#") = 0 Then
              if Instr(opr$,",*") = 0 Then
                Call KernelMistake(Ucase$(opc$)+" with register without # after "+lastLab$,rawL$)
              else
                i& =instr(opr$,",*")
                opr$=Left$(opr$,i&)+Right$(opr$,Len(opr$)-i&)
              end if
            end if
          end if
      end select
      If Ucase$(left$(opr$,2))= "K_" then
        Call KernelMistake("Modifying constant after "+lastLab$,rawL$)
      end if
      If Instr(Ucase$(opr$),",#K_")<>0 Then
        Call KernelMistake("Use of constant using #k_ after "+lastLab$,rawL$)
      end if
      select case Ucase$(opc$)
        CASE "BYTE","WORD","LONG","ORG","RES","FIT"
          if len(opr$)=0 Then
            if instr(Ucase$(rawL$),"ALIGN")=0 Then
              Call KernelMistake(Ucase$(opc$)+" without operand after "+lastLab$,rawL$)
            end if
          else
            if ucase$(left$(lab$,2)) = "K_" Then
              if Right$(opr$,len(opr$)-1) <> Right$(lab$,len(lab$)-2) Then
                Call KernelMistake("Mismatch in constant at "+lab$,rawL$)
              end if
            end if
          end if
        Case Else
          o$ = "%$0123456789"+Chr$(&h22)
          i& = 1
          while i& > 0 and i& <= Len(o$)
            If Left$(opr$,1) = Mid$(o$,i&,1) Then
              If Left$(opr$,4)<>"0-0," Then
                If Left$(opr$,4)<>"0-0+" Then
                  If Left$(opr$,5)<>"$1F7," Then
                    Call KernelMistake("Suspicious "+opc$+" "+opr$+" after "+lastLab$,rawL$)
                    i& = -1
                  end if
                end if
              end if
            end if
            If i& > 0 Then
              If Instr(opr$,","+Mid$(o$,i&,1)) <>0 Then
                If Instr(opr$,",0-0") = 0 Then
                  If Instr(opr$,",0-0+") = 0 Then
                    If Instr(opr$,",$1F7") = 0 Then
                      Call KernelMistake("Suspicious "+opc$+" "+opr$+" after "+lastLab$,rawL$)
                      i& = -1
                    end if
                  end if
                end if
              end if
            end if
            i& = i&+1
          wend
        end select
    end if

' Check PASM bytecode handlers are between $000 and $0FF - Not needed yet !
'
' --    select case ucase$(opc$)
' --      case "ORG", "FIT"
' --      case else
' --        if len(lab$)<>0 Then
' --          if org& >= &h100 Then
' --            if mid$(lab$,4,1) ="_" then
' --              Call KernelMistake(lab$+" at Cog Address $"+Hex$(org&,3),"")
' --            end if
' --          end if
' --        else
' --          org& = org&+1
' --        end if
' --    end select

    o$=FNnum$(0,5)
    if len(cnd$)<>0 then o$=Pad$(8,o$)+cnd$
    if len(opc$)<>0 then o$=Pad$(24,o$)+opc$
    if len(opr$)<>0 then o$=Pad$(32,o$)+opr$
    if len(flg$)<>0 then o$=Pad$(48,o$)+flg$
    if len(com$)<>0 then o$=Pad$(56,o$)+com$
o$=o$+"<<<<<<<<<<"
    print#asmFileNum&,o$
if instr(o$,"IF_AL")<>0 then
  print "////"+o$
end if


  end if
End Sub

REM  **************************************************************************
REM  *                                                                        *
REM  *
REM  *                                                                        *
REM  **************************************************************************

Function TryOption$( ByVal already$, ByVal This$ )
  If Len(already$) = 0 Then
    If FNswitch("/"+this$) Then
      already$ = this$
    end if
  End If
  TRyOption$ = already$
End Function

Sub InsertClkMode
Global hadCrLf As Boolean
dim xtal$
dim XIN$
dim PLL$

  xtal$ = TryOption$( ""    , "AICHIP" )
  xtal$ = TryOption$( xtal$ , "PROTO"  )
  xtal$ = TryOption$( xtal$ , "DEMO"   )
  xtal$ = TryOption$( xtal$ , "HYDRA"  )

  if xtal$ <> "" Then
    select case xtal$
      CASE "AICHIP" : Call SwitchAdd("/XTAL1/PLL16/118MHZ/TV:12")
      CASE "PROTO"  : Call SwitchAdd("/XTAL1/PLL16/80MHZ/TV:12")
      CASE "DEMO"   : Call SwitchAdd("/XTAL1/PLL16/80MHZ/TV:12")
      CASE "HYDRA"  : Call SwitchAdd("/XTAL1/PLL8/10MHZ/TV:12")
    end select
  end if

  xtal$ = TryOption$( ""    , "RCSLOW" )
  xtal$ = TryOption$( xtal$ , "RCFAST" )
  xtal$ = TryOption$( xtal$ , "XTAL1"  )
  xtal$ = TryOption$( xtal$ , "XTAL2"  )
  xtal$ = TryOption$( xtal$ , "XTAL3"  )
  xtal$ = TryOption$( xtal$ , "XINPUT" )
  If xtal$ = "" Then
    if errors& = 0 Then
      Say "Defaulting to XTAL1"
    end if
    xtal$ = "XTAL1"
  End If

  select case xtal$
    Case "RCSLOW"
    CASE "RCFAST"
    Case Else
      PLL$ = TryOption$( ""   , "PLL16" )
      PLL$ = TryOption$( PLL$ , "PLL1"  )
      PLL$ = TryOption$( PLL$ , "PLL2"  )
      PLL$ = TryOption$( PLL$ , "PLL4"  )
      PLL$ = TryOption$( PLL$ , "PLL8"  )
  End Select
  If pll$ = "" Then
    if errors& = 0 Then
      Say "Defaulting to PLL16X"
    end if
    pll$ = "PLL16"
  End If

  select case xtal$
    Case "RCSLOW"
      XIN$ = "12_000""
    CASE "RCFAST"
      XIN$ = "20_000_000"
    Case Else
      XIN$ = TryOption$( ""   , "5MHZ"   )
      XIN$ = TryOption$( XIN$ , "6MHZ"   )
      XIN$ = TryOption$( XIN$ , "10MHZ"  )
      XIN$ = TryOption$( XIN$ , "80MHZ"  )
      XIN$ = TryOption$( XIN$ , "96MHZ"  )
      XIN$ = TryOption$( XIN$ , "100MHZ" )
      XIN$ = TryOption$( XIN$ , "118MHZ" )
      Select Case XIN$
        Case ""       : XIN$="5_000_000"
                        if errors& = 0 Then
                          Say "Defaulting to 5MHz (80MHz)"
                        end if
        Case "5MHZ"   : XIN$="5_000_000"
        Case "6MHZ"   : XIN$="6_000_000"
        Case "10MHZ"  : XIN$="10_000_000"
        Case "80MHZ"  : XIN$="5_000_000"
        Case "96MHZ"  : XIN$="6_000_000"
        Case "118MHZ" : XIN$="7_372_800"
      End Select
  End Select

  if pll$<>"" Then
    xtal$=xtal$+"+"+pll$+"X"
  end if
  Print#lstFileNum&,"  _CLKMODE      = "+xtal$
  Print#lstFileNum&,"  _XINFREQ      = "+xin$
  hadCrLf = %FALSE
End Sub

Sub InsertCogDebug
dim o$
  o$ = FindLatest$("AiChip_CogDebug",".Spin")
  if o$<>"" Then
    Print#lstFileNum&,"  debug         : "+Chr$(&h22)+o$+Chr$(&h22)
    hadCrLf = %FALSE
  end if
End Sub

Sub InsertHeader
  Call MakeListHeader( "' *","Created by ",srcFileBase$+".c" )
  hadCrLf = %FALSE
End Sub

Sub InsertKernelVersion
Global hadCrLf As Boolean
  if Mid$(kernel$,len(kernel$)-3,1)<>"_" then
    Print#lstFileNum&,"  return String( "+Chr$(&h22)+"AiChip LccVm"+Chr$(&h22)+" )"
  else
    Print#lstFileNum&,"  return String( "+Chr$(&h22)+"AiChip LccVm "+Right$(kernel$,3)+Chr$(&h22)+" )"
  end if
  hadCrLf = %FALSE
end sub

Sub InsertLccCode
dim l$
dim lab$
dim o$
dim i&
dim thisPc&
dim pc&
  pc& = 0
  lab$ = "LccCode"
  do
    line input#genFileNum&,l$
    l$=Rtrim$(l$)
    if len(l$)<>0 Then
      if l$="DATA" Then
        lab$ = "LccData"
      else
        if Mid$(l$,9,1)<>" " Then
          thisPc& =Val("&h"+Left$(l$,4))
          if pc& < thisPc& Then
            o$=Pad$(16,Pad$(8,lab$)+"Byte")
            while pc& < thisPc&
              o$=o$+"$00"
              pc&=pc&+1
              if pc& < thisPc& then
                o$=o$+", "
              end if
            wend
            print#lstFileNum&,o$
          end if
          o$=Pad$(16,Pad$(8,lab$)+"Byte")
          lab$ = ""
  ' ///
          if mid$(l$,12,1)="[" then
            i& = Val(Mid$(l$,13,instr(l$,"]")-13))
            o$=o$+"$00 ["+FNstr$(i&)+"]"
            pc& = pc&+i&
          else
            i&=9
            Do
              if i& > 9 then
                o$=o$+", "
              end if
              o$=o$+"$"+Mid$(l$,I&,2)
              i&=i&+3
              pc&=pc&+1
            Loop Until Mid$(l$,i&,1)=" "
          end if
        else
          o$=""
        end if
        o$=Pad$(48,o$)+"' "+Left$(l$,4)+"  "+Right$(l$,Len(l$)-24)
        print#lstFileNum&,o$
      end if
    end if
  loop until Len(l$)=0
  hadCrlf = %FALSE
end sub

Sub InsertLibNames
Dim i&
Dim lab$
dim o$
dim n&
  lab$="LibNames"
  for i& = 1 to libTop&
    o$=pad$(16,lab$)+"byte"
    o$=Pad$(24,o$)+FNstr$(libArgs&(i&))+", "
    o$=o$+Chr$(&h22)+libName$(i&)+Chr$(&h22)+", 0"
    o$=Pad$(48,o$)+"' +"+FNstr$(i&-1)
    o$=Pad$(56,o$)+libName$(i&)
    select case libArgs&(i&)
      case 1 : o$=o$+"(int)"
      case 2 : o$=o$+"(int,int)"
      case 3 : o$=o$+"(int,int,int)"
    end select
    print#lstFileNum&,o$
    lab$=""
  next
  hadCrLf = %FALSE
End Sub

Sub InsertLibPtrTable
Dim i&
Dim lab$
dim o$
  lab$="LibPtrTable"
  for i& = 1 to libTop&
    o$=pad$(16,lab$)+"long"
    o$=Pad$(24,o$)+"@"+libReal$(i&)
    if libArgs&(i&)<>0 Then
      o$=Pad$(40,o$)+"|"+Str$(libArgs&(i&))
    end if
    o$=Pad$(48,o$)+"' +"+FNstr$(i&-1)
    o$=Pad$(56,o$)+libName$(i&)
    select case libArgs&(i&)
      case 1 : o$=o$+"(int)"
      case 2 : o$=o$+"(int,int)"
      case 3 : o$=o$+"(int,int,int)"
    end select
    Call PasmEmit(o$)
    lab$=""
  next
  hadCrLf = %FALSE
end sub

Sub InsertMethods
Dim i&
Dim lab$
dim o$
dim n&
dim t$
dim j&
dim count&
  for i& = 1 to subTop&
    o$="PRI "+subNam$(i&)
    t$ = subTyp$(i&)
    t$ = Right$(t$,Len(t$)-instr(t$,"("))
    if left$(t$,4)="void" then
      count&=0
    else
      count&=1
      j&=instr(t$,",")
      while j& <> 0
        count&=count&+1
        j&=instr(j&+1,t$,",")
      wend
      o$=o$+"("
      for j&=1 to count&
        if j& > 1 then
          o$=o$+","
        end if
        o$=o$+" _"+FNstr$(j&)
      next
      o$=o$+" )"
    end if
    o$=Pad$(48,o$)+"' "+subTyp$(i&)
    print#lstFileNum&,o$
    print#lstFileNum&,""
    if left$(subAdr$(i&),1) <> "-" then
      if count& > 0 then
        for j&=1 to count&
          print#lstFileNum&,"  Kernel_Push( _"+FNstr$(j&)+" )"
        next
      end if
      if left$(subTyp$(i&),4)="void" then
        print#lstFileNum&,"  Kernel_Run( @LccCode + $"+subAdr$(i&)+" )"
      else
        print#lstFileNum&,"  return Kernel_Call( @LccCode + $"+subAdr$(i&)+" )"
      end if
      print#lstFileNum&,""
    end if
  next
  hadCrLf = %TRUE
End Sub

Sub InsertOpcJmpTable
Dim i&
Dim lab$
dim o$
  lab$="OpcJmpTable"
  for i& = 1 to useTop&
    if useVal&(i&) >= %USR_OPC Then
      o$=pad$(16,lab$)+"jmp"
      o$=Pad$(24,o$)+"#"+useOpc$(i&)
      o$=Pad$(48,o$)+"' "+hex$(useVal&(i&),2)
      Call PasmEmit(o$)
      lab$=""
    end if
  next
  hadCrLf = %FALSE
end sub

Sub InsertOpcNames
Dim i&
Dim lab$
dim o$
dim n&
  lab$="OpcNames"
  for i& = 1 to useTop&
    if useVal&(i&) >= %USR_OPC Then
      o$=pad$(16,lab$)+"byte"
      o$=Pad$(24,o$)+"$"+Hex$(useVal&(i&),2)+", "+Chr$(&h22)
      lab$=useOpc$(i&)
      if len(lab$)>3 then
        o$=o$+left$(lab$,3)+"."+Right$(lab$,3)
      else
        o$=o$+lab$
      end if
      o$=o$+Chr$(&h22)+", 0"
      print#lstFileNum&,o$
      lab$=""
    end if
  next
  o$=Pad$(16,lab$)+"byte"
  o$=Pad$(24,o$)+"$00, "+Chr$(&h22)+"?"+Chr$(&h22)+", 0"
  print#lstFileNum&,o$
  hadCrLf = %FALSE
End Sub

Sub InsertOpcPtrTable
Dim i&
Dim lab$
dim o$
  lab$="OpcPtrTable"
  for i& = 1 to useTop&
    if useVal&(i&) >= %USR_OPC Then
      o$=pad$(16,lab$)+"word"
      o$=Pad$(24,o$)+useOpc$(i&)
      o$=Pad$(48,o$)+"' "+hex$(useVal&(i&),2)
      Call PasmEmit(o$)
      lab$=""
    end if
  next
  hadCrLf = %FALSE
end sub

Sub InsertSourceFile
  Print#lstFileNum&,"  return String( "+Chr$(&h22)+srcFileBase$+".c"+Chr$(&h22)+" )"
  hadCrLf = %FALSE
end sub

Sub InsertSxPin
  if txPin$ = "-0" then
    txPin$="30"
    Say "Defaulting TX Pin to 30 ( PropPlug Serial Out )"
  End If
  if rxPin$ = "-0" then
    rxPin$="31"
    Say "Defaulting RX Pin to 31 ( PropPlug Serial In )"
  End If
  print#lstFileNum&,"  SO_PIN        = "+txPin$
  print#lstFileNum&,"  SI_PIN        = "+rxPin$
  print#lstFileNum&,"  SX_BAUDRATE   = 9600"
  print#lstFileNum&,"  SX_INVERT     = false"
  hadCrLf = %FALSE
End Sub

Sub InsertTvPin
  if tvPin$ = "-0" then
    tvPin$="30"
    Say "Defaulting TV Pin to 'None'"
  End If
  Print#lstFileNum&,"  TV_PIN        = "+tvPin$
  hadCrLf = %FALSE
End Sub

Sub InsertVarNames
Dim i&
Dim lab$
dim o$
dim n&
dim v$
dim j&
  lab$="VarNames"
  for i& = 1 to varTop&
    o$=pad$(16,lab$)+"byte"
    o$=Pad$(24,o$)+Hex$(varSiz&(i&))
    n& = varAdr&(i&)
    shift Right n&,8
    o$=o$+", $"+Hex$(n&,2)+", $"+Hex$(varAdr&(i&),2)
    v$ = Left$(varNam$(i&),8)
    j&=instr(v$," ")
    if j&>0 then
      v$=Left$(v$,j&-1)
    end if
    o$=o$+", "+Chr$(&h22)+v$+Chr$(&h22)+", 0"
    print#lstFileNum&,o$
    lab$=""
  next
  o$=Pad$(16,lab$)+"byte"
  o$=Pad$(24,o$)+"0"
  print#lstFileNum&,o$
  hadCrLf = %FALSE
End Sub

Sub KernelMistake( Byval e$, Optional byval rawL$ )
Static hadKernelError As Boolean
  Call Failed("Kernel Mistake : "+e$)
  if len(rawL$)<>0 Then
    Call Failed("                 "+rawL$)
    errors& = errors&-1
  end if
  if not hadKernelError then
    hadKernelError = %TRUE
    Call Failed("                 Check generated "+srcFileBase$+".Spin file for error marker")
    errors& = errors&-1
    if lstFileNum&<> 0 Then
      print#lstFileNum&,"***** ERROR : "+e$
    end if
  end if
End sub

REM  **************************************************************************
REM  *                                                                        *
REM  *
REM  *                                                                        *
REM  **************************************************************************

