
#Compiler    PbCC
#Console     On
#Debug Error On
#Dim         All
#Tools       Off

$Product   = "AiChip Industries LCC Bytecode Converter for the Propeller"
$Version   = "1.10 #0609"
$Command   = "Compile"
$FileExt   = ".c"

#Resource    "Compile.Pbr"

#Include "Utility.Baz"
#Include "Say.Baz"
#Include "Calendar.Baz"
#Include "FileWild.Baz"
#Include "CmdLine.Baz"
#Include "Version.Baz"
#Include "Library.Baz"
#Include "Opcode.Baz"
#Include "Bytecode.Baz"
#Include "Assemble.Baz"
#Include "MakeList.Baz"

Function PbMain&
global cpp$
global rcc$
Global kernel$
Global mainIsPresent As boolean
Dim f$
dim fx$
dim ff$

  Call ProgramStart($FileExt)

  cpp$ = FindCompiler$("Cpp")
  rcc$ = FindCompiler$("Rcc")

  If Dir$(AppPath$+"Optimise.Exe") = "" Then
    Call Crash("Missing file '"+AppPath$+"Optimise.Exe'")
  End If
  If Not FNswitch("/NOMAKE") then
    If Dir$(AppPath$+"MakeSpin.Exe") = "" Then
      Call Crash("Missing file '"+AppPath$+"MakeSpin.Exe'")
    End If
  end if
  If Not FNswitch("/NOMAKE") then
    kernel$=FindLatest(AppPath$+"Kernel",".Spin")
    If kernel$="" Then
      Call Crash("Missing file '"+AppPath$+"Kernel*.Spin'")
    End If
  end if
  If Not FNswitch("/NOMAKE") then
    If FindLatest(AppPath$+"AiChip_CogDebug",".Spin") = "" Then
      Call Crash("Missing file '"+AppPath$+"AiChip_CogDebug*.Spin'")
    end if
  end if

  Call Report("Checking filenames")
  f$ = GetFirstFilename$
  while len(f$) <> 0
    Call Report( "   File '"+f$+"'")
    f$ = GetNextFilename$
  wend
  Call CheckFirstFileisNotAmbiguous

  if FNswitch("/CLEAN") Then
    Call Report("Cleaning directory of all previous intermediate and output files")
    ff$ = dir$("*.c")
    while ff$<>""
      f$ = Left$(ff$,len(ff$)-2)
      fx$= dir$(f$+".*")
      while fx$=ff$
        fx$ = dir$
      wend
      if fx$<>"" then
        Call Report( "   Cleaning '"+f$+".*'")
        Call TryKill( f$+".Lst"    )
        Call TryKill( f$+".Err"    )
        Call TryKill( f$+".Spin"   )
        Call TryKill( f$+".Binary" )
        Call TryKill( f$+".Eeprom" )
      end if
      f$ = dir$("*.c")
      while f$<>"" and f$<>ff$
        f$ = dir$
      wend
      if f$<>"" then
        ff$ = dir$
      end if
    wend
    f$ = dir$("*.$??")
    while f$<>""
      Call Report( "   Removing '"+f$+"'")
      Call TryKill( f$ )
      f$ = dir$("*.$??")
    wend
  else
    Call Report("Removing any previous intermediate files")
    f$ = GetFirstFilename$
    while len(f$)<>0
      f$ = FilenameBase$(f$)
      Call TryKill( f$+extnPrefix$+".Lst"    )
      Call TryKill( f$+extnPrefix$+".Err"    )
      Call TryKill( f$+extnPrefix$+".Spin"   )
      Call TryKill( f$+extnPrefix$+".Binary" )
      Call TryKill( f$+extnPrefix$+".Eeprom" )
      f$ = GetNextFilename$
    wend
    Call RemoveTemporaryFiles
  end if

  errors& = 0

  SayCrLf
  hldScreenCrLf& = -1

  f$ = GetFirstFilename$
  while len(f$) <> 0 and errors& = 0
    if cmdAnyWildFiles Then
      if Not FNswitch("/SHELL") Then
        Say "Compiling '"+f$+"'"
      end if
    end if
    Call Compile( f$ )
    f$ = GetNextFilename$
  wend

  if errors& = 0 Then

    if cmdAnyWildFiles Then
      if Not FNswitch("/SHELL") Then
        Say
     end if
    end if

    Call Report("Loading bytecode")
    Call BytecodeInit( "ASSEMBLER" )
    f$ = GetFirstFilename$
    while len(f$) <> 0 and errors& = 0
      Call BytecodeLoad( f$, extnPrefix$+".$as", "From Lcc" )
      f$ = GetNextFilename$
    wend
    if errors& = 0 Then
      Call BytecodeSetDataBot
      Call OpcodeInit
      Call Optimise( srcFilename$, extnPrefix$+".$bi", extnPrefix$+".$bo" )
      Call BytecodeInit( "BYTECODE" )
      Call BytecodeLoad( srcFilename$, extnPrefix$+".$bo", "From Optimise" )
      if errors& <> 0 then
        hldScreenCrlf& = 1
      else
        If not mainIsPresent Then
          Call Failed("No 'main' function found")
        end if
        Call BytecodeSetDataBot
        Call Optimise_CheckUniqueLibs
        Call Optimise_IdentifyReals
        Call OpcodeAllocate
        Call AssembleBytecode
        IF logFileNum&<>0 Then
          Call Report("For diagnostic purposes only ...")
          Call BytecodeSave( srcFilename$, extnPrefix$+".$$B", "From Compile","Bytecode Test")
          Call BytecodeSave( srcFilename$, extnPrefix$+".$$T", "As Threaded Code","Thread Code Test")
          Call BytecodeSave( srcFilename$, extnPrefix$+".$$L", "As LMM Code","LMM Code Test")
          Call BytecodeSave( srcFilename$, extnPrefix$+".$$P", "As PASM Code","PASM Code Test")
        end if
        IF Not FNswitch("/NOMAKE") Then
          Call LibraryFixup
        end if
        Call MakeList( srcFilename$ )
        if errors& = 0 Then
          if Not FNswitch("/NOMAKE") Then
            errors& = -1 ' Makespin will report errors
            Call MakeSpin( srcFilename$ )
          end if
        end if
      end if
    end if
  end if

  if Not FNswitch("/NOTIDY") Then
    Call Report("Removing intermediate files")
    Call RemoveTemporaryFiles
  end if

  Call ProgramEnd
End Function

Sub RemoveTemporaryFiles
dim f$
  f$ = GetFirstFilename$
  while len(f$)<>0
    f$ = FilenameBase$(f$)
    Call TryKill( f$+extnPrefix$+".$cp" )
    Call TryKill( f$+extnPrefix$+".$as" )
    Call TryKill( f$+extnPrefix$+".$sy" )
    Call TryKill( f$+extnPrefix$+".$bi" )
    Call TryKill( f$+extnPrefix$+".$bo" )
    Call TryKill( f$+extnPrefix$+".$pi" )
    Call TryKill( f$+extnPrefix$+".$po" )
    Call TryKill( f$+extnPrefix$+".$gi" )
    Call TryKill( f$+extnPrefix$+".$gn" )
    Call TryKill( f$+extnPrefix$+".$sp" )
    Call TryKill( f$+extnPrefix$+".$$b" )
    Call TryKill( f$+extnPrefix$+".$$t" )
    Call TryKill( f$+extnPrefix$+".$$l" )
    Call TryKill( f$+extnPrefix$+".$$p" )
    f$ = GetNextFilename$
  wend
end sub

Sub Help
  Say $Product+" ( "+$Version+" )"
  if Not FNswitch("/SHELL") Then
    If dir$(AppPath$+"Optimise.Exe") <> "" Then
      Shell AppPath$+"Optimise /? /SHELL"
    End If
    If dir$(AppPath$+"MakeSpin.Exe") <> "" Then
      Shell AppPath$+"MakeSpin /? /SHELL"
    End If
    If dir$(AppPath$+"PropLoad.Exe") <> "" Then
      Shell AppPath$+"PropLoad /? /SHELL"
    End If
    Say
    Say Pad$(43+7-len(appname$),"Usage : "+Ucase$(AppName$)+" filename{.c} {/options}")+"( or "+Ucase$(AppName$)+" @filename{.cmd} )"
    Say
    Say "        /BINARY         Create an executable file ( eg, /BINARY, /EEPROM )"
    Say "        /SPIN           Create a '*"+extnPrefix$+".Spin' file as a self-contained program"
    Say "        /OBJECT         Create a '*"+extnPrefix$+".Spin' file as a callable object"
    Say "        /XTALn          Set Crystal Type ( eg, /XTAL1, /RCFAST, /XINPUT )"
    Say "        /nMHZ           Set Clock or System Speed ( eg, /5MHz, /10MHz, /80MHz )"
    Say "        /PLLnnx         Set PLL ( eg, /PLL8x, /PLL16x )"
    Say "        /pin:number     Set Pin Numbers ( eg, /TV:12, /RX:31, /TX:30 )"
    Say
    Say "        /ADVANCED{:n}   Display advanced compiler options"
    Say
    Say "This software utility requires the LCC compiler available free of charge from"
    Say "Princeton University. Copyright (C) 1991,1992,1993,1994,1995,1996,1997,1998 by"
    Say "AT&T, Christopher W. Fraser, and David R. Hanson. All Rights Reserved. Please"
    Say "report all bugs to AiChip Industries."
  End If
End Sub

Sub HelpAdvanced
  if FNswitch("/ADVANCED:*") then
    Say String$(80,"*")
    Say Pad$(79,"*")+"*"
    Say Pad$(79,"*  Manual for the "+$Product)+"*"
    Say Pad$(79,"*")+"*"
    Say String$(80,"*")
    Say Pad$(79,"*")+"*"
    Say "*  This configuration probably came from 'AiChip Propeller C "+$Version+".Zip'   *"
    Say Pad$(79,"*  and is installed in '"+Left$(AppFullPath$,Len(AppFullPath$)-1)+"'.")+"*"
    Say Pad$(79,"*")+"*"
    Say String$(80,"*")
    Say
  end if
  Say $Product+" ( "+$Version+" )"
  if FNswitch("/ADVANCED:*") then
    If dir$(AppPath$+"Optimise.Exe") <> "" Then
      Shell AppPath$+"Optimise /? /SHELL"
    End If
    If dir$(AppPath$+"MakeSpin.Exe") <> "" Then
      Shell AppPath$+"MakeSpin /? /SHELL"
    End If
  end if
  Say
  Say Pad$(43+7-len(appname$),"Usage : "+Ucase$(AppName$)+" filename{.c} {/options}")+"( or "+Ucase$(AppName$)+" @filename{.cmd} )"
  Say
  if FNswitch("/ADVANCED:*") Then
    Say "Command line help options ..."
    Say
    Say "        "+Ucase$(AppName$)+" /?             Show most common options"
    Say "        "+Ucase$(AppName$)+" /ADVANCED      Show list of advanced options"
    Say "        "+Ucase$(AppName$)+" /ADVANCED:n    Show specific advanced options"
    Say "        "+Ucase$(AppName$)+" /ADVANCED:*    Show all advanced options"
    Say
  end if
  if FNswitch("/ADVANCED:6") Or FNswitch("/ADVANCED:*") Then
    Say "Command line control options ..."
    Say
    Say "        "+Ucase$(AppName$)+"                Repeat last compilation"
    Say "        "+Ucase$(AppName$)+" @              Use command line in '"+AppName$+".Cmd'"
    Say "        "+Ucase$(AppName$)+" @file{.cmd}    Use command line in '*.Cmd'"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:1") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced output options ..."
    Say
    Say "        /BINARY         Create a '*"+extnPrefix$+".Binary' file"
    Say "        /EEPROM         Create a '*"+extnPrefix$+".Eeprom' file"
    Say "        /SPIN           Create a '*"+extnPrefix$+".Spin' file'"
    Say
    Say "        /OBJECT         Create a callable object"
    Say "        /TEST           Create a self-contained testable program"
    Say "        /DEBUG          Create a self-contained kernel debugger"
    Say
    Say "        /NORAM          Run code from Eeprom ( /NORAM, /ROM )"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:2") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced compilation options ..."
    Say
    Say "        /NOMAKE         Compile only ( do not call MakeSpin )"
    Say "        /VERBOSE        Detail compilation progression"
    Say "        /NOLIST         Do not create a '*"+extnPrefix$+".Lst' Listing file"
    Say "        /LIST:ALL       Include internal information in listing file"
    Say "        /ALIGN          Force alignment ( /ALIGN, /ALIGN:VAR, /ALIGN:NUM )"
    Say "        /UCHAR          Default to unsigned char"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:3") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced configuration options ..."
    Say
    Say "        /DEMO           Build for Parallax Demo Board"
    Say "        /PROTO          Build for Parallax Proto Board"
    Say "        /HYDRA          Build for Hydra Games System"
    Say "        /HYDRA          Build for Spin Stamp System"
    Say "        /AICHIP         Build for AiChip Development Board"
    Say
    Say "        /XTALn          Set Crystal Type ( eg, /XTAL1, /RCFAST, /XINPUT )"
    Say "        /nMHZ           Set Clock or System Speed ( eg, /5MHz, /10MHz, /80MHz )"
    Say "        /PLLnnx         Set PLL ( eg, /PLL8x, /PLL16x )"
    Say
    Say "        /TV:pin         Set pin for TV display ( eg /TV:12, /TV12 )"
    Say "        /TX:pin         Set pin for Serial Out ( eg /TX:30, /TX30 )"
    Say "        /RX:pin         Set pin for Serial In  ( eg /RX:31, /RX31 )"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:4") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced code generation options ..."
    Say
    Say "        /KERNEL:name    Name or version of kernel to use"
    Say
    Say "        /BYTECODE       Generate bytecode executable  ( smallest, slowest )"
    Say "        /THREADED       Generate 16-bit threaded code ( compact , slower  )"
    Say "        /LMM            Generate 32-bit LMM code      ( larger  , faster  )"
    Say "        /PASM           Generate 32-bit PASM code     ( largest , fastest )"
    Say
    Say "        /NOPACK         Don't use number compacting   ( larger  , faster  )"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:5") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced control options ..."
    Say
    Say "        /NOERROR        Do not give an error report"
    Say "        /LOG            Log compilation process as '"+AppName$+extnPrefix$+".Log'"
    Say "        /NOENV          Ignore options in AILCC environment variable"
    Say "        /NOTIDY         Keep temporary files after compilation"
    Say "        /SHELL          Use when called from another program"
    Say "        /BATCH          Use when called from within a .Bat file"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if FNswitch("/ADVANCED:7") Or FNswitch("/ADVANCED:*") Then
    Say "Advanced download options ..."
    Say
    Say "        /COM:n          Serial port to download through ( optional )"
    Say "        /SAVE           Save download to Propeller Eeprom"
    Say "        /BREAK          Send 'break' signal to initiate reset"
    Say
    if Not FNswitch("/ADVANCED:*") Then
      Exit Sub
    End If
  end if
  if Not FNswitch("/ADVANCED:*") Then
    Say "        /ADVANCED:1     Show advanced output options"
    Say "        /ADVANCED:2     Show advanced compilation options"
    Say "        /ADVANCED:3     Show advanced configuration options"
    Say "        /ADVANCED:4     Show advanced code generation options"
    Say "        /ADVANCED:5     Show advanced control options"
    Say "        /ADVANCED:6     Show command line control options"
    Say "        /ADVANCED:7     Show program download options"
    Say
    Say "Note : Use '"+AppName$+" /ADVANCED:* > filename.ext' to create a text file
    Say "       list of all options"
  else
    Say "This software utility requires the LCC compiler available free of charge from"
    Say "Princeton University. Copyright (C) 1991,1992,1993,1994,1995,1996,1997,1998 by"
    Say "AT&T, Christopher W. Fraser, and David R. Hanson. All Rights Reserved. Please"
    Say "report all bugs to AiChip Industries."
    Say
    Say "AiChip is a trademark of AiChip Industries."
  end if
End Sub

Sub Compile( ByVal f$ )
  Call Report("Compiling "+f$)
  f$ = FilenameBase$(f$)
  Execute cpp$+" -I"+Left$(AppFullPath$,Len(AppFullPath$)-1)+" "+f$+".c "+f$+extnPrefix$+".$cp"
  if dir$(f$+extnPrefix$+".$cp") = "" Then
    errors&=errors&+1
  else
    If FNswitch("/UCHAR") then
      Execute rcc$+" -target=bytecode -g -unsigned_char=1 "+f$+extnPrefix$+".$cp -o "+f$+extnPrefix$+".$as"
    else
      Execute rcc$+" -target=bytecode -g "+f$+extnPrefix$+".$cp -o "+f$+extnPrefix$+".$as"
    end if
    Call CheckCompiledOkay(f$) ' Exits if failed
    Execute rcc$+" -target=symbolic -g "+f$+extnPrefix$+".$cp -o "+f$+extnPrefix$+".$sy"
  end if
End Sub

Sub CheckCompiledOkay( ByVal f$)
Dim s&
dim okay as boolean
dim l$
dim ideFileNum&
  Call Report("   Checking if compilation was successful")
  okay = %FALSE
  s&=FreeFile
  open f$+extnPrefix$+".$as" for input as #s&
  while (Not eof(s&)) and (Not okay)
    line input#s&,l$
    okay = ( left$(l$,6)="file "+Chr$(&h22) )
  wend
  close#s&
' @@@@@@@@@@@@@ THIS IS A MAJOR HACK
if ucase$(srcfilename$)="TV_TEXT.C" then okay=%TRUE
' @@@@@@@@@@@@@
  if not okay then
    Call Report("      It failed")
    If FNswitch("/IDE") Then
      ideFileNum& = FreeFile
      Open AppPath$+AppName$+extnPrefix$+".Ide" For output as #ideFileNum&
      Print#ideFileNum&,"-1"
      close#ideFileNum&
    End If
    Call RemoveTemporaryFiles
    errors&=-1
    Call ProgramEnd
  end if
  Call Report("      It was successful")
End Sub

Sub MakeSpin( ByVal f$ )
  f$ = FilenameBase$(f$)
  Call Report("Creating "+f$+extnPrefix$+".Spin")
  Execute AppPath$+"MakeSpin "+f$+extnPrefix$+".$gn /SHELL"+cmdSwitches$
End Sub

REM  **************************************************************************
REM  *                                                                        *
REM  *  Optimisation                                                          *
REM  *                                                                        *
REM  **************************************************************************

Sub Optimise( ByVAl f$, ByVal bi$, ByVal bo$ )
  Call Report("Optimising bytecode store")
  Call Optimise_RepairMoveBlock
  Call Optimise_RemoveNop
  Call BytecodeSave( f$, bi$, "For Optimise", "Bytecode Before Optimisation" )
  Call Report("Calling optimiser")
  Execute AppPath$+"Optimise "+FilenameBase$(f$)+bi$+" /SHELL/NOERROR"+cmdSwitches$
  Call Report("Loading optimised bytecode")
End Sub

Sub Optimise_RepairMoveBlock
Global dataBot&
Dim i&
dim count&
  Call Report("   Repairing 'Move Blocks'")
  count&=0
  i& = 2
  while i& < dataBot&
    if codeOpc$(i&)="ASGNB" Then
      if codeOpc$(i&-1)="INDIRB" Then
        codeOpc$(i&-1)="NUM.I32"
        codeOpr$(i&-1)="#"+codeOpr$(i&)
        codeOpc$(i&)="MOV.I08"
        codeOpr$(i&)=""
        count&=count&+1
      end if
    End If
    i&=i&+1
  wend
  if count&=0 then
    call report("      None present")
  else
    call report("      "+FNstr$(count&)+" repaired")
  end if
End Sub

Sub Optimise_RemoveNop
Global codeLin&()
Global codeOpc$()
Global codeOpr$()
Global codeTop&
Global changedFlag As Boolean
Global useLnk&()
Global useCnt&()
Dim i&
dim j&
dim count&
  Call Report("   Removing non-operation opcodes")
  count&=0
  i& = codeTop&
  While i& > 1
    if Mid$(codeOpc$(i&),2,1) = "2" Then
      j& = OpcodeLookup&(codeOpc$(i&))
      If useLnk&(j&) = -2 then
        useCnt&(j&)=useCnt&(j&)+1
        codeOpc$(i&)="---"
        codeTyp$(i&)=""
        codeOpr$(i&)=""
        count&=count&+1
      End If
    End If
    i& = i&-1
  Wend
  if count&=0 then
    call report("      None present")
  else
    call report("      "+FNstr$(count&)+" removed")
  end if
End Sub

Function DescribeLabel$( ByVal i& )
  select case codeOpc$(i&+1)
    Case "BYTE"
      DescribeLabel$="byte variable"
    Case "WORD"
      DescribeLabel$="word variable"
    Case "LONG"
      DescribeLabel$="long variable"
    Case "CHAR"
      DescribeLabel$="char variable"
    Case "REAL"
      DescribeLabel$="real variable"
    Case "ENT"
      DescribeLabel$="function"
    Case else
      DescribeLabel$="unknown"
  end select
end function

Sub Optimise_CheckUniqueLibs
dim i&
dim lab$
dim j&
dim first As Boolean
dim o$
  Call Report("   Checking unique library names")
  for i&=1 to dataBot&-1
    if codeOpc$(i&)="LAB" Then
      first = %TRUE
      lab$ = codeOpr$(i&)
      j&=dataBot&-1
      while j& > i&
        if codeOpc$(j&) = "LAB" then
          if codeOpr$(j&)=lab$ then
            if first Then
              first = %FALSE
              if codeOpc$(i&+1)=codeOpc$(j&+1) Then
                select case codeOpc$(i&+1)
                  Case "BYTE","WORD","LONG","CHAR","REAL"
                    o$ = o$+"variable "
                  Case "ENT"
                    o$ = o$+"function "
                end select
                o$="Duplicate "+DescribeLabel$(i&)+" '"+lab$+"'"
              else
                o$="Duplicate '"+lab$+"' used as "+DEscribeLabel$(i&)+" and "+DEscribeLabel$(j&)
              end if
              call Failed(o$)
            end if
            codeOpc$(j&)="---"
          end if
        end if
        j&=j&-1
      wend
    end if
  next
end sub

Sub Optimise_IdentifyReals
dim i&
dim j&
dim lab$

' Didn't work quite as planned. This only finds the NUM.P32 #MEM+f1 etc and
' that is never a .Fxx opcode ! The opcodes which ar Fxx don't have any ref
' to the variable itself. Best we might have is a load NUM.P32/GTI.F32 or a
' load constant NUM.P32/NUM.F32/PTI.F32

  Exit Sub

  for i&=2 to codeTop&
    if codeOpc$(i&)="LONG" then
      if codeOpc$(i&-1) = "LAB" then
        lab$=CodeOpr$(i&-1)
        j& = dataBot&-1
        while j& > 0
          if codeOpr$(j&)=lab$ Then
            if codeTyp$(j&)="#MEM+" then

              if mid$(codeOpc$(j&),5,1)="F" then
                codeOpc$(i&)="REAL"
                j&=i&+1
                while codeOpc$(j&)="LONG"
                  codeOpc$(j&)="REAL"
                  j&=j&+1
                wend
                j& = 0
              end if
            end if
          end if
          j&=j&-1
        wend
      end if
    end if
  next
End Sub

