
#Compiler    PbCC
#Console     On
#Debug Error On
#Dim         All
#Tools       Off

$Product   = "AiChip Industries LCC Bytecode Optimiser for the Propeller"
$Version   = "1.00 #0166"
$Command   = "Optimise"
$FileExt   = ".$gi .$pi .$bi"

#Resource    "Optimise.Pbr"

#Include "Utility.Baz"
#Include "Say.Baz"
#Include "FileWild.Baz"
#Include "CmdLine.Baz"
#Include "Version.Baz"
#Include "Library.Baz"
#Include "Opcode.Baz"
#Include "Bytecode.Baz"

Function PbMain&
Dim f$
Dim saveSwitches$
  Call ProgramStart($FileExt)

  Dim arg(9) As Global String

  if FNSwitch("/SHELL") Then
    hldScreenCrLf&=-1
  end if

  errors& = 0
  f$ = GetFirstFilename$
  while len(f$) <> 0 and errors& = 0
    saveSwitches$=cmdSwitches$
    if cmdAnyWildFiles Then
      if Not FNswitch("/SHELL") Then
        select case Ucase$(srcFileExtn$)
          Case ".$BI" : Say "Optimising '"+srcFilename$+"' Bytecode"
          Case ".$PI" : Say "Optimising '"+srcFilename$+"' PASM code"
          Case Else   : Say "Optimising '"+srcFilename$+"'"
        end select
      end if
    end if
    Call Optimise
    f$ = GetNextFilenameAsSrcFilename$
  wend

  Call ProgramEnd
End Function

Sub Help
  Call HelpAdvanced
'  Say $Product+" ( "+$Version+" )"
  if Not FNswitch("/SHELL") Then
'    Say
'    Say "Usage : OPTIMISE filename{.$bi|.$pi} {/options}"
'    Say
'    Say
'    Say "        /ADVANCED       Display advanced optimiser options"
    Say
    Say "Note : Use "+Chr$(&h22)+"COMPILE filename /NOTIDY"+chr$(&h22)+" to create .$bi and .$pi files"
  End If
End Sub

Sub HelpAdvanced
  Say $Product+" ( "+$Version+" )"
  if Not FNswitch("/SHELL") Then
    Say
    Say "Usage : OPTIMISE filename{.$b|.$pi} {/options}"
    Say
'    Say "Advanced options ..."
'    Say
    Say "        /LOG            Log optimisation process as '"+AppName$+extnPrefix$+".Log'"
    Say "        /VERBOSE        Detail optimisation progression"
    Say "        /NOERROR        Do not give an error report"
    Say "        /SHELL          Use when called from another program"
    Say "        /BATCH          Use when called from a .Bat file"
  end if
End Sub

Sub Optimise
Global pass&
  Call Report("Optimising "+srcFileName$)
  Call BytecodeInit( "BYTECODE" )
  Call BytecodeLoad( srcFileName$, ".$bi", "From Compile" )
  Call Optimise_Loop
  Call BytecodeSave( srcFileName$, ".$bo", "For Compile", "Bytecode After Optimisation ( "+FNstr$(pass&)+" passes )")
End Sub

REM  **************************************************************************
REM  *                                                                        *
REM  *
REM  *                                                                        *
REM  **************************************************************************

Sub Compact
global changed as boolean
global changedLast as boolean
global needCompact as boolean
global dataBot&
Dim i&
Dim j&
  j& = 0
  codeOpc$(0)=""
  while codeOpc$(codeTop&)="---"
    codeTop&=codeTop&-1
  wend
  for i&= 1 to codeTop&
    if codeOpc$(i&) = "---" then
      changed = %TRUE
    else
      j&=j&+1
      if j& <> i& then
        codeLin&(j&) = codeLin&(i&)
        codeOpc$(j&) = codeOpc$(i&)
        codeTyp$(j&) = codeTyp$(i&)
        codeOpr$(j&) = codeOpr$(i&)
      end if
    end if
  next
  codeTop& = j&
  needCompact = %FALSE
  dataBot& = codeTop&
  do
    select case codeOpc$(dataBot&)
      case "END","LAB","BYTE","WORD","LONG","CHAR","REAL","SKIP"
        dataBot&=dataBot&-1
      case else
        dataBot& = dataBot&+1
        exit sub
    end select
  loop while %TRUE
End Sub

' "1=*"     Set Arg$(1) to whatever the parameter is
' "*=1"     Must match Arg$(1)
' "<xxxx>"  Must match xxxx
' "xxxx"    Must start with xxx
' ""        Don't care

Function Match( ByVal i&, ByVal opc$, Byval typ$, ByVal opr$) As Boolean
global codeOpc$()
global codeTyp$()
global codeOpr$()
global codeTop&
global codeIdx&
global arg$()
global matchFrom&
global matchOnto&
global changedLast As Boolean

  Match = %FALSE

  If i& < 1 or i& > codeTop& Then
    Exit Function
  End If

  If codeOpc$(i&) = "---" Then
    Exit Function
  End If

  If Len(opc$)<>0 Then
    if left$(opc$,2)="*=" Then
      If codeOpc$(i&) <> arg$(Val(Right$(opc$,1))) Then
        Exit Function
      End If
    Else
      If Right$(opc$,2) = "=*" Then
        arg$(Val(Left$(opc$,1))) = codeOpc$(i&)
      else
        if Left$(opc$,1) = "<" then
          if codeOpc$(i&) <> Mid$(opc$,2,Len(opc$)-2) Then
            Exit Function
          end if
        else
          if Left$(codeOpc$(i&),Len(opc$)) <> opc$ Then
            Exit Function
          end if
        end if
      end if
    end if
  end if

  If Len(opr$)<>0 Then
    if left$(opr$,2)="*=" Then
      If codeOpr$(i&) <> arg$(Val(Right$(opr$,1))) Then
        Exit Function
      End If
    Else
      If Right$(opr$,2) = "=*" Then
        arg$(Val(Left$(opr$,1))) = codeOpr$(i&)
      else
        if Left$(opr$,1) = "<" then
          if codeOpr$(i&) <> Mid$(opr$,2,Len(opr$)-2) Then
            Exit Function
          end if
        else
          if Left$(codeOpr$(i&),Len(opr$)) <> opr$ Then
            Exit Function
          end if
        end if
      end if
    end if
  end if

  If Len(typ$)<>0 Then
    if left$(typ$,2)="*=" Then
      If codeTyp$(i&) <> arg$(Val(Right$(typ$,1))) Then
        Exit Function
      End If
    Else
      If Right$(typ$,2) = "=*" Then
        arg$(Val(Left$(typ$,1))) = codeTyp$(i&)
      else
        if Left$(typ$,1) = "<" then
          if codeTyp$(i&) <> Mid$(typ$,2,Len(typ$)-2) Then
            Exit Function
          end if
        else
          if Left$(codeTyp$(i&),Len(typ$)) <> typ$ Then
            Exit Function
          end if
        end if
      end if
    end if
  end if

  if matchFrom& = 0 Then
    matchFrom& = i&
    matchOnto& = i&+matchOnto&
  end if

  Match = %true

End Function

Sub TryThis(ByVal siz&,Byval desc$)
  Call DumpLast
  matchFrom& = 0
  matchOnto& = siz&-1
End Sub

Sub Remove( ByVal i&, Optional ByVal desc$ )

  if flgVerbose then
    if len(desc$)<>0 then
      Say "   "+desc$
    end if
  end if

  Call HoldLast(desc$)
  Call Touch(i&)

  if codeOpc$(i&) <> "LAB" then
    codeSave&=codeSave&+1
  end if

  codeOpc$(i&) = "---"
  codeTyp$(i&) = ""
  codeOpr$(i&) = ""

  needCompact = %TRUE

End sub

' "*"     Keep same
' xx*
' "*1"    Replace by arg$(1)
' "^1"    Replace by codeXXX$(1)
' "xx+*1" Replace by xx + rhs of arg$(1)
' "xx+^1" Replace by xx + rhs of codeXxx$(1)

Sub Change( Byval i&, Byval opc$, byval typ$, byval opr$, Optional ByVal desc$)

  if flgVerbose then
    if len(desc$)<>0 then
      Say "   "+desc$
    end if
  end if

  Call HoldLast(desc$)
  Call Touch(i&)

  Call ChangeXxx(codeOpc$(i&),opc$)
  Call ChangeXxx(codeTyp$(i&),typ$)
  Call ChangeXxx(codeOpr$(i&),opr$)

End Sub

Sub ChangeXxx( ByRef xxx$,ByVal t$)
dim j&
dim k&

  if len(t$)=0 then
    xxx$=""
  else
    if t$ <> "*" Then
      If right$(t$,1)="*" then
        j&=len(t$)-1
        xxx$ = left$(t$,j&)+Right$(xxx$,len(xxx$)-j&)
      else
        if left$(t$,1)="*" then
          j& = Val(Right$(t$,Len(t$)-1))
          xxx$ = arg$(j&)
        else
          if left$(t$,1)="^" then
            j& = Val(Right$(t$,Len(t$)-1))
            xxx$ = codeOpc$(j&)
          else
            k& = Instr(t$,"+*")
            if k&<>0 then
              j&=Val(Right$(t$,Len(t$)-k&-1))
              k&=k&-1
              xxx$=Left$(t$,k&)+Right$(arg$(j&),len(arg$(j&))-k&)
            else
              k& = Instr(t$,"+^")
              if k&<>0 then
                j&=Val(Right$(t$,Len(t$)-k&-1))
                k&=k&-1
                xxx$=Left$(t$,k&)+Right$(codeOpc$(j&),len(codeOpc$(j&))-k&)
              else
                xxx$=t$
              end if
            end if
          end if
        end if
      end if
    end if
  end if
end sub

Sub Touch( byval i& )
  if not heldMark(i&) Then
    heldMark(i&) = %TRUE
    heldOpc$(i&) = codeOpc$(i&)
    heldTyp$(i&) = codeTyp$(i&)
    heldOpr$(i&) = codeOpr$(i&)
  end if
end sub

Sub HoldLast( byVal desc$ )
global changed As boolean
global changedlast as boolean
Dim i&
  if not changedLast Then
    if logFileNum&<>0 Then
      Print#logFilenum&, desc$
      for i&=1 to codeTop&
        heldMark(i&) = %FALSE
      next
      for i&=matchFrom& to matchOnto&
        heldOpc$(i&) = codeOpc$(i&)
        heldTyp$(i&) = codeTyp$(i&)
        heldOpr$(i&) = codeOpr$(i&)
      next
    end if
  end if
  changedLast = %TRUE
  changed = %TRUE
end Sub

Sub DumpAll
Dim i&
dim o$
  if logFileNum&<>0 Then
    Print#logFilenum&, string$(79,"*")
    for i&=1 to codeTop&
      o$ = "* "+Right$("0000"+FNstr$(codeLin&(i&)),5)
      if codeOpc$(i&)="LAB" then
        o$=Pad$(16,o$)+codeOpr$(i&)
      else
        o$=Pad$(24,o$)+codeOpc$(i&)
        o$=Pad$(32,o$)+codeTyp$(i&)+codeOpr$(i&)
      end if
      o$=Pad$(78,o$)+"*"
      print#logFileNum&,o$
    next
    Print#logFilenum&, string$(79,"*")
    print#logFileNum&,""
  end if
end sub

Sub DumpLast
Dim i&
dim o$
dim first as boolean
  if changedLast then
    if logFileNum&<>0 Then
      Print#logFilenum&, "."+string$(77,"-")+"."
      for i&=matchFrom& to matchOnto&
        o$ = "| "+Right$("0000"+FNstr$(codeLin&(i&)),5)
        if heldOpc$(i&)="LAB" then
          o$=Pad$(16,o$)+heldOpr$(i&)
        else
          o$=Pad$(24,o$)+heldOpc$(i&)
          o$=Pad$(32,o$)+heldTyp$(i&)+heldOpr$(i&)
        end if
        if codeOpc$(i&)="LAB" then
          o$=Pad$(48,o$)+codeOpr$(i&)
        else
          o$=Pad$(56,o$)+codeOpc$(i&)
          o$=Pad$(64,o$)+codeTyp$(i&)+codeOpr$(i&)
        end if
        o$=Pad$(78,o$)+"|"
        print#logFileNum&,o$
      next
      first = %TRUE
      for i&=1 to codeTop&
        if heldMark(i&) then
          if i& < matchFrom& or i& > matchOnto& then
            if first then
              Print#logFilenum&, "|"+string$(77,"-")+"|"
              first = %FALSE
            end if
            o$ = "| "+Right$("0000"+FNstr$(codeLin&(i&)),5)
            if heldOpc$(i&)="LAB" then
              o$=Pad$(16,o$)+heldOpr$(i&)
            else
              o$=Pad$(24,o$)+heldOpc$(i&)
              o$=Pad$(32,o$)+heldTyp$(i&)+heldOpr$(i&)
            end if
            if codeOpc$(i&)="LAB" then
              o$=Pad$(48,o$)+codeOpr$(i&)
            else
              o$=Pad$(56,o$)+codeOpc$(i&)
              o$=Pad$(64,o$)+codeTyp$(i&)+codeOpr$(i&)
            end if
            o$=Pad$(78,o$)+"|"
            print#logFileNum&,o$
          end if
        end if
      next
      Print#logFilenum&, "`"+string$(77,"-")+"'"
    end if
  end if
  changedLast = %FALSE
  matchFrom& = 0
  matchOnto& = 0
End Sub

Sub DeadCode( Byval i&, Byval desc$)
  Call TryThis(1,desc$)
  matchFrom&=i&
  matchOnto&=i&
  i&=i&+1
  while i& <= codeTop&
    select case codeOpc$(i&)
      ' We need to stop on "---" or we repeat forever
      Case "LAB","END","---"
        i& = codeTop&
      Case else
        Call Remove(i&,desc$)
    end select
    i& = i&+1
  wend
End Sub

REM  **************************************************************************
REM  *                                                                        *
REM  *
REM  *                                                                        *
REM  **************************************************************************

Sub Optimise_Loop
Global codeTop&
global arg$()
Global changed as boolean
global changedLast As Boolean
global matchFrom&
global matchOnto&
global pass&
Dim i&
Dim j&
dim o$
dim labNumber&
dim oldLab$
dim newLab$
dim l$

  if logFileNum&<>0 Then
    print#logFileNum&,""
    print#logFileNum&,"Initial bytecode ..."
    print#logFileNum&,""
    Call DumpAll
  end if

  pass& = 0
  Do
    Do
      pass&=pass&+1
      changed = %FALSE
      changedLast = %FALSE
      matchFrom& = 0

      If pass& = 1 then
        For i& = 1 to codeTop&
          Call TryThis(4,"Insert Asm code")
          If Match(i&+0, "NUM"     , "#MEM+" , "1=*" ) And _
             Match(i&+1, "ARG.P32" , ""      , ""    ) And _
             Match(i&+2, "NUM.P32" , "#MEM+" , "asm" ) And _
             Match(i&+3, "JSI"     , ""      , ""    ) _
          Then
            j& = FindLabel&(arg$(1))
            if j& > 0 Then
              l$=""
              j&=j&+1
              if codeOpc$(j&)="CHAR" then
                while j& > 0 and codeOpc$(j&)="CHAR"
                  Touch(j&)
                  if codeOpr$(j&)="0" then
                    j&=0
                  else
                    if left$(codeOpr$(j&),1)="'" then
                      l$=l$+Mid$(codeOpr$(j&),2,1)
                    else
                      l$=l$+codeOpr$(j&)
                    end if
                    j&=j&+1
                  end if
                wend
Call Failed("Inline ASM is not supported yet '"+l$+"'")
                Change(i&+0,"ASM","",l$,"Inserted Asm Code")
                Remove(i&+1)
                Remove(i&+2)
                Remove(i&+3)
              end if
            end if
          end if
        next
      end if

      For i& = 1 to codeTop&
        Select case Left$(codeOpc$(i&),3)

          Case "ABS"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Consecutive Abs                                    *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Remove Consecutive Not")

            if Match(i&+0, "ABS" , "" , "" ) And _
               Match(i&+1, "ABS" , "" , "" ) _
            Then
              Call Remove(i&+1,"Removed Consecutive Abs")
            End If

          Case "ARG"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove duplicate Arg markers                              *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Remove Duplicate Arg Markers")

            if Match(i&-1, ""    , ""      , ""    ) And _
               Match(i&+0, "ARG" , ""      , ""    ) _
            Then
              j& = i&+1
              while j& <= codeTop&
                select case left$(codeOpc$(j&),3)
                  case "ARG"
                    Call Remove(j&,"Removed duplicate Arg markers")
                  case "JSI","JFI"
                    if logFileNum&<>0 Then
                      while j& >= i&
                        Call Touch(j&)
                        j&=j&-1
                      wend
                      Call Touch(i&-1)
                    end if
                    j& = codeTop&
                end select
                j&=j&+1
              wend
            end if

          Case "BYT","WOR","LON","CHA","REA","SKI"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove dead code after variables                          *
            ' *                                                               *
            ' *****************************************************************

            select case codeOpc$(i&+1)
              Case "LAB","END","---","BYTE","WORD","LONG","CHAR","REAL","SKIP"
              case else
                Call DeadCode(i&,"Removed Dead Code After Variable")
            end select

          Case "DIV"

            ' *****************************************************************
            ' *                                                               *
            ' *     Replace Div with Signed Shift Right                       *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Replace Div With Signed Shift Right")
            if Match(i&-1, "NUM"   , "<#>" , "1=*" ) And _
               Match(i&-0, "DIV.S" , ""    , ""    ) _
            Then
              select case Val(arg$(1))
                case &h00000001& : Call Remove(i&-1,"Removed Div by One")
                                   Call Remove(i&-0)
                                   j&=0
                case &h00000002& : j&=1
                case &h00000004& : j&=2
                case &h00000008& : j&=3
                case &h00000010& : j&=4
                case &h00000020& : j&=5
                case &h00000040& : j&=6
                case &h00000080& : j&=7
                case &h00000100& : j&=8
                case &h00000200& : j&=9
                case &h00000400& : j&=10
                case &h00000800& : j&=11
                case &h00000100& : j&=12
                case &h00002000& : j&=13
                case &h00004000& : j&=14
                case &h00008000& : j&=15
                case &h00010000& : j&=16
                case &h00020000& : j&=17
                case &h00040000& : j&=18
                case &h00080000& : j&=19
                case &h00100000& : j&=20
                case &h00200000& : j&=21
                case &h00400000& : j&=22
                case &h00800000& : j&=23
                case &h01000000& : j&=24
                case &h02000000& : j&=25
                case &h04000000& : j&=26
                case &h08000000& : j&=27
                case &h10000000& : j&=28
                case &h20000000& : j&=29
                case &h40000000& : j&=30
                case &h80000000& : j&=31
                case else        : j&=0
              end select
              if j& <> 0 Then
                Call Change(i&-1,"*","#",FNstr$(j&),"Replaced Div with Signed Shift Right")
                Call Change(i&-0,"ASR*","","")
              end if
            End If

          Case "ENT"

            ' *****************************************************************
            ' *                                                               *
            ' *     Reduce Enter followed by Exit                             *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(3,"Reduce Enter followed by Exit")

            if Match(i&-1, "NUM" , "" , "" ) And _
               Match(i&+0, "ENT" , "" , "" ) And _
               Match(i&+1, "EXT" , "" , "" ) _
            Then
              Call Remove(i&-1,"Reduce Enter followed by Exit")
            End If

          Case "EXT"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Dead Code After Exit                               *
            ' *                                                               *
            ' *****************************************************************

            Call DeadCode(i&,"Removed Dead Code After Exit")

          Case "JEQ"

            ' *****************************************************************
            ' *                                                               *
            ' *     Create Boolean Conditional                                *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(3,"Create Boolean conditional")

            if Match(i&-2, "NUM" , "<#>"   , "<0>" ) And _
               Match(i&-1, "NUM" , ""      , ""    ) And _
               Match(i&-0, "JNE" , ""      , ""    ) _
            Then
              Call Remove(i&-2,"Created Boolean conditional")
              Call Change(i&-0,"JPT*","","")
            End If

            Call TryThis(3,"Create Boolean conditional")

            if Match(i&-2, "NUM" , "<#>"   , "<0>" ) And _
               Match(i&-1, "NUM" , ""      , ""    ) And _
               Match(i&-0, "JEQ" , ""      , ""    ) _
            Then
              Call Remove(i&-2,"Created Boolean conditional")
              Call Change(i&-0,"JPF*","","")
            End If

          Case "JPI"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Jump To Next                                       *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(3,"Remove Jump To Next")

            if Match(i&-1, "NUM" , "#MEM+" , "1=*" ) And _
               Match(i&+0, "JPI" , ""      , ""    ) And _
               Match(i&+1, "LAB" , ""      , "*=1" ) _
            Then
              Call Remove(i&-1,"Removed Jump To Next")
              Call Remove(i&+0)
            End If

            ' *****************************************************************
            ' *                                                               *
            ' *     Update Jump To Jump                                       *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Update Jump To Jump")

            if Match(i&-1, "NUM" , "#MEM+" , "1=*" ) And _
               Match(i&+0, "JPI" , ""      , ""    ) _
            Then
              j& = FindLabel&(arg$(1))
              if j& > 0 Then
                if Match(j&+1, "NUM" , "#MEM+" , "2=*" ) And _
                   Match(j&+2, "JPI" , ""      , ""    ) _
                Then
                  if arg$(1) <> arg$(2) Then
                    Call Change(i&-1,"*","*",arg$(2),"Updated Jump To Jump")
                    Call Touch(j&+1)
                    Call Touch(j&+2)
                  end if
                End If
              End If
            End If

            ' *****************************************************************
            ' *                                                               *
            ' *     Update Jump To Exit                                       *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Update Jump To Exit")

            if Match(i&-1, "NUM" , "#MEM+" , "1=*" ) And _
               Match(i&+0, "JPI" , ""      , ""    ) _
            Then
              j& = FindLabel&(arg$(1))
              if j& > 0 Then
                if Match(j&+1, "EXT" , "" , "" ) Then
                  if Match(j&+1, "1=*" , "" , "" ) Then
                    Call Change(i&-1,arg$(1),"","","Updated Jump To Exit")
                    Call Remove(i&+0)
                    Call Touch(j&+1)
                  end if
                End If
              End If
            End If

            ' *****************************************************************
            ' *                                                               *
            ' *     Update Jump To Return                                     *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Update Jump To Return")

            if Match(i&-1, "NUM" , "#MEM+" , "1=*" ) And _
               Match(i&+0, "JPI" , ""      , ""    ) _
            Then
              j& = FindLabel&(arg$(1))
              if j& > 0 Then
                if Match(j&+1, "RET" , "" , "" ) Then
                  if Match(j&+1, "1=*" , "" , "" ) Then
                    Call Change(i&-1,arg$(1),"","","Updated Jump To Return")
                    Call Remove(i&+0)
                    Call Touch(j&+1)
                  end if
                End If
              End If
            End If

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Dead Code After Jump                               *
            ' *                                                               *
            ' *****************************************************************

            Call DeadCode(i&,"Removed Dead Code After Jump")

          case "JPT"

            ' *****************************************************************
            ' *                                                               *
            ' *     Optimise Jump True                                        *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(4,"Optimise Jump True")
            if Match(i&+0, "JPT" , ""      , ""    ) And _
               Match(i&+1, "NUM" , "#MEM+" , "*=1" ) And _
               Match(i&+3, "JPI" , ""      , ""    ) _
            Then
              Call Change(i&+0,"JPF","#MEM+","*1","Optimised Jump True")
              Call Remove(i&+1)
              Call Remove(i&+2)
            end if

          case "JPF"

            ' *****************************************************************
            ' *                                                               *
            ' *     Optimise Jump False                                       *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(4,"Optimise Jump False")
            if Match(i&+0, "JPF" , ""      , ""    ) And _
               Match(i&+1, "NUM" , "#MEM+" , "*=1" ) And _
               Match(i&+3, "JPI" , ""      , ""    ) _
            Then
              Call Change(i&+0,"JPT","#MEM+","*1","Optimised Jump False")
              Call Remove(i&+1)
              Call Remove(i&+2)
            end if

          case "JFI"

' -- Doesn't work - Screws up intermmediate stores

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Compact Global Function Store                             *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(8,"Compact Global Function Store")
' --             If Match(i&-2, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&-1, "NUM" , "#MEM+" , ""    ) And _
' --                Match(i&+0, "JFI" , ""      , ""    ) And _
' --                Match(i&+1, "PTI" , ""      , ""    ) And _
' --                Match(i&+2, "NUM" , "#MEM+" , "2=*" ) And _
' --                Match(i&+3, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4, "GTI" , ""      , ""    ) And _
' --                Match(i&+5, "PTI" , ""      , ""    ) _
' --             Then
' --                Call Change(i&-2,"NUM","#MEM+",arg$(2),"Compacted Global Function Store")
' --                Call Remove(i&+1)
' --                Call Remove(i&+2)
' --                Call Remove(i&+3)
' --                Call Remove(i&+4)
' --             end if

' -- Doesn't work - Screws up intermmediate stores

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Compact Local Function Store                              *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(8,"Compact Local Function Store")
' --             If Match(i&-2, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&-1, "NUM" , "#MEM+" , ""    ) And _
' --                Match(i&+0, "JFI" , ""      , ""    ) And _
' --                Match(i&+1, "PTI" , ""      , ""    ) And _
' --                Match(i&+2, "NUM" , "#LOC+" , "2=*" ) And _
' --                Match(i&+3, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4, "GTI" , ""      , ""    ) And _
' --                Match(i&+5, "PTI" , ""      , ""    ) _
' --             Then
' --                Call Change(i&-2,"NUM","#LOC+",arg$(2),"Compacted Local Function Store")
' --                Call Remove(i&+1)
' --                Call Remove(i&+2)
' --                Call Remove(i&+3)
' --                Call Remove(i&+4)
' --             end if

          Case "JSI"

            ' *****************************************************************
            ' *                                                               *
            ' *     Compact Call via Vector                                   *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Remove Call via Vector")

            if Match(i&-1, "NUM" , "#MEM+" , "1=*" ) And _
               Match(i&+0, "JSI" , ""      , ""    ) _
            Then
              j& = FindLabel&(arg$(1))
              if j& > 0 Then
                if Match(j&+1, "ENT" , ""      , ""    ) And _
                   Match(j&+2, "NUM" , "#MEM+" , "2=*" ) And _
                   Match(j&+3, "JSI" , ""      , ""    ) _
                Then
                   If Match(j&+4, "EXT" , ""   , ""    ) Or _
                      Match(j&+4, "RET" , ""   , ""    ) _
                   Then
                     Call Change(i&-1,"*","*",arg$(2),"Compacted Call via Vector")
                     Call Touch(j&+0)
                     Call Touch(j&+1)
                     Call Touch(j&+2)
                     Call Touch(j&+3)
                     Call Touch(j&+4)
                   end if
                end if
              end if
            End If

          Case "LAB"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Unused Labels                                      *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(1,"Remove Unused Labels")

            if Match(i&+0, "LAB" , "" , "1=*" ) Then
              if arg$(1) <> "main" Then
                j& = 1
                while j& > 0 and j& <= codeTop&
                  If Match(j&, "" , "#MEM+" , "*=1" ) Then
                    j& = 0
                  Else
                    j& = j&+1
                  End If
                wend
                If j& > 0 Then
                  select case codeOpc$(i&+1)
                    Case "BYTE","WORD","LONG","CHAR","REAL","SKIP"
                      if left$(arg$(1),1)="@" Then
                        Call Remove(i&+0,"Removed unused literal")
                      else
                        Call Remove(i&+0,"Removed unused variable")
                      end if
                      j&=i&+2
                      while codeOpc$(j&)=codeOpc$(i&+1)
                        Call Remove(j&)
                        j&=j&+1
                      wend
                      Call Remove(i&+1)
                    Case else
                      if left$(arg$(1),1)="@" Then
                        Call Remove(i&+0,"Removed unused local label")
                      else
                        Call Remove(i&+0,"Removed unused function label")
                        j&=i&+1
                        while j& < codeTop&
                          select case codeOpc$(j&)
                            Case "LAB"
                              if Left$(codeOpr$(j&),1)="@" then
                                if codeOpc$(j&+1)="CHAR" Then
                                  j& = codeTop&
                                else
                                  Call Remove(j&)
                                  j&=j&+1
                                end if
                              else
                                j& = codeTop&
                              end if
                            Case "END","CHAR"
                              j& = codeTop&
                            Case Else
                              Call Remove(j&)
                              j&=j&+1
                          end select
                        wend
                      end if
                  end select
                end if
              end if
            End If

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Consecutive Labels                                 *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Remove Consecutive Labels")

            if Match(i&+0, "LAB" , "" , "1=*" ) And _
               Match(i&+1, "LAB" , "" , "2=*" ) _
            Then
              Call Remove(i&+1,"Removed consecutive label")
              if left$(arg$(1),1)="@" and left$(arg$(2),1)<>"@" then
                For j& = 1 To codeTop&
                  If Match(j&, "" , "#MEM+" , "*=1" ) Then
                    Call Change(j&,"*","*",arg$(2))
                  End If
                Next
              else
                For j& = 1 To codeTop&
                  If Match(j&, "" , "#MEM+" , "*=2" ) Then
                    Call Change(j&,"*","*",arg$(1))
                  End If
                Next
              End If
          end if

          Case "LIB"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Dead Code After Lib                                *
            ' *                                                               *
            ' *****************************************************************

            Call DeadCode(i&,"Removed Dead Code After Lib")

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Linked Libs                                        *
            ' *                                                               *
            ' *****************************************************************

            if pass& = 1 Then
              Call TryThis(2,"Remove Linked Libs")
              if Match(i&-1, "LAB" , "" , "1=*" ) Then
                j& = 1
                while j& > 0 and j& <= codeTop&
                  if j& = i&-1 then
                    j&=j&+1
                  else
                    If Match(j&, "LAB" , "" , "*=1" ) Then
                      If Match(j&+1, "LIB" , "" , "" ) Then
                        Call Remove(i&-1,"Removed Duplicate Lib")
                      else
                        Call Remove(i&-1,"Removed Linked Lib")
                      end if
                      Call Remove(i&+0)
                      Call Touch(j&+0)
                      Call Touch(j&+1)
                      j& = 0
                    Else
                      j& = j&+1
                    End If
                  end if
                wend
              end if
            end if

          Case "NOT"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Consecutive Not                                    *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Remove Consecutive Not")

            if Match(i&+0, "NOT" , "" , "" ) And _
               Match(i&+1, "NOT" , "" , "" ) _
            Then
              Call Remove(i&+0,"Removed Consecutive Not")
              Call Remove(i&+1)
            End If

            ' *****************************************************************
            ' *                                                               *
            ' *     Fix inverted conditionals                                 *
            ' *                                                               *
            ' *****************************************************************

            Call TryThis(2,"Fix Inverted Conditionals")

            if Match(i&+0, "NOT" , "" , "" ) And _
               Match(i&+1, "NUM" , "" , "" ) And _
               Match(i&+2, "JPF" , "" , "" ) _
            Then
              Call Remove(i&+0,"Fixed Inverted Conditional")
              Call Change(i&+2,"JPT*","","")
            End If

            Call TryThis(2,"Fix Inverted Conditionals")

            if Match(i&+0, "NOT" , "" , "" ) And _
               Match(i&+1, "NUM" , "" , "" ) And _
               Match(i&+2, "JPT" , "" , "" ) _
            Then
              Call Remove(i&+0,"Fixed Inverted Conditional")
              Call Change(i&+2,"JPF*","","")
            End If

          Case "NUM"

'-- these don't work and should be a final stage anyway

'--            Call TryThis(2,"Create Duplicates")
'--            if Match(i&+0 , "NUM" , "1*=" , "2=*" ) And _
'--               Match(i&+1 , "NUM" , "*=1" , "*=2" ) _
'--            Then
'--               Call Change(i&+1,"DUP."+Right$(codeOpc$(i&+1),3),"","","Created Duplicate")
'--            End If

'--            Call TryThis(4,"Create Arguement Duplicates")
'--            if Match(i&+0 , "NUM" , "1*=" , "2=*" ) And _
'--               Match(i&+1 , "ARG" , ""    , ""    ) And _
'--               Match(i&+2 , "NUM" , "*=1" , "*=2" ) And _
'--               Match(i&+3 , "ARG" , ""    , ""    ) _
'--            Then
'--               Call Change(i&+2,codeOpc$(i&+1),"","Created Argument Duplicate")
'--               Call Change(i&+1,"DUP."+Right$(codeOPc$(i&+0),3),"","")
'--            End If

'' --  -- Doesn't work - Screws up intermmediate stores

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Fix Global Inc and Dec                                    *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(11,"Convert Global Add One to Inc")
' --             if Match(i&+0 , "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1 , "NUM" , "#MEM+" , "2=*" ) And _
' --                Match(i&+2 , "PTI" , ""      , ""    ) And _
' --                Match(i&+3 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4 , "GTI" , ""      , ""    ) And _
' --                Match(i&+5 , "NUM" , "#LOC+" , "*=1" ) and _
' --                Match(i&+6 , "GTI" , ""      , ""    ) And _
' --                Match(i&+7 , "GTI" , ""      , ""    ) And _
' --                Match(i&+8 , "NUM" , "<#>"   , "<1>" ) And _
' --                Match(i&+9 , "ADD" , ""      , ""    ) And _
' --                Match(i&+10, "PTI" , ""      , ""    ) _
' --             Then
' --                Call Change(i&+0 ,codeOpc$(i&+1),"#MEM+",arg$(2),"Converted Global Add One to Inc")
' --                Call Change(i&+1 ,"INC."+Right$(codeOpc$(i&+10),3),"","")
' --                Call Remove(i&+2)
' --                Call Remove(i&+3)
' --                Call Remove(i&+4)
' --                Call Remove(i&+5)
' --                Call Remove(i&+6)
' --                Call Remove(i&+7)
' --                Call Remove(i&+8)
' --                Call Remove(i&+9)
' --                Call Remove(i&+10)
' --             end if

' --             Call TryThis(11,"Convert Global Add Two to Double Inc")
' --             if Match(i&+0 , "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1 , "NUM" , "#MEM+" , "2=*" ) And _
' --                Match(i&+2 , "PTI" , ""      , ""    ) And _
' --                Match(i&+3 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4 , "GTI" , ""      , ""    ) And _
' --                Match(i&+5 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+6 , "GTI" , ""      , ""    ) And _
' --                Match(i&+7 , "GTI" , ""      , ""    ) And _
' --                Match(i&+8 , "NUM" , "<#>"   , "<2>" ) And _
' --                Match(i&+9 , "ADD" , ""      , ""    ) And _
' --                Match(i&+10, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+0 ,codeOpc$(i&+1),"#MEM+",arg$(2),"Converted Global Add Two to Double Inc")
' --               Call Change(i&+1 ,"DUP.P32","","")
' --               Call Change(i&+2 ,"INC."+Right$(codeOpc$(i&+10),3),"","")
' --               Call Change(i&+3 ,"INC."+Right$(codeOpc$(i&+10),3),"","")
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Remove(i&+6)
' --               Call Remove(i&+7)
' --               Call Remove(i&+8)
' --               Call Remove(i&+9)
' --               Call Remove(i&+10)
' --             end if

' --             Call TryThis(11,"Convert Global Sub One to Dec")
' --             if Match(i&+0 , "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1 , "NUM" , "#MEM+" , "2=*" ) And _
' --                Match(i&+2 , "PTI" , ""      , ""    ) And _
' --                Match(i&+3 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4 , "GTI" , ""      , ""    ) And _
' --                Match(i&+5 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+6 , "GTI" , ""      , ""    ) And _
' --                Match(i&+7 , "GTI" , ""      , ""    ) And _
' --                Match(i&+8 , "NUM" , "<#>"   , "<1>" ) And _
' --                Match(i&+9 , "SUB" , ""      , ""    ) And _
' --                Match(i&+10, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+0 ,codeOpc$(i&+1),"#MEM+",arg$(2),"Converted Global Sub One to Dec")
' --               Call Change(i&+1 ,"DEC."+Right$(codeOpc$(i&+10),3),"","")
' --               Call Remove(i&+2)
' --               Call Remove(i&+3)
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Remove(i&+6)
' --               Call Remove(i&+7)
' --               Call Remove(i&+8)
' --               Call Remove(i&+9)
' --               Call Remove(i&+10)
' --             end if

' --             Call TryThis(11,"Convert Global Sub Two to Double Dec")
' --             if Match(i&+0 , "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1 , "NUM" , "#MEM+" , "2=*" ) And _
' --                Match(i&+2 , "PTI" , ""      , ""    ) And _
' --                Match(i&+3 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4 , "GTI" , ""      , ""    ) And _
' --                Match(i&+5 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+6 , "GTI" , ""      , ""    ) And _
' --                Match(i&+7 , "GTI" , ""      , ""    ) And _
' --                Match(i&+8 , "NUM" , "<#>"   , "<2>" ) And _
' --                Match(i&+9 , "SUB" , ""      , ""    ) And _
' --                Match(i&+10, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+0 ,codeOpc$(i&+1),"#MEM+",arg$(2),"Converted Global Sub Two to Double Dec")
' --               Call Change(i&+1 ,"DUP.P32","","")
' --               Call Change(i&+2 ,"DEC."+Right$(codeOpc$(i&+10),3),"","")
' --               Call Change(i&+3 ,"DEC."+Right$(codeOpc$(i&+10),3),"","")
' --               Call Remove(i&+4)
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Remove(i&+6)
' --               Call Remove(i&+7)
' --               Call Remove(i&+8)
' --               Call Remove(i&+9)
' --               Call Remove(i&+10)
' --             end if

' -- Doesn't work - Screws up intermmediate stores

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Compact Global Binary Op                                  *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(11,"Compact Global Binary Op")
' --             if Match(i&+0 , "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1 , "NUM" , "#MEM+" , "2=*" ) And _
' --                Match(i&+2 , "PTI" , ""      , ""    ) And _
' --                Match(i&+3 , "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4 , "GTI" , ""      , ""    ) And _
' --                Match(i&+5 , "NUM" , "#LOC+" , "*=1" ) and _
' --                Match(i&+6 , "GTI" , ""      , ""    ) And _
' --                Match(i&+7 , "GTI" , ""      , ""    ) And _
' --                Match(i&+8 , "NUM" , "<#>"   , ""    ) And _
' --                Match(i&+9 , ""    , ""      , ""    ) And _
' --                Match(i&+10, "PTI" , ""      , ""    ) _
' --             Then
' --                Call Remove(i&+0,"Compacted Global Binary Op")
' --                Call Change(i&+2,"DUP.P32","","")
' --                Call Remove(i&+3)
' --                Call Remove(i&+4)
' --                Call Remove(i&+5)
' --                Call Remove(i&+6)
' --             end if

' -- Doesn't work - Screws up intermmediate stores

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Fix Local Inc and Dec                                     *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(6,"Convert Local Add One to Inc")
' --             if Match(i&+0, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+2, "GTI" , ""      , ""    ) And _
' --                Match(i&+3, "NUM" , "<#>"   , "<1>" ) And _
' --                Match(i&+4, "ADD" , ""      , ""    ) And _
' --                Match(i&+5, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+1,"INC."+Right$(codeOpc$(i&+5),3),"","","Converted Local Add One to Inc")
' --               Call Remove(i&+2)
' --               Call Remove(i&+3)
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Touch(i&+0)
' --             end if

' --             Call TryThis(6,"Convert Local Add Two to Double Inc")
' --             if Match(i&+0, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+2, "GTI" , ""      , ""    ) And _
' --                Match(i&+3, "NUM" , "<#>"   , "<2>" ) And _
' --                Match(i&+4, "ADD" , ""      , ""    ) And _
' --                Match(i&+5, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+1,"DUP.P32","","","Converted Local Add Two to Double Inc")
' --               Call Change(i&+2,"INC."+Right$(codeOpc$(i&+5),3),"","")
' --               Call Change(i&+3,"INC."+Right$(codeOpc$(i&+5),3),"","")
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Touch(i&+0)
' --             end if

' --             Call TryThis(6,"Convert Local Sub One to Dec")
' --             if Match(i&+0, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+2, "GTI" , ""      , ""    ) And _
' --                Match(i&+3, "NUM" , "<#>"   , "<1>" ) And _
' --                Match(i&+4, "SUB" , ""      , ""    ) And _
' --                Match(i&+5, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+1,"INC."+Right$(codeOpc$(i&+5),3),"","","Converted Local Sub One to Dec")
' --               Call Remove(i&+2)
' --               Call Remove(i&+3)
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Touch(i&+0)
' --             end if

' --             Call TryThis(6,"Convert Local Sub Two to Double Dec")
' --             if Match(i&+0, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+2, "GTI" , ""      , ""    ) And _
' --                Match(i&+3, "NUM" , "<#>"   , "<2>" ) And _
' --                Match(i&+4, "SUB" , ""      , ""    ) And _
' --                Match(i&+5, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Change(i&+1,"DUP.P32","","","Converted Local Sub Two to Double Dec")
' --               Call Change(i&+2,"INC."+Right$(codeOpc$(i&+5),3),"","")
' --               Call Change(i&+3,"INC."+Right$(codeOpc$(i&+5),3),"","")
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Touch(i&+0)
' --             end if

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Remove Global Non-Effect                                  *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(9,"Remove Global Non-Effect")
' --             if Match(i&+0, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1, "NUM" , "#MEM+" , ""    ) And _
' --                Match(i&+2, "PTI" , ""      , ""    ) And _
' --                Match(i&+3, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+4, "GTI" , ""      , ""    ) And _
' --                Match(i&+5, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+6, "GTI" , ""      , ""    ) And _
' --                Match(i&+7, "GTI" , ""      , ""    ) And _
' --                Match(i&+8, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Remove(i&+0,"Removed Global Non-Effect")
' --               Call Remove(i&+1)
' --               Call Remove(i&+2)
' --               Call Remove(i&+3)
' --               Call Remove(i&+4)
' --               Call Remove(i&+5)
' --               Call Remove(i&+6)
' --               Call Remove(i&+7)
' --               Call Remove(i&+8)
' --             end if

' --             ' *****************************************************************
' --             ' *                                                               *
' --             ' *     Remove Local Non-Effect                                   *
' --             ' *                                                               *
' --             ' *****************************************************************

' --             Call TryThis(4,"Remove Local Non-Effect")
' --             if Match(i&+0, "NUM" , "#LOC+" , "1=*" ) And _
' --                Match(i&+1, "NUM" , "#LOC+" , "*=1" ) And _
' --                Match(i&+2, "GTI" , ""      , ""    ) And _
' --                Match(i&+3, "PTI" , ""      , ""    ) _
' --             Then
' --               Call Remove(i&+0,"Removed Local Non-Effect")
' --               Call Remove(i&+1)
' --               Call Remove(i&+2)
' --               Call Remove(i&+3)
' --             end if

          Case "RET"

            ' *****************************************************************
            ' *                                                               *
            ' *     Remove Dead Code After Return                             *
            ' *                                                               *
            ' *****************************************************************

            Call DeadCode(i&,"Removed Dead Code After Return")

        end select

        Call DumpLast

      Next
    Loop While changed

    if needCompact then
      if logFileNum&<>0 Then
        print#logFileNum&,""
        print#logFileNum&,"Before compacting ..."
        print#logFileNum&,""
        Call DumpAll
      end if
      if flgVerbose then
        Say "   Compacted Code"
      end if
      Call Compact
      if changed then
        if logFileNum&<>0 Then
          print#logFileNum&,"After compacting ..."
          print#logFileNum&,""
          Call DumpAll
        end if
      end if
    end if

  Loop while changed

  labNumber&=0
  for i&=1 to codeTop&
    if codeOpc$(i&) = "LAB" then
      oldLab$ = codeOpr$(i&)
      if left$(oldLab$,1)="@" then
        labNumber&=labNumber&+1
        newLab$ = " @"+FNstr$(labNumber&)
        for j&=1 to codeTop&
          if codeOpr$(j&) = oldLab$ then
            codeOpr$(j&) = newLab$
          end if
        next
      end if
    end if
  next

  if labNumber& > 0 Then
    if flgVerbose then
      Say "   Re-Numbered Labels"
    end if
    for i&=1 to codeTop&
      if left$(codeOpr$(i&),1)=" " then
        codeOpr$(i&)=Ltrim$(codeOpr$(i&))
      end if
    next
  end if

  if logFileNum&<>0 Then
    print#logFileNum&,"Final bytecode ..."
    print#logFileNum&,""
    Call DumpAll
  end if

End Sub

