CON
           
' *******************************************************************************************************
' *                                                                                                     *
' *     AiChip Cog Debugger                                                AiChip_CogDebug_007.Spin     *
' *                                                                                                     *
' *******************************************************************************************************
' *                                                                                                     *
' *     Project Name   : AiChip Cog Debugger                                                            *
' *     Version        : 007                                                                            *
' *     Updated        : 2008-09-03                                                                     *
' *                                                                                                     *
' *     Author         : AiChip Industries                                                              *
' *                                                                                                     *
' *     Copyright      : 2008, AiChip Industries                                                        *
' *                                                                                                     *
' *     Target Chip    : Parallax Propeller Chip P8X32A ( "Propeller Mk I" )                            *
' *     Compiler Used  : Parallax Propeller Tool 1.2                                                    *
' *                                                                                                     *
' *     License        : MIT License. Please see end of this file for Terms of Use.                     *
' *                                                                                                     *
' *******************************************************************************************************
' *                                                                                                     *
' *     AiChip is a trademark of AiChip Industries.                                                     *
' *                                                                                                     *
' *     If distributing a modified version of this software AiChip Industries requests the "AiChip"     *
' *     prefix be removed from the filename and internal text descriptions to avoid any confusion that  *
' *     may be caused by an impression that the modified software originates from AiChip Industries.    *
' *                                                                                                     *
' *     Originating author credit may be specified as ...                                               *
' *                                                                                                     *
' *     "Original Author    : AiChip Industries"                                                        *
' *     "Original Copyright : 2008, AiChip Industries"                                                  *
' *                                                                                                     *
' *******************************************************************************************************

CON
  '                opcode zcri cond 876543210 876543210
  OP_JMP_IMM    = %010111_0001_1111_000000000_000000000
  OP_NOP        = %000000_0000_0000_000000000_000000000  
  OP_RDLONG_IMM = %000010_0011_1111_000000000_000000000  
  OP_SHR_IWCNR  = %001010_0101_0000_000000000_000000000  
  OP_SHR_IWZNR  = %001010_1001_0000_000000000_000000000  
  OP_TEST_IWC   = %011000_0101_1111_000000000_000000000  
  OP_TEST_IWZ   = %011000_1001_1111_000000000_000000000  
  OP_WRLONG_IMM = %000010_0001_1111_000000000_000000000  
  OP_WRLONG_IFC = %000010_0001_1100_000000000_000000000  
  OP_WRLONG_IFZ = %000010_0001_1010_000000000_000000000  

  OP_I          = %000000_0001_0000_000000000_000000000

CON
  
  X_ENTER       = $1EF ' X_ENTER   RDLONG  X_OPCODE, #D_OPC
  X_INIT        = $1F0 ' X_INIT    RDLONG  X_OPCODE, #D_JMP 
  X_OPCODE      = $1F1 ' X_OPCODE  NOP             
  X_DONE        = $1F2 ' X_DONE    WRLONG  X_OPCODE, #D_OPC
  X_1F3         = $1F3 '           JMP     #X_ENTER

CON

  ERROR_COGNEW  = -1
  ERROR_COGADR  = -2
  ERROR_D_OPC   = -3
  ERROR_BADPOKE = -4
  ERROR_CRASH   = -5
   
VAR

  long  debugFirstAddr
  long  debugBreakCode
  word  debugBreakAddr
  word  debugBreakLast

  long  D_OPC
  long  D_VAL
  long  D_JMP

DAT

{
BaseAddr

PUB GetBaseAddr

  return @BaseAddr
}
  
PUB CogNew_WithDebugger( atCogAdr, parVal, dbgAdr ) : cog | i, saved[ 3 ]

  if atCogAdr =< 0
    abort ERROR_COGADR
    
  debugFirstAddr := atCogAdr
  debugBreakAddr := $200
  debugBreakLast := $000

  D_OPC := dbgAdr
  D_VAL := D_OPC+4
  D_JMP := D_OPC+8
  
  ' Check the Hub Memory we will be using is accessible in the Cog
  
  if D_JMP > $1FF
    abort ERROR_D_OPC

  ' Set the default loader settings

  long[ D_OPC ] := OP_NOP
  long[ D_VAL ] := 0
  long[ D_JMP ] := OP_JMP_IMM | X_ENTER
  
  ' Save what we're over-writing

  repeat i from $000 to $002
    saved[ i ] := long[ atCogAdr ][ i ]
 
  ' Load the bootloader into Cog
   
  long[ atCogAdr ][ $000 ] := OP_NOP
  long[ atCogAdr ][ $001 ] := OP_RDLONG_IMM | $000 | D_OPC
  long[ atCogAdr ][ $002 ] := OP_JMP_IMM    | $000

  ' Launch the Pasm code
  
  if ( result := CogNew( atCogAdr, parVal ) ) => 0

    WaitCnt( CNT + 5000 )        
     
    ' Load the Debug LMM
     
    BootPoke( X_ENTER  , OP_RDLONG_IMM , X_OPCODE , D_OPC   )       ' $1EF
    BootPoke( X_INIT   , OP_RDLONG_IMM , X_OPCODE , D_JMP   )       ' $1F0                  
    BootPoke( X_OPCODE , OP_NOP        , 0+0      , 0+0     )       ' $1F1
    BootPoke( X_DONE   , OP_WRLONG_IMM , X_OPCODE , D_OPC   )       ' $1F2
    BootPoke( X_1F3    , OP_JMP_IMM    , 0+0      , X_ENTER )       ' $1F3
     
    ' Enter the Debug LMM
     
    long[ D_OPC ] := OP_JMP_IMM | X_INIT
       
    ' Restore what we previously over-wrote
     
    repeat i from $000 to $002
      Poke( i, saved[ i ] )
     
    ' At this point the Debug LMM will wait to be told what to do next 
                 
PUB Peek( cogAdr )

  Execute( OP_WRLONG_IMM, cogAdr, D_VAL )
  result := long[ D_VAL ]~
    
PUB Poke( cogAdr, num )

  if cogAdr => $1EF and cogAdr =< $1F3
    abort ERROR_BADPOKE

  long[ D_VAL ] := num
  Execute( OP_RDLONG_IMM, cogAdr, D_VAL )
  long[ D_VAL ] := 0
  
PUB GetC

  long[ D_VAL ] := 0
  Execute( OP_WRLONG_IFC, X_ENTER , D_VAL )
  result := ( long[ D_VAL ]~ <> 0 )
  
PUB GetZ

  long[ D_VAL ] := 0
  Execute( OP_WRLONG_IFZ, X_ENTER , D_VAL )
  result := ( long[ D_VAL ]~ <> 0 )

PUB SetC

  ExecuteShift( OP_SHR_IWCNR, 1 )                 

PUB ClrC

  ExecuteShift( OP_SHR_IWCNR, 0 )                 

PUB SetZ

  ExecuteShift( OP_SHR_IWZNR, 0 )                 

PUB ClrZ

  ExecuteShift( OP_SHR_IWZNR, 2 )                 

PUB RunOnce

  ClrBreakPoint
  long[ D_VAL ] := 0
  long[ D_OPC ] := OP_JMP_IMM | debugBreakLast
  
PUB RunForever

  ClrBreakPoint
  long[ D_VAL ] := -1
  long[ D_OPC ] := OP_JMP_IMM | debugBreakLast

PUB SingleStepTimes( count )

  repeat
    SingleStep
  while --count > 0
  
PUB SingleStep
  
  SetBreakPoint( GetNextAddr )
  RunUntilBreak

PUB RunUntilBreakTimes( count )

  repeat
    RunUntilBreak
  while --count > 0
    
PUB RunUntilBreak

  RunFrom( debugBreakLast )

PUB RunTo( cogAdr )

  repeat while cogAdr == debugBreakLast
    SingleStep
  SetBreakPoint( cogAdr )
  RunFrom( debugBreakLast )
    
PUB RunFrom( cogAdr )

  long[ D_VAL ] := 0
  Execute( OP_JMP_IMM, 0+0, cogAdr ) 
  debugBreakLast := debugBreakAddr
  ClrBreakPoint
      
PUB SetBreakPoint( cogAdr )

  ClrBreakPoint
  if not IsBreakPoint( cogAdr )
    debugBreakAddr := cogAdr
    debugBreakCode := Peek( debugBreakAddr )
    Poke( debugBreakAddr , OP_JMP_IMM | X_DONE )

PUB ClrBreakPoint

  if debugBreakAddr < $200
    Poke( debugBreakAddr, debugBreakCode )
    debugBreakAddr := $200

PUB Label( atCogAdr )

  result := ( atCogAdr - debugFirstAddr ) >> 2

VAR

' *******************************************************************************************************
' *                                                                                                     *
' *     Display Routines ( Serial Interface )                                                           *
' *                                                                                                     *
' *******************************************************************************************************

VAR

  byte  siPin    
  byte  soPin
  long  sxBaudRate    
  long  sxBitTime 
  long  sxInvert 

PUB StartSerial( argSiPin, argSoPin, argSxBaudRate, argSxInvert )

  siPin      := argSiPin
  soPin      := argSoPin
  sxBaudRate := argSxBaudRate
  sxBitTime  := CLKFREQ / argSxBaudRate
  sxInvert   := ( argSoPin => 28 ) ^ argSxInvert

  if soPin => 0
    if sxBaudRate =< 9600
      if ( OUTA[ soPin ] <> 0 ) == sxInvert
        OUTA[ soPin ] := sxInvert
        DIRA[ soPin ] := 1
      else
        OUTA[ soPin ] := sxInvert
        DIRA[ soPin ] := 1
        WaitCnt( CLKFREQ / 1000 * 7 + CNT )

  if siPin => 0
    DIRA[ siPin ] := 0
      
PUB Str( strPtr )

  if soPin => 0
    repeat StrSize(strPtr)
      Out( byte[ strPtr++ ] )

PUB Hex( n, w )

  if soPin => 0
    n <<= ( 8-w ) << 2
    repeat w
      Out( LookUpZ( (n <-= 4) & $F : "0".."9", "A".."F" ) )
  
PUB Bin( n, w )

  if soPin => 0
    n <<= 32 - w
    repeat w
      Out( ( n <-= 1 ) & 1 + "0")
        
PUB Dec( n ) | i

  if soPin => 0
    if n < 0
      -n
      Out( "-" )
    i := 1_000_000_000
    repeat 10
      if n => i
        Out( n / i + "0" )
        n //= i
        result~~
      elseif result or i == 1
        Out( "0" )
      i /= 10
      
PUB Out( n ) | outByte, timeout, i, saved[ $00C+1 ]

  if soPin => 0
    outByte := (( (( n & $FF ) ^$FF ) << 2 ) | 2 ) ^ sxInvert
    if sxBaudRate =< 9600
      timeout := CNT
      repeat 11
        WaitCnt(timeout += sxBitTime)
        OUTA[ soPin ] := ( outByte >>= 1 ) & 1
    else

      outByte := ( outByte << 1 ) | ( ( outByte & 1 ) ^ 1 )
      
      repeat i from $000 to $00C
        saved[ i ] := Peek( i )
{       
      Poke( $000, 0 )                                   '          or      DIR,soMask
      Poke( $001, 0 )                                   '          mov     timeout,bitTime
      Poke( $002, 0 )                                   '          add     timeout,CNT
      Poke( $003, 0 )                                   ' :Loop    shr     outByte,#1 WC
      Poke( $004, 0 )                                   '          muxc    OUTA,soMask
      Poke( $005, 0 )                                   '          waitcnt timeout,bitTime
      Poke( $006, OP_DJNZ    | $00C << 9 | $003 )       '          djnz   count,#:Loop
      Poke( $007, OP_JMP_IMM | X_DONE           )       '          jmp     #X_DONE                     
      Poke( $008, 0                             )       ' timeout  long    0-0
      Poke( $009, sxBitTime                     )       ' bitTime  long    sxBitTime
      Poke( $00A, outByte                       )       ' outByte  long    outByte
      Poke( $00B, |< soPin                      )       ' soMask   long    |< soPin
      Poke( $00C, 11                            )       ' count    long    10
       
      Execute( OP_JMP_IMM, 0+0, $000 ) 
}       
      repeat i from $000 to $00C
        Poke( i, saved[  i ] )

   if n == $0D
     Out( $0A )
     
' *******************************************************************************************************
' *                                                                                                     *
' *     These are utility routines used by the debugger                                                 *
' *                                                                                                     *
' *******************************************************************************************************

PRI BootPoke( cogAdr, opc, dst, src )

  ' The LMM Bootloader just copies values to somewhere else so the value must be changed AFTER the
  ' address to write has been set. This means the old value gets written into the new loactaion but
  ' when we change the value it will correct itself. If we do it the other way the new value may get
  ' written to the old address and corrupt what we wanted there. Once we've done the write we go back
  ' to executing NOP for speed. The time taken between settig the D_VAL and changing D_OPC is long
  ' enough that the PASM Cog will have executed it.
  
  long[ D_OPC ] := OP_RDLONG_IMM | ( cogAdr << 9 ) | D_VAL
  long[ D_VAL ] := opc | ( dst << 9 ) | src
  long[ D_OPC ] := OP_NOP

PRI ExecuteShift( opc, number ) | tmp

  tmp := Peek( $000 )
  Poke( $000, number)
  Execute( opc, $000, 1 )
  Poke( $000, tmp )
        
PUB Execute( opc, dst, src )

  if long[ D_OPC ] <> long[ D_JMP ]
    abort ERROR_CRASH
    
  long[ D_OPC ] := opc | ( dst << 9 ) | src
  repeat while long[ D_OPC ] <> long[ D_JMP ]

PRI GetNextAddr | opc, c, z

  ' Assume it's a non-branch so will continue at the address after the one we execute
  
  result := debugBreakLast+1
  
  ' Get the opcode at the address we are about to execute ( nop if condition not met )
  
  opc := FixConditional( Peek( debugBreakLast ) )

  ' Is it a potential branch insruction ?

  if opc
    case opc >> 26  
      %010111 :                                             ' JMP
      %111011 : if ( Peek( opc >> 9 ) & $1FF ) <> 0         ' TJZ
                  return
      %111010 : if ( Peek( opc >> 9 ) & $1FF ) == 0         ' TJNZ
                  return
      %111001 : if ( ( Peek( opc >> 9 ) & $1FF ) - 1 ) == 0 ' DJNZ
                  return
      other   : return
      
    result := opc & $1FF                       
    if ( opc & OP_I ) == 0
      result := Peek( result ) & $1FF

PRI FixConditional( opc ) | c, z, nc, nz, condBits

  condBits := ( opc >> 18 ) & %1111

  if condBits == %1111
    return opc
    
  if condBits == %0000
    return OP_NOP
    
  nc := not ( c := GetC )
  nz := not ( z := GetZ )  
   
  case condBits
    %0001 : result := nc and nz
    %0010 : result := nc and z
    %0011 : result := nc
    %0100 : result := c and nz
    %0101 : result := nz
    %0110 : result := nc <> nz
    %0111 : result := nc or nz
    %1000 : result := c and z
    %1001 : result := c == z
    %1010 : result := z
    %1011 : result := nc or z
    %1100 : result := c
    %1101 : result := c or nz
    %1110 : result := c or z
    
  result &= opc

PRI IsBreakPoint( cogAdr ) | opc

  '                        opcode zcri cond 876543210 876543210                                    
  opc := Peek( cogAdr ) | %000000_0000_1111_000000000_000000000         

  result := ( opc == ( OP_JMP_IMM | X_DONE ) )

CON

' *******************************************************************************************************
' *                                                                                                     *
' *     Terms of Use : MIT License                                                                      *
' *                                                                                                     *
' *******************************************************************************************************
'
' Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
' associated documentation files (the "Software"), to deal in the Software without restriction, including
' without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
' copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to
' the following conditions:                                                                   
'
' The above copyright notice and this permission notice shall be included in all copies or substantial
' portions of the Software.                                                                                             
'                                                                                                                  
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
' LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
' NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
' WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
' SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
                