
#define PAR     ( *( volatile unsigned int  * ) -0x1F0 )
#define CNT     ( *( volatile unsigned int  * ) -0x1F1 )
#define INA     ( *( volatile unsigned int  * ) -0x1F2 )
#define INB     ( *( volatile unsigned int  * ) -0x1F3 )
#define OUTA    ( *( volatile unsigned int  * ) -0x1F4 )
#define OUTB    ( *( volatile unsigned int  * ) -0x1F5 )
#define DIRA    ( *( volatile unsigned int  * ) -0x1F6 )
#define DIRB    ( *( volatile unsigned int  * ) -0x1F7 )
#define CTRA    ( *( volatile unsigned int  * ) -0x1F8 )
#define CTRB    ( *( volatile unsigned int  * ) -0x1F9 )
#define FRQA    ( *( volatile unsigned int  * ) -0x1FA )
#define FRQB    ( *( volatile unsigned int  * ) -0x1FB )
#define PHSA    ( *( volatile unsigned int  * ) -0x1FC )
#define PHSB    ( *( volatile unsigned int  * ) -0x1FD )
#define VCFG    ( *( volatile unsigned int  * ) -0x1FE )
#define VSCL    ( *( volatile unsigned int  * ) -0x1FF )

#define CLKFREQ ( *( volatile unsigned int  * ) -0x200 )
#define CLKMODE ( *( volatile unsigned char * ) -0x201 )
#define CHIPVER ( *( volatile unsigned char * ) -0x202 )

#define PIN     30
#define BAUD    9600
#define INVERT  0

#define CH      'U'

extern TxText( unsigned int pinNumber, int baudRate, char * strPtr );
extern TxByte( unsigned int pinNumber, int baudRate, unsigned char dataByte );
extern WaitCnt( unsigned int cntMatch );

void main()
{
  while (1)
  {
    if ( INVERT )
    {
      TxText( PIN, -BAUD, "Hello " );
      TxByte( PIN, -BAUD, CH       );
      TxByte( PIN, -BAUD, 0x0D     );
      TxByte( PIN, -BAUD, 0x0A     );
    }
    else
    {
      TxText( PIN, BAUD, "Hello " );
      TxByte( PIN, BAUD, CH       );
      TxByte( PIN, BAUD, 0x0D     );
      TxByte( PIN, BAUD, 0x0A     );
    };
    WaitCnt(CLKFREQ+CNT);
  }
}

