
BASECOLORS = [0x7F7F7F05,0xFF000018,0x00FF0018,0xC0C02009,*([0]*13)]
FADECOLORS = [0xE8E8E800,0x00000000,0xFFFFFF00,0xFFFFFF00,*([0]*13)]

File.binwrite("textpalette.dat",(0..7).flat_map do |fade|

    (0..15).map do |i|
        bc = BASECOLORS[i]
        fc = FADECOLORS[i]
        fdfloat = ((7-fade).to_f / (bc&255).clamp(1,255)).clamp(0.0,1.0)


        br = ((bc >>24)&255)/255.0
        bg = ((bc >>16)&255)/255.0
        bb = ((bc >> 8)&255)/255.0
        fr = ((fc >>24)&255)/255.0
        fg = ((fc >>16)&255)/255.0
        fb = ((fc >> 8)&255)/255.0


        r = (br**2.4 * (1-fdfloat) + fr**2.4 * fdfloat)**(1/2.4)
        g = (bg**2.4 * (1-fdfloat) + fg**2.4 * fdfloat)**(1/2.4)
        b = (bb**2.4 * (1-fdfloat) + fb**2.4 * fdfloat)**(1/2.4)
        r = (r*255).round.clamp(1,255)
        g = (g*255).round.clamp(1,255)
        b = (b*255).round.clamp(1,255)
        next (r<<24)+(g<<16)+(b<< 8)
    end
end.pack('L<*'))

File.binwrite("firepalette.dat",(0..255).map do |i|

    b = (i/300.0)**(1/1.5)
    g = ((i-120).clamp(0,255) / 200.0)**(1/2.4)
    r = ((i-130).clamp(0,255) / 255.0)**(1/2.4)

    r = (r*255).round.clamp(1,255)
    g = (g*255).round.clamp(1,255)
    b = (b*255).round.clamp(1,255)
    next (r<<24)+(g<<16)+(b<< 8)

end.pack('L<*'))