''8-Bit Game Graphics tile driver
'' JT Cook
''

CON
  X_Length = 32 ''number of tiles that run horizontally across screen
  Y_Length = 24 ''number of tiles that run vertically across screen

  x_tiles = 16 '*16=240
  y_tiles = 12 '*16=160


OBJ
  gfx   : "spintris_JTC_Tile_Renderer.spin2"   ' graphics engine

VAR
   byte Tile_Map[X_Length*Y_Length] ''tile map

   long tile_adr
   long tilemap_adr
   long _pad
   long scanline_buffer[2*256/4]
   
PUB start(line_ctr)

  tilemap_adr := @Tile_Map  'address of tile map
  gfx.start(@scanline_buffer,line_ctr,0,0)
  'Set_Border_Color($02)

PUB Set_Tile_Adr(ptr)
  tile_adr := ptr

PUB Place_Tile_XY(x_location, y_location, tile)
'' Place a tile in the tilemap
 ''x_location - select x position of tile
 ''y_location - select y position of tile
 ''tile - which tile will occupy location
   y_location<<=5 '' multiply by 32 since there are 32 tiles per row
   x_location+=y_location ''get final address
   Tile_Map[x_location]:=tile
          
PUB Convert_Tile(char_adr,bit_8_tile,bit_1_tile, bg_color, fg_color) | x,y,n, bit1, bit8_adr,bit1_adr
'' Convert a 1 bit tile to an 8 bit tile
'' Convert_Tile(address of 1 bit character table, 8 bit tile location to be decoded to,1 bit tile to decode, background color, foreground color)
   bit8_adr:=bit_8_tile*64 ''grab tile address
   bit1_adr:=bit_1_tile*8 ''grab tile address   
   repeat y from 0 to 7
    bit1:=Byte[char_adr + y + bit1_adr] ''grab bit row for 1 bit tile
    bit1<-=24 ''working with longs
    repeat x from 0 to 7
     bit1<-=1  ''shift to ready current bit/pixel
     n:=bit1&1 ''grab bit
     if(n==1)
       Byte[tile_adr+bit8_adr]:=fg_color
     else
       Byte[tile_adr+bit8_adr]:=bg_color
     bit8_adr++ 
  
'PUB Set_Border_Color(bcolor)
'  tv.set_border(tv.get_ntsc(bcolor))

'PUB wait_vblank()
'  repeat while tv.check_vblank()
'  repeat until tv.check_vblank()
  
                         