''*******************************
''* IMPACT_1.1                  *               
''* Author: Werner L. Schneider *
''*******************************
''
'' Based on Code from Propeller Game Engine Demo (C) 2013 Marco Maccaferri 
'' Based on Code from Marko Lukat
'' Based on PS/2 Keyboard Driver v1.0.1 by Chip Gracey Copyright (c) 2004 Parallax, Inc.
'' Based on AYcog - AY3891X / YM2149F emulator V0.8 (C) 2012 Johannes Ahlebrand                                 
'' Based on Basic I2C Routines Version 1.1 by Michael Green (C) 2007
''
''+------------------------------------------------------------------------------------------------------------------------------+
''|                                   TERMS OF USE: Parallax Object Exchange License                                             |
''+------------------------------------------------------------------------------------------------------------------------------+
''|Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    |
''|files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    |
''|modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software|
''|is furnished to do so, subject to the following conditions:                                                                   |
''|                                                                                                                              |
''|The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.|
''|                                                                                                                              |
''|THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          |
''|WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         |
''|COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   |
''|ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         |
''+------------------------------------------------------------------------------------------------------------------------------+
''
'' Changes in v1.1
''
'' PS/2 Keyboard-Driver changed
''
'' Password:
''
'' Map 11   : GOLD
''
'' Godmode  : LIFE
''
''
CON


OBJ

    hal:     "../common/PortHAL.spin2" | SAVE_SIZE = 256, BRD_TOP = 24, BRD_BOTTOM = 24, PALETTE=2  ' P2 Port abstraction layer

    'i2c:     "Basic_I2C_Driver"         ' EEprom-Access        Main Cog

    play:    "PLAY.spin2"               ' Sound Driver         need 2 Cog's

    data:    "GRAPHICS"                 '                      Main Cog

    prng:    "JKISS32"                  '                      Main Cog 

'    kb:      "KEYBOARD_DE"              ' Keyboard Driver      need 1 Cog
'    kb:      "KEYBOARD_EN"              ' Keyboard Driver      need 1 Cog

'    rr:      "REALRANDOM"               ' Random Generator     need 1 Cog at Startup, then release Cog

    render:  "RENDERER"                 ' Renderer             need 3 Cog's

'    driver:  "VGA_DRIVER"               ' VGA Driver           need 1 Cog


VAR
    long pad_state,pad_prev,pad_press

    long ptr
    long score

    byte mapbuff[247]

    byte ball_act[3]
    byte ball_x[3]
    byte ball_y[3]
    byte ball_x_v[3]
    byte ball_y_v[3]
    byte ball_x_m

    byte ship_x
    byte ship_y
    byte ship_l
    byte ship_r
    byte ship_s

    byte testx[6]
    byte testy[6]
    byte testz[6]
    byte testv[6]
    byte testw[6]

    byte token_cnt
    byte token_act[3]
    byte token_ani[3]
    byte token_x[3]
    byte token_y[3]

    byte enemy_act[4]
    byte enemy_typ[4]
    byte enemy_cnt[4]
    byte enemy_ani[4]
    byte enemy_hit[6]
    byte enemy_x[4]
    byte enemy_y[4]
    byte enemy_x_v[4]
    byte enemy_y_v[4]

    byte laser_now
    byte laser_cnt
    byte laser_act[3]
    byte laser_x[3]
    byte laser_y[3]

    byte rocket
    byte rocket_act
    byte rocket_x
    byte rocket_y

    byte ufo_act
    byte ufo_x
    byte ufo_y

    byte num[9]
    byte npos
    
    byte map
    byte readsaved
    byte saved
    byte godmode
    
    byte bricks
    byte balls
    byte bonus
    byte count

    byte exec
    byte mode
    byte magnet
    byte laser
    byte bomb
    byte fireball

    long frame_buffer[64*2]
    'long frame_indicator

PUB start | i, j, key, seed, state, new_x
    init

    state := 0

    repeat

        flip
    
        case state

            0:

                intro
                state := 1

            1:

                initWall
                state := 2

            2:

                if readsaved == 0
                    decompressMap
                    mode := 0

                printMap

                printBonus

                dec(17, 0, 9, map)
                dec(31, 0, 9, score)

                printBalls

                resetModes
                if mode > 0
                    printMode(mode, 1)

                exec := 0

                state := 3

            3:

                ship_x := 112
                ship_y := 184
                ship_l := 19
                ship_r := 204
                ship_s := 0

                ball_act[0] := 1
                ball_act[1] := 0
                ball_act[2] := 0

                ball_x_v[0] := 1
                ball_y_v[0] := -2

                state := 4

            4:

                state := 5

                new_x := 0

                repeat 400   
                    flip
                    key := getkey
                    moveShip(key, ship_s)

                    ball_x[0] := ship_x-2 + new_x
                    ball_y[0] := ship_y-5


                    printBall

                    testLaser
                    testRocket

                    moveAll

                    if key & $80 == $80                                               ' Space
                        quit

                    if key & $1F == $1E                                               ' Arrow Up                             
                        new_x := 9
                        ball_x_v[0] := 1

                    if key & $1F == $1F                                               ' Arrow Dn
                        new_x := -9
                        ball_x_v[0] := -1

                    if key & $1F == $1B                                               ' Esc
                        allOff
                        state := 0
                        quit

                count := 100
                

            5:                                                                        ' Play Loop

                key := getkey

                if key & $1F == $1D                                                   ' F1
                    saveMap

                if key & $1F == $1C                                                   ' Enter
                    execmode

                if key & $80 == $80                                                   ' Space
                    if laser == 1
                        initLaser
                    elseif rocket == 1
                        initRocket

                seed := prng.random & $FFFFF
                if seed < 128
                    initUfo

                moveShip(key, ship_s)
                if rocket == 1 and rocket_act == 0
                    rocket_x := ship_x - 3
                    rocket_y := ship_y -12
                    render.sprite_show(15, 42, 2, rocket_x , rocket_y)


                count--
                if count == 0
                    initEnemys(0)
                    count := 1

                state := moveBall
                    
                testBricks
                testEnemys
                testLaser
                testRocket
                testUfo

                moveAll

                if bricks == 0
                    state := 8

                if ball_act[0] == 0 and ball_act[1] == 0 and ball_act[2] == 0 
                    state := 7

                if key & $1F == $1B                                                   ' Esc                             
                    allOff
                    state := 0

            6:                                                                        ' Ball hold (Magnet) Loop

                state := 5
                repeat 400
                    flip
                    key := getkey

                    if key & $1F == $1D                                               ' F1
                        saveMap

                    if key & $80 == $80                                               ' Space
                        quit

                    if key & $1F == $1B                                               ' Esc                             
                        allOff
                        state := 0
                        quit
                        
                    if key & $1F == $1E                                               ' Arrow Up                             
                        ball_x_m := 7

                        if ball_x_v[0] > 128
                            ball_x_v[0] := -ball_x_v[0]

                    if key & $1F == $1F                                               ' Arrow Dn
                        ball_x_m := -11

                        if ball_x_v[0] < 128
                            ball_x_v[0] := -ball_x_v[0]

                    moveShip(key, ship_s)
                    ball_x[0] := ship_x + ball_x_m
                    ball_y[0] := ship_y-5
                    printBall

                    moveAll

            7:                                                                        ' Loose Ball or End Game

                if godmode == 0
                    balls--

                printBalls

                if rocket == 1 and rocket_act == 0
                    render.sprite_hide(15)

                if balls <> 0

                    looseShip

                    if exec == 1
                        clearMode
                        resetModes
                        mode := 0

                    state := 3
                    
                else

                    gameOver

                    state := 0

            8:                                                                        ' Finished Map

                repeat
                    flip

                    key := getkey

                    moveShip(key, ship_s)

                    moveBall

                    moveAll
                    if token_act[0] == 0 and token_act[1] == 0 and  token_act[2] == 0
                        quit 

                allOff

                printStars(1, 2, 26, 22)

                flip

                if mode <> 0 and exec == 0

                    strxy(9, 12, 12, @strBonus)
                    printxy(15, 12, 12, $30 + mode) 
                    
                    flip

                    repeat mode 
                        waitcnt(clkfreq * 1 + cnt)
                        mode--
                        clearMode
                        if mode > 0
                            printMode(mode, 1)
                        printxy(15, 12, 12, $30 + mode) 

                        play.tone(@tonewall)

                        incrScore(1000)

                        flip
 
                    strxy(9, 12, 12, @strClr)

                clearMode
                flip
                waitcnt(clkfreq * 1 + cnt)

                map += 1
                if map == 81
                    map := 1
                    score := 0
                    strxy(19, 0, 12, @strScore)

                if map <> 1
                    if (map // 10) == 1
                        strxy(8, 12, 12, @strPass)
                        strxy(17, 12, 12, @password + (map/10 - 1)*5)
                        flip
                        waitcnt(clkfreq * 2 + cnt)

                changeWall

                printStars(1, 2, 26, 22)

                readsaved := 0

                state := 2


PRI init | i, magic

    'rr.start                                                            ' Start Real Random, uses a COG
    'repeat while rr.random == 0                                         ' Wait for Real Random to warm up

    prng.start                                                          ' Start the Pseudo Random Number generator
                                                                        ' (Uses default seed values)
    prng.seed (getrnd(), getrnd(), getrnd(), getrnd(), getrnd())        ' Seed the PRNG with real random numbers
    'rr.stop                                                             ' Free Real Random COG

    'kb.start(kbd, kbc)                                                  ' Start Keyboard Driver

    'driver.start(@frame_buffer, @frame_indicator, render#vres)

    hal.start(@"impact",true,@frame_buffer,2,(hal#VIDEO_CLKFREQ +/ play.ay1.SAMPLE_RATE)*(-2))

    render.start(@frame_buffer, @hal.curr_line, @map1, data.get_tile_def, data.get_palette_def, data.get_sprite_def)
    render.start_doublebuffer(@map2)

    play.start(hal#AUDIO_RIGHT, hal#AUDIO_LEFT, hal#DIGITAL_BASEPIN)

    'i2c.Initialize(i2cSCL)

    hal.save_init(@"IMPACT.SAV")

    magic := byte[@hal.save_buf+$00]             ' read test byte to see if MAP stored

    if magic == 88                                        
        saved := 1
    else
        saved := 0


DAT
''********************************************************************
''* Functions for Intro                                              *
''********************************************************************
''
PRI intro | i, j, key, seed, offs, da, bit, sel, counter, toggle, pwok, passentry,passchr

    printStars(0, 0, 32, 24)

    ptr := render.get_tilemap_address(0, 1)
    repeat i from 0 to 6
        offs := @impact + (i*4)
        da := long[offs]
        repeat 32
            da <-= 1
            bit := da & 1
            if bit <> 0
                word[ptr] := (13+i) << 8 | 8           ' Tile 008 
                ptr += 2
            else
                ptr += 2

    printBox(6, 9, 20, 5, 1)
    sel := printSel(saved) 
    strxy(10, 10, 15, @strNew)
    strxy(10, 11, 15, @strSaved)
    strxy(10, 12, 15, @strPass)

    printBox(0, 15, 32, 8, 1)
    strxy(4, 16, 15, @strMove)
    strxy(4, 17, 15, @strMove2)
    strxy(1, 18, 15, @strEnter)
    strxy(1, 19, 15, @strSpace)
    strxy(1, 20, 15, @strF1)
    strxy(1, 21, 15, @strEsc)
    strxy(0, 23, 7, @strVer)

    printHat(27, 11)

    repeat 4
        initEnemys(1)

    render.sprite_show(0, 0, 2, 163-15, 129)
    render.sprite_show(1, 1, 2, 163+1, 129)

    counter := toggle := 0                             ' No
    repeat until (hal.emupads_present&1)              ' Keyboard present???
        counter++
        if counter == 80
            counter := 0
            toggle ^= 1
            if toggle == 0
                strxy(0, 0, 12, @strNoKeyb)
                play.over(1)
            else
                strxy(0, 0, 12, @strClrWtf)
                play.over(0)
        moveEnemys(1)
        flip
    strxy(0, 0, 12, @strClrWtf)
    play.over(0)

    counter := toggle := 0 

    repeat

        npos := 0
        pwok := 0
        passentry := 0
        passchr := $20

        repeat

            flip

            counter++
            if counter == 20
                counter := 0
                toggle ^= 1

            if toggle
              i := 6
            else
              i := 7
            printxy(19+npos,12,i,passchr)

            key := getkey & $1F

            if key == $1E                                  ' Arrow Up
                ifnot passentry
                    sel := printSel(sel-1)
                else
                    if --passchr < "A"
                        passchr := "Z"
                play.tone(@btone0)


            if key == $1F                                  ' Arrow Dn
                ifnot passentry
                    sel := printSel(sel+1)
                else
                    if ++passchr > "Z"
                        passchr := "A"
                play.tone(@btone0)

            if key == $1C or key == $1B                    ' Enter

                if passentry
                    if pwok := addChar(passchr)
                      quit
                    elseifnot npos
                      passentry := false
                      passchr := " "
                      printSel(sel)
                      play.tone(@tonewall)
                elseif sel == 0
                    quit
                elseif sel == 1 and saved == 1
                    quit
                elseif sel == 2
                    passentry := true
                    passchr := "A"
                    printxy(8,12,7," ")
                    play.tone(@btone3)

            {
            if key < $1B and key <> 0
                pwok := addChar(key + $40)
                if pwok <> 0
                    quit
            }

            moveEnemys(1)

        balls := 5
        score := 0

        readsaved := 0

        if pwok == 0
            if sel == 0
                map := 1
                quit
                
            elseif sel == 1
                map := byte[@hal.save_buf+$01]
                balls := byte[@hal.save_buf+$02]
                if balls < 5
                    balls := 5
                bonus := byte[@hal.save_buf+$03]
                bricks := byte[@hal.save_buf+$04]
                mode := byte[@hal.save_buf+$05]
                score := long[@hal.save_buf+$08]
                repeat i from 0 to 233
                    mapbuff[i] := byte[@hal.save_buf+$10+i]
                repeat i from 234 to 246
                    mapbuff[i] := 255

                readsaved := 1
                quit
                
        else

            if pwok == 81                             ' Toggle Godmode
                godmode ^= 1

                play.tone(@toneball)

                strxy(0, 0, 12, @strGod)
                if godmode == 1
                    strxy(11, 0, 12, @strOn)
                else
                    strxy(11, 0, 12, @strOff)

                flip

                waitcnt(clkfreq * 2 + cnt)

                ptr := render.get_tilemap_address(0, 0)
                repeat 14
                    print(15, $20)

            else
                map := pwok
                play.tone(@toneenemy)
                quit

    repeat i from 0 to 3
        render.sprite_hide(8+i)
        enemy_act[i] := 0

    printStars(0, 0, 32, 24)


PRI addChar(k) | i, offs

    num[npos] := k
    printxy(19+npos, 12, 6, k)
    npos++

    flip

    'repeat until kb.key == 0
    
    if npos == 4
        num[npos] := 0

        repeat i from 0 to 7
            offs := @password + (i * 5)

            if strcomp(offs, @num)
                strxy(19, 12, 15, @strClr2)
                return ((i+1) * 10) + 1

        strxy(19, 12, 15, @strClr2)
        npos := 0
    else
        play.tone(@btone3)

    return 0


PRI printSel(s) | a, b, c

    s <#= 2
    s #>= 0

    a := b := c := $20

    case s
      0: a:= $2A
      1: b:= $2A
      2: c:= $2A

    printxy(8, 10, 10, a)

    if saved == 1
        printxy(8, 11, 10, b)
    else
        printxy(8, 11, 12, b)

    printxy(8, 12, 10, c)

    return s
    

DAT
''********************************************************************
''* Functions for Loose Ship / Game Over                             *
''********************************************************************
''
PRI looseShip | i, shipl, shipr, shipl_v, shipr_v, shipa, state, tonea, toneb

    shipa := 0

    if ship_x < 112
        shipl := ship_x - 15
        shipr := ship_x + 1 + 4 
        shipl_v := 4
        shipr_v := 4
        state := 0
    elseif ship_x > 112
        shipl := ship_x - 15 - 4
        shipr := ship_x + 1  
        shipl_v := -4
        shipr_v := -4
        state := 0
    else
        shipl := ship_x - 15 - 2
        shipr := ship_x + 1 + 2 
        shipl_v := -4
        shipr_v := 4
        state := 1

    tonea := $8F0
    toneb := $7F0

    repeat

        render.sprite_show(0, 0, 3, shipl, 184)
        render.sprite_show(1, 1, 3, shipr, 184)

        flip

        shipl := (shipl + shipl_v) & $FF
        shipr := (shipr + shipr_v) & $FF

        if state == 0
            if shipl_v == 4
                testx[0] := shipr
            else
                testx[0] := shipl

        elseif state == 1
            testx[0] := shipl

        elseif state == 2
            if shipl => 97
                shipa := 1

        elseif state == 3
            if shipr =< 112
                shipa := 1

        play.death(15, tonea, toneb)
        tonea -= 16
        toneb -= 16

        if state == 0
            if testx[0] > 205
                state := 3
                shipl_v := -shipl_v        
                shipr_v := -shipr_v        
                shipl := 185
                shipr := 205

            if testx[0] < 4
                state := 2
                shipl_v := -shipl_v        
                shipr_v := -shipr_v        
                shipl := 4
                shipr := 23

        elseif state == 1
            if testx[0] < 4
                state := 2
                shipl_v := -shipl_v        
                shipr_v := -shipr_v        
                shipl := 4
                shipr := 205

        if shipa == 1
            quit


    play.death(0, tonea, toneb)


PRI gameOver | i, key, counter, toggle, time

    printBox(7, 9, 14, 7, 4)
    repeat i from 10 to 14
        strxy(8, i, 15, @strClr)

    strxy(9, 11, 12, @strGame)
    strxy(9, 13, 12, @strOver)
    play.over(1)

    counter := toggle := time := 0

    repeat
        counter++

        if counter == 70
            counter := 0
            toggle ^= 1
            if toggle == 0
                time++
                strxy(9, 11, 12, @strGame)
                strxy(9, 13, 12, @strOver)
                play.over(1)
            else
                strxy(8, 11, 12, @strClr)
                strxy(8, 13, 12, @strClr)
                play.over(0)

        key := getkey
        moveShip(key, ship_s)
        moveAll

        if time == 20 and toggle == 1 
            quit

        flip

        if key & $1F == $1B or key & $1F == $1C ' Esc                             
            allOff
            quit

    play.over(0)

    repeat i from 0 to 3
        render.sprite_hide(8+i)
        enemy_act[i] := 0


DAT
''********************************************************************
''* Functions for Ufo                                                *
''********************************************************************
''
PRI initUfo

    if rocket_act == 0
        if ufo_act == 0
            ufo_act := 1
            ufo_x := 7
            ufo_y := 18


PRI moveUfo

    if ufo_act == 1
        ufo_x++

       if ufo_x > 199
           render.sprite_hide(15)
           ufo_act := 0
       else
           printUfo


PRI printUfo

    if ufo_act == 1
        render.sprite_show(15, 43, 2, ufo_x, ufo_y)


PRI testUfo | i, j, e, k, v, seed

    repeat i from 0 to 2
        if ball_act[i] == 1

            if ufo_act == 1

                prepTest(i)
                
                repeat j from 0 to 5
                    if (testx[j] => ufo_x and testx[j] =< ufo_x+14) and (testy[j] => ufo_y and testy[j] =< ufo_y+7)
                        getBall
                        render.sprite_hide(15)
                        ufo_act := 0
                        quit


DAT
''********************************************************************
''* Functions for Rocket                                             *
''********************************************************************
''
PRI initRocket

    if ufo_act == 0
        if rocket_act == 0
            rocket_act := 1


PRI moveRocket

    if rocket_act == 1
        rocket_y--

       if rocket_y < 18
           render.sprite_hide(15)
           rocket_act := 0
       else
           printRocket


PRI printRocket

    if rocket_act == 1
        render.sprite_show(15, 42, 2, rocket_x , rocket_y)


PRI testRocket | i, h, p

    if rocket_act == 1
        if rocket_y < 160 

            testx[0] := rocket_x + 4
            testy[0] := rocket_y

            p := ((testx[0]-8) / 16) + (((testy[0]-16) / 8) * 13)

            if mapbuff[p] <> 255

                play.tone(@@BrickTone[(prng.random & $03)])

                h := (mapbuff[p] & $F0) >> 4
                if h <> 4
                    bricks--

                    mapbuff[p] := 255

                    ptr := getBrickPos(p) 
                    setStar(ptr)

    if rocket_act == 1
        if rocket_y < 160 
            repeat i from 0 to 3
                if enemy_act[i] == 1
                    if (rocket_x+4 => enemy_x[i] and rocket_x+4 =< enemy_x[i]+11) and (rocket_y => enemy_y[i] and rocket_y =< enemy_y[i]+11)
                        play.tone(@toneenemy)
                        enemy_act[i] := 0
                        render.sprite_hide(8+i)


DAT
''********************************************************************
''* Functions for Laser's                                            *
''********************************************************************
''
PRI initLaser

    laser_cnt++
    if laser_cnt == 8
        laser_cnt := 0 
        
        if laser_act[laser_now] == 0
            laser_act[laser_now] := 1
            laser_x[laser_now] := ship_x 
            laser_y[laser_now] := ship_y - 2

        laser_now++
        if laser_now == 3
            laser_now := 0

        printLaser


PRI moveLaser | i

    repeat i from 0 to 2
        if laser_act[i] == 1

            laser_y[i] -= 2

            if laser_y[i] < 18
                render.sprite_hide(12+i)
                laser_act[i] := 0
            else
                printLaser


PRI printLaser | i

    repeat i from 0 to 2
        if laser_act[i] == 1
            render.sprite_show(12+i, 41, 2, laser_x[i] , laser_y[i])


PRI testLaser |  i, j, h, p

    repeat i from 0 to 2
        if laser_act[i] == 1
            if laser_y[i] < 160 

                testx[0] := laser_x[i]
                testx[1] := laser_x[i] + 1 
                testy[0] := testy[1] := laser_y[i]

                repeat j from 0 to 1
                    p := ((testx[j]-8) / 16) + (((testy[j]-16) / 8) * 13)
                    if mapbuff[p] <> 255
                        testz[j] := p
                    else
                        testz[j] := 255

                if testz[0] == testz[1]
                    testz[1] := 255    

                repeat j from 0 to 1
                    p := testz[j]
                    if p <> 255

                        play.tone(@@BrickTone[(prng.random & $03)])

                        h := (mapbuff[p] & $F0) >> 4
                        if h <> 4
                            bricks--

                            mapbuff[p] := 255

                            ptr := getBrickPos(p) 
                            setStar(ptr)
                        
                        laser_act[i] := 0
                        render.sprite_hide(12+i)

    repeat i from 0 to 2
        if laser_act[i] == 1
            if laser_y[i] < 160 

                repeat j from 0 to 3
                    if enemy_act[j] == 1
                        if (laser_x[i] => enemy_x[j] and laser_x[i] =< enemy_x[j]+11) and (laser_y[i] => enemy_y[j] and laser_y[i] =< enemy_y[j]+11)
                            play.tone(@toneenemy)
                            enemy_act[j] := 0
                            render.sprite_hide(8+j)
                            laser_act[i] := 0
                            render.sprite_hide(12+i)

    repeat i from 0 to 2
        if laser_act[i] == 1
            if laser_y[i] < 160 
                if (laser_x[i] => ufo_x and laser_x[i] =< ufo_x+14) and (laser_y[i] => ufo_y and laser_y[i] =< ufo_y+7)
                    getBall
                    laser_act[i] := 0
                    render.sprite_hide(12+i)
                    render.sprite_hide(15)
                    ufo_act := 0


DAT
''********************************************************************
''* Functions for Enemy's                                            *
''********************************************************************
''
PRI initEnemys(v) | i, seed, err

    if bomb == 1
        return

    repeat i from 0 to 3
        if enemy_act[i] == 0
            seed := prng.random & $FF        
            if v == 1
                seed := 0
            if seed < 8

                enemy_act[i] := 1 
                seed := prng.random & $7                    ' Enemy 0 - 7
                enemy_typ[i] := (seed * 4) + 9              ' Sprite_009 is first Enemy, Sprite_013 is second Enemy, ... 
                enemy_cnt[i] := 16 
                enemy_ani[i] := 0 

                repeat

                    seed := prng.random & $FF
                    if seed > 193
                        seed -= 62
                    enemy_x[i] := seed + 10

                    seed := prng.random & ($4F + (v * 16))
                    enemy_y[i] := seed + 27 


                    testx[0] := testx[2] := testx[4] := enemy_x[i]  
                    testx[1] := testx[3] := testx[5] := enemy_x[i] + 11  
                    testy[0] := testy[1] := enemy_y[i]
                    testy[2] := testy[3] := enemy_y[i] + 11
                    testy[4] := testy[5] := enemy_y[i] + 5

                    err := testOther(i)

                    if err == 0
                        if v == 0
                            err := testBrick

                        if err == 0
                            quit

                seed := prng.random & $FF
                if seed < 128
                    enemy_x_v[i] := 1
                else
                    enemy_x_v[i] := -1


                seed := prng.random & $FF
                if seed < 128
                    enemy_y_v[i] := 1
                else
                    enemy_y_v[i] := -1

    printEnemys


PRI moveEnemys(v) | i, seed, err, new_x, new_y, key

    repeat i from 0 to 3
        if enemy_act[i] == 1

            enemy_cnt[i]--
            if enemy_cnt[i] == 0
                enemy_cnt[i] := 16

                new_x := (enemy_x[i] + enemy_x_v[i]) & $FF
                new_y := (enemy_y[i] + enemy_y_v[i]) & $FF

                seed := prng.random & $FF
                if seed < 32
                    enemy_x_v[i] := -enemy_x_v[i]

                seed := prng.random & $FF
                if seed < 32
                    enemy_y_v[i] := -enemy_y_v[i]

                seed := prng.random & $FF
                 if seed < 192
                     enemy_y_v[i] := 0
                 else
                     seed := prng.random & $FF
                     if seed < 128             
                         enemy_y_v[i] := -1
                     else
                         enemy_y_v[i] := 1

                testx[0] := testx[2] := testx[4] := new_x 
                testx[1] := testx[3] := testx[5] := new_x + 11 
                testy[0] := testy[1] := new_y
                testy[2] := testy[3] := new_y + 11
                testy[4] := testy[5] := new_y + 5

                err := testOther(i)

                if err == 0

                    if v == 0
                        err := testBrick
                    if err == 0

                        if new_x < 8
                            new_x := 8
                        elseif new_x > 204
                            new_x := 204
                   
                        if new_y < 27
                            new_y := 27
                        elseif new_y > 155
                            new_y := 155

                        enemy_x[i] := new_x
                        enemy_y[i] := new_y

        if (enemy_cnt[i] & $F) == 0
            enemy_ani[i]++
            if enemy_ani[i] == 4
                enemy_ani[i] := 0            
        
    printEnemys


PRI testOther(i) | j, k, contact

    contact := 0
    repeat j from 0 to 3
        if j <> i
            if enemy_act[j] == 1
                repeat k from 0 to 5
                    if (testx[k] => enemy_x[j] and testx[k] =< enemy_x[j]+11) and (testy[k] => enemy_y[j] and testy[k] =< enemy_y[j]+11) 
                        contact := 1
    
    return contact


PRI testBrick |i, h, p, contact

    contact := 0
    repeat i from 0 to 5
        p := ((testx[i]-8) / 16) + (((testy[i]-16) / 8) * 13)
        if mapbuff[p] <> 255
            h := (mapbuff[p] & $F0) >> 4
            if h <> 4
                contact := 1

    return contact


PRI printEnemys | i

    repeat i from 0 to 3
        if enemy_act[i] == 1
            render.sprite_show(8+i, enemy_typ[i]+enemy_ani[i], 2, enemy_x[i] , enemy_y[i])


PRI testEnemys | i, j, e, k, v, seed

    repeat i from 0 to 2
        if ball_act[i] == 1

            prepTest(i)
                
            repeat j from 0 to 5
                enemy_hit[j] := 0
                repeat e from 0 to 3
                    if enemy_act[e] == 1
                        if (testx[j] => enemy_x[e] and testx[j] =< enemy_x[e]+11) and (testy[j] => enemy_y[e] and testy[j] =< enemy_y[e]+11)
                            enemy_hit[j] := 1
                            k := e
                            
            if enemy_hit[0] <> 0 or enemy_hit[1] <> 0 or enemy_hit[2] <> 0or enemy_hit[3] <> 0or enemy_hit[4] <> 0or enemy_hit[5] <> 0

                play.tone(@toneenemy)
                incrScore(50)

                enemy_act[k] := 0
                render.sprite_hide(8+k)
                count := 50

                if fireball == 0

                    ball_x_v[i] := -ball_x_v[i]

                    seed := (prng.random & $1F)         
                    if seed < 16
                        if ball_x_v[i] == 1
                            ball_x_v[i] := 2
                        elseif ball_x_v[i] == -1
                            ball_x_v[i] := -2

                        if ball_y_v[i] == 2 or ball_y_v[i] == -2
                            if ball_x_v[i] == 2
                                ball_x_v[i] := 1
                            elseif ball_x_v[i] == -2
                                ball_x_v[i] := -1

                    if ball_x_v[i] == 2 or ball_x_v[i] == -2
                        seed := (prng.random & $1F)         
                        if seed < 16
                            if ball_y_v[i] == 1
                                ball_y_v[i] := 2
                            elseif ball_y_v[i] == -1
                                ball_y_v[i] := -2
                            elseif ball_y_v[i] == 2
                                ball_y_v[i] := 1
                            elseif ball_y_v[i] == -2
                                ball_y_v[i] := -1

            if fireball == 0
                if enemy_hit[0] == 1 and enemy_hit[2] == 1
                    ball_y_v[i] := -ball_y_v[i]
                elseif enemy_hit[1] == 1 and enemy_hit[2] == 1
                    ball_y_v[i] := -ball_y_v[i]


DAT
''********************************************************************
''* Functions for Token's                                            *
''********************************************************************
''
PRI initToken(t) | i, seed

    token_cnt++
    if token_cnt > 1
        token_cnt := 0
    else    
        return

    repeat i from 0 to 2
        if token_act[i] == 0
            seed := (prng.random & $3F) + 1        
            if seed < 8
                token_act[i] := 1
                token_ani[i] := 0
                token_x[i] := ball_x[t]   
                token_y[i] := ball_y[t]
                quit
                
    printTokens


PRI moveTokens | i, offsl, offsr

    repeat i from 0 to 2
        if token_act[i] == 1

            token_y[i]++

            if (token_y[i] & $07) == 0
                token_ani[i]++
                if token_ani[i] == 4
                    token_ani[i] := 0

            if token_y[i] == 180
                if token_ani[i] == 0
                    offsl := 7
                    offsr := 0
                elseif token_ani[i] == 1 or token_ani[i] == 3
                    offsl := 5
                    offsr := 2
                elseif token_ani[i] == 2
                    offsl := 4  '2
                    offsr := 3

            if (token_x[i] => ship_x-11-offsl-(ship_s*4)) and (token_x[i] =< ship_x+11-offsr+(ship_s*4)) and token_y[i] == 180   
                play.tone(@tonetoken)
                render.sprite_hide(5+i)
                token_act[i] := 0
                if exec == 0
                    if mode < 9
                        mode++
                        clearMode
                        printMode(mode, 1)
                    else
                        incrScore(1000)
                else
                    incrScore(1000)

            if token_y[i] > 187
                render.sprite_hide(5+i)
                token_act[i] := 0
            else
                printTokens


PRI printTokens | i

    repeat i from 0 to 2
        if token_act[i] == 1
            render.sprite_show(5+i, 5+token_ani[i], 3, token_x[i] , token_y[i])


DAT
''********************************************************************
''* Functions for Execute Token's                                    *
''********************************************************************
''
PRI execmode | i, h, b

    if mode == 0
        return

    if exec == 1
        return
        
    exec := 1

    if mode == 1
        clearMode
        incrScore(1000)
        exec := 0
        return

    printMode(mode, 2)

    if mode == 2
        magnet := 1

    if mode == 3
        ball_act[1] := ball_act[2] := 1

        ball_x[1] := ball_x[2] := ball_x[0]
        ball_y[1] := ball_y[2] := ball_y[0]

        ball_x_v[1] := (getNewBall_x_v & $FF) 
        ball_x_v[2] := (getNewBall_x_v & $FF)

        if ball_y_v[0] < 128          ' top to bottom
            ball_y_v[1] := -2 
            ball_y_v[2] := -2
        else
            ball_y_v[1] := 2 
            ball_y_v[2] := 2
                   
    if mode == 4
        ship_l := 23
        ship_r := 206
        ship_s := 1
        if ship_x < ship_l
            ship_x := ship_l
        if ship_x > ship_r - 6
            ship_x := ship_r - 6

    if mode == 5
        repeat i from 0 to 233

            if mapbuff[i] <> 255

                h := mapbuff[i] & $F0
                b := mapbuff[i] & $0F 
        
                if b == 0
                    b := $0F
                    mapbuff[i] := h | b
                    ptr := getBrickPos(i)

                    word[ptr] := ($0F+4) << 8 | 1     ' Brick left
                    ptr += 2
                    word[ptr] := ($0F+4) << 8 | 2     ' Brick right

    if mode == 6
        laser := 1

    if mode == 7
        bomb := 1
        repeat i from 0 to 3
            render.sprite_hide(8+i)
            enemy_act[i] := 0

    if mode == 8
        rocket := 1

    if mode == 9
        fireball := 1


PRI getNewBall_x_v | seed, xv

    seed := (prng.random & $1F)         
    if seed < 16
        seed := (prng.random & $1F)         
        if seed < 16
            xv := -1 
        else
            xv := 1 
    else
        seed := (prng.random & $1F)         
        if seed < 16
            xv := -2 
        else
            xv := 2 

    return xv


DAT
''********************************************************************
''* Functions for Brick's                                            *
''********************************************************************
''
PRI testBricks | i, j, k, p, h, b, pold, cx, cy, bc

    repeat i from 0 to 2
        if ball_act[i] == 1
            if ball_y[i] > 15 and ball_y[i] < 160 

                prepTest(i)

                repeat j from 0 to 5

                    testz[j] := testw[j] := 255

                    p := ((testx[j]-8) / 16) + (((testy[j]-16) / 8) * 13)

                    if mapbuff[p] <> 255

                        h := (mapbuff[p] & $F0) >> 4
                        if h == 4
                            testw[j] := p

                        else
                            testz[j] := p

                k := 0
                pold := -1

                repeat j from 0 to 5
                    testv[j] := 255

                    if testz[j] <> 255
                        p := testz[j]
                        if p <> pold
                            testv[k] := p 
                            k++
                            pold := p 

                repeat j from 0 to 5
                    p := testv[j]
                    if p <> 255
                        h := (mapbuff[p] & $F0) >> 4
                        b := mapbuff[p] & $0F 

                        play.tone(@@BrickTone[(prng.random & $03)])

                        incrScore(20)

                        if h > 4

                            if h == bonus
                                ptr := render.get_tilemap_address(bonus+1, 0)

                                bc := word[ptr] & $0FF
                                word[ptr] := (4 + 2) << 8 | bc
                        
                                bonus++
                                if bonus == 10
                                    bonus := 0
                                    getBall

                            else
                                bonus := 0
                                printBonus

                        h--
                        if h == 0 or h == 4 or h == 5 or h == 6 or h == 7 or h == 8 or h == 9
                            mapbuff[p] := 255
                            bricks--
                            initToken(i)             ' i = ball_act 0-2
                            ptr := getBrickPos(p)
                            setStar(ptr)

                        elseif h == 1 or h == 2
                            mapbuff[p] := (h << 4) | b

                if fireball == 0

                    if testz[0] <> 255 or testz[1] <> 255 or testz[2] <> 255 or testz[3] <> 255 or testz[4] <> 255 or testz[5] <> 255
                         cx := cy := 0
                        repeat b from 0 to 2
                            if testz[b] == 255
                                cx++
                        repeat b from 3 to 5
                            if testz[b] == 255
                                cy++
                        changeBall(i, cx, cy)

                    if testw[0] <> 255 or testw[1] <> 255 or testw[2] <> 255 or testw[3] <> 255 or testw[4] <> 255 or testw[5] <> 255
                        play.tone(@@BrickTone[(prng.random & $03)])
                        cx := cy := 0
                        repeat b from 0 to 2
                            if testw[b] == 255
                                cx++
                        repeat b from 3 to 5
                            if testw[b] == 255
                                cy++
                        changeBall(i, cx, cy)


DAT
''********************************************************************
''* Functions for Map's                                              *
''********************************************************************
''
PRI decompressMap | i, c, by                       ' Decompress Map to Map-Buffer

    bricks := 0
    i := 0
    ptr := @@MapTab[map-1]                         ' Map 01 - 20
    repeat
        if i == 234
            quit
        c := byte[ptr++]

        if c == 0
            bonus := 5
            by := byte[ptr++]
            setBrick(i, by)
            i++
        elseif c > $80
            by := byte[ptr++]
            repeat c - $80
                setBrick(i, by)
                i++
        else
            setBrick(i, c)
            i++

    repeat i from 234 to 246
        setBrick(i, $2E)


PRI setBrick(i, b) | tcolor, hit

    if b == $2E                                  ' "."
        mapbuff[i] := 255
    else
        tcolor := b & $0F
        hit := b & $F0 

        if hit > $60
            bricks += 1
            mapbuff[i] := (hit - $20) | tcolor  ' B, O, N, U or S
        elseif hit == $60
            mapbuff[i] := $40 | tcolor          ' No Destroy
        else
            bricks += 1
            mapbuff[i] := (hit - $20) | tcolor  ' 1, 2 or 3 Hit's


PRI printMap | i, j, d, t, h, p

    ptr := render.get_tilemap_address(1, 2)
    d := 0
    repeat i from 0 to 17
        repeat j from 0 to 12

            if mapbuff[d] == 255
                ptr += 4
                d++
            else
                t := (mapbuff[d] & $0F)      
                h := (mapbuff[d] & $F0) >> 4 

                if h < 5
                    word[ptr] := (t+4) << 8 | 1     ' Brick left
                    ptr += 2
                    word[ptr] := (t+4) << 8 | 2     ' Brick right
                    ptr += 2
                    d++
                else
                    p := ((h - 4) * 2) + 1
                    word[ptr] := (t+4) << 8 | p     ' Bonus Brick left
                    ptr += 2
                    word[ptr] := (t+4) << 8 | p+1   ' Bonus Brick right
                    ptr += 2
                    d++

        ptr += 12


DAT
''********************************************************************
''* Functions for Ball's                                             *
''********************************************************************
''
PRI moveBall | i, new_ball_x, new_ball_y

    repeat i from 0 to 2
        if ball_act[i] == 1

            new_ball_x := (ball_x[i] + ball_x_v[i]) & $FF
            new_ball_y := (ball_y[i] + ball_y_v[i]) & $FF

            if new_ball_x > 211
                play.tone(@tonewall)
                new_ball_x := 211
                ball_x_v[i] := -ball_x_v[i]
            elseif new_ball_x < 8
                play.tone(@tonewall)
                new_ball_x := 8
                ball_x_v[i] := -ball_x_v[i]

            if new_ball_y < 16
                play.tone(@tonewall)
                new_ball_y := 16

                if ball_x_v[i] < 128
                    if new_ball_x[i] < 205
                        new_ball_x[i] += 2
                else
                    if new_ball_x[i] > 12
                        new_ball_x[i] -= 2

                ball_y_v[i] := -ball_y_v[i]

            if (new_ball_x => ship_x-15-(ship_s*4)) and (new_ball_x =< ship_x+11+(ship_s*4)) and new_ball_y => 178 and new_ball_y < 180  
                                    '14                                       10
                play.tone(@toneship)

                ball_y_v[i] := -ball_y_v[i]

                if (ball_x_v[i] > 128) and (new_ball_x => ship_x+7+(ship_s*4))  
                     ball_x_v[i] := -ball_x_v[i]
                elseif (ball_x_v[i] < 128) and (new_ball_x =< ship_x-7-(ship_s*4))  
                     ball_x_v[i] := -ball_x_v[i]

                if magnet == 1
                    ball_x_m := new_ball_x - ship_x 
                    return 6

            if new_ball_y > 187

                render.sprite_hide(2+i)
                ball_act[i] := 0

            else
                ball_x[i] := new_ball_x
                ball_y[i] := new_ball_y

                printBall

    return 5
    

PRI printBall | i

    repeat i from 0 to 2
        if ball_act[i] == 1
            render.sprite_show(2+i, 4, 3, ball_x[i] , ball_y[i])


PRI printBalls | r                             ' Print remaining Ball's (Top Left)

    ptr := render.get_tilemap_address(0, 0)

    if balls =< 5

        r := 5 - balls
        repeat balls
            word[ptr] := (4 + 15) << 8 | 13        ' Tile_013 White Ball
            ptr += 2
        if r <> 0
            repeat r
                word[ptr] := (4 + 7) << 8 | 13     ' Tile_013 Grey Ball
                ptr += 2

        printxy(5, 0, 15, $20)

    else

        repeat 5
            word[ptr] := (4 + 15) << 8 | 13        ' Tile_013 White Ball
            ptr += 2

        printxy(5, 0, 15, $2B)


DAT
''********************************************************************
''* Functions for Ship                                               *
''********************************************************************
''
PRI moveShip(k, p)

    if k & $40 == $40
        ship_x -= 2
        if ship_x < ship_l
            ship_x := ship_l

    elseif k & $20 == $20
        ship_x += 2
        if ship_x > ship_r - (p*6)
            ship_x := ship_r - (p*6)
        
    printShip(p)


PRI printShip(p)

    if p == 0
        render.sprite_show(0, 0, 2, ship_x-15, ship_y)
        render.sprite_show(1, 1, 2, ship_x+1, ship_y)
    else
        render.sprite_show(0, 2, 2, ship_x-15, ship_y)
        render.sprite_show(1, 3, 2, ship_x+1, ship_y)


DAT
''********************************************************************
''* Miscellaneous Functions                                          *
''********************************************************************
''
PRI flip

    'driver.wait_vbl
    hal.wait_vblank
    render.flip


PRI getBrickPos(p)

    return render.get_tilemap_address(((p // 13) * 2) + 1, (p / 13) + 2)


PRI getBall

    play.tone(@toneball)
    balls++
    printBalls


PRI changeBall(i, cx, cy)

    if cx > cy
        ball_x_v[i] := -ball_x_v[i]        
    elseif cy > cx
        ball_y_v[i] := -ball_y_v[i]        
    else
        ball_x_v[i] := -ball_x_v[i]        
        ball_y_v[i] := -ball_y_v[i]        


PRI printStars(x, y, w, h)

    ptr := render.get_tilemap_address(x, y)
    repeat h
        repeat w
            word[ptr] := 2 << 8 + getStar
            ptr += 2

        ptr += (32 - w) * 2


PRI setStar(p)

    word[p] := 2 << 8 + getStar
    p += 2
    word[p] := 2 << 8 + getStar


PRI getStar | seed

    seed := (prng.random & $07) + (prng.random & $7F) + 14
    if seed > 7 + 14
        seed := 0

    return seed


PRI moveAll

    moveTokens
    moveEnemys(0)
    moveLaser
    moveRocket
    moveUfo


PRI saveMap | i

    byte[@hal.save_buf+$00] := 88
    byte[@hal.save_buf+$01] := map
    byte[@hal.save_buf+$02] := balls
    byte[@hal.save_buf+$03] := bonus
    byte[@hal.save_buf+$04] := bricks
    long[@hal.save_buf+$08] := score
    repeat i from 0 to 233
        byte[@hal.save_buf+$10+i] := mapbuff[i]
    saved := 1
    hal.save_flush


PRI allOff | i

    repeat i from 2 to 15
        render.sprite_hide(i)

    repeat i from 0 to 3
        enemy_act[i] := 0

    repeat i from 0 to 2
        ball_act[i] := 0
        token_act[i] := 0
        laser_act[i] := 0
    rocket_act := 0
    ufo_act := 0


PRI prepTest(i)

    testx[0] := ball_x[i] + 1
    testx[1] := ball_x[i] + 2
    testx[2] := ball_x[i] + 3 

    testy[3] := ball_y[i] + 1
    testy[4] := ball_y[i] + 2 
    testy[5] := ball_y[i] + 3

    if ball_x_v[i] < 128
        testx[3] := testx[4] := testx[5] := ball_x[i] + 4
    else
        testx[3] := testx[4] := testx[5] := ball_x[i]

    if ball_y_v[i] < 128
        testy[0] := testy[1] := testy[2] := ball_y[i] + 4
    else
        testy[0] := testy[1] := testy[2] := ball_y[i] 


PRI printBonus

     if bonus == 0
         strxy(6, 0, 15, @strClr+6)
     else
         strxy(6, 0, 7, @strBonus2)


PRI incrScore(s)

    score += s
    dec(31, 0, 9, score)


PRI initWall | i, j

    ptr := render.get_tilemap_address(0, 1)
    j := 22                                   ' Tile 22, 23, 24, 22, 23, 24, 22... , Palette 0
    repeat i from 0 to 31
        word[ptr] := j++
        if j == 25
            j := 22
        ptr += 2

    ptr := render.get_tilemap_address(0, 2)
    repeat 22
        word[ptr] := 25                       ' Tile 25, Palette 0
        ptr += 54
        word[ptr] := 25                       ' Tile 25  Palette 0
        ptr += 10

    strxy(12, 0, 12, @strMap)
    strxy(19, 0, 12, @strScore)
    str(9, @str07)

    printBox(28, 2, 4, 20, 1)

    clearMode

    printHat(28, 22)


PRI printHat(x, y) | i

    ptr := render.get_tilemap_address(x, y)
    i := data#HAT 
    repeat 4 
        word[ptr] := 2 << 8 | i++
        ptr += 2
    ptr += 56
    repeat 4 
        word[ptr] := 2 << 8 | i++
        ptr += 2


PRI clearMode | i

    repeat i from 1 to 9
        printMode(i, 0)


PRI resetModes

    exec := 0
    magnet := 0
    laser := 0
    bomb := 0
    rocket := 0
    ship_l := 19
    ship_r := 204
    ship_s := 0
    fireball := 0
    

PRI printMode(m, s) | t

    ptr := render.get_tilemap_address(29, (m * 2) + 1) 

    t := data#MODE_CHR + ((m-1) * 12) + (s * 4) 

    repeat 2
        word[ptr] := 1 << 8 | t++
        ptr += 2
    ptr += 60
    repeat 2
        word[ptr] := 1 << 8 | t++
        ptr += 2


PRI printBox(x, y, w, h, p)

    ptr := render.get_tilemap_address(x, y)
    printTile(176, p)
    repeat w-2
        printTile(177, p)
    printTile(178, p)
    ptr += (32 - w) * 2
    repeat h-2
        printTile(180, p)
        ptr += (w - 2) * 2
        printTile(179, p)
        ptr += (32 - w) * 2
    printTile(181, p)
    repeat w-2
        printTile(182, p)
    printTile(183, p)


PRI printTile(t, p)

    word[ptr] := p << 8 | t 
    ptr += 2


PRI changeWall | i, j

    j := byte[data.get_palette_def+1]
    repeat i from 2 to 15
        byte[data.get_palette_def+i-1] := byte[data.get_palette_def+i]     
    byte[data.get_palette_def+15] := j


PRI print(color, char)

    case char
        $30..$39: char := char - $30 + data#FONT_0
        $41..$5A: char := char - $41 + data#FONT_A
        $61..$7A: char := char - $61 + data#FONT_A
        $2A: char := data#BALL
        $3A: char := data#FONT_COLON 
        $2F: char := data#FONT_SLASH 
        $3C: char := data#FONT_LEFT 
        $3E: char := data#FONT_RIGHT 
        $28: char := data#FONT_UP 
        $29: char := data#FONT_DN 
        $2B: char := data#PLUS
        $2D: char := data#MINUS
        $2E: char := data#DOT
        $21: char := data#EXC
        other: char := data#FONT_SPACE

    word[ptr] := (4 + color) << 8 | char
    ptr += 2


PRI printxy(x, y, color, char)

    ptr := render.get_tilemap_address(x, y)
    print(color, char)
    

PRI str(color, stringptr)

    repeat strsize(stringptr)
        print(color, byte[stringptr++])


PRI strxy(x, y, color, stringptr)

    ptr := render.get_tilemap_address(x, y)
    str(color, stringptr)


PRI dec(x, y, color, val) | i, p, c, optr 

    repeat i from 0 to 8
        num[i] := 0

    optr := render.get_tilemap_address(x, y)

    ptr := 0
    prn(val)

    p := ptr-1
    repeat ptr
        c := num[p] - $30 + data#FONT_0
        word[optr] := (4 + color) << 8 | c
        optr -= 2
        p--
    if val < 10
        word[optr] := (4 + color) << 8 | 32


PRI prn(val) | dig

    dig := 48 + (val // 10)
    val := val/10
    if val > 0
        prn(val)
    num[ptr++] := dig


DAT

map1        word 0 [render#MAP_SIZE_WORD]
map2        word 0 [render#MAP_SIZE_WORD]

'                    I     M       P      A      C      T
impact      long %00_111_0_10001_0_1110_0_0110_0_0110_0_111_00
            long %00_010_0_11011_0_1001_0_1001_0_1001_0_010_00
            long %00_010_0_10101_0_1001_0_1001_0_1000_0_010_00
            long %00_010_0_10101_0_1110_0_1111_0_1000_0_010_00
            long %00_010_0_10001_0_1000_0_1001_0_1000_0_010_00
            long %00_010_0_10001_0_1000_0_1001_0_1001_0_010_00
            long %00_111_0_10001_0_1000_0_1001_0_0110_0_010_00

strVer      byte "IMPACT 1.1 P2 PORT     WS 3/2018", 0
strNoKeyb   byte "NO CONTROLLER!", 0
strMap      byte "MAP:", 0 
strScore    byte "SCORE:", 0 
str07       byte "0000000", 0
strClrWtf   byte "  "
strClr      byte "        "
strClr2     byte "    ", 0
strNew      byte "PLAY NEW GAME", 0
strSaved    byte "PLAY SAVED MAP", 0
strPass     byte "PASSWORD:", 0
strMove     byte "<> : MOVE SHIP", 0  
strMove2    byte "() : SET BALL TO RIGHT/LEFT", 0  
strEnter    byte "BT3/C : SELECT ITEM", 0  
strSpace    byte "BT4/X : SHOT BALL/LASER/ROCKET", 0  
strF1       byte "BT9/<-: SAVE CURRENT MAP", 0  
strEsc      byte {"ESC : EXIT GAME",} 0  
strBonus    byte "BONUS:0000", 0
strGame     byte "G  A  M  E", 0
strOver     byte "O  V  E  R", 0
strBonus2   byte "BONUS" , 0
strGod      byte "GODMODE IS ", 0
strOn       byte "ON ", 0
strOff      byte "OFF", 0

password    byte "GOLD", 0
            byte "FISH", 0
            byte "WALL", 0
            byte "PLUS", 0
            byte "HEAD", 0
            byte "FORK", 0
            byte "ROAD", 0
            byte "LIFE", 0


DAT

bricktone   word @btone0, @btone1, @btone2, @btone3

btone0      long $F140
            long $FFFF

btone1      long $F100
            long $FFFF

btone2      long $F0C0
            long $FFFF

btone3      long $F080
            long $FFFF

tonewall    long $F1FF
            long $FFFF

toneship    long $F7F0
            long $F7FF
            long $FFFF

toneball    long $F100
            long $F0F0
            long $F0E0
            long $F0D0
            long $F0E0
            long $F0F0
            long $F100
            long $FFFF

toneenemy   long $F0AF
            long $F08F
            long $F06F
            long $F04F
            long $F02F
            long $FFFF

tonetoken   long $F3FF
            long $F3FF
            long $F2FF
            long $F1FF
            long $FFFF


DAT

MapTab  word @map01, @map02, @map03, @map04, @map05, @map06, @map07, @map08, @map09, @map10, @map11, @map12
        word @map13, @map14, @map15, @map16, @map17, @map18, @map19, @map20  
        word @map21, @map22, @map23, @map24, @map25, @map26, @map27, @map28, @map29, @map30, @map31, @map32
        word @map33, @map34, @map35, @map36, @map37, @map38, @map39, @map40  
        word @map41, @map42, @map43, @map44, @map45, @map46, @map47, @map48, @map49, @map50, @map51, @map52
        word @map53, @map54, @map55, @map56, @map57, @map58, @map59, @map60  
        word @map61, @map62, @map63, @map64, @map65, @map66, @map67, @map68, @map69, @map70, @map71, @map72
        word @map73, @map74, @map75, @map76, @map77, @map78, @map79, @map80  

DAT

map01   byte $A0, $2E, $3C, $8B, $2E, $3C, $3B, $3C, $89, $2E, $3C, $3B, $34, $3B, $3C, $87, $2E, $3C, $3B, $34, $31, $34, $3B, $3C
        byte $85, $2E, $3C, $3B, $34, $31, $4A, $31, $34, $3B, $3C, $83, $2E, $3C, $3B, $34, $31, $4A, $34, $4A, $31, $34, $3B, $3C
        byte $2E, $3C, $3B, $34, $31, $4A, $34, $40, $34, $4A, $31, $34, $3B, $3C, $2E, $3C, $3B, $34, $31, $4A, $34, $4A, $31, $34
        byte $3B, $3C, $83, $2E, $3C, $3B, $34, $31, $4A, $31, $34, $3B, $3C, $85, $2E, $3C, $3B, $34, $31, $34, $3B, $3C, $87, $2E
        byte $3C, $3B, $34, $3B, $3C, $89, $2E, $3C, $3B, $3C, $8B, $2E, $3C, $AD, $2E


map02   byte $A7, $2E, $34, $3E, $34, $3E, $34, $3E, $34, $3E, $34, $3E, $34, $3E, $34, $3E, $8B, $2E, $3E, $34, $2E, $00, $91, $3D
        byte $31, $3D, $31, $3D, $31, $3D, $00, $A1, $2E, $34, $3E, $2E, $3D, $87, $2E, $3D, $2E, $3E, $34, $2E, $31, $2E, $32, $3E
        byte $32, $3E, $32, $2E, $31, $2E, $34, $3E, $2E, $3D, $2E, $3E, $83, $2E, $3E, $2E, $3D, $2E, $3E, $34, $2E, $31, $2E, $32
        byte $3E, $00, $B2, $3E, $32, $2E, $31, $2E, $34, $3E, $2E, $3D, $87, $2E, $3D, $2E, $3E, $34, $2E, $31, $3D, $31, $3D, $31
        byte $3D, $31, $3D, $31, $2E, $34, $3E, $8B, $2E, $3E, $00, $74, $3E, $34, $3E, $34, $3E, $34, $3E, $34, $3E, $34, $3E, $00
        byte $84, $B4, $2E


map03   byte $8E, $2E, $31, $2E, $31, $2E, $31, $2E, $31, $2E, $31, $2E, $31, $2E, $2E, $32, $2E, $32, $2E, $32, $2E, $32, $2E, $32
        byte $2E, $32, $2E, $2E, $33, $2E, $33, $2E, $33, $2E, $33, $2E, $33, $2E, $33, $2E, $2E, $34, $2E, $34, $2E, $34, $2E, $34
        byte $2E, $34, $2E, $34, $2E, $2E, $3F, $2E, $3F, $2E, $3F, $2E, $3F, $2E, $3F, $2E, $3F, $2E, $2E, $3C, $2E, $3C, $2E, $3C
        byte $2E, $3C, $2E, $3C, $2E, $3C, $2E, $2E, $3B, $2E, $3B, $2E, $3B, $2E, $3B, $2E, $3B, $2E, $3B, $2E, $2E, $3E, $2E, $3E
        byte $2E, $3E, $2E, $3E, $2E, $3E, $2E, $3E, $2E, $2E, $33, $2E, $33, $2E, $33, $2E, $33, $2E, $33, $2E, $33, $2E, $2E, $36
        byte $2E, $36, $2E, $36, $2E, $36, $2E, $36, $2E, $36, $2E, $2E, $35, $2E, $35, $2E, $35, $2E, $35, $2E, $35, $2E, $35, $8E
        byte $2E, $8D, $37, $00, $78, $38, $38, $00, $88, $38, $38, $00, $98, $38, $38, $00, $A8, $38, $38, $00, $B8, $8D, $33, $9A
        byte $2E


map04   byte $9A, $2E, $3E, $3E, $32, $32, $34, $34, $2E, $3E, $3E, $32, $32, $34, $34, $3E, $3E, $32, $32, $34, $34, $2E, $3E, $3E
        byte $32, $32, $34, $34, $9A, $2E, $32, $32, $2E, $2E, $3E, $3E, $2E, $34, $34, $2E, $2E, $84, $32, $2E, $2E, $3E, $3E, $2E
        byte $34, $34, $2E, $2E, $32, $32, $9C, $2E, $44, $44, $85, $2E, $4E, $4E, $84, $2E, $34, $34, $85, $2E, $3E, $3E, $A0, $2E
        byte $32, $32, $2E, $32, $32, $88, $2E, $32, $32, $2E, $32, $32, $84, $2E, $3E, $3E, $89, $2E, $34, $34, $3E, $3E, $89, $2E
        byte $82, $34


map05   byte $A7, $2E, $32, $2E, $00, $93, $2E, $3F, $2E, $00, $B3, $2E, $3F, $2E, $00, $A3, $2E, $32, $8E, $2E, $6F, $2E, $68, $2E
        byte $31, $2E, $31, $2E, $68, $2E, $6F, $8E, $2E, $34, $2E, $32, $2E, $31, $2E, $4D, $2E, $31, $2E, $32, $2E, $34, $8E, $2E
        byte $3F, $2E, $38, $2E, $31, $2E, $31, $2E, $38, $2E, $3F, $8E, $2E, $32, $2E, $00, $83, $2E, $3F, $2E, $33, $2E, $3F, $2E
        byte $00, $73, $2E, $32, $CE, $2E


map06   byte $9C, $2E, $89, $6F, $84, $2E, $89, $34, $84, $2E, $89, $3A, $84, $2E, $89, $31, $84, $2E, $89, $3B, $9E, $2E, $89, $32
        byte $84, $2E, $89, $39, $84, $2E, $89, $35, $84, $2E, $89, $3E, $84, $2E, $89, $6F, $B6, $2E


map07   byte $8D, $2E, $37, $31, $89, $2E, $39, $31, $37, $2E, $31, $87, $2E, $39, $2E, $31, $37, $2E, $2E, $31, $85, $2E, $39, $2E
        byte $2E, $31, $3C, $34, $2E, $2E, $31, $83, $2E, $39, $2E, $2E, $32, $36, $3C, $2E, $34, $2E, $2E, $31, $2E, $39, $2E, $2E
        byte $32, $2E, $36, $3C, $2E, $2E, $34, $2E, $2E, $39, $2E, $2E, $32, $2E, $2E, $36, $33, $35, $2E, $2E, $34, $83, $2E, $32
        byte $2E, $2E, $37, $34, $33, $2E, $35, $2E, $2E, $34, $2E, $32, $2E, $2E, $37, $2E, $34, $33, $2E, $2E, $35, $2E, $2E, $34
        byte $2E, $2E, $37, $2E, $2E, $34, $2E, $32, $2E, $2E, $35, $83, $2E, $37, $2E, $2E, $3F, $83, $2E, $32, $2E, $2E, $35, $2E
        byte $37, $2E, $2E, $3F, $85, $2E, $32, $2E, $2E, $35, $2E, $2E, $3F, $87, $2E, $32, $83, $2E, $3F, $89, $2E, $32, $2E, $3F
        byte $8B, $2E, $32, $A0, $2E


map08   byte $B4, $2E, $3F, $35, $32, $36, $33, $34, $32, $3D, $31, $37, $3C, $3E, $33, $3F, $35, $32, $36, $33, $34, $32, $3D, $31
        byte $37, $3C, $3E, $2E, $3F, $35, $32, $36, $33, $34, $32, $3D, $31, $37, $3C, $2E, $2E, $3F, $35, $32, $36, $33, $34, $32
        byte $3D, $31, $37, $83, $2E, $3F, $35, $32, $36, $33, $34, $32, $3D, $00, $B1, $84, $2E, $3F, $35, $32, $36, $33, $34, $32
        byte $3D, $85, $2E, $3F, $35, $32, $36, $33, $34, $00, $A2, $86, $2E, $3F, $35, $32, $36, $33, $34, $87, $2E, $3F, $35, $32
        byte $36, $00, $93, $88, $2E, $3F, $35, $32, $36, $89, $2E, $3F, $35, $00, $82, $8A, $2E, $3F, $35, $8B, $2E, $00, $7F, $99
        byte $2E


map09   byte $86, $2E, $64, $8C, $2E, $64, $8C, $2E, $64, $BC, $2E, $6F, $2E, $2E, $6F, $2E, $6F, $2E, $2E, $6F, $84, $2E, $6F, $2E
        byte $2E, $6F, $2E, $6F, $2E, $2E, $6F, $84, $2E, $6F, $2E, $2E, $6F, $2E, $6F, $2E, $2E, $6F, $84, $2E, $6F, $32, $3B, $6F
        byte $2E, $6F, $3B, $32, $6F, $84, $2E, $6F, $3B, $32, $6F, $2E, $6F, $32, $3B, $6F, $84, $2E, $84, $6F, $2E, $84, $6F, $C3
        byte $2E


map10   byte $9C, $2E, $00, $91, $87, $2E, $00, $A1, $84, $2E, $31, $87, $2E, $31, $84, $2E, $31, $87, $2E, $31, $85, $2E, $31, $85
        byte $2E, $31, $87, $2E, $31, $83, $2E, $31, $89, $2E, $83, $39, $89, $2E, $85, $3E, $87, $2E, $83, $32, $00, $B4, $83, $32
        byte $87, $2E, $85, $3A, $87, $2E, $34, $85, $2E, $34, $85, $2E, $34, $87, $2E, $34, $83, $2E, $34, $89, $2E, $34, $2E, $2E
        byte $34, $89, $2E, $34, $2E, $2E, $00, $74, $89, $2E, $00, $84, $9B, $2E


DAT

map11   byte $9A, $2E, $5E, $83, $2E, $51, $83, $2E, $55, $83, $2E, $52, $5E, $2E, $34, $2E, $51, $2E, $3C, $2E, $55, $2E, $34, $2E
        byte $52, $5E, $34, $2E, $34, $51, $3C, $2E, $3C, $55, $34, $2E, $34, $52, $5E, $34, $2E, $34, $51, $3C, $2E, $3C, $55, $34
        byte $2E, $34, $52, $5E, $2E, $34, $2E, $51, $2E, $3C, $2E, $55, $2E, $34, $2E, $52, $5E, $83, $2E, $51, $83, $2E, $55, $83
        byte $2E, $52, $A9, $2E, $32, $2E, $32, $2E, $32, $2E, $32, $2E, $32, $85, $2E, $3A, $2E, $3A, $2E, $3A, $2E, $3A, $85, $2E
        byte $32, $2E, $32, $2E, $32, $2E, $32, $2E, $32, $B6, $2E

 
map12   byte $A7, $2E, $89, $6F, $84, $2E, $89, $3A, $9E, $2E, $89, $35, $84, $2E, $89, $6F, $84, $2E, $89, $31, $9E, $2E, $89, $32
        byte $84, $2E, $89, $6F, $B8, $2E


map13   byte $8D, $2E, $00, $A2, $85, $2E, $35, $85, $2E, $00, $B1, $2E, $32, $84, $2E, $35, $84, $2E, $31, $83, $2E, $32, $83, $2E
        byte $35, $83, $2E, $31, $85, $2E, $32, $2E, $2E, $35, $2E, $2E, $31, $87, $2E, $32, $2E, $35, $2E, $31, $89, $2E, $32, $35
        byte $31, $85, $2E, $86, $3C, $32, $86, $3C, $85, $2E, $31, $35, $32, $89, $2E, $31, $2E, $35, $2E, $32, $87, $2E, $31, $2E
        byte $2E, $00, $85, $2E, $2E, $32, $85, $2E, $31, $83, $2E, $35, $83, $2E, $32, $83, $2E, $31, $84, $2E, $35, $84, $2E, $32
        byte $2E, $00, $71, $85, $2E, $35, $85, $2E, $00, $92, $86, $2E, $35, $AD, $2E


map14   byte $2E, $35, $8B, $2E, $35, $2E, $35, $87, $2E, $35, $85, $2E, $35, $85, $2E, $35, $2E, $35, $85, $2E, $35, $83, $2E, $35
        byte $83, $2E, $35, $85, $2E, $35, $2E, $35, $87, $2E, $34, $83, $2E, $35, $87, $2E, $44, $2E, $34, $87, $2E, $34, $2E, $34
        byte $83, $2E, $34, $85, $2E, $34, $2E, $44, $85, $2E, $44, $83, $2E, $44, $2E, $2E, $3E, $83, $2E, $3E, $2E, $2E, $34, $2E
        byte $34, $2E, $2E, $3E, $83, $2E, $3E, $2E, $3E, $2E, $3E, $34, $2E, $2E, $3E, $83, $2E, $3E, $83, $2E, $3E, $2E, $3E, $2E
        byte $3E, $31, $2E, $2E, $3E, $87, $2E, $3E, $31, $2E, $31, $83, $2E, $31, $85, $2E, $31, $83, $2E, $31, $2E, $31, $2E, $31
        byte $83, $2E, $31, $85, $2E, $31, $83, $2E, $31, $2E, $31, $8B, $2E, $31, $94, $2E


map15   byte $9A, $2E, $34, $33, $36, $38, $85, $2E, $31, $3C, $3E, $32, $84, $2E, $39, $83, $2E, $36, $84, $2E, $31, $36, $3A, $32
        byte $85, $2E, $38, $3A, $32, $36, $9A, $2E, $31, $3E, $3C, $36, $85, $2E, $3E, $31, $35, $32, $84, $2E, $32, $83, $2E, $35
        byte $84, $2E, $38, $3A, $36, $32, $85, $2E, $3B, $36, $38, $34, $9F, $2E, $83, $67, $8A, $2E, $83, $67, $93, $2E, $67, $67
        byte $87, $2E, $67, $67, $9B, $2E


map16   byte $8D, $2E, $67, $67, $89, $2E, $84, $67, $89, $2E, $67, $67, $9F, $2E, $67, $67, $89, $2E, $67, $67, $2E, $2E, $67, $67
        byte $86, $2E, $67, $86, $2E, $67, $85, $2E, $67, $86, $2E, $67, $85, $2E, $67, $2E, $2E, $3C, $3A, $2E, $2E, $67, $85, $2E
        byte $67, $2E, $2E, $3E, $39, $2E, $2E, $67, $86, $2E, $67, $67, $84, $2E, $67, $8C, $2E, $67, $8C, $2E, $67, $8C, $2E, $67
        byte $8A, $2E, $67, $67, $89, $2E, $67, $67, $86, $2E, $85, $67, $88, $2E


map17   byte $98, $2E, $3E, $83, $2E, $83, $64, $85, $2E, $3E, $2E, $3E, $83, $2E, $34, $83, $2E, $32, $2E, $2E, $3E, $3E, $84, $2E
        byte $34, $83, $2E, $32, $32, $2E, $3E, $85, $2E, $34, $83, $2E, $32, $2E, $2E, $3E, $84, $2E, $83, $64, $2E, $2E, $32, $8C
        byte $2E, $32, $32, $A6, $2E, $85, $31, $2E, $2E, $35, $35, $84, $2E, $31, $2E, $31, $2E, $31, $2E, $35, $2E, $35, $84, $2E
        byte $31, $2E, $31, $2E, $31, $2E, $2E, $83, $35, $9D, $2E, $38, $38, $8B, $2E, $38, $8C, $2E, $38, $38, $83, $2E


map18   byte $9F, $2E, $33, $36, $3E, $89, $2E, $00, $73, $33, $36, $3E, $00, $8C, $88, $2E, $33, $36, $3E, $3E, $3C, $87, $2E, $33
        byte $33, $36, $3E, $3C, $3C, $35, $86, $2E, $33, $36, $3E, $00, $BE, $3C, $35, $35, $86, $2E, $33, $36, $3E, $3C, $3C, $35
        byte $33, $85, $2E, $33, $36, $3E, $3E, $3C, $35, $35, $33, $32, $84, $2E, $33, $36, $3E, $3C, $3C, $35, $33, $33, $32, $84
        byte $2E, $36, $3E, $3E, $00, $9C, $35, $00, $A5, $33, $32, $32, $85, $2E, $3E, $3C, $3C, $35, $33, $33, $32, $86, $2E, $3C
        byte $3C, $35, $35, $33, $32, $32, $86, $2E, $3C, $35, $35, $33, $33, $32, $32, $87, $2E, $35, $33, $33, $32, $32, $88, $2E
        byte $35, $33, $33, $32, $32, $89, $2E, $33, $32, $32, $92, $2E


map19   byte $39, $31, $39, $31, $39, $31, $39, $31, $39, $31, $39, $31, $39, $39, $8B, $2E, $39, $39, $8B, $2E, $39, $39, $2E, $35
        byte $34, $35, $34, $35, $34, $35, $34, $35, $2E, $39, $39, $2E, $35, $87, $2E, $35, $2E, $39, $39, $2E, $35, $2E, $85, $3E
        byte $2E, $35, $2E, $39, $39, $2E, $35, $87, $2E, $35, $2E, $39, $39, $2E, $35, $2E, $85, $33, $2E, $35, $2E, $39, $39, $2E
        byte $35, $87, $2E, $35, $2E, $39, $39, $2E, $35, $2E, $85, $32, $2E, $35, $2E, $39, $39, $2E, $35, $87, $2E, $35, $2E, $39
        byte $8E, $2E, $66, $89, $2E, $66, $C2, $2E


map20   byte $B4, $2E, $8D, $31, $8D, $3E, $8D, $3C, $DB, $2E, $66, $85, $2E, $66, $85, $2E, $66, $66, $85, $2E, $66, $85, $2E, $66
        byte $66, $85, $2E, $66, $85, $2E, $66, $66, $85, $2E, $66, $85, $2E, $81, $66

DAT

map21   byte $A8, $2E, $67, $8C, $2E, $67, $51, $51, $8A, $2E, $83, $67, $96, $2E, $8B, $35, $B8, $2E, $8B, $3E, $B4, $2E, $8B, $32
        byte $82, $2E


map22   byte $9F, $2E, $83, $58, $8A, $2E, $83, $31, $8A, $2E, $83, $58, $A3, $2E, $85, $33, $87, $2E, $3D, $85, $2E, $3D, $86, $2E
        byte $3D, $85, $2E, $3D, $85, $2E, $38, $87, $2E, $38, $84, $2E, $38, $87, $2E, $38, $83, $2E, $32, $89, $2E, $32, $2E, $2E
        byte $32, $89, $2E, $32, $2E, $3E, $8B, $2E, $3E, $3E, $8B, $2E, $3E, $9A, $2E


map23   byte $34, $8C, $2E, $33, $35, $8B, $2E, $3E, $31, $34, $8A, $2E, $00, $78, $36, $33, $35, $8A, $2E, $32, $3E, $31, $34, $8A
        byte $2E, $38, $36, $33, $35, $8A, $2E, $32, $3E, $31, $34, $8A, $2E, $00, $88, $36, $33, $35, $8A, $2E, $32, $3E, $31, $00
        byte $A4, $8A, $2E, $38, $36, $33, $35, $83, $2E, $34, $86, $2E, $32, $3E, $31, $34, $2E, $2E, $33, $35, $86, $2E, $00, $98
        byte $36, $33, $35, $2E, $3E, $31, $34, $86, $2E, $32, $3E, $31, $00, $B4, $38, $36, $33, $35, $86, $2E, $38, $36, $33, $2E
        byte $32, $3E, $31, $34, $86, $2E, $32, $3E, $2E, $2E, $38, $36, $33, $87, $2E, $38, $83, $2E, $32, $3E, $8C, $2E, $38, $88
        byte $2E


map24   byte $A0, $2E, $33, $8B, $2E, $33, $2E, $33, $89, $2E, $33, $2E, $42, $2E, $33, $87, $2E, $33, $2E, $42, $2E, $42, $2E, $33
        byte $85, $2E, $33, $2E, $42, $2E, $3A, $2E, $42, $2E, $33, $83, $2E, $33, $2E, $42, $2E, $3A, $40, $3A, $2E, $42, $2E, $33
        byte $2E, $33, $2E, $42, $2E, $3A, $83, $40, $3A, $2E, $42, $2E, $33, $2E, $33, $2E, $42, $2E, $3A, $40, $3A, $2E, $42, $2E
        byte $33, $83, $2E, $33, $2E, $42, $2E, $3A, $2E, $42, $2E, $33, $85, $2E, $33, $2E, $42, $2E, $42, $2E, $33, $87, $2E, $33
        byte $2E, $42, $2E, $33, $89, $2E, $33, $2E, $33, $8B, $2E, $33, $AD, $2E


map25   byte $89, $2E, $84, $31, $88, $2E, $31, $83, $2E, $31, $87, $2E, $31, $84, $2E, $83, $31, $84, $2E, $31, $2E, $2E, $31, $31
        byte $2E, $31, $31, $2E, $31, $2E, $2E, $31, $2E, $2E, $31, $2E, $2E, $83, $31, $2E, $2E, $31, $31, $83, $2E, $31, $2E, $2E
        byte $83, $31, $2E, $2E, $31, $31, $83, $2E, $31, $2E, $31, $2E, $31, $31, $2E, $31, $2E, $31, $83, $2E, $31, $31, $2E, $2E
        byte $83, $31, $2E, $2E, $31, $87, $2E, $31, $31, $83, $2E, $31, $86, $2E, $31, $85, $2E, $31, $85, $2E, $31, $85, $2E, $83
        byte $31, $83, $2E, $31, $85, $2E, $31, $2E, $31, $2E, $31, $2E, $2E, $31, $84, $2E, $31, $2E, $2E, $31, $2E, $2E, $31, $2E
        byte $31, $83, $2E, $31, $83, $2E, $31, $2E, $2E, $31, $2E, $2E, $31, $2E, $2E, $31, $83, $2E, $31, $2E, $2E, $31, $83, $2E
        byte $83, $31, $83, $2E, $84, $31, $84, $2E, $31, $31, $8B, $2E, $81, $31


map26   byte $DB, $2E, $8D, $67, $8D, $2E, $36, $8B, $2E, $36, $3C, $36, $89, $2E, $36, $3C, $83, $36, $87, $2E, $90, $36, $8D, $38
        byte $84, $36, $00, $76, $00, $86, $00, $96, $00, $A6, $00, $B6, $87, $36, $87, $2E, $83, $36, $3C, $36, $89, $2E, $36, $3C
        byte $36, $8B, $2E, $81, $36


map27   byte $91, $2E, $4E, $2E, $4E, $2E, $4E, $89, $2E, $83, $4E, $89, $2E, $85, $4E, $89, $2E, $83, $4E, $89, $2E, $4E, $2E, $4E
        byte $2E, $4E, $86, $2E, $3A, $87, $2E, $31, $83, $2E, $3A, $36, $3A, $85, $2E, $31, $3D, $31, $2E, $3A, $36, $3C, $36, $3A
        byte $83, $2E, $31, $3D, $3E, $3D, $31, $3A, $36, $3C, $36, $3A, $83, $2E, $31, $3D, $3E, $3D, $31, $3A, $36, $3C, $36, $3A
        byte $83, $2E, $31, $3D, $3E, $3D, $31, $2E, $3A, $36, $3A, $85, $2E, $31, $3D, $31, $83, $2E, $3A, $87, $2E, $31, $84, $2E
        byte $32, $87, $2E, $32, $2E, $2E, $32, $2E, $32, $2E, $32, $83, $2E, $32, $2E, $32, $2E, $32, $2E, $83, $32, $85, $2E, $83
        byte $32, $83, $2E, $32, $87, $2E, $32, $84, $2E, $32, $87, $2E, $32, $82, $2E


map28   byte $C5, $2E, $85, $6F, $87, $2E, $6F, $85, $2E, $6F, $85, $2E, $6F, $87, $2E, $6F, $83, $2E, $6F, $89, $2E, $6F, $2E, $6F
        byte $8B, $2E, $6F, $2E, $38, $2E, $38, $2E, $38, $2E, $38, $2E, $38, $2E, $38, $2E, $3E, $38, $3E, $38, $3E, $38, $3E, $38
        byte $3E, $38, $3E, $38, $3E, $31, $38, $31, $38, $31, $38, $31, $38, $31, $38, $31, $38, $31, $31, $33, $31, $33, $31, $33
        byte $31, $33, $31, $33, $31, $33, $31, $31, $2E, $31, $2E, $31, $2E, $31, $2E, $31, $2E, $31, $2E, $31, $8F, $2E, $6D, $83
        byte $2E, $6D, $83, $2E, $6D, $8F, $2E


map29   byte $B4, $2E, $36, $8B, $2E, $36, $38, $36, $89, $2E, $36, $38, $2E, $38, $36, $87, $2E, $36, $38, $83, $2E, $38, $36, $85
        byte $2E, $36, $38, $85, $2E, $38, $36, $83, $2E, $36, $38, $87, $2E, $38, $36, $3D, $36, $38, $88, $2E, $31, $3D, $2E, $3D
        byte $31, $84, $2E, $83, $67, $2E, $31, $3D, $2E, $3D, $31, $2E, $83, $67, $83, $2E, $31, $2E, $3D, $2E, $3D, $2E, $31, $85
        byte $2E, $31, $2E, $3D, $83, $2E, $3D, $2E, $31, $83, $2E, $31, $2E, $3D, $85, $2E, $3D, $2E, $31, $2E, $31, $2E, $2E, $3D
        byte $85, $2E, $3D, $2E, $2E, $31, $2E, $36, $36, $3D, $85, $2E, $3D, $36, $36, $2E, $36, $36, $3D, $87, $2E, $3D, $82, $36


map30   byte $CE, $2E, $8D, $6F, $36, $2E, $31, $2E, $3C, $2E, $32, $2E, $3D, $2E, $38, $2E, $3A, $36, $2E, $31, $2E, $3C, $2E, $32
        byte $2E, $3D, $2E, $38, $2E, $3A, $36, $2E, $31, $2E, $3C, $2E, $32, $2E, $3D, $2E, $38, $2E, $3A, $36, $2E, $31, $2E, $3C
        byte $2E, $32, $2E, $3D, $2E, $38, $2E, $3A, $36, $2E, $00, $B1, $2E, $00, $AC, $2E, $00, $92, $2E, $00, $8D, $2E, $00, $78
        byte $2E, $3A, $36, $2E, $31, $2E, $3C, $2E, $32, $2E, $3D, $2E, $38, $2E, $3A, $36, $6F, $31, $6F, $3C, $6F, $32, $6F, $3D
        byte $6F, $38, $6F, $3A, $B4, $2E


DAT

map31   byte $9A, $2E, $60, $8B, $2E, $60, $2E, $60, $89, $2E, $60, $83, $2E, $60, $87, $2E, $60, $2E, $2E, $33, $2E, $2E, $60, $85
        byte $2E, $60, $2E, $2E, $31, $36, $33, $2E, $2E, $60, $83, $2E, $60, $2E, $2E, $31, $32, $3E, $36, $33, $2E, $2E, $60, $2E
        byte $60, $2E, $2E, $31, $32, $38, $39, $3E, $36, $33, $2E, $2E, $60, $2E, $2E, $31, $32, $38, $35, $3C, $39, $3E, $36, $33
        byte $83, $2E, $31, $32, $38, $35, $36, $32, $3C, $39, $3E, $36, $33, $2E, $31, $32, $38, $35, $36, $3F, $36, $32, $3C, $39
        byte $3E, $36, $33, $32, $38, $35, $36, $3F, $3E, $2E, $36, $32, $3C, $39, $3E, $32, $38, $35, $36, $3F, $3E, $83, $2E, $36
        byte $32, $3C, $39, $3E, $35, $36, $3F, $3E, $85, $2E, $36, $32, $3C, $35, $36, $3F, $3E, $87, $2E, $36, $32, $3C, $3F, $3E
        byte $89, $2E, $36, $3F, $3E, $8B, $2E, $36, $86, $2E


map32   byte $8D, $2E, $32, $3E, $31, $60, $32, $3E, $60, $3C, $32, $60, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E
        byte $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $60, $32, $3E
        byte $31, $60, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E
        byte $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $32, $3E, $31, $3C, $60, $3E, $31, $3C, $32, $3E, $31, $B5, $2E, $38
        byte $38, $2E, $38, $38, $2E, $38, $38, $2E, $38, $38, $2E, $39, $32, $32, $39, $32, $32, $39, $32, $32, $39, $32, $32, $39
        byte $2E, $3D, $3D, $2E, $3D, $3D, $2E, $3D, $3D, $2E, $3D, $3D, $A8, $2E


map33   byte $C6, $2E, $83, $30, $8A, $2E, $83, $30, $94, $2E, $60, $2E, $85, $60, $2E, $60, $83, $2E, $60, $89, $2E, $60, $E9, $2E


map34   byte $93, $2E, $36, $99, $2E, $36, $97, $2E, $35, $2E, $36, $2E, $35, $95, $2E, $35, $2E, $36, $2E, $35, $93, $2E, $32, $2E
        byte $35, $2E, $36, $2E, $35, $2E, $32, $91, $2E, $32, $2E, $35, $2E, $36, $2E, $35, $2E, $32, $91, $2E, $32, $2E, $35, $2E
        byte $36, $2E, $35, $2E, $32, $91, $2E, $32, $2E, $35, $2E, $36, $2E, $35, $2E, $32, $91, $2E, $32, $2E, $35, $2E, $36, $2E
        byte $35, $2E, $32, $82, $2E


map35   byte $F5, $2E, $8D, $6F, $A7, $2E, $38, $2E, $32, $2E, $3C, $2E, $3E, $2E, $31, $2E, $33, $2E, $3C, $2E, $36, $2E, $35, $2E
        byte $33, $2E, $32, $2E, $3E, $2E, $38, $2E, $32, $2E, $37, $2E, $38, $2E, $31, $2E, $3C, $2E, $35, $2E, $39, $9A, $2E


map36   byte $A7, $2E, $8D, $36, $8D, $3C, $00, $72, $32, $32, $00, $82, $32, $32, $00, $92, $32, $32, $00, $A2, $32, $32, $00, $B2
        byte $A7, $2E, $61, $2E, $61, $65, $65, $66, $2E, $66, $63, $63, $6E, $2E, $6E, $61, $2E, $61, $2E, $2E, $66, $2E, $66, $2E
        byte $2E, $6E, $2E, $6E, $61, $2E, $61, $2E, $2E, $66, $2E, $66, $2E, $2E, $6E, $2E, $6E, $61, $2E, $61, $2E, $2E, $66, $2E
        byte $66, $2E, $2E, $6E, $2E, $6E, $61, $2E, $61, $2E, $2E, $66, $2E, $66, $2E, $2E, $6E, $2E, $6E, $61, $2E, $61, $2E, $2E
        byte $66, $2E, $66, $2E, $2E, $6E, $2E, $6E, $A7, $2E


map37   byte $83, $2E, $33, $83, $2E, $33, $87, $2E, $33, $85, $2E, $33, $85, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E, $33
        byte $83, $2E, $33, $2E, $33, $83, $2E, $33, $85, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $85, $2E, $33, $83
        byte $2E, $33, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $2E, $33, $83, $2E, $33, $85, $2E, $33
        byte $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $85, $2E, $33, $85, $2E, $33, $83, $2E, $33
        byte $83, $2E, $33, $83, $2E, $33, $83, $2E, $33, $2E, $33, $83, $2E, $33, $2E, $33, $83, $2E, $33, $83, $2E, $33, $83, $2E
        byte $33, $83, $2E, $33, $85, $2E, $33, $85, $2E, $33, $87, $2E, $33, $83, $2E, $33, $89, $2E, $33, $2E, $33, $8B, $2E, $33
        byte $86, $2E


map38   byte $F7, $2E, $32, $83, $2E, $32, $83, $2E, $32, $8F, $2E, $32, $83, $2E, $32, $83, $2E, $32, $83, $2E, $32, $2E, $31, $83
        byte $2E, $31, $83, $2E, $31, $93, $2E, $31, $83, $2E, $31, $83, $2E, $31, $83, $2E, $48, $83, $2E, $48, $83, $2E, $48, $8F
        byte $2E, $48, $83, $2E, $48, $83, $2E, $48, $83, $2E, $81, $48


map39   byte $A7, $2E, $83, $3A, $00, $B6, $84, $32, $00, $A1, $31, $31, $33, $33, $83, $3A, $36, $84, $32, $83, $31, $33, $00, $93
        byte $00, $7A, $3A, $3A, $36, $84, $32, $84, $39, $33, $83, $3A, $3E, $32, $84, $3C, $83, $39, $33, $83, $3A, $3E, $3E, $84
        byte $3C, $83, $39, $33, $36, $36, $83, $3E, $83, $3C, $83, $35, $33, $33, $36, $36, $83, $3E, $83, $3C, $83, $35, $33, $33
        byte $36, $85, $31, $3C, $3C, $83, $35, $33, $33, $36, $85, $31, $3C, $3C, $83, $35, $33, $33, $36, $85, $31, $3C, $00, $8C
        byte $84, $35, $83, $36, $83, $3E, $83, $3C, $84, $35, $36, $38, $38, $83, $3E, $84, $3C, $84, $36, $38, $38, $84, $3E, $38
        byte $86, $36, $87, $38, $86, $36, $87, $38, $86, $36


map40   byte $8D, $2E, $00, $71, $8B, $2E, $00, $9C, $C7, $2E, $00, $B2, $C7, $2E, $00, $83, $8B, $2E, $00, $A5, $B4, $2E


DAT

map41   byte $87, $2E, $6F, $6F, $8A, $2E, $84, $6F, $84, $2E, $36, $85, $2E, $6F, $6F, $84, $2E, $83, $36, $8A, $2E, $84, $36, $85
        byte $2E, $36, $36, $2E, $2E, $85, $36, $83, $2E, $84, $36, $2E, $8D, $34, $85, $2E, $33, $3F, $33, $8A, $2E, $33, $3F, $33
        byte $89, $2E, $33, $2E, $3F, $2E, $33, $88, $2E, $33, $83, $2E, $33, $87, $2E, $33, $2E, $2E, $3F, $2E, $2E, $33, $86, $2E
        byte $33, $2E, $2E, $3F, $2E, $2E, $33, $85, $2E, $33, $83, $2E, $3F, $83, $2E, $33, $84, $2E, $33, $87, $2E, $33, $83, $2E
        byte $33, $84, $2E, $3F, $84, $2E, $33, $2E, $2E, $33, $84, $2E, $3F, $84, $2E, $33, $2E, $33, $85, $2E, $3F, $85, $2E, $81
        byte $33


map42   byte $9C, $2E, $3C, $87, $2E, $31, $31, $2E, $2E, $3C, $87, $2E, $31, $2E, $2E, $31, $3C, $88, $2E, $31, $2E, $2E, $31, $3C
        byte $88, $2E, $31, $2E, $2E, $31, $3C, $89, $2E, $83, $31, $83, $3C, $2E, $2E, $00, $A3, $2E, $00, $B3, $84, $2E, $31, $3C
        byte $2E, $2E, $3C, $2E, $2E, $00, $93, $85, $2E, $31, $3C, $2E, $2E, $3C, $2E, $00, $73, $2E, $00, $83, $84, $2E, $31, $3C
        byte $2E, $2E, $3C, $87, $2E, $31, $2E, $2E, $3C, $3C, $87, $2E, $31, $D0, $2E


map43   byte $D0, $2E, $3E, $38, $2E, $33, $3B, $2E, $3A, $32, $85, $2E, $3C, $32, $2E, $32, $37, $2E, $31, $3B, $85, $2E, $00, $77
        byte $38, $2E, $35, $32, $2E, $3F, $3D, $85, $2E, $38, $31, $2E, $3B, $33, $2E, $3E, $3C, $85, $2E, $33, $3A, $2E, $36, $3C
        byte $2E, $31, $00, $BB, $85, $2E, $3D, $37, $2E, $00, $8F, $31, $2E, $33, $3E, $85, $2E, $39, $32, $2E, $38, $3D, $2E, $32
        byte $38, $85, $2E, $36, $3B, $2E, $36, $36, $2E, $35, $3E, $85, $2E, $31, $39, $2E, $34, $35, $2E, $00, $98, $31, $85, $2E
        byte $3F, $35, $2E, $32, $3A, $2E, $36, $38, $85, $2E, $32, $36, $2E, $39, $3E, $2E, $3A, $37, $85, $2E, $3E, $34, $2E, $3C
        byte $31, $2E, $38, $00, $AB, $83, $2E


map44   byte $A9, $2E, $38, $3A, $3C, $3E, $31, $32, $3D, $39, $36, $84, $2E, $38, $6F, $3C, $3E, $31, $32, $3D, $39, $36, $84, $2E
        byte $38, $3A, $3C, $6F, $31, $32, $3D, $39, $36, $84, $2E, $38, $3A, $3C, $3E, $31, $6F, $3D, $6F, $36, $84, $2E, $6F, $3A
        byte $3C, $3E, $31, $32, $3D, $39, $36, $84, $2E, $38, $3A, $3C, $3E, $6F, $32, $3D, $39, $36, $84, $2E, $38, $3A, $6F, $3E
        byte $31, $32, $6F, $39, $36, $84, $2E, $38, $3A, $3C, $3E, $31, $32, $3D, $39, $36, $84, $2E, $38, $3A, $3C, $3E, $31, $32
        byte $3D, $39, $6F, $9D, $2E, $3D, $89, $2E, $38, $83, $2E, $3B, $87, $2E, $31, $83, $2E, $36, $89, $2E, $3C, $2E, $3A, $8B
        byte $2E, $81, $3E


map45   byte $86, $2E, $38, $8B, $2E, $38, $3E, $38, $89, $2E, $38, $3E, $3B, $3E, $38, $87, $2E, $38, $3E, $3B, $36, $3B, $3E, $38
        byte $85, $2E, $38, $3E, $3B, $36, $2E, $36, $3B, $3E, $38, $2E, $2E, $60, $38, $3E, $3B, $36, $83, $2E, $36, $3B, $3E, $38
        byte $60, $38, $3E, $3B, $36, $85, $2E, $36, $3B, $3E, $38, $2E, $38, $3E, $3B, $36, $83, $2E, $36, $3B, $3E, $38, $83, $2E
        byte $38, $3E, $3B, $36, $2E, $36, $3B, $3E, $38, $85, $2E, $38, $3E, $3B, $36, $3B, $3E, $38, $87, $2E, $38, $3E, $3B, $3E
        byte $38, $89, $2E, $38, $3E, $38, $89, $2E, $00, $78, $00, $8E, $00, $9B, $00, $AE, $00, $B8, $87, $2E, $38, $3E, $3B, $36
        byte $3B, $3E, $38, $85, $2E, $38, $3E, $3B, $36, $2E, $36, $3B, $3E, $38, $2E, $2E, $60, $38, $3E, $3B, $36, $83, $2E, $36
        byte $3B, $3E, $38, $60, $38, $3E, $3B, $36, $85, $2E, $36, $3B, $3E, $38, $2E, $38, $3E, $3B, $36, $83, $2E, $36, $3B, $3E
        byte $38, $81, $2E


map46   byte $A9, $2E, $3E, $3D, $3A, $83, $2E, $3A, $3D, $3E, $85, $2E, $3E, $3D, $3A, $2E, $3A, $3D, $3E, $87, $2E, $3E, $3D, $2E
        byte $3D, $3E, $89, $2E, $3E, $2E, $3E, $89, $2E, $3E, $3D, $2E, $3D, $3E, $87, $2E, $3E, $3D, $3A, $2E, $3A, $3D, $3E, $85
        byte $2E, $3E, $3D, $3A, $83, $2E, $3A, $3D, $3E, $83, $2E, $3E, $3D, $3A, $85, $2E, $3A, $3D, $3E, $2E, $3E, $3D, $3A, $87
        byte $2E, $3A, $3D, $3E, $2E, $3E, $3D, $3A, $85, $2E, $3A, $3D, $3E, $83, $2E, $3E, $3D, $3A, $83, $2E, $3A, $3D, $3E, $85
        byte $2E, $3E, $3D, $3A, $2E, $3A, $3D, $3E, $87, $2E, $3E, $3D, $3A, $3D, $3E, $89, $2E, $3E, $3D, $3E, $8B, $2E, $3E, $86
        byte $2E


map47   byte $8D, $2E, $3F, $60, $3F, $60, $83, $3F, $60, $3F, $60, $3F, $60, $3F, $3F, $60, $3F, $60, $83, $3F, $60, $3F, $60, $3F
        byte $60, $3F, $3F, $60, $3F, $60, $83, $3F, $60, $3F, $60, $3F, $60, $3F, $3F, $60, $3F, $60, $83, $3F, $60, $3F, $60, $3F
        byte $60, $3F, $3F, $60, $3F, $60, $83, $3F, $60, $3F, $60, $3F, $60, $3F, $3F, $60, $3F, $60, $83, $3F, $60, $3F, $60, $3F
        byte $60, $A8, $3F, $93, $2E, $83, $3C, $88, $2E, $3C, $3C, $2E, $2E, $3C, $89, $2E, $3C, $2E, $2E, $3C, $89, $2E, $3C, $2E
        byte $3C, $3C, $88, $2E, $85, $3C, $87, $2E, $83, $3C, $2E, $3C, $89, $2E, $3C, $88, $2E


map48   byte $96, $2E, $60, $85, $2E, $67, $9E, $2E, $67, $87, $2E, $60, $94, $2E, $67, $94, $2E, $67, $89, $2E, $89, $3D, $2E, $67
        byte $2E, $67, $89, $3D, $84, $2E, $89, $3D, $9F, $2E, $67, $8F, $2E, $67, $86, $2E, $60, $8B, $2E, $60, $89, $2E, $60, $83
        byte $2E


map49   byte $9D, $2E, $87, $60, $86, $2E, $3E, $3C, $2E, $3C, $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $3C, $2E, $3C, $3E, $86, $2E
        byte $3E, $3C, $2E, $00, $BC, $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $3C, $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $00, $AC
        byte $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $3C, $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $00, $9C, $2E, $3C, $3E, $86, $2E
        byte $3E, $3C, $2E, $3C, $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $00, $8C, $2E, $3C, $3E, $86, $2E, $3E, $3C, $2E, $3C, $2E
        byte $3C, $3E, $86, $2E, $3E, $3C, $2E, $00, $7C, $2E, $3C, $3E, $85, $2E, $3E, $3C, $2E, $2E, $3C, $2E, $2E, $3C, $3E, $83
        byte $2E, $3E, $3C, $83, $2E, $3C, $83, $2E, $3C, $3E, $2E, $3E, $3C, $84, $2E, $3C, $84, $2E, $3C, $3E, $3C, $8B, $2E, $81
        byte $3C


map50   byte $B4, $2E, $8D, $33, $8D, $2E, $83, $60, $84, $2E, $86, $60, $8D, $2E, $8D, $3C, $8D, $2E, $86, $60, $84, $2E, $83, $60
        byte $8D, $2E, $8D, $32, $8D, $2E, $84, $60, $84, $2E, $85, $60, $A7, $2E


DAT

map51   byte $8D, $2E, $67, $3B, $67, $34, $67, $36, $67, $32, $67, $3E, $67, $31, $67, $2E, $3B, $2E, $34, $2E, $36, $2E, $32, $2E
        byte $3E, $2E, $31, $2E, $2E, $3B, $2E, $34, $2E, $36, $2E, $32, $2E, $3E, $2E, $31, $2E, $2E, $3B, $2E, $34, $2E, $36, $2E
        byte $32, $2E, $3E, $2E, $31, $2E, $67, $5B, $67, $54, $67, $56, $67, $52, $67, $5E, $67, $51, $67, $2E, $3B, $2E, $34, $2E
        byte $36, $2E, $32, $2E, $3E, $2E, $31, $2E, $2E, $3B, $2E, $34, $2E, $36, $2E, $32, $2E, $3E, $2E, $31, $2E, $2E, $3B, $2E
        byte $34, $2E, $36, $2E, $32, $2E, $3E, $2E, $31, $2E, $67, $5B, $67, $54, $67, $56, $67, $52, $67, $5E, $67, $51, $67, $2E
        byte $3B, $2E, $34, $2E, $36, $2E, $32, $2E, $3E, $2E, $31, $2E, $2E, $3B, $2E, $34, $2E, $36, $2E, $32, $2E, $3E, $2E, $31
        byte $2E, $2E, $3B, $2E, $34, $2E, $36, $2E, $32, $2E, $3E, $2E, $31, $2E, $67, $5B, $67, $54, $67, $56, $67, $52, $67, $5E
        byte $67, $51, $67, $B4, $2E


map52   byte $B4, $2E, $8D, $60, $9A, $2E, $3F, $31, $3F, $31, $3F, $31, $3F, $31, $3F, $31, $3F, $31, $3F, $31, $8B, $2E, $31, $3F
        byte $2E, $62, $63, $62, $63, $62, $63, $62, $63, $62, $2E, $3F, $31, $8B, $2E, $31, $3F, $31, $3F, $31, $3F, $31, $3F, $31
        byte $3F, $31, $3F, $31, $3F, $8D, $2E, $33, $32, $33, $32, $33, $32, $33, $32, $33, $32, $33, $32, $33, $32, $8B, $2E, $32
        byte $33, $2E, $61, $6F, $61, $6F, $61, $6F, $61, $6F, $61, $2E, $33, $32, $8B, $2E, $32, $33, $32, $33, $32, $33, $32, $33
        byte $32, $33, $32, $33, $32, $81, $33


map53   byte $CE, $2E, $8D, $6F, $8E, $2E, $32, $32, $2E, $32, $32, $2E, $32, $32, $2E, $32, $32, $8E, $2E, $36, $31, $31, $00, $86
        byte $31, $31, $36, $31, $31, $00, $A6, $31, $31, $36, $2E, $6F, $6F, $2E, $6F, $6F, $2E, $6F, $6F, $2E, $6F, $6F, $8F, $2E
        byte $33, $33, $2E, $33, $33, $2E, $33, $33, $2E, $33, $33, $8E, $2E, $00, $7C, $35, $35, $3C, $35, $35, $00, $9C, $35, $35
        byte $3C, $35, $35, $00, $BC, $2E, $6F, $6F, $2E, $6F, $6F, $2E, $6F, $6F, $2E, $6F, $6F, $8E, $2E


map54   byte $2E, $2E, $6F, $6F, $86, $2E, $60, $91, $2E, $3B, $3D, $2E, $2E, $60, $2E, $2E, $3A, $3C, $2E, $60, $2E, $2E, $38, $32
        byte $85, $2E, $3E, $36, $96, $2E, $60, $89, $2E, $60, $88, $2E, $60, $8A, $2E, $60, $83, $2E, $36, $83, $2E, $36, $83, $2E
        byte $36, $83, $2E, $33, $31, $33, $2E, $33, $31, $33, $2E, $33, $31, $33, $2E, $36, $32, $2E, $32, $36, $32, $2E, $32, $36
        byte $32, $2E, $32, $36, $31, $83, $2E, $31, $83, $2E, $31, $83, $2E, $31, $8D, $2E, $38, $3E, $3D, $3E, $3D, $3E, $3D, $3E
        byte $3D, $3E, $3D, $3E, $38, $3C, $8B, $2E, $3C, $38, $8B, $2E, $38, $3C, $8B, $2E, $3C, $38, $8B, $2E, $81, $38


map55   byte $8D, $2E, $3E, $3E, $89, $2E, $3D, $3D, $3E, $3E, $89, $2E, $3D, $3D, $3E, $3E, $89, $2E, $3D, $3D, $3E, $3E, $89, $2E
        byte $3D, $3D, $3E, $3E, $89, $2E, $3D, $3D, $3E, $3E, $89, $2E, $3D, $3D, $3E, $3E, $83, $2E, $31, $3E, $31, $83, $2E, $3D
        byte $3D, $3E, $3E, $83, $2E, $3E, $3C, $3E, $83, $2E, $3D, $3D, $3E, $3E, $83, $2E, $31, $3E, $31, $83, $2E, $3D, $3D, $B4
        byte $2E, $85, $36, $83, $2E, $85, $32, $85, $36, $83, $2E, $85, $32, $8D, $2E, $00, $7F, $2E, $2E, $00, $8F, $2E, $2E, $00
        byte $9F, $2E, $2E, $00, $AF, $2E, $2E, $81, $BF


map56   byte $8D, $2E, $3D, $8B, $2E, $36, $2E, $3D, $89, $2E, $36, $83, $2E, $3D, $87, $2E, $36, $85, $2E, $3D, $85, $2E, $36, $87
        byte $2E, $31, $33, $31, $33, $31, $88, $2E, $33, $32, $3E, $32, $33, $88, $2E, $31, $3E, $32, $3E, $31, $88, $2E, $33, $32
        byte $3E, $32, $33, $88, $2E, $31, $33, $31, $33, $31, $87, $2E, $3C, $2E, $38, $2E, $38, $2E, $3B, $85, $2E, $3C, $2E, $2E
        byte $38, $2E, $38, $2E, $2E, $3B, $83, $2E, $3C, $38, $2E, $2E, $38, $2E, $38, $2E, $2E, $38, $3B, $2E, $3C, $2E, $38, $2E
        byte $2E, $38, $2E, $38, $2E, $2E, $38, $2E, $3B, $2E, $2E, $38, $2E, $2E, $38, $2E, $38, $2E, $2E, $38, $84, $2E, $38, $2E
        byte $2E, $38, $2E, $38, $2E, $2E, $38, $84, $2E, $38, $2E, $2E, $38, $2E, $38, $2E, $2E, $38, $84, $2E, $38, $37, $37, $38
        byte $37, $38, $37, $37, $38, $82, $2E


map57   byte $9B, $2E, $32, $89, $2E, $31, $2E, $83, $32, $83, $2E, $3A, $83, $2E, $83, $31, $32, $2E, $32, $2E, $2E, $83, $3A, $2E
        byte $2E, $31, $2E, $31, $85, $2E, $3A, $2E, $3A, $86, $2E, $38, $89, $2E, $36, $2E, $83, $38, $83, $2E, $3E, $83, $2E, $83
        byte $36, $38, $2E, $38, $2E, $2E, $83, $3E, $2E, $2E, $36, $2E, $36, $85, $2E, $3E, $2E, $3E, $86, $2E, $3B, $89, $2E, $3D
        byte $2E, $83, $3B, $83, $2E, $33, $83, $2E, $83, $3D, $3B, $2E, $3B, $2E, $2E, $83, $33, $2E, $2E, $3D, $2E, $3D, $85, $2E
        byte $33, $2E, $33, $86, $2E, $35, $89, $2E, $39, $2E, $83, $35, $83, $2E, $3C, $83, $2E, $83, $39, $35, $2E, $35, $2E, $2E
        byte $83, $3C, $2E, $2E, $39, $2E, $39, $85, $2E, $3C, $2E, $3C, $85, $2E


map58   byte $87, $2E, $33, $33, $8B, $2E, $33, $33, $2E, $3F, $3F, $2E, $2E, $60, $2E, $00, $92, $32, $85, $2E, $3F, $3F, $84, $2E
        byte $32, $32, $90, $2E, $00, $A1, $31, $8B, $2E, $31, $31, $2E, $60, $94, $2E, $60, $87, $2E, $00, $8F, $3F, $8B, $2E, $3F
        byte $3F, $86, $2E, $32, $32, $87, $2E, $33, $33, $2E, $2E, $32, $32, $87, $2E, $33, $33, $88, $2E, $60, $92, $2E, $60, $86
        byte $2E, $00, $71, $31, $86, $2E, $00, $B3, $33, $83, $2E, $31, $31, $86, $2E, $33, $33, $87, $2E, $32, $32, $8B, $2E, $32
        byte $32, $85, $2E


map59   byte $C1, $2E, $60, $85, $2E, $60, $85, $2E, $60, $2E, $60, $83, $2E, $60, $2E, $60, $83, $2E, $60, $83, $2E, $60, $2E, $60
        byte $83, $2E, $60, $2E, $60, $2E, $2E, $31, $2E, $2E, $60, $84, $2E, $31, $60, $83, $2E, $3E, $3F, $85, $2E, $3F, $3E, $3F
        byte $83, $2E, $3B, $3A, $31, $83, $2E, $31, $3A, $3B, $3A, $31, $83, $2E, $36, $3E, $3F, $2E, $3F, $3E, $36, $2E, $36, $3E
        byte $3F, $83, $2E, $3B, $3A, $31, $3A, $3B, $83, $2E, $3B, $3A, $31, $83, $2E, $36, $3E, $36, $85, $2E, $36, $3E, $84, $2E
        byte $3B, $87, $2E, $3B, $A7, $2E


map60   byte $93, $2E, $60, $8C, $2E, $60, $8C, $2E, $60, $89, $2E, $38, $2E, $2E, $60, $2E, $2E, $3C, $85, $2E, $38, $3E, $38, $2E
        byte $60, $2E, $3C, $3F, $3C, $83, $2E, $38, $3E, $38, $2E, $2E, $60, $2E, $2E, $3C, $3F, $3C, $83, $2E, $38, $87, $2E, $3C
        byte $AF, $2E, $60, $8C, $2E, $60, $89, $2E, $3B, $2E, $2E, $60, $2E, $2E, $31, $85, $2E, $3B, $33, $3B, $2E, $60, $2E, $31
        byte $3A, $31, $83, $2E, $3B, $33, $3B, $2E, $2E, $60, $2E, $2E, $31, $3A, $31, $83, $2E, $3B, $83, $2E, $60, $83, $2E, $31
        byte $8F, $2E


DAT

map61   byte $AD, $2E, $60, $8B, $2E, $60, $2E, $60, $89, $2E, $60, $83, $2E, $60, $87, $2E, $60, $3B, $83, $31, $3B, $60, $85, $2E
        byte $60, $2E, $31, $3B, $32, $3B, $31, $2E, $60, $83, $2E, $60, $2E, $2E, $31, $32, $31, $32, $31, $2E, $2E, $60, $2E, $60
        byte $83, $2E, $31, $3B, $32, $3B, $31, $83, $2E, $60, $2E, $60, $2E, $2E, $3B, $83, $31, $3B, $2E, $2E, $60, $83, $2E, $60
        byte $87, $2E, $60, $85, $2E, $60, $85, $2E, $60, $B0, $2E, $6F, $8C, $2E, $6F, $86, $2E


map62   byte $F5, $2E, $3F, $3E, $3F, $3E, $3F, $3E, $3F, $3E, $3F, $3E, $3F, $3E, $3F, $38, $32, $38, $32, $38, $32, $38, $32, $38
        byte $32, $38, $32, $38, $3D, $3B, $3D, $3B, $3D, $3B, $3D, $3B, $3D, $3B, $3D, $3B, $3D, $31, $3C, $31, $31, $3C, $31, $31
        byte $3C, $31, $31, $3C, $31, $31, $00, $76, $3A, $36, $00, $8A, $36, $3A, $00, $96, $3A, $36, $00, $AA, $36, $3A, $00, $B6
        byte $9C, $2E, $84, $67, $2E, $84, $67, $8F, $2E


map63   byte $8E, $2E, $6F, $2E, $6F, $2E, $6F, $2E, $6F, $2E, $6F, $2E, $6F, $A1, $2E, $3C, $8C, $2E, $33, $8B, $2E, $33, $31, $33
        byte $89, $2E, $31, $2E, $3E, $2E, $31, $87, $2E, $3E, $2E, $2E, $38, $2E, $2E, $3E, $85, $2E, $38, $83, $2E, $32, $83, $2E
        byte $38, $83, $2E, $3A, $2E, $2E, $6F, $2E, $36, $2E, $6F, $2E, $2E, $3A, $83, $2E, $36, $83, $2E, $3A, $83, $2E, $36, $85
        byte $2E, $32, $2E, $2E, $38, $2E, $2E, $32, $87, $2E, $36, $2E, $3B, $2E, $36, $85, $2E, $6F, $83, $2E, $3B, $3D, $3B, $83
        byte $2E, $6F, $83, $2E, $6F, $83, $2E, $37, $83, $2E, $6F, $85, $2E, $6F, $2E, $2E, $37, $2E, $2E, $6F, $90, $2E


map64   byte $C1, $2E, $8E, $67, $3E, $3E, $67, $3A, $3A, $67, $3B, $3B, $67, $3D, $3D, $67, $67, $33, $33, $67, $3C, $3C, $67, $35
        byte $35, $67, $31, $31, $67, $67, $36, $36, $67, $39, $39, $67, $3A, $3A, $67, $38, $38, $67, $67, $31, $31, $67, $32, $32
        byte $67, $3E, $3E, $67, $3F, $3F, $67, $67, $2E, $2E, $67, $2E, $2E, $67, $2E, $2E, $67, $2E, $2E, $67, $67, $2E, $2E, $67
        byte $2E, $2E, $67, $2E, $2E, $67, $2E, $2E, $67, $67, $2E, $2E, $67, $2E, $2E, $67, $2E, $2E, $67, $2E, $2E, $67, $A8, $2E
        byte $67, $67, $2E, $67, $67, $2E, $67, $67, $2E, $67, $67, $8E, $2E


map65   byte $93, $2E, $60, $8C, $2E, $60, $8C, $2E, $60, $88, $2E, $3B, $83, $2E, $60, $83, $2E, $3B, $84, $2E, $3C, $3E, $2E, $2E
        byte $60, $2E, $2E, $3E, $3C, $85, $2E, $3C, $3E, $2E, $60, $2E, $3E, $3C, $87, $2E, $3C, $3E, $60, $3E, $3C, $89, $2E, $3C
        byte $3E, $3C, $8A, $2E, $3C, $3E, $3C, $85, $2E, $84, $31, $2E, $3E, $33, $3E, $2E, $84, $31, $85, $2E, $3E, $33, $3E, $8A
        byte $2E, $3E, $33, $3E, $8B, $2E, $3E, $8C, $2E, $00, $9E, $8B, $2E, $00, $8E, $2E, $00, $AE, $89, $2E, $00, $7E, $83, $2E
        byte $00, $BE, $86, $2E, $3B, $3E, $85, $2E, $3E, $3B, $82, $2E


map66   byte $8D, $2E, $31, $2E, $32, $87, $2E, $32, $2E, $31, $31, $2E, $32, $87, $2E, $32, $2E, $31, $31, $2E, $32, $87, $2E, $32
        byte $2E, $31, $31, $2E, $32, $87, $2E, $32, $2E, $31, $31, $2E, $32, $87, $2E, $32, $2E, $31, $31, $2E, $32, $2E, $2E, $60
        byte $2E, $60, $2E, $2E, $32, $2E, $31, $31, $2E, $32, $87, $2E, $32, $2E, $31, $31, $2E, $32, $87, $2E, $32, $2E, $31, $31
        byte $2E, $32, $60, $00, $7C, $00, $83, $00, $9E, $00, $AD, $00, $BB, $60, $32, $2E, $31, $31, $2E, $32, $60, $3B, $3C, $33
        byte $3E, $3D, $60, $32, $2E, $31, $31, $2E, $32, $60, $3D, $3B, $3C, $33, $3E, $60, $32, $2E, $31, $31, $2E, $32, $60, $3E
        byte $3D, $3B, $3C, $33, $60, $32, $2E, $31, $31, $2E, $32, $87, $60, $32, $2E, $31, $9B, $2E, $60, $89, $2E, $60, $2E, $2E
        byte $60, $89, $2E, $60, $81, $2E


map67   byte $93, $2E, $60, $97, $2E, $60, $83, $2E, $60, $93, $2E, $60, $87, $2E, $60, $8F, $2E, $60, $83, $2E, $60, $83, $2E, $60
        byte $83, $2E, $60, $8F, $2E, $31, $31, $85, $2E, $3C, $3C, $84, $2E, $31, $31, $2E, $3E, $36, $3E, $2E, $3C, $3C, $87, $2E
        byte $36, $2E, $36, $88, $2E, $3D, $36, $83, $2E, $36, $3D, $86, $2E, $36, $2E, $2E, $6F, $2E, $2E, $36, $83, $2E, $33, $2E
        byte $2E, $3D, $36, $83, $2E, $36, $3D, $2E, $2E, $3B, $33, $84, $2E, $36, $2E, $36, $84, $2E, $3B, $33, $84, $2E, $3E, $36
        byte $3E, $84, $2E, $3B, $33, $2E, $6F, $87, $2E, $6F, $2E, $81, $3B


map68   byte $9A, $2E, $57, $83, $2E, $57, $83, $2E, $57, $83, $2E, $57, $2E, $2E, $57, $83, $2E, $57, $83, $2E, $57, $8F, $2E, $57
        byte $83, $2E, $57, $83, $2E, $57, $83, $2E, $57, $8D, $2E, $31, $3F, $3E, $3F, $38, $83, $37, $36, $3F, $32, $3F, $35, $3F
        byte $3C, $3F, $3A, $3F, $83, $37, $3F, $3B, $3F, $34, $3F, $31, $3F, $3E, $3F, $38, $83, $2E, $36, $3F, $32, $3F, $35, $3F
        byte $3C, $3F, $3A, $85, $2E, $3B, $3F, $34, $3F, $31, $3F, $3E, $3F, $85, $2E, $3F, $32, $3F, $35, $3F, $3C, $3F, $87, $2E
        byte $3F, $34, $3F, $31, $3F, $3E, $87, $2E, $32, $3F, $35, $3F, $3C, $89, $2E, $34, $3F, $31, $3F, $89, $2E, $3F, $35, $3F
        byte $8B, $2E, $3F, $31, $8B, $2E, $81, $35


map69   byte $B9, $2E, $83, $3E, $89, $2E, $85, $3E, $87, $2E, $87, $3E, $85, $2E, $89, $3E, $84, $2E, $88, $3E, $84, $2E, $87, $3E
        byte $86, $2E, $86, $3E, $2E, $6F, $2E, $6F, $2E, $6F, $2E, $87, $3E, $87, $2E, $88, $3E, $85, $2E, $89, $3E, $85, $2E, $87
        byte $3E, $87, $2E, $85, $3E, $89, $2E, $83, $3E, $92, $2E


map70   byte $A7, $2E, $83, $3A, $36, $84, $32, $83, $31, $85, $3A, $36, $84, $32, $31, $00, $A1, $31, $2E, $2E, $83, $3A, $36, $84
        byte $32, $83, $3B, $84, $2E, $3A, $3E, $32, $84, $3C, $83, $3B, $3A, $2E, $2E, $3A, $3E, $3E, $3C, $00, $7C, $3C, $3C, $83
        byte $3B, $3A, $36, $36, $83, $3E, $83, $3C, $83, $3D, $3A, $3A, $36, $36, $83, $3E, $3C, $2E, $2E, $83, $3D, $3A, $3A, $36
        byte $85, $31, $2E, $2E, $3D, $3D, $00, $8D, $3A, $3A, $36, $85, $31, $3C, $3C, $83, $3D, $3A, $3A, $00, $96, $85, $31, $3C
        byte $3C, $83, $3D, $84, $36, $83, $3E, $83, $3C, $83, $3D, $36, $00, $B6, $38, $2E, $2E, $3E, $3E, $84, $3C, $84, $36, $38
        byte $2E, $2E, $83, $3E, $38, $84, $36, $2E, $2E, $87, $38, $84, $36, $2E, $2E, $87, $38, $86, $36

DAT

map71   byte $93, $2E, $31, $8B, $2E, $31, $3E, $31, $89, $2E, $31, $3E, $3B, $3E, $31, $87, $2E, $31, $3E, $3B, $36, $3B, $3E, $31
        byte $85, $2E, $31, $3E, $3B, $36, $2E, $36, $3B, $3E, $31, $2E, $2E, $60, $31, $3E, $3B, $36, $00, $B1, $2E, $00, $A1, $36
        byte $3B, $3E, $31, $60, $31, $3E, $3B, $36, $2E, $2E, $00, $81, $2E, $2E, $36, $3B, $3E, $31, $2E, $31, $3E, $3B, $36, $00
        byte $71, $2E, $00, $91, $36, $3B, $3E, $31, $83, $2E, $31, $3E, $3B, $36, $2E, $36, $3B, $3E, $31, $85, $2E, $31, $3E, $3B
        byte $36, $3B, $3E, $31, $83, $2E, $63, $83, $2E, $31, $3E, $3B, $3E, $31, $83, $2E, $63, $85, $2E, $31, $3E, $31, $87, $2E
        byte $63, $83, $2E, $31, $83, $2E, $63, $93, $2E, $63, $83, $2E, $63, $97, $2E, $63, $86, $2E


map72   byte $90, $2E, $3B, $85, $2E, $33, $83, $2E, $3C, $2E, $2E, $3B, $85, $2E, $33, $2E, $2E, $3E, $3C, $2E, $2E, $6B, $2E, $2E
        byte $3D, $2E, $2E, $63, $2E, $2E, $3E, $6C, $2E, $2E, $00, $AB, $2E, $2E, $3D, $2E, $2E, $33, $2E, $2E, $6E, $3C, $85, $2E
        byte $6D, $85, $2E, $3E, $83, $2E, $3B, $2E, $2E, $3D, $2E, $2E, $33, $83, $2E, $3C, $2E, $2E, $3B, $85, $2E, $33, $2E, $2E
        byte $3E, $3C, $2E, $2E, $6B, $2E, $2E, $3D, $2E, $2E, $63, $2E, $2E, $3E, $6C, $2E, $2E, $3B, $2E, $2E, $00, $9D, $2E, $2E
        byte $33, $2E, $2E, $6E, $00, $BC, $85, $2E, $6D, $85, $2E, $3E, $83, $2E, $3B, $2E, $2E, $3D, $2E, $2E, $33, $83, $2E, $3C
        byte $2E, $2E, $3B, $85, $2E, $00, $83, $2E, $2E, $3E, $3C, $2E, $2E, $6B, $2E, $2E, $3D, $2E, $2E, $63, $2E, $2E, $3E, $6C
        byte $2E, $2E, $3B, $2E, $2E, $3D, $2E, $2E, $33, $2E, $2E, $6E, $3C, $85, $2E, $6D, $85, $2E, $00, $7E, $86, $2E, $3D, $93
        byte $2E


map73   byte $92, $2E, $83, $3D, $87, $2E, $89, $63, $84, $2E, $63, $87, $2E, $63, $84, $2E, $63, $2E, $85, $3C, $2E, $63, $84, $2E
        byte $63, $2E, $3C, $83, $2E, $3C, $2E, $63, $84, $2E, $63, $2E, $3C, $83, $2E, $3C, $2E, $63, $84, $2E, $63, $87, $2E, $63
        byte $84, $2E, $63, $2E, $85, $36, $2E, $63, $84, $2E, $63, $83, $2E, $36, $83, $2E, $63, $84, $2E, $63, $83, $2E, $36, $83
        byte $2E, $63, $84, $2E, $63, $87, $2E, $63, $84, $2E, $63, $2E, $85, $3E, $2E, $63, $84, $2E, $63, $2E, $3E, $83, $2E, $3E
        byte $2E, $63, $84, $2E, $63, $2E, $3E, $83, $2E, $3E, $2E, $63, $84, $2E, $63, $87, $2E, $63, $84, $2E, $63, $2E, $85, $38
        byte $2E, $63, $84, $2E, $63, $83, $2E, $38, $83, $2E, $63, $82, $2E


map74   byte $A7, $2E, $87, $31, $3E, $31, $31, $3E, $8A, $31, $3E, $3E, $85, $31, $84, $3A, $31, $31, $3E, $3E, $84, $31, $84, $3A
        byte $32, $3A, $3E, $31, $31, $3E, $31, $31, $85, $3A, $6C, $3A, $3A, $86, $31, $3A, $3A, $38, $38, $3A, $3A, $86, $31, $83
        byte $3B, $38, $38, $8B, $3B, $38, $38, $88, $3B, $83, $36, $38, $38, $8B, $36, $38, $38, $8B, $36, $38, $38, $8B, $36, $38
        byte $38, $8A, $36, $84, $38, $87, $36, $9A, $2E


map75   byte $50, $8B, $2E, $50, $F5, $2E, $C1, $2E, $50, $8B, $2E, $50, $9A, $2E


map76   byte $A7, $2E, $00, $7B, $85, $31, $3B, $83, $31, $3B, $31, $2E, $31, $3B, $83, $31, $3B, $83, $31, $3B, $31, $31, $2E, $31
        byte $31, $3B, $31, $3B, $31, $31, $00, $A1, $3B, $83, $31, $2E, $83, $31, $3B, $83, $31, $3B, $83, $31, $3B, $2E, $3B, $31
        byte $3B, $31, $3B, $31, $3B, $83, $31, $3B, $31, $2E, $00, $91, $3B, $83, $31, $3B, $83, $31, $3B, $31, $31, $2E, $3B, $31
        byte $3B, $31, $3B, $31, $3B, $31, $3B, $83, $31, $2E, $83, $31, $3B, $83, $31, $3B, $84, $31, $2E, $3B, $31, $3B, $31, $3B
        byte $31, $3B, $31, $3B, $83, $31, $2E, $31, $3B, $83, $31, $3B, $83, $31, $3B, $00, $B1, $31, $2E, $3B, $31, $3B, $31, $3B
        byte $31, $3B, $83, $31, $3B, $31, $2E, $83, $31, $3B, $31, $31, $00, $81, $3B, $83, $31, $3B, $2E, $31, $31, $3B, $31, $3B
        byte $83, $31, $3B, $83, $31, $2E, $31, $3B, $83, $31, $3B, $83, $31, $3B, $31, $31, $2E, $3B, $85, $31, $3B, $83, $31, $3B
        byte $31, $81, $2E


map77   byte $AA, $2E, $47, $47, $83, $2E, $47, $47, $85, $2E, $47, $3C, $3C, $47, $2E, $47, $3C, $3C, $47, $83, $2E, $47, $84, $3C
        byte $47, $84, $3C, $47, $2E, $2E, $47, $89, $3C, $47, $83, $2E, $47, $87, $3C, $47, $84, $2E, $47, $87, $3C, $47, $85, $2E
        byte $47, $85, $3C, $47, $86, $2E, $47, $85, $3C, $47, $87, $2E, $47, $83, $3C, $47, $88, $2E, $47, $83, $3C, $47, $89, $2E
        byte $47, $3C, $47, $8A, $2E, $47, $3C, $47, $8B, $2E, $47, $A0, $2E


map78   byte $B1, $2E, $3C, $3C, $2E, $2E, $85, $3C, $32, $85, $3C, $2E, $2E, $3C, $3C, $83, $2E, $31, $8B, $2E, $31, $36, $31, $89
        byte $2E, $31, $3E, $36, $3E, $31, $87, $2E, $31, $3E, $3E, $36, $3E, $3E, $31, $86, $2E, $31, $3E, $83, $36, $3E, $31, $85
        byte $2E, $31, $3E, $3E, $83, $36, $3E, $3E, $31, $84, $2E, $31, $3E, $3E, $83, $36, $3E, $3E, $31, $84, $2E, $31, $3E, $85
        byte $36, $3E, $31, $83, $2E, $8B, $31, $2E, $2E, $31, $89, $3E, $31, $83, $2E, $89, $31, $9C, $2E


map79   byte $C1, $2E, $3C, $3F, $83, $31, $3F, $3C, $3F, $83, $31, $3F, $3C, $3F, $3C, $3F, $31, $31, $3F, $3C, $3F, $31, $31, $3F
        byte $3C, $3F, $31, $3F, $3C, $3F, $31, $3F, $3C, $3F, $31, $3F, $3C, $3F, $83, $31, $3F, $3C, $3F, $3F, $3C, $3F, $3F, $3C
        byte $3F, $85, $31, $3F, $3C, $3F, $3C, $3F, $3C, $3F, $83, $31, $85, $3F, $83, $3C, $85, $3F, $8D, $3C, $85, $3F, $83, $3C
        byte $85, $3F, $83, $31, $3F, $3C, $3F, $3C, $3F, $3C, $3F, $85, $31, $3F, $3C, $3F, $3F, $3C, $3F, $3F, $3C, $3F, $83, $31
        byte $3F, $3C, $3F, $31, $3F, $3C, $3F, $31, $3F, $3C, $3F, $31, $3F, $3C, $3F, $31, $31, $3F, $3C, $3F, $31, $31, $3F, $3C
        byte $3F, $3C, $3F, $83, $31, $3F, $3C, $3F, $83, $31, $3F, $81, $3C


map80   byte $B4, $2E, $84, $32, $85, $35, $84, $36, $84, $62, $35, $65, $2E, $2E, $65, $36, $66, $66, $36, $62, $83, $32, $35, $65
        byte $2E, $2E, $65, $36, $66, $2E, $66, $62, $83, $32, $35, $65, $65, $2E, $65, $36, $66, $2E, $66, $83, $62, $32, $35, $65
        byte $65, $2E, $65, $36, $66, $2E, $66, $62, $32, $2E, $2E, $35, $65, $35, $65, $65, $36, $66, $2E, $66, $62, $32, $2E, $2E
        byte $35, $65, $35, $65, $65, $36, $66, $2E, $66, $62, $32, $2E, $2E, $35, $65, $35, $35, $65, $36, $66, $2E, $66, $84, $62
        byte $35, $65, $35, $35, $65, $36, $66, $66, $36, $84, $32, $85, $35, $84, $36, $B4, $2E

      

CON
  NES0_RIGHT    = %00000000_00000001
  NES0_LEFT     = %00000000_00000010
  NES0_DOWN     = %00000000_00000100
  NES0_UP       = %00000000_00001000
  NES0_START    = %00000000_00010000
  NES0_SELECT   = %00000000_00100000
  NES0_B        = %00000000_01000000
  NES0_A        = %00000000_10000000

PRI poll_emupads
  pad_prev := pad_state
  pad_state := hal.get_emupad
  pad_press := (pad_state^pad_prev)&pad_state

PRI getkey
    poll_emupads

    if pad_press & NES0_A
        result := $1C
    elseif pad_press & NES0_SELECT
        result := $1D
    elseif pad_press & NES0_UP
        result := $1E
    elseif pad_press & NES0_DOWN
        result := $1F

    if pad_state & NES0_B
        result |= $80
    if pad_state & NES0_LEFT
        result |= $40
    if pad_state & NES0_RIGHT
        result |= $20
  

