
require 'chunky_png'

def make_palette(name)
    colarray = Array.new
    image = ChunkyPNG::Image.new(16,16)
    for i in 0..255 do
        color = yield i
        color ||= 0xFF00FF00
        color &= ~0xFF
        colarray << color
        image[i&15,i>>4] = color|0xFF
    end
    image.save("#{name}_preview.png")
    File.binwrite("#{name}_palette.dat",colarray.pack("L<*"))
end

make_palette("vga") do |i|
    if (i&3)==0
        ChunkyPNG::Color.rgb(
            ((i>>6)&3)*0x55,
            ((i>>4)&3)*0x55,
            ((i>>2)&3)*0x55
        )
    else
        nil
    end
end

def tv_color(i,hue_shift = 4.5/8,phaseflip=true)
    hue = ((i&0xF0)/128.0)*Math::PI
    if phaseflip
        hue = hue_shift*Math::PI + hue
    else
        hue = hue_shift*Math::PI - hue
    end

    if (i & 0xF)==0x8
        y = 4/5.0
        sat = 0.6
        hue += Math::PI
    elsif (i & 8)!=0
        y = ((i&7)-2) / 5.0
        sat = 0.2
    else
        y = ((i&7)-2) / 5.0
        sat = 0.0
    end
    u = Math.sin(hue)*sat
    v = Math.cos(hue)*sat

    if y >= 0
        # Yes this matrix is bad but matches what I actually see on my TV
        ChunkyPNG::Color.rgb(
            ((y+1.770*v).clamp(0,1)*255).to_i,
            ((y-0.344*u-0.714*v).clamp(0,1)*255).to_i,
            ((y+1.403*u).clamp(0,1)*255).to_i
        )
    else
        nil
    end
end

make_palette("ntsc") do |i|
    tv_color(i,4.0/8)
end
make_palette("ntsc_hel") do |i|
    tv_color(i,4.0/8,false)
end
