## ![P1 Classics Collection](img/promo.png)

This is a collection of games originally written for the Propeller 1 microcontroller,
ported to the Propeller 2 (taking advantage of FlexSpin's cross-language capabilities).

## Usage

All games are configured through one common `_config.spin2`. The structure of this file will be familiar to users of MegaYume/etc.

None of the games require PSRAM or storage beyond the game executable. However, SD filesystem support is present to support loading PADMAP.TXT configuration or in some cases, store scores and other data (such data will be stored in `/sd/P2PORTS/`).

You need flexspin v7.4.4 or later installed into your PATH.

Run script `build_all.sh` to build all games into convenient .BIX files.

See [below](#control-details) for details on in-game controls.

## Unterwelt

Game by Michael Zinn

![](img/unterwelt.png)

Block-pushing, monster-smashing puzzle game.

### Controls

|Action|Keyboard|Gamepad|
|-|-|-|
|Move|Arrow Keys|D-Pad / L.Stick|
|Start/Pause|<kbd>Enter</kbd>|Button 10 / Start|
|Switch Characters<br>(In Later Levels)|<kbd>Backspace</kbd>|Button 9 / Select|
|Scroll Left|<kbd>X</kbd>|Button 4 / B|
|Scroll Right|<kbd>C</kbd>|Button 3 / A|

AppID: `unterwelt`  
Executable: `UNTRWELT.BIX`

## Ranquest

Game by Jay T. Cook, Music by John Wedgeworth

![](img/ranquest.png)

The king needs your help! The six mystical treasures have been taken from the castle! Locate the six
treausres and return them safely to the save the kingdom. Are you brave enough for this task?


The P2 version features the music reinstrumented for YM2612 emulation.

### Controls

|Action|Keyboard|Gamepad|
|-|-|-|
|Move|Arrow Keys|D-Pad / L.Stick|
|Start/Pause|<kbd>Enter</kbd>|Button 10 / Start|
|Attack!|<kbd>X</kbd>|Button 4 / B|

(You can interact with objects just by walking into them)

AppID: `ranquest`  
Executable: `RANQUEST.BIX`

## Spintris (2020 edition)

Game by Jay T. Cook, Enhancements and Music by Ada Gottensträter.

![](img/spintris.png)

Clone of a well-known russian block-statcking game. Features 2-player modes!

### Controls

|Action|Keyboard|Gamepad|
|-|-|-|
|Move Piece (left/right)<br>Soft Drop(down)|Arrow Keys|D-Pad / L.Stick|
|Start/Pause|<kbd>Enter</kbd>|Button 10 / Start|
|Spin Counter-Clockwise|<kbd>X</kbd>|Button 4 / B|
|Spin Clockwise|<kbd>C</kbd>|Button 3 / A|

AppID: `spintris`  
Executable: `SPINTRIS.BIX`

## PropICE

Game by Werner L. Schneider

![](img/propice.png)

You're an Excavator and you push ice blocks into evil Smiley faces. Yeah, just another Monday.
High scores can be saved to the SD card.

### Controls

|Action|Keyboard|Gamepad|
|-|-|-|
|Move|Arrow Keys|D-Pad / L.Stick|
|Start|<kbd>Enter</kbd>|Button 10 / Start|
|Toggle Music|<kbd>Backspace</kbd>|Button 9 / Select|
|Push Block|<kbd>X</kbd>|Button 4 / B|

AppID: `propice`  
Executable: `PROPICE.BIX`

## IMPACT

Game by Werner L. Schneider

![](img/impact.png)

Arkanoid-style game based on the retro PC game of the same name.
(May be mildly impossible until I add mouse or spinner controls...)

Depending on the number of tokens collected, you can buy various power-ups, but they only last until you loose your next ball!

### Controls

|Action|Keyboard|Gamepad|
|-|-|-|
|Move (left/right)<br>Adjust Ball (up/down)|Arrow Keys|D-Pad / L.Stick|
|Serve Ball/Shoot Item|<kbd>X</kbd>|Button 4 / B|
|Buy Item<br>Confirm Menu|<kbd>C</kbd>|Button 3 / A|
|Save current map|<kbd>Backspace</kbd>|Button 9 / Select|

AppID: `impact`  
Executable: `IMPACT.BIX`

## Dr. Hydra

Code by Remi 'Remz' Veilleux and GFX by Louis-Philippe 'FoX' Guilbert.

![](img/drhydra.png)

Dr. Mario-type game with single player, two-player and vs. Computer modes.

AppID: `drhydra`  
Executable: `DRHYDRA.BIX`

## Mythic Flight

Game by trodoss, enhanced audio by Ada.

![](img/mythicflight.png)

Simplistic side-scrolling shoot-em-up.


### Controls

|Action|Keyboard|Gamepad|
|-|-|-|
|Move|Arrow Keys|D-Pad / L.Stick|
|Start|<kbd>Enter</kbd>|Button 10 / Start|
|Shoot Arrow|<kbd>X</kbd>|Button 4 / B|

AppID: `mythicflight`  
Executable: `MYTHIC.BIX`


## Control Details

USB controls are handled by [usbnew](https://github.com/Wuerfel21/usbnew). Gamepads and the keyboard are supported.

All games use exclusively buttons 3, 4, 9 and 10 on the usbnew generic gamepad, in corrospondence with an NES controller's A, B ,Select and Start buttons, respectively:

![](img/refpad.png)

Your controller may have different labels for the buttons in these positions (or look completely unlike this). If the mapping is incorrect or you want to use different buttons, see [the usbnew wiki](https://github.com/Wuerfel21/usbnew/wiki/PADMAP.TXT-Format-and-the-reference-gamepad) for more information.

|Generic Button|NES Button|Keyboard Key        |XBox button     |
|-------------:|:--------:|:------------------:|:--------------:|
|Directions    |   D-Pad  |     Arrow Keys     |D-Pad or L.Stick|
|Button 3      |     A    |    <kbd>C</kbd>    |        A       |
|Button 4      |     B    |    <kbd>X</kbd>    |        X       |
|Button 9      |  SELECT  |<kbd>Backspace</kbd>|      Back      |
|Button 10     |   START  |  <kbd>Enter</kbd>  |      Start     |

See per-game tables for more detailed information.

**Currently, multiplayer is only supported by using two gamepads, which have to be attached to a USB Hub.**
